<?php
// Exit if accessed directly.
if( ! defined( 'ABSPATH' ) ) {
	exit;
}

$params = [
	'register_type' => 'approval_request',
	'declined' => (isset( $_GET['show'] ) && $_GET['show'] == 'declined') ? 1 : 0,
];
$approvals = $this->helpers->dbSelect( 'cjwpbldr_temp_user_data', '*', [
	'AND' => $params,
] );

// approve account
if( isset( $_GET['cjwpbldr_action'] ) && $_GET['cjwpbldr_action'] == 'approve-temp-user' && $_GET['id'] != '' ) {
	$temp_user_info = $this->helpers->dbGet( 'cjwpbldr_temp_user_data', '*', [
		'id' => $_GET['id']
	] );
	$user_info = (is_serialized( $temp_user_info['user_data'] )) ? unserialize( $temp_user_info['user_data'] ) : $temp_user_info['user_data'];
	$form_info = $this->helpers->postInfo( $user_info['form_id'] );

	$submit_action = $form_info['form_submit_actions']['submit_action'];
	$submit_action_params = [];
	if( $this->helpers->isValidatedArray( $form_info, true, 'form_submit_actions' ) ) {
		$submit_action_params = $form_info['form_submit_actions']['submit_action_params'][ $submit_action ];
	}

	unset( $user_info['form_id'] );
	unset( $user_info['current_url'] );
	unset( $user_info['_wp_nonce'] );
	unset( $user_info['cjwpbldr_form_submit'] );
	$register_form_class = cjwpbldr_frontend_auth_do_register::getInstance();
	$response = $register_form_class->createNewAccount( $user_info, $form_info, $submit_action_params );
	$this->helpers->dbDelete( 'cjwpbldr_temp_user_data', [
		'id' => $_GET['id']
	] );
	$location = $this->helpers->callbackUrl( 'cjfm-manage-approvals', '', 'addon-frontend-auth' );
	wp_safe_redirect( $location );
	die();
}

// decline without sending email
if( isset( $_GET['cjwpbldr_action'] ) && $_GET['cjwpbldr_action'] == 'decline-temp-user' && $_GET['id'] != '' ) {
	$temp_user_info = $this->helpers->dbUpdate( 'cjwpbldr_temp_user_data', array('declined' => 1), 'id', $_GET['id'] );
	$location = $this->helpers->callbackUrl( 'cjfm-manage-approvals', '', 'addon-frontend-auth' );
	wp_safe_redirect( $location );
	die();
}

// delete from database
if( isset( $_GET['cjwpbldr_action'] ) && $_GET['cjwpbldr_action'] == 'delete-temp-user' && $_GET['id'] != '' ) {
	$temp_user_info = $this->helpers->dbDelete( 'cjwpbldr_temp_user_data', [
		'id' => $_GET['id']
	] );
	$location = $this->helpers->callbackUrl( 'cjfm-manage-approvals', '', 'addon-frontend-auth', true ) . '&show=declined';
	wp_safe_redirect( $location );
	die();
}

// decline with email
if( isset( $_POST['remove_temp_user'] ) ) {
	$temp_user_info = $this->helpers->dbGet( 'cjwpbldr_temp_user_data', '*', array('id' => $_POST['approval_id']) );
	$user_info = (is_serialized( $temp_user_info['user_data'] )) ? unserialize( $temp_user_info['user_data'] ) : $temp_user_info['user_data'];
	$form_info = $this->helpers->postInfo( $user_info['form_id'] );
	unset( $user_info['form_id'] );
	unset( $user_info['current_url'] );
	unset( $user_info['_wp_nonce'] );
	unset( $user_info['cjwpbldr_form_submit'] );

	$cjwpbldr_auth_helpers = cjwpbldr_frontend_auth_helpers::getInstance();
	$email_subject = $cjwpbldr_auth_helpers->processDynamicVariables( $_POST['subject'], $user_info );
	$email_message = $cjwpbldr_auth_helpers->processDynamicVariables( $_POST['message'], $user_info );
	$email_data = array(
		'to' => $user_info['user_email'],
		'from_name' => $this->helpers->savedOption( 'cjfmr_email_from_name' ),
		'from_email' => $this->helpers->savedOption( 'cjfmr_email_from' ),
		'subject' => $email_subject,
		'message' => $email_message,
	);
	$this->helpers->sendEmail( $email_data );

	$temp_user_info = $this->helpers->dbUpdate( 'cjwpbldr_temp_user_data',
		[
			'declined' => 1,
			'decline_reason' => $email_message
		],
		'id',
		$_POST['approval_id']
	);
	$location = $this->helpers->callbackUrl( 'cjfm-manage-approvals', '', 'addon-frontend-auth' );
	wp_safe_redirect( $location );

	die();
}

$location = $this->helpers->callbackUrl( 'cjfm-manage-approvals', '', 'addon-frontend-auth' );

?>
<div class="cssjockey-ui">
    <table class="table cj-table">
        <caption>
            <div class="cj-is-pulled-right">
                <div class="">
                    <a href="#" class="cj-button cj-is-small cj-is-link"><?php _e( 'Show: ', 'addon-frontend-auth' ); ?></a>
                    <a href="<?php echo $this->helpers->callbackUrl( 'cjfm-manage-approvals', '', 'addon-frontend-auth' ); ?>" class="cj-button cj-is-small cj-is-info"><i class="fa cj-fs-12 fa-hourglass cj-mr-5"></i><?php _e( 'Pending', 'addon-frontend-auth' ); ?></a>
                    <a href="<?php echo $this->helpers->callbackUrl( 'cjfm-manage-approvals', '', 'addon-frontend-auth' ) . '&show=declined'; ?>" class="cj-button cj-is-small cj-is-danger"><i class="fa cj-fs-14 fa-ban cj-mr-5"></i><?php _e( 'Declined', 'addon-frontend-auth' ); ?></a>
                </div>
            </div>
			<?php _e( 'Approvals', 'addon-frontend-auth' ) ?>
        </caption>
        <tbody>
        <tr>
            <th width="8%"><?php _e( 'ID', 'addon-frontend-auth' ) ?></th>
            <th width=""><?php _e( 'User Info', 'addon-frontend-auth' ) ?></th>
            <th width="15%"><?php _e( 'Submitted On', 'addon-frontend-auth' ) ?></th>
            <th width="10%" class="actions"><?php _e( 'Actions', 'addon-frontend-auth' ) ?></th>
        </tr>
		<?php if( empty( $approvals ) ) { ?>
            <tr>
                <td colspan="4"><?php _e( 'No pending approval requests.', 'addon-frontend-auth' ) ?></td>
            </tr>
		<?php } ?>
		<?php if( ! empty( $approvals ) ) { ?>
			<?php
			foreach( $approvals as $key => $approval ) {
				$display_fields = [];
				$user_data = unserialize( $approval['user_data'] );
				$form_info = $this->helpers->postInfo( $user_data['form_id'] );
				$form_fields = $form_info['form_settings']['fields'];
				if( ! empty( $form_fields ) ) {
					foreach( $form_fields as $form_field ) {
						$display_fields[ $form_field['field']['settings']['unique_id'] ] = $form_field['field']['settings']['label'];
					}
				}
				unset( $user_data['user_pass'] );
				unset( $user_data['user_pass_confirmation'] );
				$approve_link = $this->helpers->queryString( $this->helpers->currentUrl() ) . 'cjwpbldr_action=approve-temp-user&id=' . $approval['id'];
				$direct_decline_link = $this->helpers->queryString( $this->helpers->currentUrl() ) . 'cjwpbldr_action=decline-temp-user&id=' . $approval['id'];
				$remove_link = $this->helpers->queryString( $this->helpers->currentUrl() ) . 'cjwpbldr_action=delete-temp-user&id=' . $approval['id'];
				?>
                <tr>
                    <td width="8%"><?php echo $approval['id']; ?></td>
                    <td width="">
                        <a href="#modal-<?php echo $approval['id'] ?>" data-toggle="class" data-classes="cj-is-active" data-target="#modal-<?php echo $approval['id'] ?>">
                            <i class="fa fa-info-circle cj-color-dark cj-mr-10"></i>
							<?php echo $approval['user_login'] . ' (' . $approval['user_email'] . ')'; ?>
                        </a>
                        <div class="cj-modal" id="modal-<?php echo $approval['id'] ?>" tabindex="-1" role="dialog" aria-labelledby="modal-label-<?php echo $approval['id'] ?>">
                            <div class="cj-modal-background" data-toggle="class" data-classes="cj-is-active" data-target="#modal-<?php echo $approval['id'] ?>"></div>
                            <div class="cj-modal-content">
                                <div class="cj-modal-header">
                                    <h4 class="cj-modal-title" id="modal-label-<?php echo $approval['id'] ?>">
										<?php echo $approval['user_login'] . ' (' . $approval['user_email'] . ')'; ?>
                                    </h4>
                                </div>
                                <div class="cj-modal-body cj-p-0">
                                    <table class="table cj-table">
                                        <tr>
                                            <th><?php _e( 'Registered Via', 'addon-frontend-auth' ); ?></th>
                                            <th><?php echo $form_info['post_title']; ?></th>
                                        </tr>
										<?php
										foreach( $user_data as $user_key => $user_value ) {
											if( array_key_exists( $user_key, $display_fields ) ) {
												?>
                                                <tr>
													<?php if( ! is_object( $user_value ) ) { ?>
                                                        <td><?php echo $display_fields[ $user_key ]; ?></td>
														<?php if( is_array( $user_value ) && ! is_object( $user_value ) ) { ?>
                                                            <td><?php echo implode( ', ', $user_value ); ?></td>
														<?php } else { ?>
                                                            <td><?php echo $user_value; ?></td>
														<?php } ?>
													<?php } ?>
                                                </tr>
											<?php }
										} ?>

										<?php if( isset( $_GET['show'] ) && $_GET['show'] == 'declined' && $approval['decline_reason'] != '' ) { ?>
                                            <tr>
                                                <td><?php _e( 'Decline Reason', 'addon-frontend-auth' ) ?></td>
                                                <td><?php echo $approval['decline_reason'] ?></td>
                                            </tr>
										<?php } ?>

                                    </table>
                                </div>
                            </div>
                            <button class="cj-modal-close cj-is-large" aria-label="close" data-toggle="class" data-classes="cj-is-active" data-target="#modal-<?php echo $approval['id'] ?>"></button>
                        </div>

                        <div class="cj-modal" id="modal-decline-<?php echo $approval['id'] ?>" tabindex="-1" role="dialog" aria-labelledby="modal-label-decline-<?php echo $approval['id'] ?>">
                            <div class="cj-modal-background"></div>
                            <div class="cj-modal-content cj-width-70">
                                <div class="cj-box cj-p-0">
                                    <div class="cj-modal-body cj-pb-0">
                                        <div class="cj-content">
                                            <h4 class="cj-text-center cj-color-danger cj-pt-25">
												<?php _e( 'Decline approval request for: ', 'addon-frontend-auth' ) ?><?php echo $approval['user_login'] . ' (' . $approval['user_email'] . ')'; ?>
                                            </h4>
                                        </div>
                                        <form action="" method="post">
											<?php
											$form_fields = array(
												array(
													'id' => 'approval_id',
													'type' => 'hidden',
													'label' => __( 'Invitation Key', 'addon-frontend-auth' ),
													'default' => $approval['id'],
													'options' => '', // array in case of dropdown, checkbox and radio buttons
												),
												array(
													'id' => 'subject',
													'type' => 'text',
													'label' => __( 'Email Subject', 'addon-frontend-auth' ),
													'default' => __( 'Your approval request for %site_name% is declined', 'addon-frontend-auth' ),
													'options' => '', // array in case of dropdown, checkbox and radio buttons
												),
												array(
													'id' => 'message',
													'type' => 'wysiwyg-tiny',
													'label' => __( 'Email Message', 'addon-frontend-auth' ),
													'info' => __( 'This message will be sent to the user via email.', 'addon-frontend-auth' ),
													'default' => __( 'Your approval request is declined due to the following reasons: <p>Reason 1</p>', 'addon-frontend-auth' ),
													'options' => '', // array in case of dropdown, checkbox and radio buttons
												),
												array(
													'id' => 'remove_temp_user',
													'type' => 'submit',
													'label' => '<a href="' . $direct_decline_link . '" class="cj-button cj-is-success cj-ml-10">' . __( 'Decline without email', 'addon-frontend-auth' ) . '</a>',
													'default' => __( 'Decline and send email', 'addon-frontend-auth' ),
													'options' => '', // array in case of dropdown, checkbox and radio buttons
												)
											);
											echo $this->helpers->renderAdminForm( $form_fields );
											?>
                                        </form>
                                    </div>
                                </div>
                            </div>
                            <a href="#" data-toggle="class" data-target="#modal-decline-<?php echo $approval['id'] ?>" data-classes="cj-is-active" class="cj-modal-close"></a>
                        </div>
                    </td>
                    <td width="15%"><?php echo $this->helpers->wpDate( $approval['created_on'], 'date' ); ?></td>
                    <td width="15%" class="cj-text-center">
						<?php if( ! isset( $_GET['show'] ) ) { ?>
                            <a data-confirm="<?php _e( 'Are you sure? User account will be created and welcome email will be sent to this user.', 'addon-frontend-auth' ) ?>" href="<?php echo $approve_link; ?>" class="cj-button cj-mr-5 cj-is-small cj-is-success cj-confirm">
								<?php _e( 'Approve', 'addon-frontend-auth' ) ?>
                            </a>
                            <a href="#" data-toggle="class" data-target="#modal-decline-<?php echo $approval['id'] ?>" data-classes="cj-is-active" class="cj-button cj-mr-5 cj-is-small cj-is-danger">
								<?php _e( 'Decline', 'addon-frontend-auth' ) ?>
                            </a>
						<?php } ?>

						<?php if( isset( $_GET['show'] ) && $_GET['show'] == 'declined' ) { ?>
                            <a href="<?php echo $remove_link; ?>" class="cj-button cj-mr-5 cj-is-small cj-is-danger cj-confirm" data-confirm="<?php _e( "Are you sure?\nUser can submit approval request again.", 'addon-frontend-auth' ) ?>">
								<?php _e( 'Delete from Database', 'addon-frontend-auth' ) ?>
                            </a>
						<?php } ?>
                    </td>
                </tr>
			<?php } ?>
		<?php } ?>
        </tbody>
    </table>
</div>