<?php
// Exit if accessed directly.
if( ! defined( 'ABSPATH' ) ) {
	exit;
}

$import_export_class = cjwpbldr_import_export_users::getInstance();
$import_export_class->displayImportExportErrors();
$user_meta_keys = $import_export_class->getUserMetaKeys();

$fields = [
	[
		'type' => 'sub-heading',
		'id' => 'export_user_heading',
		'label' => __( 'Export User Data', 'addon-frontend-auth' ),
		'info' => __( 'Export user data in an excel sheet', 'addon-frontend-auth' ),
		'suffix' => '',
		'prefix' => '',
		'default' => '',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'multi-dropdown',
		'id' => 'user_data_export',
		'label' => __( 'User Meta Keys', 'addon-frontend-auth' ),
		'info' => __( 'Select user meta keys to include in downloadable CSV file.', 'addon-frontend-auth' ),
		'suffix' => '',
		'prefix' => '',
		'default' => '',
		'options' => $user_meta_keys, // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'dropdown',
		'id' => 'export_form_id',
		'label' => __( 'Select a Custom Form', 'addon-frontend-auth' ),
		'info' => __( 'Select a custom form to export the custom fields along with the default ones.', 'addon-frontend-auth' ),
		'suffix' => '',
		'prefix' => '',
		'default' => '1',
		'options' => $import_export_class->helpers->getCustomFormsArray(), // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'number',
		'id' => 'export_limit',
		'label' => __( 'Select an Export Limit', 'addon-frontend-auth' ),
		'info' => __( 'An export limit has been set to handle huge user database. The script may crash if we do not set an limit to export users. <br/>You can change the limit but be cautious selecting a large amount to export may crash the page.', 'addon-frontend-auth' ),
		'suffix' => '',
		'prefix' => '',
		'default' => ($import_export_class->user_set_export_limit != '' ? $import_export_class->user_set_export_limit : '250'),
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'info',
		'id' => 'export_stats',
		'label' => __( 'Export Stats', 'addon-frontend-auth' ),
		'info' => $import_export_class->exportUserStats(),
		'suffix' => '',
		'prefix' => '',
		'default' => '',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'hidden',
		'id' => 'export_action',
		'label' => '',
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => 'export_users',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
	[
		'type' => 'submit',
		'id' => 'export_data',
		'label' => '',
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => 'Export User Data',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	],
];

$fields[] = [
	'type' => 'sub-heading',
	'id' => 'update_user_heading',
	'label' => __( 'Update Existing Users', 'addon-frontend-auth' ),
	'info' => '',
	'suffix' => '',
	'prefix' => '',
	'default' => '',
	'options' => '', // array in case of dropdown, checkbox and radio buttons
];

$fields[] = [
	'type' => 'info',
	'id' => 'update_user_info',
	'label' => __( 'Step 1: Download Format', 'addon-frontend-auth' ),
	'suffix' => '',
	'prefix' => '',
	'default' => '<a href="' . $this->helpers->callbackUrl( 'cjfm-manage-import-export-users', null, 'addon-frontend-auth' ) . '&export_data=yes&export_action=download_format&export_form_id=none " title="">Click here</a> to download format for .csv file.',
	'options' => '', // array in case of dropdown, checkbox and radio buttons
];

$fields[] = [
	'type' => 'file-raw',
	'id' => 'cjwpbldr_import_users',
	'label' => __( 'Step 2: Import File', 'addon-frontend-auth' ),
	'info' => '',
	'suffix' => '',
	'prefix' => '',
	'default' => '',
	'options' => '', // array in case of dropdown, checkbox and radio buttons
];

$fields[] = [
	'type' => 'submit',
	'id' => 'upload_user_data',
	'label' => '',
	'info' => '',
	'suffix' => '',
	'prefix' => '',
	'default' => 'Update Existing User',
	'options' => '', // array in case of dropdown, checkbox and radio buttons
];

return $fields;