<?php
// Exit if accessed directly.
if( ! defined( 'ABSPATH' ) ) {
	exit;
}

$module_helper = cjwpbldr_frontend_auth_helpers::getInstance();
$auto_setup_url = $this->helpers->callbackUrl( 'cjfm-page-setup', '', 'addon-frontend-auth' ) . 'cjwpbldr_action=frontend-auth-auto-page-setup';
$manage_forms_url = $this->helpers->callbackUrl( 'manage-forms', '', 'addon-form-builder' );
$logout_shortcode = '<code>[cjwpbldr_logout redirect="' . site_url() . '"]</code>';

return [
	[
		'type' => 'heading',
		'id' => 'cjfmr_heading',
		'label' => __( 'Page Setup', 'addon-frontend-auth' ),
		'info' => 'Specify default authentication pages.',
		'suffix' => '',
		'prefix' => '',
		'default' => '',
		'options' => '',
	],
	[
		'type' => 'info',
		'id' => 'cjfmr_auto_page_setup_info',
		'label' => __( 'Auto Setup', 'addon-frontend-auth' ),
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => sprintf( __( '<a tabindex="-1" href="%s">Click here</a> to automatically setup default required pages. <br>This will create required pages however, you would need to insert shortcodes to display the forms on these pages.', 'addon-frontend-auth' ), $auto_setup_url ),
		'options' => '',
	],
	[
		'type' => 'page',
		'id' => 'cjfmr_page_login',
		'label' => __( 'Login Page', 'addon-frontend-auth' ),
		'info' => sprintf( __( 'Select a page where you have added the <a tabindex="-1" href="%s" target="_blank">login form shortcode</a>.', 'addon-frontend-auth' ), $this->helpers->callbackUrl( 'cjfb-manage-forms', null, 'addon-form-builder' ) ),
		'suffix' => '',
		'prefix' => '',
		'default' => '',
		'options' => '',
	],
	[
		'type' => 'page',
		'id' => 'cjfmr_page_register',
		'label' => __( 'Register Page', 'addon-frontend-auth' ),
		'info' => sprintf( __( 'Select a page where you have added the <a tabindex="-1" href="%s" target="_blank">register form shortcode</a>.', 'addon-frontend-auth' ), $this->helpers->callbackUrl( 'cjfb-manage-forms', null, 'addon-form-builder' ) ),
		'suffix' => '',
		'prefix' => '',
		'default' => '',
		'options' => '',
	],
	[
		'type' => 'page',
		'id' => 'cjfmr_page_edit_profile',
		'label' => __( 'Edit Profile Page', 'addon-frontend-auth' ),
		'info' => sprintf( __( 'Select a page where you have added the <a tabindex="-1" href="%s" target="_blank">edit profile form shortcode</a>.', 'addon-frontend-auth' ), $this->helpers->callbackUrl( 'cjfb-manage-forms', null, 'addon-form-builder' ) ),
		'suffix' => '',
		'prefix' => '',
		'default' => '',
		'options' => '',
	],
	[
		'type' => 'page',
		'id' => 'cjfmr_page_password',
		'label' => __( 'Password Reset Page', 'addon-frontend-auth' ),
		'info' => sprintf( __( 'Select a page where you have added the <a tabindex="-1" href="%s" target="_blank">reset password form shortcode</a>.', 'addon-frontend-auth' ), $this->helpers->callbackUrl( 'cjfb-manage-forms', null, 'addon-form-builder' ) ),
		'suffix' => '',
		'prefix' => '',
		'default' => '',
		'options' => '',
	],
	[
		'type' => 'page',
		'id' => 'cjfmr_page_new_password',
		'label' => __( 'Set New Password Page', 'addon-frontend-auth' ),
		'info' => sprintf( __( 'Select a page where you have added the <a tabindex="-1" href="%s" target="_blank">set new password form shortcode</a>.', 'addon-frontend-auth' ), $this->helpers->callbackUrl( 'cjfb-manage-forms', null, 'addon-form-builder' ) ),
		'suffix' => '',
		'prefix' => '',
		'default' => '',
		'options' => '',
	],
	[
		'type' => 'page',
		'id' => 'cjfmr_page_logout',
		'label' => __( 'Logout Page', 'addon-frontend-auth' ),
		'info' => '<p>' . __( 'Select a page where you have added the logout shortcode.', 'addon-frontend-auth' ) . '</p>' . $logout_shortcode,
		'suffix' => '',
		'prefix' => '',
		'default' => '',
		'options' => '',
	],
];