<?php
// Exit if accessed directly.
if( ! defined( 'ABSPATH' ) ) {
	exit;
}

$this->helpers->getMenuLocations();

$cjwpbldr_user_menus = get_option( 'cjwpbldr_user_menus' );
$menu_locations = get_option( 'cjwpbldr_user_menus' );

$roles = $this->helpers->getWPUserRoles();

$cjwpbldr_options[] = [
	'type' => 'heading',
	'id' => 'cjfmr_role_based_menu_heading',
	'label' => __( 'Role Based Menus', 'addon-frontend-auth' ),
	'info' => __( 'Please select the Menu Location and Menu for each role from below:', 'addon-frontend-auth' ),
	'suffix' => '',
	'prefix' => '',
	'default' => '',
	'options' => '', // array in case of dropdown, checkbox and radio buttons
];

foreach( $roles as $key => $role ) {

	$cjwpbldr_options[] = [
		'type' => 'sub-heading',
		'id' => 'cjfmr_role_based_menu_' . $key . '_heading',
		'label' => __( 'Menu for ', 'addon-frontend-auth' ) . $role,
		'info' => '',
		'suffix' => '',
		'prefix' => '',
		'default' => '',
		'options' => '', // array in case of dropdown, checkbox and radio buttons
	];

	if( is_array( $menu_locations ) ) {
		foreach( $menu_locations as $m_key => $location ) {
			$cjwpbldr_options[] = [
				'type' => 'dropdown',
				'id' => 'cjfmr_role_based_menu_' . $key . '_' . $m_key . '_menu_location',
				'label' => $location,
				'info' => '',
				'suffix' => '',
				'prefix' => '',
				'default' => '',
				'options' => $this->helpers->getTaxonomyArray( 'nav_menu' ), // array in case of dropdown, checkbox and radio buttons
			];
		}
	}
}

return $cjwpbldr_options;
