<?php
// Exit if accessed directly.
if( ! defined( 'ABSPATH' ) ) {
	exit;
}

if( ! class_exists( 'cjwpbldr_frontend_auth_api_addon_info' ) ) {
	class cjwpbldr_frontend_auth_api_addon_info {

		public $helpers, $addon_dir, $routes, $api_url, $namespace;

		private static $instance;

		public static function getInstance() {
			if( ! isset( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		public function __construct() {
			$this->helpers = cjwpbldr_frontend_auth_helpers::getInstance();
			$this->namespace = basename( $this->helpers->addon_dir );

			$this->api_url = '';
			if( function_exists( 'using_index_permalinks' ) ) {
				$this->api_url = rest_url( 'cjwpbldr' ) . '/';
			}
			$this->routes = array(
				$this->namespace . '-info' => array(
					'endpoint' => $this->namespace . '/info',
					'name' => __( 'Addon Info', 'addon-frontend-auth' ),
					'description' => __( 'Returns addon info.', 'addon-frontend-auth' ),
					'methods' => array(
						'get' => array($this, 'addonInfo'), // callback function
					),
					'permissions' => function () {
						return true;
						// return current_user_can( 'manage_options' );
					},
				)
			);

			add_filter( 'cjwpbldr_register_api_route', array($this, 'registerRoute') );
		}

		public function registerRoute( $routes ) {
			$routes = array_merge( $routes, $this->routes );

			return $routes;
		}

		public function addonInfo( $request ) {
			$data = $this->helpers->addonInfo( null, basename( $this->helpers->addon_dir ) );

			return $this->helpers->apiResponse( $request, $data );
		}

	}

	cjwpbldr_frontend_auth_api_addon_info::getInstance();
}