<?php
// Exit if accessed directly.
if( ! defined( 'ABSPATH' ) ) {
	exit;
}

if( ! class_exists( 'cjwpbldr_frontend_auth_buddypress_mods' ) ) {
	class cjwpbldr_frontend_auth_buddypress_mods {
		private static $instance;
		public $helpers;

		public static function getInstance() {
			if( ! isset( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		public function __construct() {
			$this->helpers = cjwpbldr_helpers::getInstance();

			if( function_exists( 'buddypress' ) ) {
				add_action( 'init', array($this, 'buddypressAvatars'), 1, 5 );
			}
		}

		public function buddypressAvatars() {
			$avatar_type = $this->helpers->savedOption( 'cjfmr_user_avatar_type' );
			if( $avatar_type !== 'custom' ) {
				return false;
			}
			add_filter( 'bp_core_fetch_avatar_no_grav', array($this, 'getUserAvatarUrl'), 10, 2 );
			add_filter( 'bp_core_fetch_avatar_url', array($this, 'getUserAvatarUrl'), 10, 2 );
			add_filter( 'bp_core_fetch_avatar', array($this, 'getUserAvatarImageTag'), 10, 2 );
		}

		public function getUserAvatarUrl( $no_grav, $params ) {
			$user_avatar = get_user_meta( $params['item_id'], 'user_avatar', true );
			/*if( $user_avatar !== '' ) {
				list( $width, $height, $type, $attr ) = getimagesize( $user_avatar );
				if( $width !== $height ) {
					$cropped = $this->helpers->imageResize( $user_avatar, array(125, 125), true );
					update_user_meta( $params['item_id'], 'default_avatar', $cropped );
					update_user_meta( $params['item_id'], 'user_avatar', $cropped );
					$user_avatar = get_user_meta( $params['item_id'], 'user_avatar', true );
				}
			}*/
			if( $user_avatar != '' ) {
				return $user_avatar;
			}
		}

		public function getUserAvatarImageTag( $img_html, $params ) {
			$user_avatar = get_user_meta( $params['item_id'], 'user_avatar', true );
			if( $user_avatar !== '' ) {
				$img_tag = preg_replace( '/src=".+?"/', 'src="' . $user_avatar . '"', $img_html );

				return $img_tag;
			}

			return $img_html;
		}

	}

	cjwpbldr_frontend_auth_buddypress_mods::getInstance();
}