<?php
// Exit if accessed directly.
if( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * This file contains the class which modify's few WordPress default
 * functionality via in-built WordPress Hooks and Filters
 *
 * .0
 * @since v.18.3
 */
if( ! class_exists( 'cjwpbldr_fa_configuration_wordpress' ) ) {
	class cjwpbldr_fa_configuration_wordpress {

		/**
		 * @var $helpers | Object | Hold object for helpers class
		 *
		 * .0
		 * @since 3.0.1
		 */
		public $helpers;

		/**
		 * @var $instance | Object | Holds the instance of this class
		 *
		 * @since 3.0.1
		 */
		private static $instance;

		public static function getInstance() {
			if( ! isset( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		public function __construct() {
			$this->helpers = cjwpbldr_frontend_auth_helpers::getInstance();
			add_action( 'admin_init', array($this, 'restrictDashboardAccess') );
			add_action( 'login_head', array($this, 'restrictDefaultLoginPage') );
			add_filter( 'wp_nav_menu_args', array($this, 'roleBasedMenus') );
			add_filter( 'get_avatar', array($this, 'gravatarFilter'), 10, 5 );
			add_filter( 'manage_users_columns', array($this, 'newUserColumnNames'), 10, 1 );
			add_filter( 'manage_users_custom_column', array($this, 'newModifyUserColumns'), 10, 3 );
		}

		public function newUserColumnNames( $column ) {

			if( $this->helpers->savedOption( 'cjfmr_show_user_columns' ) == 'yes' ) {

				$user_meta_keys = $this->helpers->getCombinedUserMetaKeysForUserColumns();

				foreach( $user_meta_keys as $user_metas ) {

					foreach( $user_metas as $user_meta ) {

						$names = ucfirst( str_replace( '_', ' ', $user_meta ) );

						$column[ $user_meta ] = $names;
					}
				}
			}

			return $column;
		}

		public function newModifyUserColumns( $val, $column_name, $user_id ) {

			if( $this->helpers->savedOption( 'cjfmr_show_user_columns' ) == 'yes' ) {

				$user_meta_keys = $this->helpers->getCombinedUserMetaKeysForUserColumns();

				foreach( $user_meta_keys as $user_metas ) {

					foreach( $user_metas as $user_meta ) {

						switch( $column_name ) {
							case $user_meta :
								return get_the_author_meta( $user_meta, $user_id );
								break;
							default:
						}
					}
				}
			}

			return $val;
		}

		/**
		 * Disable WordPress admin access based on roles selected.
		 */
		public function restrictDashboardAccess() {
			global $current_user;
			if( defined( 'DOING_AJAX' ) && DOING_AJAX ) {
				return false;
			}
			if( false !== strpos( $_SERVER['PHP_SELF'], 'async-upload.php' ) ) {
				return false;
			}
			if( is_user_logged_in() ) {

				if( current_user_can( 'manage_options' ) ) {
					return false;
				}
				$roles = $this->helpers->savedOption( 'cjfmr_disable_dashboard_access' );
				$user_role = $this->helpers->userRole( $current_user->ID );
				if( in_array( 'everyone', $roles ) && ! current_user_can( 'manage_options' ) ) {
					wp_safe_redirect( home_url() );
					exit;
				}
				if( is_array( $roles ) && is_array( $user_role ) ) {
					$match = array_intersect( $roles, $user_role );
					if( ! empty( $match ) && is_admin() && ! current_user_can( 'manage_options' ) ) {
						wp_safe_redirect( home_url() );
						exit;
					}
				}
			}
		}

		/**
		 * Disable default WordPress login page.
		 */
		public function restrictDefaultLoginPage() {
			$restrict_login_page = $this->helpers->savedOption( 'cjfmr_disable_default_login_page' );
			if( $restrict_login_page == 'yes' ) {
				$page_login = $this->helpers->savedOption( 'cjfmr_page_login' );
				$page_register = $this->helpers->savedOption( 'cjfmr_page_register' );
				$page_password = $this->helpers->savedOption( 'cjfmr_page_password' );
				$location = site_url();
				if( ! isset( $_GET['action'] ) && $page_login != '' ) {
					$location = get_permalink( $page_login );
				}
				if( isset( $_GET['action'] ) && $_GET['action'] == 'register' && $page_register != '' ) {
					$location = get_permalink( $page_register );
				}
				if( isset( $_GET['action'] ) && $_GET['action'] == 'lostpassword' && $page_password != '' ) {
					$location = get_permalink( $page_password );
				}
				if( isset( $_GET['redirect_to'] ) ) {
					$location = $this->helpers->queryString( $location ) . 'redirect_to=' . $_GET['redirect_to'];
				}
				wp_safe_redirect( $location );
			}
		}

		/**
		 * Role Based Menu Hook
		 *
		 * [cjwpbldr_modify_nav_menu_args]
		 *
		 * @param  [type] $args [menu args]
		 *
		 * @return [mix]
		 */
		public function roleBasedMenus( $args ) {
			if( is_user_logged_in() ) {
				global $wp_roles;
				$current_user = wp_get_current_user();
				$roles = $current_user->roles;
				$roles = explode( ',', implode( ',', $roles ) );
				if( is_array( $roles ) ) {
					$option_name = 'cjfmr_role_based_menu_' . $roles[0] . '_' . $args['theme_location'] . '_menu_location';
					$option_value = $this->helpers->savedOption( $option_name );
					if( $option_value != '' ) {
						$args['menu'] = $option_value;
					}
				}
			}

			return $args;
		}

		public function gravatarFilter( $avatar, $id_or_email, $size, $default, $alt ) {
			$avatar_type = $this->helpers->savedOption( 'cjfmr_user_avatar_type' );

			if( $avatar_type == '' || $avatar_type == 'default' || $avatar_type == 'gravatar' ) {
				return $avatar;
			}
			$custom_field = '';
			if( $avatar_type == 'custom' ) {
				$custom_field = 'user_avatar';
			}

			return $this->getAvatar( $avatar, $id_or_email, $size, $default, $alt, $custom_field );
		}

		public function getAvatar( $avatar, $id_or_email, $size, $default, $alt, $custom_field ) {
			$user = false;
			if( is_numeric( $id_or_email ) ) {
				$id = (int) $id_or_email;
				$user = get_user_by( 'id', $id );
			} elseif( is_object( $id_or_email ) ) {
				if( ! empty( $id_or_email->user_id ) ) {
					$id = (int) $id_or_email->user_id;
					$user = get_user_by( 'id', $id );
				}
			} else {
				$user = get_user_by( 'email', $id_or_email );
			}
			if( $user && is_object( $user ) ) {
				$custom_avatar = get_user_meta( $user->data->ID, $custom_field, true );
				if( $custom_avatar ) {
					$return = '<img src="' . $custom_avatar . '" width="' . $size . '" height="' . $size . '" alt="' . $alt . '" class="avatar avatar-' . $size . ' photo" />';
				} elseif( $avatar ) {
					$return = $avatar;
				} else {
					$return = '<img src="' . $default . '" width="' . $size . '" height="' . $size . '" alt="' . $alt . '" class="avatar avatar-' . $size . ' photo" />';
				}

				return $return;
			} else {
				return $avatar;
			}
		}
	}

	cjwpbldr_fa_configuration_wordpress::getInstance();
}