<?php
// Exit if accessed directly.
if( ! defined( 'ABSPATH' ) ) {
	exit;
}

if( ! class_exists( 'cjwpbldr_fa_configuration_wp_mail' ) ) {
	class cjwpbldr_fa_configuration_wp_mail {
		public $helpers;
		private static $instance;

		public static function getInstance() {
			if( ! isset( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		public function __construct() {
			$this->helpers = cjwpbldr_frontend_auth_helpers::getInstance();
			add_action( 'admin_init', array($this, 'emailConfigSendTestEmail') );
			add_filter( 'cjwpbldr_email_variables_user', array($this, 'extendUserVariables') );
			add_filter( 'cjwpbldr_content_above_email', array($this, 'contentAboveEmail') );
			add_filter( 'cjwpbldr_content_below_email', array($this, 'contentBelowEmail') );
		}

		public function extendUserVariables( $array ) {
			$array['reset_password_verification_link'] = __( 'This will display reset password verification url.', '' );

			return $array;
		}

		public function contentAboveEmail( $content ) {
			$content_above = $this->helpers->savedOption( 'cjfmr_code_above_email' );

			return $content_above . $content;
		}

		public function contentBelowEmail( $content ) {
			$content_below = $this->helpers->savedOption( 'cjfmr_code_below_email' );

			return $content . $content_below;
		}

		/**
		 * Send test email from email configuration page.
		 */
		public function emailConfigSendTestEmail() {
			if( isset( $_GET['cjwpbldr_action'] ) && $_GET['cjwpbldr_action'] == 'send-test-email' ) {

				$email_data = array(
					'to' => $this->helpers->frontendAuthAdminEmail(),
					'from_name' => $this->helpers->savedOption( 'cjfmr_email_from_name' ),
					'from_email' => $this->helpers->savedOption( 'cjfmr_email_from' ),
					'subject' => sprintf( __( 'Email test @ %s', 'addon-frontend-auth' ), get_bloginfo( 'name' ) ),
					'message' => __( 'This is a test message and this will be replaced with actual message.', 'addon-frontend-auth' ),
				);
				$this->helpers->sendEmail( $email_data );
				$location = $this->helpers->callbackUrl( 'cjfm-configuration-wp-mail', null, 'addon-frontend-auth' );
				wp_safe_redirect( $location );
				exit;
			}
		}

	}

	cjwpbldr_fa_configuration_wp_mail::getInstance();
}