<?php
// Exit if accessed directly.
if( ! defined( 'ABSPATH' ) ) {
	exit;
}

if( ! class_exists( 'cjwpbldr_frontend_auth_nav_menu_metabox' ) ) {
	class cjwpbldr_frontend_auth_nav_menu_metabox {
		public $helpers;
		private static $instance;

		public static function getInstance() {
			if( ! isset( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		public function __construct() {
			$this->helpers = cjwpbldr_frontend_auth_helpers::getInstance();
			//add_action( 'admin_init', array($this, 'init') );
			add_action( 'admin_init', array($this, 'navMenuMetaboxLinks'), 10 );
		}

		public function navMenuMetaboxLinks() {
			add_filter( 'cjwpbldr_nav_menu_metabox_links', function ( $links ) {

				$link_page_login = $this->helpers->getOptionPageUrl( 'cjfmr_page_login' );
				$link_page_register = $this->helpers->getOptionPageUrl( 'cjfmr_page_register' );
				$link_page_edit_profile = $this->helpers->getOptionPageUrl( 'cjfmr_page_edit_profile' );
				$link_page_password = $this->helpers->getOptionPageUrl( 'cjfmr_page_password' );
				$link_page_logout = $this->helpers->getOptionPageUrl( 'cjfmr_page_logout' );

				$links['cjwpbldr-frontend-auth-title'] = array(
					'object_id' => 'cjwpbldr-metabox-frontend-auth-heading',
					'label' => 'WP Frontend Auth',
					'type' => 'cjwpbldr-metabox-heading',
					'title' => '',
					'url' => '',
					'classes' => '',
				);

				if( $link_page_login != '' ) {
					$links['cjwpbldr-frontend-auth-login-page'] = array(
						'object_id' => 'cjwpbldr-frontend-auth-login-page',
						'label' => __( 'Login Page Link', 'addon-frontend-auth' ),
						'type' => 'custom',
						'title' => 'Sign In',
						'url' => $link_page_login,
						'classes' => 'cj-show-if-logged-out',
					);
				}
				if( $link_page_register != '' ) {
					$links['cjwpbldr-frontend-auth-register-page'] = array(
						'object_id' => 'cjwpbldr-frontend-auth-register-page',
						'label' => __( 'Register Page Link', 'addon-frontend-auth' ),
						'type' => 'custom',
						'title' => 'Sign In',
						'url' => $link_page_register,
						'classes' => 'cj-show-if-logged-out',
					);
				}
				if( $link_page_edit_profile != '' ) {
					$links['cjwpbldr-frontend-auth-edit-profile-page'] = array(
						'object_id' => 'cjwpbldr-frontend-auth-edit-profile-page',
						'label' => __( 'Edit Profile Page Link', 'addon-frontend-auth' ),
						'type' => 'custom',
						'title' => 'Edit Profile',
						'url' => $link_page_edit_profile,
						'classes' => 'cj-show-if-logged-out',
					);
				}
				if( $link_page_password != '' ) {
					$links['cjwpbldr-frontend-auth-forgot-password-page'] = array(
						'object_id' => 'cjwpbldr-frontend-auth-forgot-password-page',
						'label' => __( 'Forgot Password Page Link', 'addon-frontend-auth' ),
						'type' => 'custom',
						'title' => 'Forgot Password?',
						'url' => $link_page_password,
						'classes' => 'cj-show-if-logged-out',
					);
				}
				if( $link_page_logout != '' ) {
					$links['cjwpbldr-frontend-auth-logout-page'] = array(
						'object_id' => 'cjwpbldr-frontend-auth-logout-page',
						'label' => __( 'Logout Page Link', 'addon-frontend-auth' ),
						'type' => 'custom',
						'title' => 'Logout',
						'url' => $link_page_logout,
						'classes' => 'cj-show-if-logged-in',
					);
				}

				return $links;
			}, 1 );
		}

	}

	cjwpbldr_frontend_auth_nav_menu_metabox::getInstance();
}