<?php
// Exit if accessed directly.
if( ! defined( 'ABSPATH' ) ) {
	exit;
}

if( ! class_exists( 'cjwpbldr_password_strength_meter' ) ) {
	class cjwpbldr_password_strength_meter {
		private static $instance;

		public static function getInstance() {
			if( ! isset( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		public function __construct() {
			$this->helpers = cjwpbldr_frontend_auth_helpers::getInstance();
			add_action( 'cjwpbldr_form_extend_fields', [$this, 'showMeter'], 5 );
		}

		public function showMeter( $fields ) {
			$allowed_pages = [
				$this->helpers->savedOption( 'cjfmr_page_new_password' ),
				$this->helpers->savedOption( 'cjfmr_page_register' ),
				$this->helpers->savedOption( 'cjfmr_page_edit_profile' )
			];

			if( is_page( $allowed_pages ) ) {
				if( $this->helpers->savedOption( 'cjfmr_show_password_meter' ) == 'yes' ) {
					foreach( $fields as $key => $field ) {
						if( strpos( $field['id'], 'password' ) || strpos( $field['id'], 'pass' ) ) {
							$meter_id = 'password-meter-label-' . $field['id'];
							$bar_id = 'password-meter-progress-' . $field['id'];
							$fields[ $key ]['info'] = '<span id="' . $meter_id . '"></span><progress id="' . $bar_id . '" class="cj-is-hidden" value="0" max="100"></progress>';
							$fields[ $key ]['params'] = [
								'data-meter-id' => $meter_id,
								'data-meter-bar-id' => $bar_id,
								'class' => 'password-meter'
							];
						}
					}
				}
			}

			return $fields;
		}

	}

	cjwpbldr_password_strength_meter::getInstance();
}