<?php
// Exit if accessed directly.
if( ! defined( 'ABSPATH' ) ) {
	exit;
}

if( ! class_exists( 'cjwpbldr_import_export_users' ) ) {

	class cjwpbldr_import_export_users {

		public $helpers, $user_meta_keys, $user_set_export_limit, $users_table_columns;
		public $errors = array();
		public $textdomain;
		public static $instance;

		public static function getInstance() {
			if( ! isset( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		public function __construct() {
			$this->helpers = cjwpbldr_frontend_auth_helpers::getInstance();
			$this->textdomain = 'cjwpbldr';
			$this->user_set_export_limit = get_option( 'cjwpbldr_user_set_export_limit' );
			$this->exportUserInitValues();
			$this->users_table_columns = array('user_nicename', 'user_email', 'user_url', 'user_registered', 'user_status', 'display_name', 'spam', 'deleted');
			add_action( 'init', array($this, 'initFunctions') );
		}

		public function initFunctions() {
			$this->exportUsersData();
			$this->clearExportStats();
			$this->updateExistingUser();
			$this->addNewUser();
		}

		public function getUserMetaKeys() {
			global $wpdb;
			$user_meta_keys_array = array();

			$user_meta_keys_query = $wpdb->get_results( "SELECT meta_key FROM $wpdb->usermeta ORDER BY meta_key ASC" );
			if( is_array( $user_meta_keys_query ) && ! empty( $user_meta_keys_query ) ) {
				foreach( $user_meta_keys_query as $m_key => $meta ) {
					$user_meta_keys_array[ $meta->meta_key ] = $meta->meta_key;
				}
			}

			return $user_meta_keys_array;
		}

		public function exportUserStats() {
			global $wpdb;

			$total_users = $wpdb->get_row( "SELECT COUNT(*) as total_users FROM $wpdb->users" );

			$exported_users = get_option( $this->textdomain . '_exported_users' );

			$last_exported = (get_option( $this->textdomain . '_last_exported_users' ) != '') ? get_option( $this->textdomain . '_last_exported_users' ) : 'No Records Found';

			$done = ($last_exported != 'No Records Found') ? true : false;

			$all_exported = ($done) ? __( '<br/><strong>All Users Exported. Please Clear Stats before proceeding again.</strong>', $this->textdomain ) : '';

			$export_stats_content = 'Total number of users : ' . $total_users->total_users;
			$export_stats_content .= '<br/>';
			$export_stats_content .= 'Exported Users : ' . $exported_users . ' of ' . $total_users->total_users;
			$export_stats_content .= ' <a href="' . $this->helpers->callbackUrl( 'cjfm-manage-import-export-users', '', 'addon-frontend-auth' ) . '" title="Reload">Referesh</a>';
			$export_stats_content .= '<br/>';
			$export_stats_content .= 'Last Exported On : ' . $last_exported;
			$export_stats_content .= '<br/>';
			$export_stats_content .= '<a href="' . $this->helpers->callbackUrl( 'cjfm-manage-import-export-users', '', 'addon-frontend-auth' ) . '&clear_stats=yes" title="Clear Stats">Clear Stats</a>';
			$export_stats_content .= $all_exported;

			return $export_stats_content;
		}

		public function exportUserInitValues() {
			global $wpdb;

			$total_users = $wpdb->get_row( "SELECT COUNT(*) as total_users FROM $wpdb->users" );

			if( ! get_option( $this->textdomain . '_export_offset' ) ) {
				add_option( $this->textdomain . '_export_offset', '0' );
			}
			if( ! get_option( $this->textdomain . '_export_total_users' ) ) {
				add_option( $this->textdomain . '_export_total_users', $total_users->total_users );
			}
			if( ! get_option( $this->textdomain . '_exported_users' ) ) {
				add_option( $this->textdomain . '_exported_users', '0' );
			}
		}

		public function exportUsersData() {

			if( isset( $_REQUEST['export_data'] ) ) {

				global $wpdb;

				$cjwpbldr_action = $_REQUEST['export_action'];

				$form_id = $_REQUEST['export_form_id'];

				$selected_fields = (isset( $_REQUEST['user_data_export'] ) && ! empty( $_POST['user_data_export'] ) ? $_POST['user_data_export'] : array());

				if( $form_id != 'none' || isset( $form_id ) ) {
					$form_fields = $this->helpers->getFormFields( $form_id );
				} else {
					$form_fields = array();
				}

				if( ! get_option( $this->textdomain . '_user_set_export_limit' ) ) {

					add_option( $this->textdomain . '_user_set_export_limit', $_POST['export_limit'] );
				}

				if( get_option( $this->textdomain . '_user_set_export_limit' ) ) {
					$user_limit = get_option( $this->textdomain . '_user_set_export_limit' );
				} else {
					$user_limit = $_POST['export_limit'];
				}

				$offset = get_option( $this->textdomain . '_export_offset' );

				$offset_number = get_option( $this->textdomain . '_export_start_limit' );

				$users_table_columns = array('ID', 'user_login', 'user_pass', 'user_nicename', 'user_email', 'user_url', 'user_registered', 'user_status', 'display_name');

				$columns_array[] = 'Sr. No.';

				$new_users_meta_columns_array = array();

				foreach( $users_table_columns as $ukey ) {
					$columns_array[] = $ukey;
					$new_users_columns_array[] = $ukey;
				}

				if( is_array( $selected_fields ) && ! empty( $selected_fields ) ) {

					foreach( $selected_fields as $skey => $svalue ) {
						$columns_array[] = $svalue;
						$new_users_meta_columns_array[] = $svalue;
					}
				}

				$custom_fields = $form_fields;

				$new_custom_fields = array();
				$custom_user_fields = array();

				if( ! empty( $custom_fields ) ) {

					foreach( $custom_fields as $key => $value ) {
						$new_custom_fields[ $value['id'] ] = $value;
					}

					foreach( $new_custom_fields as $key => $value ) {
						if( in_array( $key, $users_table_columns ) ) {
							unset( $new_custom_fields[ $key ] );
						}
					}

					foreach( $new_custom_fields as $key => $value ) {
						$columns_array[] = $key;
						$custom_user_fields[] = $key;
						$new_users_columns_array[] = $key;
					}
				}

				$user_query = new WP_User_Query( array('orderby' => 'ID', 'number' => $user_limit, 'offset' => $offset) );

				$users_row = $user_query->get_results();

				foreach( $users_row as $ukey => $uvalue ) {

					$uvalue_array = (array) $uvalue->data;

					foreach( $uvalue_array as $key => $value_data ) {

						if( in_array( $key, $users_table_columns ) ) {

							$rows_array[ $uvalue->ID ]['count'] = $ukey + 1;

							if( $key == 'user_registered' ) {
								$rows_array[ $uvalue->ID ][ $key ] = date( 'Y-m-d H:i:s', strtotime( $value_data ) );
							} else {
								$rows_array[ $uvalue->ID ][ $key ] = $value_data;
							}
						}
					}

					if( is_array( $new_users_meta_columns_array ) && ! empty( $new_users_meta_columns_array ) ) {

						foreach( $new_users_meta_columns_array as $mkey => $mvalue ) {
							$rows_array[ $uvalue->ID ][ $mvalue ] = get_user_meta( $uvalue->ID, $mvalue, true );
						}
					}

					if( is_array( $custom_user_fields ) && ! empty( $custom_user_fields ) ) {

						foreach( $custom_user_fields as $ckey => $cvalue ) {
							$meta_value = get_user_meta( $uvalue->ID, $cvalue, true );
							if( is_array( $meta_value ) ) {
								$rows_array[ $uvalue->ID ][ $cvalue ] = implode( ', ', $meta_value );
							} else {
								$rows_array[ $uvalue->ID ][ $cvalue ] = $meta_value;
							}
						}
					}
				}

				if( isset( $cjwpbldr_action ) && $cjwpbldr_action == 'export_users' ) {

					$file_name = sanitize_title( get_bloginfo( 'name' ) . '-users-' . date( "Y-m-d" ) );

					if( ! empty ( $rows_array ) ) {

						$rows_left = count( $rows_array );

						$updated_offset = get_option( $this->textdomain . '_export_offset' ) + $user_limit;

						if( $updated_offset >= get_option( $this->textdomain . '_export_total_users' ) && $rows_left != 0 ) {

							update_option( $this->textdomain . '_export_offset', $updated_offset );

							update_option( $this->textdomain . '_exported_users', get_option( $this->textdomain . '_export_total_users' ) );

							update_option( $this->textdomain . '_last_exported_users', $this->helpers->wpDate( null, 'date-time' ) );

							$this->createCSV( $file_name, $columns_array, $rows_array );
						}

						if( $updated_offset >= get_option( $this->textdomain . '_export_total_users' )
						    && get_option( $this->textdomain . '_exported_users' ) == get_option( $this->textdomain . '_export_total_users' )
						    && $rows_left != 0
						) {

							wp_redirect( $this->helpers->callbackUrl( 'cjfm-manage-import-export-users', '', 'addon-frontend-auth' ) );

							exit;
						}

						if( $updated_offset >= get_option( $this->textdomain . '_export_total_users' )
						    && get_option( $this->textdomain . '_exported_users' ) == get_option( $this->textdomain . '_export_total_users' )
						    && $rows_left == 0
						) {

							wp_redirect( $this->helpers->callbackUrl( 'cjfm-manage-import-export-users', '', 'addon-frontend-auth' ) );

							exit;
						}

						update_option( $this->textdomain . '_export_offset', $updated_offset );

						update_option( $this->textdomain . '_exported_users', $updated_offset );

						$this->createCSV( $file_name, $columns_array, $rows_array );
					} else {

						wp_redirect( $this->helpers->callbackUrl( 'cjfm-manage-import-export-users', '', 'addon-frontend-auth' ) );

						exit;
					}
				}

				if( isset( $cjwpbldr_action ) && $cjwpbldr_action == 'download_format' ) {

					$file_name = 'cjwpbldr-users-import-format';

					$this->createCSV( $file_name, $columns_array, array() );
				}

				if( isset( $cjwpbldr_action ) && $cjwpbldr_action == 'download_format_new_users' ) {

					$file_name = 'cjwpbldr-new-users-import-format';

					foreach( $new_users_columns_array as $key => $value ) {

						if( $value != 'ID' && $value != 'spam' && $value != 'deleted' && $value != 'user_status' ) {
							$new_users_array[] = $value;
						}
					}

					$this->createCSV( $file_name, $new_users_array, array() );
				}
			}
		}

		public function updateExistingUser() {
			if( isset( $_POST['upload_user_data'] ) ) {

				if( isset( $_FILES ) ) {

					global $wpdb;

					$error = array();

					if( $_FILES['cjwpbldr_import_users']['error'] != 0 ) {
						$this->errors[] = esc_attr__( 'No file found to update users, please choose a file to upload.', 'addon-frontend-auth' );
					} elseif( $_FILES['cjwpbldr_import_users']['type'] != 'text/csv' ) {
						$this->errors[] = esc_attr__( 'Invalid file type, please try again.', 'addon-frontend-auth' );
						$this->errors[] = esc_attr__( 'Uploaded File Type is: ', 'addon-frontend-auth' ) . $_FILES['cjwpbldr_import_users']['type'];
					} else {

						$user_data = $this->parseCSV( $_FILES['cjwpbldr_import_users']['tmp_name'], 'data' );

						$required_fields = array('ID', 'user_login', 'user_email');

						if( ! empty( $user_data ) ) {

							foreach( $user_data as $ckey => $cvalue ) {
								$total[ $ckey ] = 1;
								$ids[ @$cvalue['ID'] ] = @$cvalue['ID'];
								$emails[ @$cvalue['user_email'] ] = @$cvalue['user_email'];
								$logins[ @$cvalue['user_login'] ] = @$cvalue['user_login'];
							}

							if( count( $logins ) != count( $total ) || count( $ids ) != count( $total ) || count( $emails ) != count( $total ) ) {
								$error[] = __( '<b>Invalid Data</b>, please verify the uploaded data and try again.<br>ID, user_login, user_email fields are required and must be unique.', 'addon-frontend-auth' );
							}

							foreach( $user_data as $key => $value ) {
								$users_table_data = null;
								$user_id = $value['ID'];

								$check_id = $this->helpers->userInfo( @$value['ID'] );
								$check_user_login = $this->helpers->userInfo( @$value['user_login'] );
								$check_user_email = $this->helpers->userInfo( @$value['user_email'] );

								if( empty( $check_id ) && empty( $check_user_login ) && empty( $check_user_email ) ) {
									$excluded_users[] = '<li>' . $value['user_login'] . '</li>';
									$error[] = sprintf( __( 'Could not find these users in database:<br><ol>%s</ol>', 'addon-frontend-auth' ), implode( '', $excluded_users ) );
								}

								if( empty( $error ) ) {

									foreach( $value as $ukey => $uvalue ) {
										if( in_array( $ukey, $this->users_table_columns ) ) {
											if( $ukey == 'user_registered' ) {
												$users_table_data[ $ukey ] = date( 'Y-m-d H:i:s', strtotime( $uvalue ) );
											} else {
												$users_table_data[ $ukey ] = $uvalue;
											}
										}
									}

									$this->helpers->update( $wpdb->users, $users_table_data, 'ID', $user_id );

									if( ! in_array( $ukey, $this->users_table_columns ) ) {
										update_user_meta( $value['ID'], $ukey, $value[ $ukey ] );
									}
								}
							}

							if( empty( $error ) ) {
								$this->errors[] = esc_attr__( 'User data uploaded successfully.', 'addon-frontend-auth' );
							} else {
								foreach( $error as $err ) {
									$this->errors[] = $err;
								}
							}
						} else {
							$this->errors[] = esc_attr__( 'No data found in the uploaded file, please check and try again.', 'addon-frontend-auth' );
						}
					}
				}
			}
		}

		public function addNewUser() {
			if( isset( $_POST['add_new_users'] ) ) {

				$error = array();

				if( isset( $_FILES ) ) {

					if( $_FILES['cjwpbldr_new_users']['error'] != 0 ) {
						$this->errors[] = esc_attr__( 'No file found to add new users, please choose a file to upload.', 'addon-frontend-auth' );
					} elseif( $_FILES['cjwpbldr_new_users']['type'] != 'text/csv' ) {
						$this->errors[] = esc_attr__( 'Invalid file type, please try again.', 'addon-frontend-auth' );
					} else {

						$user_data = $this->parseCSV( $_FILES['cjwpbldr_new_users']['tmp_name'], 'data' );

						if( ! empty( $user_data ) ) {

							foreach( $user_data as $ckey => $cvalue ) {
								$total[ $ckey ] = 1;
								$emails[ @$cvalue['user_email'] ] = @$cvalue['user_email'];
								$logins[ @$cvalue['user_login'] ] = @$cvalue['user_login'];

								$check_user_login = $this->helpers->userInfo( @$cvalue['user_login'] );
								$check_user_email = $this->helpers->userInfo( @$cvalue['user_email'] );

								if( ! empty( $check_user_login ) ) {
									$user_exists[] = '<li>' . @$cvalue['user_login'] . '</li>';
									//$error['user_exists'] = sprintf(esc_attr__('Following users already registered:<br><ol>%s</ol>', 'addon-frontend-auth'), implode('', $user_exists));
								}

								if( ! empty( $check_user_email ) ) {
									$email_exists[] = '<li>' . @$cvalue['user_email'] . '</li>';
									//$error['email_exists'] = sprintf(esc_attr__('Following email addresses already registered:<br><ol>%s</ol>', 'addon-frontend-auth'), implode('', $email_exists));
								}
							}

							if( count( $logins ) != count( $total ) || count( $emails ) != count( $total ) ) {
								$error[] = __( '<b>Invalid Data</b>, please verify the uploaded data and try again.<br>user_login, user_email fields are required and must be unique.', 'addon-frontend-auth' );
							}

							if( empty( $error ) ) {

								foreach( $user_data as $ckey => $cvalue ) {

									if( @$cvalue['user_pass'] != '' ) {
										$password = @$cvalue['user_pass'];
									} else {
										$password = strtolower( $this->helpers->uniqueString() );
									}
									if( @$cvalue['user_login'] != '' && @$cvalue['user_email'] != '' ) {

										if( ! username_exists( $cvalue['user_login'] ) && ! email_exists( $cvalue['user_email'] ) ) {

											$new_user = wp_create_user( $cvalue['user_login'], $password, $cvalue['user_email'] );
											$nuid = $new_user;
										} else {
											$nuid = $this->helpers->userInfo( $cvalue['user_login'], 'ID' );
										}

										foreach( $cvalue as $ckey => $cvalue ) {

											if( in_array( $ckey, $this->users_table_columns ) ) {
												$update_user_data[ $nuid ]['ID'] = $nuid;
												if( $ckey == 'user_registered' ) {
													$update_user_data[ $nuid ][ $ckey ] = date( 'Y-m-d H:i:s', strtotime( $cvalue ) );
												} else {
													$update_user_data[ $nuid ][ $ckey ] = $cvalue;
												}
												wp_update_user( $update_user_data[ $nuid ] );
											}

											if( ! in_array( $ckey, $this->users_table_columns ) && ! in_array( $ckey, array('user_login', 'user_pass', 'user_email') ) ) {
												update_user_meta( $nuid, $ckey, $cvalue );
											}
										}
									}
								}

								$this->errors[] = esc_attr__( 'New user data uploaded successfully.', 'addon-frontend-auth' );
							} else {
								foreach( $error as $err ) {
									$this->errors[] = $err;
								}
							}
						} else {
							$this->errors[] = esc_attr__( 'No data found in the uploaded file, please check and try again.', 'addon-frontend-auth' );
						}
					}
				}
			}
		}

		public function displayImportExportErrors() {

			if( ! empty( $this->errors ) ) {
				foreach( $this->errors as $key => $value ) {
					echo '<h3>' . $value . '</h3>';
				}
			}
		}

		public function createCSV( $filename = null, $headings_array = null, $row_array = null ) {

			ob_get_clean();

			$output_file = (is_null( $filename )) ? date( 'Y-m-d-H-i-s' ) : $filename;

			if( is_null( $row_array ) ) {
				return;
			}

			// output headers so that the file is downloaded rather than displayed
			header( "Content-type: Application/CSV" );
			header( 'Content-Disposition: attachment; filename=' . $output_file . '.csv' );
			header( 'Cache-Control: cache, must-revalidate' ); // HTTP/1.1
			header( 'Pragma: public' ); // HTTP/1.0

			ob_start();
			ob_flush();

			// create a file pointer connected to the output stream
			$output = @fopen( 'php://output', 'w' );

			ob_end_clean();

			// output the column headings
			fputcsv( $output, $headings_array );

			// loop over the rows, outputting them
			foreach( $row_array as $key => $value ) {
				fputcsv( $output, $value );
			}

			fclose( $output );

			exit;
		}

		public function clearExportStats() {

			if( isset( $_GET['clear_stats'] ) ) {
				update_option( $this->textdomain . '_export_offset', '0' );
				update_option( $this->textdomain . '_exported_users', '0' );
				delete_option( $this->textdomain . '_user_set_export_limit' );
				delete_option( $this->textdomain . '_last_exported_users' );

				wp_redirect( $this->helpers->callbackUrl( 'cjfm-manage-import-export-users', '', 'addon-frontend-auth' ) );
				exit;
			}
		}

		function parseCSV( $file_url, $return = 'data' ) {

			global $cjwpbldr_get_options;

			require_once('lib/parse-csv/parsecsv.lib.php');

			# create new parseCSV object.
			$csv = new parseCSV();

			/*$csv->delimiter = "{$delimiter}";   # tab delimited
			$csv->parse('_books.csv');*/

			# Parse '_books.csv' using automatic delimiter detection...
			$csv->auto( $file_url );

			if( $return == 'data' ) {
				return $csv->data;
			} else {
				return $csv;
			}
		}

	}

	cjwpbldr_import_export_users::getInstance();
}