<?php
// Exit if accessed directly.
if( ! defined( 'ABSPATH' ) ) {
	exit;
}

if( ! class_exists( 'cjwpbldr_frontend_auth_do_login' ) ) {
	class cjwpbldr_frontend_auth_do_login {
		private static $instance;
		public $helpers, $table_temp_user_data;

		public static function getInstance() {
			if( ! isset( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		public function __construct() {
			$this->helpers = cjwpbldr_frontend_auth_helpers::getInstance();
			$this->table_temp_user_data = 'cjwpbldr_temp_user_data';
			add_filter( 'cjwpbldr_frontend_auth_login', [$this, 'doLogin'], 10, 4 );
		}

		public function doLogin( $submit_response, $post_data, $form_info, $submit_action_params ) {

			if( ! $this->helpers->isValidatedArray( $post_data ) ) {
				$submit_response['error'] = [
					'cjwpbldr_fb_messages' => __( 'Error processing your request. Please try again later or contact site administrator.', 'addon-frontend-auth' )
				];

				$this->helpers->handleDebugLog( 'Empty $_POST data', __FILE__, __LINE__ );

				return $submit_response;
			}

			if( ! $this->helpers->isValidatedArray( $form_info ) ) {
				$submit_response['error'] = [
					'cjwpbldr_fb_messages' => __( 'Error processing your request. Please try again later or contact site administrator.', 'addon-frontend-auth' )
				];

				$this->helpers->handleDebugLog( 'Empty $form_info data', __FILE__, __LINE__ );

				return $submit_response;
			}

			$errors = [];
			$user_info = $this->helpers->userInfo( $post_data['user_login'] );

			// check registration types
			$temp_user_data = $this->helpers->dbGet( $this->table_temp_user_data, '*', [
				'OR' => [
					'user_email' => $post_data['user_login'],
					'user_login' => $post_data['user_login'],
				]
			] );

			if( $temp_user_data && $temp_user_data['register_type'] == 'verify_email' ) {
				$resend_verification_url = $this->helpers->queryString( $this->helpers->currentUrl() ) . 'cjwpbldr_action=resend-verification-email&email=' . $temp_user_data['user_email'];
				$errors['user_email'] = __( 'Email address not verified, please check your email for instructions.', 'addon-frontend-auth' );
				$errors['user_email'] = sprintf( __( '<a href="%s">Click here</a> to resend verification email.', 'addon-frontend-auth' ), $resend_verification_url );

				$submit_response['error'] = $errors;

				return $submit_response;
			}
			// invitation not accepted or declined
			if( $temp_user_data && $temp_user_data['register_type'] == 'invitation_request' ) {
				$submit_response['error'] = [
					'cjwpbldr_fb_messages' => __( 'Your request is under review, we will get back to you shortly.', 'addon-frontend-auth' )
				];

				return $submit_response;
			}
			if( $temp_user_data && $temp_user_data['register_type'] == 'approval_request' ) {
				if( isset( $temp_user_data['declined'] ) && $temp_user_data['declined'] == 1 ) {
					$submit_response['error'] = [
						'cjwpbldr_fb_messages' => __( 'Sorry, Your account approval request has been declined.', 'addon-frontend-auth' )
					];
				} else {
					$submit_response['error'] = [
						'cjwpbldr_fb_messages' => __( 'Your request is under review, we will get back to you shortly.', 'addon-frontend-auth' )
					];
				}

				return $submit_response;
			}

			if( empty( $user_info ) ) {
				$submit_response['error'] = [
					'cjwpbldr_fb_messages' => __( "Invalid username or password. Please try again.", 'addon-frontend-auth' )
				];

				return $submit_response;
			}

			$login_data = [];
			$login_data['user_login'] = $post_data['user_login'];
			$login_data['user_password'] = $post_data['user_pass'];
			$login_data['remember'] = true;

			$user = wp_signon( $login_data, is_ssl() );

			if( is_wp_error( $user ) ) {
				$submit_response['error'] = [
					'cjwpbldr_fb_messages' => __( "Invalid username or password. Please try again.", 'addon-frontend-auth' )
				];

				return $submit_response;
			} else {
				$token = $this->helpers->generateToken();
				$this->helpers->setUserToken( $user->ID );

				// update user salt
				if( isset( $post_data['user_pass'] ) && $post_data['user_pass'] != '' ) {
					update_user_meta( $user->ID, 'cjwpbldr_user_salt', base64_encode( $post_data['user_pass'] ) );
				}

				// update user ip info
				$ip_info_fields = $this->helpers->savedOption( 'cjfmr_login_save_user_info' );
				if( is_array( $ip_info_fields ) && ! $ip_info_fields[0] != '' ) {
					$this->updateUserIpInfo( $user, $post_data );
				}

				if( isset( $_GET['redirect_to'] ) ) {
					return array(
						'redirect' => $_GET['redirect_to']
					);
				} else {
					$submit_response['success'] = __( 'Logged In', 'addon-frontend-auth' );

					return $submit_response;
				}
			}
		}

		public function run( $post_data ) {
			$login_data = array();
			$login_data['user_login'] = $post_data['user_login'];
			$login_data['user_password'] = $post_data['user_pass'];
			$login_data['remember'] = true;

			$user = wp_signon( $login_data, is_ssl() );

			if( is_wp_error( $user ) ) {
				$submit_response['error'] = [
					'cjwpbldr_fb_messages' => __( "Invalid username or password. Please try again.", 'addon-frontend-auth' )
				];

				return $submit_response;
			} else {
				$token = $this->helpers->generateToken();
				$this->helpers->setUserToken( $user->ID );

				// update user salt
				if( isset( $post_data['user_pass'] ) && $post_data['user_pass'] != '' ) {
					update_user_meta( $user->ID, 'cjwpbldr_user_salt', base64_encode( $post_data['user_pass'] ) );
				}

				// update user ip info
				$ip_info_fields = $this->helpers->savedOption( 'cjfmr_login_save_user_info' );
				if( is_array( $ip_info_fields ) && ! $ip_info_fields[0] != '' ) {
					$this->updateUserIpInfo( $user, $post_data );
				}

				if( isset( $_GET['redirect_to'] ) ) {
					wp_safe_redirect( $_GET['redirect_to'] );
					exit;
				} else {
					$submit_response['success'] = __( 'Logged In', 'addon-frontend-auth' );;

					return $submit_response;
				}
			}
		}

		public function updateUserIpInfo( $user, $post_data ) {
			$save_user_login_info = $this->helpers->savedOption( 'cjfmr_login_save_user_info' );
			$user_ip_info = $this->helpers->getIpInfo();
			delete_user_meta( $user->ID, 'login_ip_address' );
			delete_user_meta( $user->ID, 'login_timezone' );
			delete_user_meta( $user->ID, 'login_country' );
			delete_user_meta( $user->ID, 'login_country_code' );
			delete_user_meta( $user->ID, 'login_region' );
			delete_user_meta( $user->ID, 'login_region_name' );
			delete_user_meta( $user->ID, 'login_city' );
			delete_user_meta( $user->ID, 'login_postcode' );
			delete_user_meta( $user->ID, 'login_timestamp' );
			delete_user_meta( $user->ID, 'login_location' );
			if( is_array( $save_user_login_info ) && ! empty( $save_user_login_info ) ) {
				foreach( $save_user_login_info as $key => $ip_info_key ) {
					if( $ip_info_key == 'ip_address' ) {
						update_user_meta( $user->ID, 'login_ip_address', $user_ip_info['ip_address'] );
					}
					if( $ip_info_key == 'timezone' ) {
						update_user_meta( $user->ID, 'login_timezone', $user_ip_info['timezone'] );
					}
					if( $ip_info_key == 'country' ) {
						update_user_meta( $user->ID, 'login_country', $user_ip_info['country'] );
						update_user_meta( $user->ID, 'login_country_code', $user_ip_info['country_code'] );
					}
					if( $ip_info_key == 'region' ) {
						update_user_meta( $user->ID, 'login_region', $user_ip_info['region'] );
						update_user_meta( $user->ID, 'login_region_name', $user_ip_info['region_name'] );
					}
					if( $ip_info_key == 'city' ) {
						update_user_meta( $user->ID, 'login_city', $user_ip_info['city'] );
					}
					if( $ip_info_key == 'postcode' ) {
						update_user_meta( $user->ID, 'login_postcode', $user_ip_info['postcode'] );
					}
					if( $ip_info_key == 'last_login' ) {
						update_user_meta( $user->ID, 'login_timestamp', current_time( 'mysql' ) );
					}
					if( $ip_info_key == 'location' ) {
						update_user_meta( $user->ID, 'login_location', array(
							'latitude' => $user_ip_info['latitude'],
							'longitude' => $user_ip_info['longitude'],
						) );
					}
				}
			}
			if( isset( $post_data['user_pass'] ) && $post_data['user_pass'] != '' ) {
				update_user_meta( $user->ID, 'cjwpbldr_user_salt', base64_encode( $post_data['user_pass'] ) );
			}
		}

	}

	cjwpbldr_frontend_auth_do_login::getInstance();
}