<?php
// Exit if accessed directly.
if( ! defined( 'ABSPATH' ) ) {
	exit;
}

if( ! class_exists( 'cjwpbldr_frontend_auth_do_set_new_password' ) ) {
	class cjwpbldr_frontend_auth_do_set_new_password {
		private static $instance;
		public $helpers, $verification_url_key;

		public static function getInstance() {
			if( ! isset( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		public function __construct() {
			$this->helpers = cjwpbldr_frontend_auth_helpers::getInstance();
			$this->verification_url_key = $this->helpers->savedOption( 'cjfmr_password_verification_key' );

			add_filter( 'cjwpbldr_form_extend_fields', [$this, 'addVerificationKeyField'] );
			add_filter( 'cjwpbldr_frontend_auth_new_password', [$this, 'processNewPassword'], 10, 4 );
		}

		public function addVerificationKeyField( $form_fields ) {
			$verification_key_field = [];
			if( ! isset( $form_fields['form_id'] ) ) {
				return $form_fields;
			}
			if( ! $this->helpers->isValidatedArray( $form_fields['form_id'], true, 'default' ) && $form_fields['form_id']['default'] == '' ) {
				return $form_fields;
			}
			if( is_user_logged_in() ) {
				return $form_fields;
			}

			if( isset( $_GET[ $this->verification_url_key ] ) ) {
				$verification_key_field['new_password_verify_key'] = array(
					'type' => 'hidden',
					'id' => $this->verification_url_key,
					'label' => '',
					'default' => $_GET[ $this->verification_url_key ],
				);
			}

			return array_merge( $verification_key_field, $form_fields );
		}

		public function processNewPassword( $submit_response, $post_data, $form_info, $submit_action_params ) {

			if( ! $this->helpers->isValidatedArray( $post_data ) ) {
				$submit_response['error'] = [
					'cjwpbldr_fb_messages' => __( 'Error processing your request. Please try again later or contact site administrator.', 'addon-frontend-auth' )
				];

				$this->helpers->handleDebugLog( 'Empty $_POST data', __FILE__, __LINE__ );

				return $submit_response;
			}

			if( ! $this->helpers->isValidatedArray( $form_info ) ) {
				$submit_response['error'] = [
					'cjwpbldr_fb_messages' => __( 'Error processing your request. Please try again later or contact site administrator.', 'addon-frontend-auth' )
				];

				$this->helpers->handleDebugLog( 'Empty $form_info data', __FILE__, __LINE__ );

				return $submit_response;
			}

			$reset_password_page_url = get_permalink( $this->helpers->savedOption( 'cjfmr_page_password' ) );

			$verification_code = 'invalid-key';
			$verification_code = (isset( $_GET[ $this->verification_url_key ] ) && $_GET[ $this->verification_url_key ] != '') ? $_GET[ $this->verification_url_key ] : $verification_code;
			$verification_code = (isset( $post_data[ $this->verification_url_key ] ) && $post_data[ $this->verification_url_key ] != '') ? $post_data[ $this->verification_url_key ] : $verification_code;

			if( $verification_code == 'invalid-key' ) {
				$this->helpers->handleDebugLog( 'Reset key not present in either $_GET or $_POST.', __FILE__, __LINE__ );
			}

			$user_info = $this->helpers->getUserByMeta( 'cjfmr_reset_password_key', $verification_code );

			if( empty( $user_info ) ) {
				$submit_response['error'] = [
					'cjwpbldr_fb_messages' => sprintf( __( 'Invalid verification code, please <a href="%s">try again</a>.', 'addon-frontend-auth' ), $reset_password_page_url )
				];

				return $submit_response;
			}

			$user_info = $this->helpers->userInfo( $user_info->user_id );

			if( $post_data['new_password'] == '' ) {
				$submit_response['error'] = [
					'new_password' => __( 'You must type a password.', 'addon-frontend-auth' )
				];

				return $submit_response;
			}

			if( $post_data['new_password'] != '' && strlen( $post_data['new_password'] ) < $this->helpers->savedOption( 'cjfmr_min_password_length' ) ) {
				$submit_response['error'] = [
					'new_password' => sprintf( __( 'Password must be at least %s characters long.', 'addon-frontend-auth' ), $this->helpers->savedOption( 'cjfmr_min_password_length' ) ),
				];

				return $submit_response;
			}

			if( $post_data['new_password_confirmation'] != '' && strlen( $post_data['new_password_confirmation'] ) < $this->helpers->savedOption( 'cjfmr_min_password_length' ) ) {
				$submit_response['error'] = [
					'new_password_confirmation' => sprintf( __( 'Password must be at least %s characters long.', 'addon-frontend-auth' ), $this->helpers->savedOption( 'cjfmr_min_password_length' ) ),
				];

				return $submit_response;
			}

			if( $post_data['new_password'] != '' && $this->helpers->savedOption( 'cjfmr_strong_password' ) == 'yes' && ! $this->helpers->isStrongPassword( $post_data['new_password'] ) ) {
				$submit_response['error'] = [
					'new_password' => __( 'Your password must contain at least one number, one uppercase letter, one lowercase letter and a special character.', 'addon-frontend-auth' )
				];

				return $submit_response;
			}

			if( $post_data['new_password_confirmation'] != '' && $this->helpers->savedOption( 'cjfmr_strong_password' ) == 'yes' && ! $this->helpers->isStrongPassword( $post_data['new_password_confirmation'] ) ) {
				$submit_response['error'] = [
					'new_password_confirmation' => __( 'Your password must contain at least one number, one uppercase letter, one lowercase letter and a special character.', 'addon-frontend-auth' )
				];

				return $submit_response;
			}

			if( $post_data['new_password'] != '' && $post_data['new_password'] != $post_data['new_password_confirmation'] ) {
				$submit_response['error'] = [
					'cjwpbldr_fb_messages' => __( 'Password fields does not match.', 'addon-frontend-auth' ),
				];

				return $submit_response;
			}

			$auto_login = $submit_action_params['auto_login'];

			wp_set_password( $post_data['new_password'], $user_info['ID'] );

			delete_user_meta( $user_info['ID'], 'cjfmr_reset_password_key' );

			if( $auto_login == 'yes' ) {
				$login_class = cjwpbldr_frontend_auth_do_login::getInstance();
				$post_data = array(
					'user_login' => $user_info['user_login'],
					'user_pass' => $post_data['new_password'],
					'form_id' => $form_info['ID'],
					'current_url' => $this->helpers->currentUrl(),
				);

				$login_class->run( $post_data );
			}

			$submit_response['success'] = __( 'New Password Processed.', 'addon-frontend-auth' );

			return $submit_response;
		}

	}

	cjwpbldr_frontend_auth_do_set_new_password::getInstance();
}