<?php
// Exit if accessed directly.
if( ! defined( 'ABSPATH' ) ) {
	exit;
}

if( ! class_exists( 'cjwpbldr_frontend_auth_do_reset_password' ) ) {
	class cjwpbldr_frontend_auth_do_reset_password {
		private static $instance;
		public $helpers;
		private $verification_url_key = '';

		public static function getInstance() {
			if( ! isset( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		public function __construct() {
			$this->helpers = cjwpbldr_frontend_auth_helpers::getInstance();

			$this->verification_url_key = $this->helpers->savedOption( 'cjfmr_password_verification_key' );

			add_action( 'init', array($this, 'checkResetPasswordKey') );
			add_filter( 'cjwpbldr_frontend_auth_forgot_password', [$this, 'processForgotPassword'], 10, 4 );
		}

		public function processForgotPassword( $submit_response, $post_data, $form_info, $submit_action_params ) {
			if( $post_data['user_login'] == '' ) {
				$submit_response['error'] = [
					'user_login' => __( 'Please enter username or email address.', 'addon-frontend-auth' )
				];

				return $submit_response;
			}
			$user_info = $this->helpers->userInfo( $post_data['user_login'] );
			if( empty( $user_info ) ) {
				$submit_response['error'] = [
					'user_login' => sprintf( __( 'We could not find any user with (%s).', 'addon-frontend-auth' ), $post_data['user_login'] )
				];

				return $submit_response;
			}

			$reset_password_key = sha1( md5( site_url() . $user_info['user_login'] . current_time( 'mysql' ) ) );
			update_user_meta( $user_info['ID'], 'cjfmr_reset_password_key', $reset_password_key );

			$reset_password_url = $this->helpers->queryString( get_permalink( $this->helpers->savedOption( 'cjfmr_page_new_password' ) ) );
			$reset_password_verification_link = $reset_password_url . $this->verification_url_key . '=' . $reset_password_key;
			$reset_password_verification_link = sprintf( '<a href="%1$s" title="">%1$s</a>', $reset_password_verification_link );

			$source_array = $user_info;
			$source_array['reset_password_verification_link'] = $reset_password_verification_link;
			$email_subject = $this->helpers->processDynamicVariables( $this->helpers->savedOption( 'cjfmr_reset_password_verification_email_subject' ), $source_array );
			$email_message = $this->helpers->processDynamicVariables( $this->helpers->savedOption( 'cjfmr_reset_password_verification_email_message' ), $source_array );
			$email_message = $this->helpers->processUserVariables( $user_info['ID'], $email_message );

			$email_data = array(
				'to' => $user_info['user_email'],
				'from_name' => $this->helpers->savedOption( 'cjfmr_email_from_name' ),
				'from_email' => $this->helpers->savedOption( 'cjfmr_email_from' ),
				'subject' => $email_subject,
				'message' => $email_message,
			);
			$mail = $this->helpers->sendEmail( $email_data );

			if( ! $mail ) {
				$this->helpers->handleDebugLog( 'Problem Sending Email', __FILE__, __LINE__ );
			}

			$submit_response['success'] = __( 'Verification email sent to your registered email address.', 'addon-frontend-auth' );

			return $submit_response;
		}

		public function checkResetPasswordKey() {

			add_filter( 'cjwpbldr_form_extend_fields', function ( $fields ) {
				$reset_password_key = $this->helpers->savedOption( 'cjfmr_password_verification_key' );
				if( isset( $_GET[ $reset_password_key ] ) ) {
					$key_valid = $this->helpers->getUserByMeta( 'cjfmr_reset_password_key', $_GET[ $reset_password_key ] );
					if( is_array( $key_valid ) && empty( $key_valid ) ) {
						$fields = array();
					}
				}

				return $fields;
			} );

			add_action( 'cjwpbldr_form_content_above', function () {
				$new_password_page = $this->helpers->savedOption( 'cjfmr_page_new_password' );
				$reset_password_key = $this->helpers->savedOption( 'cjfmr_password_verification_key' );
				if( $new_password_page != '' && is_page( $new_password_page ) ) {
					if( ! isset( $_GET[ $reset_password_key ] ) ) {
						wp_redirect( site_url() );
						exit;
					}
					if( isset( $_GET[ $reset_password_key ] ) && $_GET[ $reset_password_key ] == '' ) {
						wp_redirect( site_url() );
						exit;
					}
					$key_valid = $this->helpers->getUserByMeta( 'cjfmr_reset_password_key', $_GET[ $reset_password_key ] );
					if( is_array( $key_valid ) && empty( $key_valid ) ) {
						$message = __( 'Invalid verification key, please try again.', 'addon-frontend-auth' );
						echo $this->helpers->alert( 'danger', $message, '', '', false );
					}
				}
			} );
		}
	}

	cjwpbldr_frontend_auth_do_reset_password::getInstance();
}