<?php
// Exit if accessed directly.
if( ! defined( 'ABSPATH' ) ) {
	exit;
}

if( ! class_exists( 'cjwpbldr_restrict_content' ) ) {
	class cjwpbldr_restrict_content {
		private static $instance;
		public $helpers;

		public static function getInstance() {
			if( ! isset( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		public function __construct() {

			$this->helpers = cjwpbldr_frontend_auth_helpers::getInstance();

			add_action( 'wp_head', array($this, 'restrictSiteAccess') );

			add_action( 'the_content', array($this, 'restrictSiteContent') );
		}

		/**
		 * Restrict Access to the whole site
		 *
		 * [restrictSiteAccess]
		 *
		 * @return [mix]
		 */
		public function restrictSiteAccess() {

			if( ! is_user_logged_in() ):

				$restrict_site = $this->helpers->savedOption( 'cjfmr_restrict_site' );
				$restrict_site_except_home = $this->helpers->savedOption( 'cjfmr_restrict_site_except_home' );

				$restrict_woo = $this->helpers->savedOption( 'cjfmr_restrict_woocommerce' );

				$login_page = $this->helpers->savedOption( 'cjfmr_page_login' );
				$register_page = $this->helpers->savedOption( 'cjfmr_page_register' );
				$reset_pass_page = $this->helpers->savedOption( 'cjfmr_page_password' );
				$logout_page = $this->helpers->savedOption( 'cjfmr_page_logout' );
				$new_password_page = $this->helpers->savedOption( 'cjfmr_page_new_password' );

				$login_page_link = get_permalink( $login_page );

				if( 'yes' == $restrict_site ) {
					if( ! is_page( $login_page ) && ! is_page( $register_page ) && ! is_page( $reset_pass_page ) && ! is_page( $new_password_page ) && ! is_page( $logout_page ) ) {
						wp_redirect( $login_page_link );
						exit;
					}
				}

				if( 'yes' == $restrict_site_except_home ) {
					$un_restrict_pages = [
						$login_page,
						$register_page,
						$reset_pass_page,
						$login_page
					];

					if( ! is_front_page() && ( ! is_home() || ! is_front_page()) && ! is_page( $un_restrict_pages ) ) {
						wp_redirect( $login_page_link );
						exit;
					}
				}

				if( 'yes' == $restrict_woo ) {

					if(
						is_shop() ||
						is_product_category() ||
						is_product_tag() ||
						is_product() ||
						is_cart() ||
						is_checkout() ||
						is_account_page()
					) {

						wp_redirect( $login_page_link );
						exit;
					}
				}

			endif;
		}

		public function restrictSiteContent( $content ) {

			global $post;

			if( ! is_user_logged_in() ):

				$login_page = $this->helpers->savedOption( 'cjfmr_page_login' );
				$register_page = $this->helpers->savedOption( 'cjfmr_page_register' );

				$login_page_link = get_permalink( $login_page );
				$register_page_link = get_permalink( $register_page );

				$login_message_login_link = sprintf( __( '<a href="%s" title="Login">Login</a>', 'addon-frontend-auth' ), $login_page_link );
				$login_message_register_link = sprintf( __( '<a href="%s" title="Register">Register</a>', 'addon-frontend-auth' ), $register_page_link );

				$login_message = $this->helpers->savedOption( 'cjfmr_restricted_login_message' );

				$login_message = str_replace( '%%login_link%%', $login_message_login_link, $login_message );
				$login_message = str_replace( '%%register_link%%', $login_message_register_link, $login_message );

				$restrict_pages = $this->helpers->savedOption( 'cjfmr_restrict_pages' );
				$restrict_cats = $this->helpers->savedOption( 'cjfmr_restrict_categories' );
				$restrict_tags = $this->helpers->savedOption( 'cjfmr_restrict_tags' );
				$restrict_post_types = $this->helpers->savedOption( 'cjfmr_restrict_post_types' );
				$restrict_taxonomies = $this->helpers->savedOption( 'cjfmr_restrict_taxonomies' );

				//print_r( $restrict_pages );

				if( is_array( $restrict_pages ) && ! empty( $restrict_pages ) ) {
					if( is_page( $restrict_pages ) ) {
						$content = $login_message;
					}
				}

				if( is_array( $restrict_cats ) && ! empty( $restrict_cats ) ) {
					if( is_category( $restrict_cats ) || in_category( $restrict_cats ) ) {
						$content = $login_message;
					}
				}

				if( is_array( $restrict_tags ) && ! empty( $restrict_tags ) ) {
					if( is_tag( $restrict_tags ) || has_tag( $restrict_tags ) ) {
						$content = $login_message;
					}
				}

				if( is_array( $restrict_post_types ) && ! empty( $restrict_post_types ) ) {
					$current_post_type = get_post_type();
					if( in_array( $current_post_type, $restrict_post_types ) && ! is_page( $login_page ) && ! is_page( $register_page ) ) {
						$content = $login_message;
					}
				}

				if( is_array( $restrict_taxonomies ) && ! empty( $restrict_taxonomies ) ) {
					foreach( $restrict_taxonomies as $tax_value ) {
						if( $tax_value != '' ) {
							list( $tax_slug, $tax_name ) = explode( '@', $tax_value );
							if( is_tax( $tax_name ) ) {
								$content = $login_message;
							}
						}
					}
				}

				return $content;
			else:
				return $content;
			endif;
		}

	}

	cjwpbldr_restrict_content::getInstance();
}