<?php
// Exit if accessed directly.
if( ! defined( 'ABSPATH' ) ) {
	exit;
}

if( ! class_exists( 'cjwpbldr_woocommerce_integration' ) ) {
	class cjwpbldr_woocommerce_integration {
		private static $instance;
		public $helpers;

		public static function getInstance() {
			if( ! isset( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		public function __construct() {
			$this->helpers = cjwpbldr_frontend_auth_helpers::getInstance();

			if( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {

				add_action( 'woocommerce_register_form_start', array($this, 'wooRegistrationFields') );

				add_action( 'woocommerce_before_checkout_registration_form', array($this, 'wooRegistrationFields') );

				//add_action( 'wp_head', array( $this, 'wooStyles' ) );

				$res = $this->helpers->savedOption( 'cjfmr_enable_woocommerce' );

				$integrate_woo = $res['selected_value'];

				if( 'yes' == $integrate_woo ) {
					add_action( 'woocommerce_register_post', array($this, 'wooValidateRegistrationFields'), 10, 3 );
					add_action( 'woocommerce_checkout_process', array($this, 'wooValidateCheckoutRegistrationFields') );
					add_action( 'woocommerce_created_customer', array($this, 'wooSaveRegistrationFields') );
				}
			}
		}

		public function wooStyles() {
			if( is_checkout() ) {
				?>
                <style type="text/css">
                    .cssjockey-form {
                        display: none;
                    }
                </style>
				<?php
			}
		}

		public function getWooFormID() {
			$form_id = $this->helpers->getGroupOption( 'cjfmr_enable_woocommerce' );
			if( array_key_exists( 'woocommerce_form_id', $form_id ) ) {
				$form_id = $form_id['woocommerce_form_id'];
			} else {
				$form_id = '';
			}

			if( $form_id ) {
				return $form_id;
			} else {
				return '';
			}
		}

		public function wooRegistrationFields() {

			$res = $this->helpers->savedOption( 'cjfmr_enable_woocommerce' );

			$integrate_woo = $res['selected_value'];

			$form_id = $this->getWooFormID();

			if( 'no' == $integrate_woo || '' == $integrate_woo || '' == $form_id ) {
				return;
			}

			$form_fields = $this->helpers->getFormFields( $form_id );

			$new_form_fields = $this->generateNewFields( $form_fields );

			if( is_checkout() ) {
				unset( $new_form_fields['first_name'] );
				unset( $new_form_fields['last_name'] );
			}

			echo $this->helpers->renderFrontendForm( $new_form_fields );
		}

		public function generateNewFields( $form_fields ) {

			$new_fields = array();

			$wordpress_fields = array('user_login', 'user_pass', 'user_email', 'display_name', 'user_nicename', 'user_url', 'user_pass_confirmation');

			foreach( $form_fields as $key => $value ) {

				if( $value['type'] != 'file' && ! in_array( $value['id'], $wordpress_fields ) ) {

					$new_fields[ $value['id'] ] = $value;
				}
			}

			return $new_fields;
		}

		public function getFormData() {

			$form_id = $form_id = $this->getWooFormID();

			$form_fields = $this->helpers->getFormFields( $form_id );

			$new_form_fields = $this->generateNewFields( $form_fields );

			$form_data = array();

			$form_data['id'] = $form_id;
			$form_data['fields'] = $new_form_fields;

			return $form_data;
		}

		public function wooValidateRegistrationFields( $username, $email, $validation_errors ) {

			$form_data = $this->getFormData();

			$new_form_fields = $this->generateNewFields( $form_data['fields'] );

			$postData = array();

			foreach( $new_form_fields as $key => $value ) {

				if( array_key_exists( $key, $_POST ) ) {
					$postData[ $key ] = $_POST[ $key ];
				}
			}

			$errors = array();

			$validation_rules = array();

			foreach( $new_form_fields as $f_key => $fields_array ) {
				if( array_key_exists( 'validation_rules', $fields_array ) && $fields_array['validation_rules'] != "" ) {
					$validation_rules[ $fields_array['id'] ] = $this->helpers->prepareValidationRules( $fields_array['validation_rules'] );
				}
			}

			$errors = array();

			if( ! empty( $validation_rules ) ) {
				$errors = $this->helpers->validateFormWithGump( $postData, $validation_rules, $new_form_fields );
			}

			if( ! empty( $errors ) ):

				foreach( $errors as $key => $value ) {

					foreach( $value as $verrorkey => $verror ) {
						$validation_errors->add( $verror['field_unique_id'] . '_error', __( $verror['error_msg'], 'woocommerce' ) );
					}
				}

			endif;
		}

		public function wooValidateCheckoutRegistrationFields() {

			if( isset( $_POST['createaccount'] ) && $_POST['createaccount'] == 1 ) {

				$form_data = $this->getFormData();

				$new_form_fields = $this->generateNewFields( $form_data['fields'] );

				$postData = array();

				foreach( $new_form_fields as $key => $value ) {

					if( array_key_exists( $key, $_POST ) ) {
						$postData[ $key ] = $_POST[ $key ];
					}
				}

				$errors = array();

				$validation_rules = array();

				foreach( $new_form_fields as $f_key => $fields_array ) {
					if( array_key_exists( 'validation_rules', $fields_array ) && $fields_array['validation_rules'] != "" ) {
						$validation_rules[ $fields_array['id'] ] = $this->helpers->prepareValidationRules( $fields_array['validation_rules'] );
					}
				}

				$errors = array();

				if( ! empty( $validation_rules ) ) {
					$errors = $this->helpers->validateFormWithGump( $postData, $validation_rules, $new_form_fields );
				}

				if( ! empty( $errors ) ):

					foreach( $errors as $key => $value ) {

						foreach( $value as $verrorkey => $verror ) {

							wc_add_notice( $verror['error_msg'], 'error' );
						}
					}

				endif;
			}
		}

		public function wooSaveRegistrationFields( $customer_id ) {

			$form_data = $this->getFormData();

			$form_id = $form_data['id'];

			$new_form_fields = $this->generateNewFields( $form_data['fields'] );

			$role = (get_post_meta( $form_id, 'cjwpbldr_form_roles', true ) == 'none' ? get_option( 'default_role' ) : get_post_meta( $form_id, 'cjwpbldr_form_roles', true ));

			foreach( $new_form_fields as $key => $value ) {

				update_user_meta( $customer_id, $key, $_POST[ $key ] );
			}
		}

	}

	cjwpbldr_woocommerce_integration::getInstance();
}