<?php
// Exit if accessed directly.
if( ! defined( 'ABSPATH' ) ) {
	exit;
}

if( ! class_exists( 'cjwpbldr_frontend_auth_functions' ) ) {

	class cjwpbldr_frontend_auth_functions {
		public $helpers;
		private static $instance;

		public static function getInstance() {
			if( ! isset( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		public function __construct() {
			$this->helpers = cjwpbldr_frontend_auth_helpers::getInstance();
		}

		public static function navigationMenu() {
			if( is_user_logged_in() ) {
				return 'cjwpbldr_fa_users_menu';
			} else {
				return 'cjwpbldr_fa_visitors_menu';
			}
		}

	}//END class

	cjwpbldr_frontend_auth_functions::getInstance();
}