<?php
// Exit if accessed directly.
if( ! defined( 'ABSPATH' ) ) {
	exit;
}

if( ! class_exists( 'cjwpbldr_admin_extra_profile_fields' ) ) {

	/**
	 * Class cjwpbldr_admin_extra_profile_fields
	 *
	 * This class includes all the hook/actions of this plugin.
	 */
	class cjwpbldr_admin_extra_profile_fields {

		/**
		 * Store instanse of helpers class
		 *
		 * [$helpers]
		 *
		 * @var [class object]
		 */
		public $helpers;

		/**
		 * Text Domain for language
		 *
		 * [$textdomain]
		 *
		 * @var [string]
		 */
		public $textdomain;

		public static $instance;

		public static function getInstance() {
			if( ! isset( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		/**
		 * Class Constrcutor
		 *
		 * [__construct]
		 */
		public function __construct() {

			$this->helpers = cjwpbldr_frontend_auth_helpers::getInstance();

			$this->textdomain = 'addon-frontend-auth';

			/** Add Extra Profile Fields */
			add_action( 'show_user_profile', array($this, 'displayExtraProfileFields') );
			add_action( 'edit_user_profile', array($this, 'displayExtraProfileFields') );

			/** Save Extra Profile Fields */
			add_action( 'personal_options_update', array($this, 'saveExtraProfileFields') );
			add_action( 'edit_user_profile_update', array($this, 'saveExtraProfileFields') );
		}

		/**
		 * Add extra profile fields to the user's profile. If profile sync option is 'yes' under plugin settings
		 *
		 * [displayExtraProfileFields ]
		 *
		 * @param  [type] $user [user profile being displayed]
		 *
		 * @return void
		 */
		public function displayExtraProfileFields( $user ) {

			if( $this->helpers->savedOption( 'cjfmr_profile_sync' ) == 'yes' ) {

				echo '<h2>' . $this->helpers->savedOption( 'cjfmr_profile_sync_heading' ) . '</h2>';

				$form_id = $this->helpers->savedOption( 'cjfmr_profile_sync_form' );

				if( ! $form_id && is_admin() ) {
					echo sprintf( __( 'Please Select a Form to Sync in the <a target="_blank" href="%s" title="">plugin settings</a>.', $this->textdomain ), $this->helpers->callbackUrl( 'cjfm-configuration-wordpress', '', 'addon-frontend-auth' ) );

					return;
				}

				$new_form_fields = array();

				$new_form_fields = $this->processMetaData( $user, $form_id );

				$this->extraFieldsTop();

				foreach( $new_form_fields as $key => $value ) {

					$options = $this->helpers->getFieldOptions( $value );

					$info = (array_key_exists( 'info', $value ) ? $value['info'] : '');

					$this->extraFieldsHtml( $value['settings']['label'], $key, $value['type'], $value['default'], $options, $info );
				}

				$this->extraFieldsBottom();
			}
		}

		/**
		 * Process user meta data with form fields
		 *
		 * [processMetaData]
		 *
		 * @param  [type] $user    [description]
		 * @param  [type] $form_id [description]
		 *
		 * @return [type]          [description]
		 */
		public function processMetaData( $user, $form_id = '' ) {

			$new_form_fields = array();

			$profile_form_id = ($form_id != '' ? $form_id : $this->helpers->savedOption( 'cjfmr_profile_sync_form' ));

			$user_id = (is_int( $user ) ? $user : $user->data->ID);

			$form_fields = $this->helpers->getFormFields( $profile_form_id );

			foreach( $form_fields as $value ) {
				$new_form_fields[ $value['id'] ] = $value;
			}

			$wp_fields = $this->helpers->defaultWordPressFields();
			$wp_meta_fields = $this->helpers->defaultWordPressFields( 'meta' );

			foreach( $wp_fields as $value ) {
				unset( $new_form_fields[ $value ] );
			}
			foreach( $wp_meta_fields as $value ) {
				unset( $new_form_fields[ $value ] );
			}

			foreach( $new_form_fields as $key => $value ) {

				$user_meta = get_user_meta( $user_id, $key, true );

				$new_form_fields[ $key ]['default'] = $user_meta;
			}

			return $new_form_fields;
		}

		/**
		 * Extra Profile Fields HTML to be displayed in the admin dashboard
		 *
		 * [extraFieldsHtml]
		 *
		 * @param  [type] $label       [label]
		 * @param  [type] $field_id    [id to be used as CSS id and input name tag]
		 * @param  [type] $value       [the value of the field]
		 * @param string $description [description of the field]
		 *
		 * @return [type]              [description]
		 */
		public function extraFieldsHtml( $label, $field_id, $type, $value = '', $options = '', $description = '' ) {

			if( $type == 'text' ) {
				$this->inputText( $label, $field_id, $value, $description );
			}
			if( $type == 'number' ) {
				$this->inputText( $label, $field_id, $value, $description, 'number' );
			}
			if( $type == 'email' ) {
				$this->inputText( $label, $field_id, $value, $description, 'email' );
			}
			if( $type == 'url' ) {
				$this->inputText( $label, $field_id, $value, $description, 'url' );
			}
			if( $type == 'date' ) {
				$this->inputText( $label, $field_id, $value, $description );
			}
			if( $type == 'date-time' ) {
				$this->inputText( $label, $field_id, $value, $description );
			}
			if( $type == 'color' ) {
				$this->inputText( $label, $field_id, $value, $description );
			}
			if( $type == 'textarea' ) {
				$this->inputTextArea( $label, $field_id, $value, $description );
			}
			if( $type == 'wysiwyg' ) {
				$this->inputTextArea( $label, $field_id, $value, $description );
			}
			if( $type == 'dropdown' || $type == 'form-options-dropdown' ) {
				$this->inputSelect( $label, $field_id, $value, $options, $description );
			}
			if( $type == 'multi-dropdown' ) {
				$this->inputSelect( $label, $field_id, $value, $options, true, $description );
			}
			if( $type == 'file' || $type == 'file-raw' || $type == 'vue_file_upload' ) {
				$description = esc_attr__( 'To update the picture please upload a new or select an image URL from Media Library and paste the URL in the box above', $this->textdomain );
				$this->inputTextFile( $label, $field_id, $value, $description );
			}
			if( $type == 'checkbox' || $type == 'checkbox-inline' ) {
				$this->inputCheckbox( $label, $field_id, $value, $options, $description );
			}
			if( $type == 'radio' || $type == 'radio-inline' ) {
				$this->inputRadio( $label, $field_id, $value, $options, $description );
			}
			if( $type == 'full-address' ) {
				$this->fullAddress( $label, $field_id, $value, $options, $description );
			}
		}

		/**
		 * Display Textbox
		 *
		 * [input_text]
		 *
		 * @param  [type] $label       [label]
		 * @param  [type] $field_id    [unique id]
		 * @param  [type] $value       [deafult value]
		 * @param string $description [description]
		 *
		 * @return void
		 */
		public function inputText( $label, $field_id, $value, $description = '', $type = 'text' ) {
			if( $field_id != 'qna_answer' ):
				?>
                <tr>
                    <th><label for="<?php echo $label; ?>"><?php echo $label ?></label></th>
                    <td>
                        <div class="cj-field-body">
                            <div class="cj-field">
                                <div class="cj-control cj-is-expanded">
                                    <input class="cj-input" type="<?php echo $type; ?>" name="<?php echo $field_id ?>" id="<?php echo $field_id ?>" value="<?php echo $value; ?>" class="regular-text"/>
                                </div>
                            </div>
                        </div>
                        <br/>
						<?php $this->fieldDescription( $description ); ?>
                    </td>
                </tr>
			<?php
			endif;
		}

		/**
		 * Display Textarea
		 *
		 * [input_text]
		 *
		 * @param  [type] $label       [label]
		 * @param  [type] $field_id    [unique id]
		 * @param  [type] $value       [deafult value]
		 * @param string $description [description]
		 *
		 * @return void
		 */
		public function inputTextArea( $label, $field_id, $value, $description = '' ) {
			?>
            <tr>
                <th><label for="<?php echo $label; ?>"><?php echo $label ?></label></th>
                <td>
                    <div class="cj-field-body">
                        <div class="cj-field">
                            <div class="cj-control cj-is-expanded">
                                <textarea class="cj-textarea" rows="5" cols="5" name="<?php echo $field_id ?>" id="<?php echo $field_id ?>" class="regular-text"><?php echo $value; ?></textarea>
                            </div>
                        </div>
                    </div>
                    <br/>
					<?php $this->fieldDescription( $description ); ?>
                </td>
            </tr>
			<?php
		}

		/**
		 * Display Image File
		 *
		 * [input_text_file]
		 *
		 * @param  [type] $label       [label]
		 * @param  [type] $field_id    [unique id]
		 * @param  [type] $value       [deafult value]
		 * @param string $description [description]
		 *
		 * @return void
		 */
		public function inputTextFile( $label, $field_id, $value, $description = '' ) {
			?>
            <tr>
                <th><label for="<?php echo $label; ?>"><?php echo $label ?></label></th>

                <td>
					<?php
					if( $this->helpers->isValidatedArray( $value ) ) {
						foreach( $value as $val ) {
							?>
                            <div class="cj-field-body">
                                <div class="cj-field">
                                    <div class="cj-control cj-is-expanded">
                                        <input class="cj-input" type="text" name="<?php echo $field_id ?>[]" id="<?php echo $field_id ?>" value="<?php echo $val; ?>" class="regular-text"/>
                                    </div>
                                </div>
                            </div>
                            <br/>
						<?php }
					} else { ?>
                        <div class="cj-field-body">
                            <div class="cj-field">
                                <div class="cj-control cj-is-expanded">
                                    <input class="cj-input" type="text" name="<?php echo $field_id ?>" id="<?php echo $field_id ?>" value="<?php echo $value; ?>" class="regular-text"/>
                                </div>
                            </div>
                        </div>
						<?php
					}
					?>
					<?php $this->fieldDescription( $description ); ?>
                </td>
            </tr>
			<?php
		}

		/**
		 * Display dropdowns
		 *
		 * [input_select]
		 *
		 * @param  [type] $label       [label]
		 * @param  [type] $field_id    [unique id]
		 * @param  [type] $value       [deafult value]
		 * @param  [type] $options     [options]
		 * @param string $description [description]
		 *
		 * @return void
		 */
		public function inputSelect( $label, $field_id, $value, $options, $multiple = false, $description = '' ) {
			$select_options = $options;
			$multiple = ($multiple ? 'multiple' : '');
			$name_ext = ('multiple' == $multiple) ? '[]' : '';
			?>
            <tr>
                <th><label for="<?php echo $label; ?>"><?php echo $label ?></label></th>
                <td>
                    <div class="cj-field-body">
                        <div class="cj-field">
                            <div class="cj-control cj-is-expanded">
                                <div class="cj-select cj-is-fullwidth">
                                    <select class="selectize" name="<?php echo $field_id ?><?php echo $name_ext; ?>" id="<?php echo $field_id ?>" <?php echo $multiple; ?>>
										<?php foreach( $select_options as $key => $sop ) : ?>
											<?php
											if( $multiple != '' ) {
												$default = (is_array( $value ) && in_array( $key, $value ) ? ' selected' : '');
											} else {
												$default = ($value == $key ? ' selected' : '');
											}
											?>
                                            <option <?php echo $default; ?> value="<?php echo $key ?>"><?php echo $sop; ?></option>
										<?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
					<?php $this->fieldDescription( $description ); ?>
                </td>
            </tr>
			<?php
		}

		/**
		 * Display checkbox buttons
		 *
		 * [input_checkbox]
		 *
		 * @param  [type] $label       [label]
		 * @param  [type] $field_id    [unique id]
		 * @param  [type] $value       [deafult value]
		 * @param  [type] $options     [options]
		 * @param string $description [description]
		 *
		 * @return void
		 */
		public function inputCheckbox( $label, $field_id, $value, $options, $description = '' ) {
			$select_options = $options;
			if( array_key_exists( 'null', $select_options ) ) {
				$select_options = $options;
			}
			?>
            <tr>
                <th><label for="<?php echo $label; ?>"><?php echo $label ?></label></th>
                <td>
                    <div class="cj-field-body">
                        <div class="cj-field">
                            <div class="cj-control">
								<?php if( is_array( $select_options ) && ! empty ( $select_options ) ): ?>
									<?php foreach( $select_options as $key => $sop ) : ?>
                                        <label class="cj-checkbox">
											<?php $default = (is_array( $value ) && ! empty( $value ) && in_array( $key, $value ) ? ' checked' : ''); ?>
                                            <input type="checkbox" name="<?php echo $field_id ?>[]" value="<?php echo $key; ?>" <?php echo $default; ?>/><?php echo $sop; ?>
                                        </label>
									<?php endforeach; ?>
								<?php endif; ?>
								<?php $this->fieldDescription( $description ); ?>
                            </div>
                        </div>
                    </div>
                </td>
            </tr>
			<?php
		}

		/**
		 * Display radio buttons
		 *
		 * [input_radio]
		 *
		 * @param  [type] $label       [label]
		 * @param  [type] $field_id    [unique id]
		 * @param  [type] $value       [deafult value]
		 * @param  [type] $options     [options]
		 * @param string $description [description]
		 *
		 * @return void
		 */
		public function inputRadio( $label, $field_id, $value, $options, $description = '' ) {
			$select_options = $options;
			?>
            <tr>
                <th><label for="<?php echo $label; ?>"><?php echo $label ?></label></th>

                <td>
                    <div class="cj-field-body">
                        <div class="field">
                            <div class="cj-control">
								<?php if( is_array( $select_options ) && ! empty ( $select_options ) ): ?>
									<?php foreach( $select_options as $key => $sop ) : ?>
                                        <label class="cj-radio">
											<?php $default = ($key == $value) ? ' checked' : ''; ?>
                                            <input type="radio" name="<?php echo $field_id ?>" value="<?php echo $key; ?>" <?php echo $default; ?>/><?php echo $sop; ?>
                                        </label>
									<?php endforeach; ?>
								<?php endif; ?>
								<?php $this->fieldDescription( $description ); ?>
                            </div>
                        </div>
                    </div>
                </td>
            </tr>
			<?php
		}

		/**
		 * Display Full Address Field
		 *
		 *
		 * @param string |       $label
		 * @param string |       $field_id
		 * @param string|array | $value
		 * @param array |        $options
		 * @param string |       $description
		 *
		 * @return void
		 */
		public function fullAddress( $label, $field_id, $value, $options, $description = '' ) {
			$add_line_1 = ($this->helpers->isValidatedArray( $value, true, 'add_line_1' )) ? $value['add_line_1'] : '';
			$add_line_2 = ($this->helpers->isValidatedArray( $value, true, 'add_line_2' )) ? $value['add_line_2'] : '';
			$country = ($this->helpers->isValidatedArray( $value, true, 'country' )) ? $value['country'] : '';
			$state = ($this->helpers->isValidatedArray( $value, true, 'state' )) ? $value['state'] : '';
			$city = ($this->helpers->isValidatedArray( $value, true, 'city' )) ? $value['city'] : '';
			$zip = ($this->helpers->isValidatedArray( $value, true, 'zip' )) ? $value['zip'] : '';
			$countries = $this->helpers->getInternalApiResponse( 'countries' );
			$states = $this->helpers->getInternalApiResponse( 'country/state', 'GET', ['country' => $country] );
			?>
            <tr>
                <th><label for="<?php echo $label; ?>"><?php echo $label ?></label></th>
                <td>
                    <table>
                        <tr>
                            <td>
                                <div class="cj-field-body">
                                    <div class="cj-field">
                                        <div class="cj-control">
                                            <label class="cj-label">Address Line 1</label>
                                            <input class="cj-input" type="text" name="<?php echo $field_id ?>['add_line_1']" value="<?php echo $add_line_1; ?>"/>
                                        </div>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <div class="cj-field-body">
                                    <div class="cj-field">
                                        <div class="cj-control">
                                            <label class="cj-label">Address Line 2</label>
                                            <input class="cj-input" type="text" name="<?php echo $field_id ?>['add_line_2']" value="<?php echo $add_line_2; ?>"/>
                                        </div>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <div class="cj-field-body">
                                    <div class="cj-field">
                                        <div class="cj-control cj-is-expanded">
                                            <label class="cj-label">Country</label>
                                            <div class="cj-select is-fullwidth">
                                                <select name="<?php echo $field_id ?>['country']">
													<?php
													foreach( $countries as $co ) {
														$selected = ($co == $country) ? ' selected' : '';
														?>
                                                        <option <?php echo $selected; ?> value="<?php echo $co; ?>"><?php echo $co; ?></option>
													<?php } ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="cj-field">
                                        <div class="cj-control cj-is-expanded">
                                            <label class="cj-label">State</label>
                                            <div class="cj-select is-fullwidth">
                                                <select class="cj-select" name="<?php echo $field_id ?>['state']">
													<?php
													foreach( $states as $st ) {
														$selected = ($st == $state) ? ' selected' : '';
														?>
                                                        <option <?php echo $selected; ?> value="<?php echo $st; ?>"><?php echo $st; ?></option>
													<?php } ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <div class="cj-field-body">
                                    <div class="cj-field">
                                        <div class="cj-control cj-is-expanded">
                                            <label class="cj-label">City</label>
                                            <input class="cj-input" type="text" name="<?php echo $field_id ?>['city']" value="<?php echo $city; ?>"/>
                                        </div>
                                    </div>
                                    <div class="cj-field">
                                        <div class="cj-control cj-is-expanded">
                                            <label class="cj-label">Zip</label>
                                            <input class="cj-input" type="text" name="<?php echo $field_id ?>['zip']" value="<?php echo $zip; ?>"/>
                                        </div>
                                    </div>
                                </div>
                            </td>
                            <td>

                            </td>
                        </tr>
                    </table>
					<?php $this->fieldDescription( $description ); ?>
                </td>
            </tr>
			<?php
		}

		/**
		 * Field Description
		 *
		 * [fieldDescription]
		 *
		 * @param string $description [description of the field]
		 *
		 * @return void
		 */
		public function fieldDescription( $description = '' ) {
			if( $description != '' ) {
				echo '<br/><span class="description">' . $description . '</span>';
			}
		}

		/**
		 * Extra user profile fields top html
		 *
		 * [extraFieldsTop]
		 *
		 * @return void
		 */
		public function extraFieldsTop() {
			echo '<div class="cssjockey-ui">';
			echo '<table class="cj-table">';
		}

		/**
		 * Extra user profile fields bottom html
		 *
		 * [extraFieldsBottom]
		 *
		 * @return void
		 */
		public function extraFieldsBottom() {
			echo '</table>';
			echo '</div>';
		}

		/**
		 * Save custom user meta fields
		 *
		 * @param $user_id | int | ID of the user
		 *
		 * @return bool
		 * @since 3.0.1
		 */
		public function saveExtraProfileFields( $user_id ) {

			if( ! current_user_can( 'edit_user', $user_id ) ) {
				return false;
			}

			$form_fields = $this->processMetaData( $user_id );

			foreach( $form_fields as $key => $value ) {

				if( array_key_exists( $key, $_POST ) ) {
					update_user_meta( $user_id, $key, $_POST[ $key ] );
				}
			}
		}

	}//END class

	cjwpbldr_admin_extra_profile_fields::getInstance();
}//END !class_exists()