<?php
// Exit if accessed directly.
if( ! defined( 'ABSPATH' ) ) {
	exit;
}

if( ! class_exists( 'cjwpbldr_frontend_auth_helpers' ) ) {
	require_once sprintf( '%s/helpers.php', dirname( __FILE__ ) );
}
if( ! class_exists( 'cjwpbldr_frontend_auth_base' ) ) {
	class cjwpbldr_frontend_auth_base {
		private static $instance;
		public $helpers, $addon_slug;

		public static function getInstance() {
			if( ! isset( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		public function __construct() {
			$this->helpers = cjwpbldr_frontend_auth_helpers::getInstance();
			add_filter( 'cjwpbldr_admin_menu', array($this, 'adminMenuDropdown') );
			add_action( 'admin_menu', array($this, 'adminMenu'), 9999 );
			add_action( 'init', array($this, 'registerPostTypes') );
			add_action( 'init', array($this, 'registerTaxonomies') );
			add_action( 'init', array($this, 'registerNavMenus') );
			add_filter( 'cjwpbldr_localize_scripts', array($this, 'localeStrings') );
			add_action( 'wp_loaded', array($this, 'includeMetaboxes') );
			add_action( 'widgets_init', array($this, 'includeWidgets') );
			add_action( 'wp_loaded', array($this, 'includeShortcodes') );
			$this->autoload();
			$this->apiRoutes();
		}

		public function adminMenuDropdown( $menu ) {
			if( isset( $_GET['page'] ) && $_GET['page'] == basename( $this->helpers->addon_dir ) ) {
				$addon_admin_menus = $this->helpers->config( 'admin-menu', null, $this->helpers->addon_dir );
				$addon_welcome['welcome'] = $this->helpers->addon_info['addon_name'];
				$menu = array_merge( $menu, $addon_welcome );
				if( is_array( $addon_admin_menus ) && ! empty( $addon_admin_menus ) ) {
					$menu = array_merge( $menu, $addon_admin_menus );
				}
			}

			return $menu;
		}

		public function adminMenu() {
			//global $menu;
			$page_slug = $this->helpers->config( 'plugin-info', 'page_slug' );
			if( is_array( $this->helpers->addon_info ) && ! empty( $this->helpers->addon_info ) ) {
				add_submenu_page( $page_slug, $this->helpers->addon_info['addon_name'], $this->helpers->addon_info['addon_name'], 'manage_options', $this->helpers->addon_info['addon_id'], array($this, 'adminPageContent') );
			}
		}

		public function adminPageContent() {
			$sub_page_path = sprintf( '%s/html/admin-sub-page.php', $this->helpers->framework_dir );
			if( file_exists( $sub_page_path ) ) {
				ob_start();
				require_once $sub_page_path;
				echo ob_get_clean();
			}
		}

		public function autoload() {
			$autoload_dir = sprintf( '%s/autoload', $this->helpers->addon_dir );
			$autoload_dirs = preg_grep( '/^([^.])/', scandir( $autoload_dir ) );
			if( is_array( $autoload_dirs ) && ! empty( $autoload_dirs ) ) {
				foreach( $autoload_dirs as $key => $file_name ) {
					if( strpos( $file_name, '.php' ) ) {
						$file_path = sprintf( '%s/%s', $autoload_dir, $file_name );
						if( file_exists( $file_path ) ) {
							require_once $file_path;
						}
					}
				}
			}
		}

		public function apiRoutes() {
			$autoload_dir = sprintf( '%s/api-routes', $this->helpers->addon_dir );
			$autoload_dirs = preg_grep( '/^([^.])/', scandir( $autoload_dir ) );
			if( is_array( $autoload_dirs ) && ! empty( $autoload_dirs ) ) {
				foreach( $autoload_dirs as $key => $file_name ) {
					if( strpos( $file_name, '.php' ) ) {
						$file_path = sprintf( '%s/%s', $autoload_dir, $file_name );
						if( file_exists( $file_path ) ) {
							require_once $file_path;
						}
					}
				}
			}
		}

		public function registerPostTypes() {
			$post_types = $this->helpers->moduleConfig( basename( $this->helpers->addon_dir ), 'custom-post-types' );
			if( is_array( $post_types ) && ! empty( $post_types ) ) {
				foreach( $post_types as $key => $post_type ) {
					if( ! empty( $post_type ) && isset( $post_type['labels'] ) ) {
						$labels = '';
						$labels = $post_type['labels'];
						$args = array(
							'labels' => $labels,
							'public' => $post_type['args']['public'],
							'publicly_queryable' => $post_type['args']['publicly_queryable'],
							'show_ui' => $post_type['args']['show_ui'],
							'show_in_menu' => $post_type['args']['show_in_menu'],
							'query_var' => $post_type['args']['query_var'],
							'rewrite' => $post_type['args']['rewrite'],
							'capability_type' => $post_type['args']['capability_type'],
							'has_archive' => $post_type['args']['has_archive'],
							'hierarchical' => $post_type['args']['hierarchical'],
							'menu_position' => $post_type['args']['menu_position'],
							'supports' => $post_type['args']['supports'],
							'menu_icon' => $post_type['args']['menu_icon'],
							'taxonomies' => $post_type['args']['taxonomies'],
						);
						register_post_type( $key, $args );
					}
				}
			}
		}

		public function registerTaxonomies() {
			$custom_taxonomies = $this->helpers->moduleConfig( basename( $this->helpers->addon_dir ), 'custom-taxonomies' );
			if( is_array( $custom_taxonomies ) && ! empty( $custom_taxonomies ) ) {
				foreach( $custom_taxonomies as $key => $taxonomy ) {
					if( ! empty( $taxonomy ) ) {
						$labels = '';
						$labels = $taxonomy['labels'];
						$args = array(
							'hierarchical' => $taxonomy['args']['hierarchical'],
							'labels' => $labels,
							'show_ui' => $taxonomy['args']['show_ui'],
							'show_admin_column' => $taxonomy['args']['show_admin_column'],
							'query_var' => $taxonomy['args']['query_var'],
							'rewrite' => $taxonomy['args']['rewrite'],
						);
						register_taxonomy( $key, $taxonomy['post_types'], $args );
					}
				}
			}
		}

		public function registerNavMenus() {
			$nav_menus = $this->helpers->moduleConfig( basename( $this->helpers->addon_dir ), 'custom-nav-menus' );
			if( is_array( $nav_menus ) && ! empty( $nav_menus ) ) {
				foreach( $nav_menus as $key => $nav_menu ) {
					register_nav_menus( $nav_menu );
				}
			}
		}

		public function localeStrings( $locale ) {
			$module_slug = basename( $this->helpers->addon_dir );
			$locale['addons'][ $module_slug ]['info'] = $this->helpers->addonInfo();
			$locale['addons'][ $module_slug ]['locale'] = include($this->helpers->addon_dir . '/config/locale.php');

			return $locale;
		}

		public function includeShortcodes() {
			$shortcodes_dir = sprintf( '%s/shortcodes', $this->helpers->addon_dir );
			$dirs = preg_grep( '/^([^.])/', scandir( $shortcodes_dir ) );
			if( is_array( $dirs ) && ! empty( $dirs ) ) {
				foreach( $dirs as $key => $dir ) {
					$dir_path = $shortcodes_dir . '/' . $dir;
					if( is_dir( $dir_path ) ) {
						$file_path = $dir_path . '/init.php';
						require_once $file_path;
					}
				}
			}
		}

		public function includeWidgets() {
			$widgets_dir = sprintf( '%s/widgets', $this->helpers->addon_dir );
			$dirs = preg_grep( '/^([^.])/', scandir( $widgets_dir ) );
			if( is_array( $dirs ) && ! empty( $dirs ) ) {
				foreach( $dirs as $key => $dir ) {
					$dir_path = $widgets_dir . '/' . $dir;
					if( is_dir( $dir_path ) ) {
						$file_path = $dir_path . '/init.php';
						require_once $file_path;
					}
				}
			}
		}

		public function includeMetaboxes() {
			$metaboxes_dir = sprintf( '%s/metaboxes', $this->helpers->addon_dir );
			$dirs = preg_grep( '/^([^.])/', scandir( $metaboxes_dir ) );
			if( is_array( $dirs ) && ! empty( $dirs ) ) {
				foreach( $dirs as $key => $value ) {
					$metabox_path = $metaboxes_dir . '/' . $value;
					if( strpos( $value, '.php' ) > 0 ) {
						require_once $metabox_path;
					}
				}
			}
		}

	}
}