<?php
// Exit if accessed directly.
if( ! defined( 'ABSPATH' ) ) {
	exit;
}

/*
 * To display admin form automatically include the key name in option-files.php
 * */

$module_helper = cjwpbldr_frontend_auth_helpers::getInstance();

return [
	'addon-frontend-auth' => [
		'label' => __( 'Configuration', 'addon-frontend-auth' ),
		'items' => [
			'cjfm-page-setup' => __( 'Page Setup', 'addon-frontend-auth' ),
			'cjfm-configuration-wordpress' => __( 'WordPress Overrides', 'addon-frontend-auth' ),
			'cjfm-configuration-login' => __( 'Login Settings', 'addon-frontend-auth' ),
			'cjfm-configuration-registration' => __( 'Registration Settings', 'addon-frontend-auth' ),
			'cjfm-configuration-password' => __( 'Password Settings', 'addon-frontend-auth' ),
			'cjfm-role-based-menus' => __( 'Role Based Menus', 'addon-frontend-auth' ),
			'cjfm-configuration-woocommerce' => __( 'WooCommerce Setup', 'addon-frontend-auth' ),
			'cjfm-configuration-restrict-content' => __( 'Restrict Content', 'addon-frontend-auth' ),
			'cjfm-configuration-wp-mail' => __( 'Email Settings', 'addon-frontend-auth' ),
			'cjfm-configuration-dynamic-variables' => __( 'Dynamic Variables', 'addon-frontend-auth' ),
			'cjfm-manage-forms' => __( 'Manage Forms', 'addon-frontend-auth' ),
			'cjfm-manage-import-export-users' => __( 'Import/Export', 'addon-frontend-auth' ),
		]
	],
	[
		'label' => __( 'Email Messages', 'addon-frontend-auth' ),
		'items' => [
			'cjfm-email-messages-registration' => __( 'Registration Emails', 'addon-frontend-auth' ),
			'cjfm-email-messages-reset-password' => __( 'Reset Password Emails', 'addon-frontend-auth' )
		]
	],
	[
		'label' => __( 'Requests', 'addon-frontend-auth' ) . ' ' . $module_helper->getApprovalsCount(),
		'items' => [
			'cjfm-manage-approvals' => __( 'Manage Approvals ', 'addon-frontend-auth' ) . ' ' . $module_helper->getApprovalsCount(),
		]
	],
];