<?php
global $builder_forms;
$builder_forms['cjwpbldr_frontend_auth_do_edit_profile'] = [
	'form_name' => __( 'Frontend Auth ~ Edit Profile Form', 'addon-frontend-auth' ),
	'form_settings' => [
		'form_access' => ['everyone'],
		'field_size' => 'default',
		'submit_button' => [
			'text' => __( 'Update Profile', 'addon-frontend-auth' ),
			'size' => 'default',
			'color' => 'primary',
			'custom_css' => '',
			'suffix' => ''
		],
		'fields' => [
			[
				'type' => 'text',
				'group' => 'wordpress',
				'title' => __( 'Username', 'addon-frontend-auth' ),
				'field' => [
					'id' => 'user_login',
					'type' => 'text',
					'label' => __( 'Username', 'addon-frontend-auth' ),
					'info' => '',
					'default' => '',
					'settings' => [
						'unique_id' => 'user_login',
						'label' => __( 'Username', 'addon-frontend-auth' ),
						'description' => '',
						'default' => '',
						'columns' => [
							'widescreen' => 'cj-is-12-widescreen',
							'desktop' => 'cj-is-12-desktop',
							'tablet' => 'cj-is-12-tablet',
							'mobile' => 'cj-is-12-mobile',
						]
					],
					'attributes' => [
						'readonly' => 'readonly',
					],
					'attributes_readonly' => [],
					'validations' => [
						'required' => 'yes',
					],
					'options' => '',
					'settings_readonly' => ['unique_id'],
					'validations_readonly' => [],
				],
			],
			[
				'type' => 'text',
				'group' => 'wordpress',
				'title' => __( 'Your Email Address', 'addon-frontend-auth' ),
				'field' => [
					'id' => 'user_email',
					'type' => 'text',
					'label' => __( 'Your Email Address', 'addon-frontend-auth' ),
					'info' => '',
					'default' => '',
					'settings' => [
						'unique_id' => 'user_email',
						'label' => __( 'Your Email Address', 'addon-frontend-auth' ),
						'description' => '',
						'default' => '',
						'columns' => [
							'widescreen' => 'cj-is-12-widescreen',
							'desktop' => 'cj-is-12-desktop',
							'tablet' => 'cj-is-12-tablet',
							'mobile' => 'cj-is-12-mobile',
						]
					],
					'attributes' => [],
					'attributes_readonly' => [],
					'validations' => [
						'required' => 'yes',
						'valid_email' => 'yes',
					],
					'options' => '',
					'settings_readonly' => ['unique_id'],
					'validations_readonly' => [],
				],
			],
			[
				'type' => 'text',
				'group' => 'wordpress',
				'title' => __( 'First Name', 'addon-frontend-auth' ),
				'field' => [
					'id' => 'first_name',
					'type' => 'text',
					'label' => __( 'First Name', 'addon-frontend-auth' ),
					'info' => '',
					'default' => '',
					'settings' => [
						'unique_id' => 'first_name',
						'label' => __( 'First Name', 'addon-frontend-auth' ),
						'description' => '',
						'default' => '',
						'columns' => [
							'widescreen' => 'cj-is-6-widescreen',
							'desktop' => 'cj-is-6-desktop',
							'tablet' => 'cj-is-12-tablet',
							'mobile' => 'cj-is-12-mobile',
						]
					],
					'attributes' => [],
					'attributes_readonly' => [],
					'validations' => [],
					'options' => '',
					'settings_readonly' => ['unique_id'],
					'validations_readonly' => [],
				],
			],
			[
				'type' => 'text',
				'group' => 'wordpress',
				'title' => __( 'Last Name', 'addon-frontend-auth' ),
				'field' => [
					'id' => 'last_name',
					'type' => 'text',
					'label' => __( 'Last Name', 'addon-frontend-auth' ),
					'info' => '',
					'default' => '',
					'settings' => [
						'unique_id' => 'last_name',
						'label' => __( 'Last Name', 'addon-frontend-auth' ),
						'description' => '',
						'default' => '',
						'columns' => [
							'widescreen' => 'cj-is-6-widescreen',
							'desktop' => 'cj-is-6-desktop',
							'tablet' => 'cj-is-12-tablet',
							'mobile' => 'cj-is-12-mobile',
						]
					],
					'attributes' => [],
					'attributes_readonly' => [],
					'validations' => [],
					'options' => '',
					'settings_readonly' => ['unique_id'],
					'validations_readonly' => [],
				],
			],
			[
				'type' => 'textarea',
				'group' => 'wordpress',
				'title' => __( 'Biographical Info', 'addon-frontend-auth' ),
				'field' => [
					'id' => 'description',
					'type' => 'textarea',
					'label' => __( 'Biographical Info', 'addon-frontend-auth' ),
					'info' => '',
					'default' => '',
					'settings' => [
						'unique_id' => 'description',
						'label' => __( 'Biographical Info', 'addon-frontend-auth' ),
						'description' => '',
						'default' => '',
						'columns' => [
							'widescreen' => 'cj-is-12-widescreen',
							'desktop' => 'cj-is-12-desktop',
							'tablet' => 'cj-is-12-tablet',
							'mobile' => 'cj-is-12-mobile',
						]
					],
					'attributes' => [],
					'attributes_readonly' => [],
					'validations' => [],
					'options' => '',
					'settings_readonly' => ['unique_id'],
					'validations_readonly' => [],
				],
			],
			[
				'type' => 'password',
				'group' => 'wordpress',
				'title' => __( 'Password', 'addon-frontend-auth' ),
				'field' => [
					'id' => 'user_pass',
					'type' => 'password',
					'label' => __( 'Password', 'addon-frontend-auth' ),
					'info' => '',
					'default' => '',
					'settings' => [
						'unique_id' => 'user_pass',
						'label' => __( 'Password', 'addon-frontend-auth' ),
						'description' => '',
						'default' => '',
						'columns' => [
							'widescreen' => 'cj-is-12-widescreen',
							'desktop' => 'cj-is-12-desktop',
							'tablet' => 'cj-is-12-tablet',
							'mobile' => 'cj-is-12-mobile',
						]
					],
					'attributes' => [],
					'attributes_readonly' => [],
					'validations' => [],
					'options' => '',
					'settings_readonly' => ['unique_id'],
					'validations_readonly' => [],
				],
			],
			[
				'type' => 'password',
				'group' => 'wordpress',
				'title' => __( 'Confirm Password', 'addon-frontend-auth' ),
				'field' => [
					'id' => 'user_pass_confirmation',
					'type' => 'password',
					'label' => __( 'Confirm Password', 'addon-frontend-auth' ),
					'info' => '',
					'default' => '',
					'settings' => [
						'unique_id' => 'user_pass_confirmation',
						'label' => __( 'Confirm Password', 'addon-frontend-auth' ),
						'description' => '',
						'default' => '',
						'columns' => [
							'widescreen' => 'cj-is-12-widescreen',
							'desktop' => 'cj-is-12-desktop',
							'tablet' => 'cj-is-12-tablet',
							'mobile' => 'cj-is-12-mobile',
						]
					],
					'attributes' => [],
					'attributes_readonly' => [],
					'validations' => [],
					'options' => '',
					'settings_readonly' => ['unique_id'],
					'validations_readonly' => [],
				],
			],
		],
		'form_submit_action_class_prefix' => 'cjwpbldr_frontend_auth_',
		'form_submit_actions' => [
			'default' => 'update_profile',
			'update_profile' => [
				'update_profile' => [
					'id' => 'update_profile',
					'type' => 'info',
					'label' => __( 'This will help user update his profile.', 'addon-frontend-auth' ),
					'default' => '',
					'options' => '',
				],
			],
		],
	],
];