<?php
global $builder_forms;

$builder_forms['cjwpbldr_frontend_auth_do_login'] = [
	'form_name' => __( 'Frontend Auth ~ Login Form', 'addon-frontend-auth' ),
	'form_settings' => [
		'form_access' => ['everyone'],
		'field_size' => 'default',
		'submit_button' => [
			'text' => __( 'Login', 'addon-frontend-auth' ),
			'size' => 'default',
			'color' => 'primary',
			'custom_css' => '',
			'suffix' => ''
		],
		'fields' => [
			[
				'type' => 'text',
				'group' => 'wordpress',
				'title' => __( 'Username or Email Address', 'addon-frontend-auth' ),
				'field' => [
					'id' => 'user_login',
					'type' => 'text',
					'info' => '',
					'default' => '',
					'settings' => [
						'unique_id' => 'user_login',
						'label' => __( 'Username or Email Address', 'addon-frontend-auth' ),
						'description' => '',
						'default' => '',
						'columns' => [
							'widescreen' => 'cj-is-12-widescreen',
							'desktop' => 'cj-is-12-desktop',
							'tablet' => 'cj-is-12-tablet',
							'mobile' => 'cj-is-12-mobile',
						]
					],
					'attributes' => [],
					'attributes_readonly' => [],
					'validations' => [
						'required' => 'yes'
					],
					'options' => '',
					'settings_readonly' => ['unique_id'],
					'validations_readonly' => [],
				],
			],
			[
				'type' => 'password',
				'group' => 'wordpress',
				'title' => __( 'Password', 'addon-frontend-auth' ),
				'field' => [
					'id' => 'user_pass',
					'type' => 'password',
					'info' => '',
					'default' => '',
					'settings' => [
						'unique_id' => 'user_pass',
						'label' => __( 'Password', 'addon-frontend-auth' ),
						'description' => '',
						'default' => '',
						'columns' => [
							'widescreen' => 'cj-is-12-widescreen',
							'desktop' => 'cj-is-12-desktop',
							'tablet' => 'cj-is-12-tablet',
							'mobile' => 'cj-is-12-mobile',
						]
					],
					'attributes' => [],
					'attributes_readonly' => [],
					'validations' => [
						'required' => 'yes'
					],
					'options' => '',
					'settings_readonly' => ['unique_id'],
					'validations_readonly' => [],
				],
			],
		],
		'form_submit_action_class_prefix' => 'cjwpbldr_frontend_auth_',
		'form_submit_actions' => [
			'default' => 'login',
			'login' => [
				'login' => [
					'id' => 'login',
					'type' => 'info',
					'label' => __( 'User will be logged-in.', 'addon-frontend-auth' ),
					'default' => '',
					'options' => '',
				],
			],
		],
	],
];