<?php
global $builder_forms;
$helpers = cjwpbldr_frontend_auth_helpers::getInstance();

$builder_forms['cjwpbldr_frontend_auth_do_set_new_password'] = [
	'form_name' => __( 'Frontend Auth ~ Set New Password Form', 'addon-frontend-auth' ),
	'form_settings' => [
		'form_access' => ['everyone'],
		'field_size' => 'default',
		'submit_button' => [
			'text' => __( 'Set New Password', 'addon-frontend-auth' ),
			'size' => 'default',
			'color' => 'primary',
			'custom_css' => '',
			'suffix' => ''
		],
		'fields' => [
			[
				'type' => 'password',
				'group' => 'wordpress',
				'title' => __( 'Enter a New Password', 'addon-frontend-auth' ),
				'field' => [
					'id' => 'new_password',
					'type' => 'password',
					'info' => '',
					'default' => '',
					'settings' => [
						'unique_id' => 'new_password',
						'label' => __( 'Enter a New Password', 'addon-frontend-auth' ),
						'description' => '',
						'default' => '',
						'columns' => [
							'widescreen' => 'cj-is-12-widescreen',
							'desktop' => 'cj-is-12-desktop',
							'tablet' => 'cj-is-12-tablet',
							'mobile' => 'cj-is-12-mobile',
						]
					],
					'attributes' => [],
					'attributes_readonly' => [],
					'validations' => [
						'required' => 'yes'
					],
					'options' => '',
					'settings_readonly' => ['unique_id'],
					'validations_readonly' => [],
				],
			],
			[
				'type' => 'password',
				'group' => 'wordpress',
				'title' => __( 'Confirm Your New Password', 'addon-frontend-auth' ),
				'field' => [
					'id' => 'new_password_confirmation',
					'type' => 'password',
					'info' => '',
					'default' => '',
					'settings' => [
						'unique_id' => 'new_password_confirmation',
						'label' => __( 'Confirm Your New Password', 'addon-frontend-auth' ),
						'description' => '',
						'default' => '',
						'columns' => [
							'widescreen' => 'cj-is-12-widescreen',
							'desktop' => 'cj-is-12-desktop',
							'tablet' => 'cj-is-12-tablet',
							'mobile' => 'cj-is-12-mobile',
						]
					],
					'attributes' => [],
					'attributes_readonly' => [],
					'validations' => [
						'required' => 'yes'
					],
					'options' => '',
					'settings_readonly' => ['unique_id'],
					'validations_readonly' => [],
				],
			],
		],
		'form_submit_action_class_prefix' => 'cjwpbldr_frontend_auth_',
		'form_submit_actions' => [
			'default' => 'new_password',
			'new_password' => [
				'auto_login' => [
					'id' => 'auto_login',
					'type' => 'select-raw',
					'label' => __( 'Auto Login?', 'addon-frontend-auth' ),
					'default' => 'yes',
					'options' => $helpers->arrays( 'yes-no' ),
				],
			],
		],
	],
];