<?php
global $builder_forms;
$helpers = cjwpbldr_frontend_auth_helpers::getInstance();
$builder_forms['cjwpbldr_frontend_auth_do_register'] = [
	'form_name' => __( 'Frontend Auth ~ Register Form', 'addon-frontend-auth' ),
	'form_settings' => [
		'form_access' => ['everyone'],
		'field_size' => 'default',
		'submit_button' => [
			'text' => __( 'Create Account', 'addon-frontend-auth' ),
			'size' => 'default',
			'color' => 'success',
			'custom_css' => '',
			'suffix' => ''
		],
		'fields' => [
			[
				'type' => 'text',
				'group' => 'wordpress',
				'title' => __( 'First Name', 'addon-frontend-auth' ),
				'field' => [
					'id' => 'first_name',
					'type' => 'text',
					'info' => '',
					'default' => '',
					'settings' => [
						'unique_id' => 'first_name',
						'label' => __( 'First Name', 'addon-frontend-auth' ),
						'description' => '',
						'default' => '',
						'columns' => [
							'widescreen' => 'cj-is-6-widescreen',
							'desktop' => 'cj-is-6-desktop',
							'tablet' => 'cj-is-12-tablet',
							'mobile' => 'cj-is-12-mobile',
						]
					],
					'attributes' => [],
					'attributes_readonly' => [],
					'validations' => [],
					'options' => '',
					'settings_readonly' => ['unique_id'],
					'validations_readonly' => [],
				],
			],
			[
				'type' => 'text',
				'group' => 'wordpress',
				'title' => __( 'Last Name', 'addon-frontend-auth' ),
				'field' => [
					'id' => 'last_name',
					'type' => 'text',
					'info' => '',
					'default' => '',
					'settings' => [
						'unique_id' => 'last_name',
						'label' => __( 'Last Name', 'addon-frontend-auth' ),
						'description' => '',
						'default' => '',
						'columns' => [
							'widescreen' => 'cj-is-6-widescreen',
							'desktop' => 'cj-is-6-desktop',
							'tablet' => 'cj-is-12-tablet',
							'mobile' => 'cj-is-12-mobile',
						]
					],
					'attributes' => [],
					'attributes_readonly' => [],
					'validations' => [],
					'options' => '',
					'settings_readonly' => ['unique_id'],
					'validations_readonly' => [],
				],
			],
			[
				'type' => 'text',
				'group' => 'wordpress',
				'title' => __( 'Choose a username', 'addon-frontend-auth' ),
				'field' => [
					'id' => 'user_login',
					'type' => 'text',
					'info' => '',
					'default' => '',
					'settings' => [
						'unique_id' => 'user_login',
						'label' => __( 'Choose a username', 'addon-frontend-auth' ),
						'description' => '',
						'default' => '',
						'columns' => [
							'widescreen' => 'cj-is-12-widescreen',
							'desktop' => 'cj-is-12-desktop',
							'tablet' => 'cj-is-12-tablet',
							'mobile' => 'cj-is-12-mobile',
						]
					],
					'attributes' => [],
					'attributes_readonly' => [],
					'validations' => [
						'required' => 'yes'
					],
					'options' => '',
					'settings_readonly' => ['unique_id'],
					'validations_readonly' => [],
				],
			],
			[
				'type' => 'text',
				'group' => 'wordpress',
				'title' => __( 'Your Email Address', 'addon-frontend-auth' ),
				'field' => [
					'id' => 'user_email',
					'type' => 'text',
					'info' => '',
					'default' => '',
					'settings' => [
						'unique_id' => 'user_email',
						'label' => __( 'Your Email Address', 'addon-frontend-auth' ),
						'description' => '',
						'default' => '',
						'columns' => [
							'widescreen' => 'cj-is-12-widescreen',
							'desktop' => 'cj-is-12-desktop',
							'tablet' => 'cj-is-12-tablet',
							'mobile' => 'cj-is-12-mobile',
						]
					],
					'attributes' => [],
					'attributes_readonly' => [],
					'validations' => [
						'required' => 'yes',
						'valid_email' => 'yes'
					],
					'options' => '',
					'settings_readonly' => ['unique_id'],
					'validations_readonly' => [],
				],
			],
			[
				'type' => 'text',
				'group' => 'wordpress',
				'title' => __( 'Password', 'addon-frontend-auth' ),
				'field' => [
					'id' => 'user_pass',
					'type' => 'password',
					'info' => '',
					'default' => '',
					'settings' => [
						'unique_id' => 'user_pass',
						'label' => __( 'Password', 'addon-frontend-auth' ),
						'description' => '',
						'default' => '',
						'columns' => [
							'widescreen' => 'cj-is-12-widescreen',
							'desktop' => 'cj-is-12-desktop',
							'tablet' => 'cj-is-12-tablet',
							'mobile' => 'cj-is-12-mobile',
						]
					],
					'attributes' => [],
					'attributes_readonly' => [],
					'validations' => [
						'required' => 'yes'
					],
					'options' => '',
					'settings_readonly' => ['unique_id'],
					'validations_readonly' => [],
				],
			],
		],
		'form_submit_action_class_prefix' => 'cjwpbldr_frontend_auth_',
		'form_submit_actions' => [
			'default' => 'direct_registration',
			'direct_registration' => [
				'auto_login' => [
					'id' => 'auto_login',
					'type' => 'select-raw',
					'label' => __( 'Auto Login?', 'addon-frontend-auth' ),
					'default' => 'yes',
					'options' => $helpers->arrays( 'yes-no' ),
				],
				'registration_role' => [
					'id' => 'registration_role',
					'type' => 'select-raw',
					'label' => __( 'Registration Role', 'addon-frontend-auth' ),
					'default' => get_option( 'default_role' ),
					'options' => $helpers->userRolesArray(),
				],
			],
			'approve_account' => [
				'registration_role' => [
					'id' => 'registration_role',
					'type' => 'select-raw',
					'label' => __( 'Registration Role', 'addon-frontend-auth' ),
					'default' => get_option( 'default_role' ),
					'options' => $helpers->userRolesArray(),
				],
			],
			'verify_email' => [
				'redirect_after_verification' => [
					'id' => 'redirect_after_verification',
					'type' => 'text',
					'label' => __( 'Redirect after verification', 'addon-frontend-auth' ),
					'info' => __( 'User will be redirected to this Url after successful verification', 'addon-frontend-auth' ),
					'default' => site_url(),
					'options' => '', // array in case of dropdown, checkbox and radio buttons
				],
				'registration_role' => [
					'id' => 'registration_role',
					'type' => 'select-raw',
					'label' => __( 'Registration Role', 'addon-frontend-auth' ),
					'default' => get_option( 'default_role' ),
					'options' => $helpers->userRolesArray(),
				],
			],
			'invitation' => [
				'invitation_code' => [
					'id' => 'invitation_code',
					'type' => 'text',
					'label' => __( 'Invitation Code', 'addon-frontend-auth' ),
					'info' => __( 'User will be asked to enter this code to access this form', 'addon-frontend-auth' ),
					'default' => $helpers->uniqueString(),
					'options' => '', // array in case of dropdown, checkbox and radio buttons
				],
				'invitation_code_error_message' => [
					'id' => 'invitation_code_error_message',
					'type' => 'text',
					'label' => __( 'Error Message', 'addon-frontend-auth' ),
					'info' => __( 'This will be displayed to user if they submit incorrect invitation code.', 'addon-frontend-auth' ),
					'default' => __( 'Sorry, this code is not valid.', 'addon-frontend-auth' ),
					'options' => '', // array in case of dropdown, checkbox and radio buttons
				],
				'registration_role' => [
					'id' => 'registration_role',
					'type' => 'select-raw',
					'label' => __( 'Registration Role', 'addon-frontend-auth' ),
					'default' => get_option( 'default_role' ),
					'options' => $helpers->userRolesArray(),
				],
			],
		],
	],
];