<?php
global $builder_forms;

$builder_forms['cjwpbldr_frontend_auth_do_reset_password'] = [
	'form_name' => __( 'Frontend Auth ~ Forgot Password Form', 'addon-frontend-auth' ),
	'form_settings' => [
		'form_access' => ['everyone'],
		'field_size' => 'default',
		'submit_button' => [
			'text' => __( 'Send Verification Link', 'addon-frontend-auth' ),
			'size' => 'default',
			'color' => 'primary',
			'custom_css' => '',
			'suffix' => ''
		],
		'fields' => [
			[
				'type' => 'text',
				'group' => 'wordpress',
				'title' => __( 'Username or Email Address', 'addon-frontend-auth' ),
				'field' => [
					'id' => 'user_login',
					'type' => 'text',
					'info' => '',
					'default' => '',
					'settings' => [
						'unique_id' => 'user_login',
						'label' => __( 'Username or Email Address', 'addon-frontend-auth' ),
						'description' => '',
						'default' => '',
						'columns' => [
							'widescreen' => 'cj-is-12-widescreen',
							'desktop' => 'cj-is-12-desktop',
							'tablet' => 'cj-is-12-tablet',
							'mobile' => 'cj-is-12-mobile',
						]
					],
					'attributes' => [],
					'attributes_readonly' => [],
					'validations' => [
						'required' => 'yes'
					],
					'options' => '',
					'settings_readonly' => ['unique_id'],
					'validations_readonly' => [],
				],
			],
		],
		'form_submit_action_class_prefix' => 'cjwpbldr_frontend_auth_',
		'form_submit_actions' => [
			'default' => 'forgot_password',
			'forgot_password' => [
				'forgot_password' => [
					'id' => 'forgot_password',
					'type' => 'info',
					'label' => __( 'This will help user to set a new password in case he forgets his older password.', 'addon-frontend-auth' ),
					'default' => '',
					'options' => '',
				],
			],
		],
	],
];