<?php
// Exit if accessed directly.
if( ! defined( 'ABSPATH' ) ) {
	exit;
}

/*
 * Class name should be cjwpbldr_NAME_shortcode
 * Shortcode Tag will be cjwpbldr_NAME
 * */
if( ! class_exists( 'cjwpbldr_frontend_delete_user_account_shortcode' ) ) {
	class cjwpbldr_frontend_delete_user_account_shortcode {

		public $defaults, $helpers, $render_forms, $textdomain, $shortcode_tag;

		private static $instance;

		public static function getInstance() {

			if( ! isset( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		public function __construct() {
			$this->shortcode_tag = str_replace( '_shortcode', '', get_class( $this ) );
			add_shortcode( $this->shortcode_tag, array($this, 'run') );
			$this->helpers = cjwpbldr_frontend_auth_helpers::getInstance();
			$this->textdomain = $this->helpers->config( 'plugin-info', 'textdomain' );
			$this->defaults = $this->defaults();
		}

		public function defaults() {
			$defaults['info'] = array(
				'single' => true,
				'tag' => $this->shortcode_tag,
				'name' => esc_attr__( 'Delete Account', 'addon-frontend-auth' ),
				'description' => esc_attr__( 'Displays a button for a user to delete their account.', 'addon-frontend-auth' ),
				'screenshot' => '',
				'default_content' => '',
				'group' => 'Core',
				'item_name' => $this->helpers->config( 'plugin-info', 'name' ),
				'preview' => true,
			);
			$defaults['options'] = array(
				array(
					'type' => 'text',
					'id' => 'button_text',
					'label' => __( 'Button Text', 'addon-frontend-auth' ),
					'info' => '',
					'default' => __( 'Delete Account', 'addon-frontend-auth' ),
					'options' => '', // array in case of dropdown, checkbox and radio buttons
				),
				array(
					'type' => 'text',
					'id' => 'button_class',
					'label' => __( 'Button CSS Class', 'addon-frontend-auth' ),
					'info' => '',
					'default' => 'btn btn-danger',
					'options' => '', // array in case of dropdown, checkbox and radio buttons
				),
				array(
					'type' => 'textarea',
					'id' => 'confirm_message',
					'label' => __( 'Confirmation message', 'addon-frontend-auth' ),
					'info' => __( 'This message will be displayed to use once they click the button with an option to go ahead and cancel.', 'addon-frontend-auth' ),
					'default' => "Are you sure? Your account will be removed and you will not be able to login again to this website.",
					'options' => '', // array in case of dropdown, checkbox and radio buttons
				),
				array(
					'type' => 'url',
					'id' => 'redirect_url',
					'label' => __( 'Redirect Url', 'addon-frontend-auth' ),
					'info' => __( 'User will be redirected to this Url after account is removed. If blank, user will be redirected to homepage.', 'addon-frontend-auth' ),
					'default' => site_url( '?account=removed' ),
					'options' => '', // array in case of dropdown, checkbox and radio buttons
				)
			);

			return $defaults;
		}

		public function run( $atts, $content = null ) {
			$defaults = array();
			$shortcode_params = $this->defaults();
			if( is_array( $shortcode_params['options'] ) && ! empty( $shortcode_params['options'] ) ) {
				foreach( $shortcode_params['options'] as $key => $param ) {
					$default_key = str_replace( '-', '_', $param['id'] );
					$default_value = (isset( $param['default'] ) && is_array( $param['default'] )) ? implode( '|', $param['default'] ) : $param['default'];
					$defaults[ $default_key ] = $default_value;
				}
			}

			$instance = ( ! is_array( $atts )) ? array() : $atts;
			$instance['content'] = $content;
			$output = '';
			$content_file_path = dirname( __FILE__ ) . '/content.php';
			if( file_exists( $content_file_path ) ) {
				ob_start();
				require($content_file_path);
				$output .= ob_get_clean();
				$output = apply_filters( 'cjwpbldr_shortcode_before_output', $output, $shortcode_params );
				$output = apply_filters( 'cjwpbldr_shortcode_after_output', $output, $shortcode_params );
			} else {
				$output .= '<div class="cj-notification cj-is-info">';
				$output .= sprintf( __( 'Shortcode content file not found.<br>%s', 'cjwpbldr' ), str_replace( dirname( dirname( __FILE__ ) ), '', $content_file_path ) );
				$output .= '</div>';
			}

			return $output;
		}

		public function deleteAccount() {
			global $current_user, $wpdb;
			if( isset( $_GET['cjwpbldr_action'] ) && $_GET['cjwpbldr_action'] == 'delete-my-account' ) {
				wp_get_current_user();
				if( ! is_user_logged_in() ) {
					wp_redirect( site_url() );
				}
				if( current_user_can( 'manage_options' ) ) {
					wp_die( __( 'Admin accounts cannot be removed via this method, please use wp-admin to remove this account.', 'addon-frontend-auth' ) );
				}
				if( isset( $_REQUEST['_wpnonce'] ) && wp_verify_nonce( $_REQUEST['_wpnonce'], 'cjwpbldr_delete_account' ) ) {
					require_once(ABSPATH . 'wp-admin/includes/user.php');
					wp_delete_user( $current_user->ID );
					$wpdb->query( "DELETE FROM $wpdb->comments WHERE comment_author = '{$current_user->ID}'" );
					$wpdb->query( "DELETE FROM $wpdb->links WHERE link_owner = '{$current_user->ID}'" );
					do_action( 'cjfm_delete_account', $current_user->ID );
					wp_logout();
					$redirect = (isset( $_GET['redirect'] )) ? $_GET['redirect'] : site_url();
					wp_redirect( $redirect );
					exit();
				}
			}
		}

	}

	cjwpbldr_frontend_delete_user_account_shortcode::getInstance();
}