<?php
// Exit if accessed directly.
if( ! defined( 'ABSPATH' ) ) {
	exit;
}

/*
 * Class name should be cjwpbldr_NAME_shortcode
 * Shortcode Tag will be cjwpbldr_NAME
 * */
if( ! class_exists( 'cjwpbldr_logout_shortcode' ) ) {
	class cjwpbldr_logout_shortcode {

		public $defaults, $helpers, $render_forms, $textdomain, $shortcode_tag;

		private static $instance;

		public static function getInstance() {

			if( ! isset( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		public function __construct() {
			$this->shortcode_tag = str_replace( '_shortcode', '', get_class( $this ) );
			add_shortcode( $this->shortcode_tag, array($this, 'run') );
			$this->helpers = cjwpbldr_frontend_auth_helpers::getInstance();
			$this->textdomain = $this->helpers->config( 'plugin-info', 'textdomain' );
			$this->defaults = $this->defaults();
		}

		public function defaults() {
			$defaults['info'] = array(
				'single' => true,
				'tag' => $this->shortcode_tag,
				'name' => esc_attr__( 'Logout', 'addon-frontend-auth' ),
				'description' => esc_attr__( 'Logout current user and redirect to specified url.', 'addon-frontend-auth' ),
				'screenshot' => '',
				'default_content' => '',
				'group' => 'Core',
				'item_name' => $this->helpers->config( 'plugin-info', 'name' ),
				'preview' => true,
			);
			$defaults['options'] = array(
				array(
					'type' => 'text',
					'id' => 'redirect',
					'label' => __( 'Redirect Url', 'addon-frontend-auth' ),
					'info' => __( 'Specify a valid Url where user will be redirected after logout.', 'addon-frontend-auth' ),
					'default' => site_url(),
					'options' => '', // array in case of dropdown, checkbox and radio buttons
				),
			);

			return $defaults;
		}

		public function run( $atts, $content = null ) {
			$defaults = array();
			$shortcode_params = $this->defaults();
			if( is_array( $shortcode_params['options'] ) && ! empty( $shortcode_params['options'] ) ) {
				foreach( $shortcode_params['options'] as $key => $param ) {
					$default_key = str_replace( '-', '_', $param['id'] );
					$default_value = (isset( $param['default'] ) && is_array( $param['default'] )) ? implode( '|', $param['default'] ) : $param['default'];
					$defaults[ $default_key ] = $default_value;
				}
			}

			$instance = ( ! is_array( $atts )) ? array() : $atts;
			$instance['content'] = $content;
			$output = '';
			$content_file_path = dirname( __FILE__ ) . '/content.php';
			if( file_exists( $content_file_path ) ) {
				ob_start();
				require($content_file_path);
				$output .= ob_get_clean();
				$output = apply_filters( 'cjwpbldr_shortcode_before_output', $output, $shortcode_params );
				$output = apply_filters( 'cjwpbldr_shortcode_after_output', $output, $shortcode_params );
			} else {
				$output .= '<div class="cj-notification cj-is-info">';
				$output .= sprintf( __( 'Shortcode content file not found.<br>%s', 'cjwpbldr' ), str_replace( dirname( dirname( __FILE__ ) ), '', $content_file_path ) );
				$output .= '</div>';
			}

			return $output;
		}
	}

	cjwpbldr_logout_shortcode::getInstance();
}