<?php
// Exit if accessed directly.
if( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $post;

$textdomain = 'cjwpbldr';

$url_args = array('redirect' => get_permalink( $post->ID ));

$login_page = $this->helpers->savedOption( 'cjfmr_page_login' );
$register_page = $this->helpers->savedOption( 'cjfmr_page_register' );

$login_link = get_permalink( $login_page );
$register_link = get_permalink( $register_page );

$login_page_link = $this->helpers->generateSafeLink( $login_link, $url_args );
$register_page_link = $this->helpers->generateSafeLink( $register_link, $url_args );

$login_message_login_link = sprintf( __( '<a href="%s" title="Login">Login</a>', $textdomain ), $login_page_link );
$login_message_register_link = sprintf( __( '<a href="%s" title="Register">Register</a>', $textdomain ), $register_page_link );

$login_message = $this->helpers->savedOption( 'cjfmr_restricted_login_message' );

$login_message = str_replace( '%%login_link%%', $login_message_login_link, $login_message );
$login_message = str_replace( '%%register_link%%', $login_message_register_link, $login_message );

if( is_user_logged_in() ) {
	echo $content;
} else {
	echo $login_message;
}