<?php
$core_features = $this->getOption( 'core_features', [] );

return [
	'cjwpbldr-ui-blocks' => [
		'labels' => [
			'name' => esc_attr__( 'UI Blocks', 'wp-builder-locale' ),
			'singular_name' => esc_attr__( 'UI Block', 'wp-builder-locale' ),
			'add_new' => _x( 'Add New', 'UI Blocks' ),
			'add_new_item' => esc_attr__( 'Add New UI Block', 'wp-builder-locale' ),
			'edit_item' => esc_attr__( 'Edit UI Block', 'wp-builder-locale' ),
			'new_item' => esc_attr__( 'New UI Block', 'wp-builder-locale' ),
			'view_item' => esc_attr__( 'View UI Block', 'wp-builder-locale' ),
			'search_items' => esc_attr__( 'Search UI Blocks', 'wp-builder-locale' ),
			'not_found' => esc_attr__( 'No UI Blocks found', 'wp-builder-locale' ),
			'not_found_in_trash' => esc_attr__( 'No UI Blocks found in Trash', 'wp-builder-locale' ),
			'parent_item_colon' => ''
		],
		'args' => [
			'exclude_from_search' => true,
			'public' => false,
			'publicly_queryable' => false,
			'show_ui' => ($this->inArray( ['blocks'], $core_features )) ? true : false,
			'show_in_menu' => ($this->inArray( ['blocks'], $core_features )) ? true : false,
			'has_archive' => false,
			'can_export' => true,
			'query_var' => true,
			'rewrite' => array('slug' => 'cjwpbldr-ui-blocks', 'with_front' => false, 'hierarchical' => true),
			'capability_type' => 'post',
			'capabilities' => array(), //'create_posts' => 'do_not_allow'
			'taxonomies' => array('cjwpbldr-blocks-group'),
			'hierarchical' => false,
			'menu_position' => 91,
			'menu_icon' => 'dashicons-welcome-widgets-menus',
			'supports' => array('title'),
		]
	],
	'cjwpbldr-templates' => [
		'labels' => [
			'name' => esc_attr__( 'Templates', 'wp-builder-locale' ),
			'singular_name' => esc_attr__( 'Template', 'wp-builder-locale' ),
			'add_new' => _x( 'Add New', 'Templates' ),
			'add_new_item' => esc_attr__( 'Add New Template', 'wp-builder-locale' ),
			'edit_item' => esc_attr__( 'Edit Template', 'wp-builder-locale' ),
			'new_item' => esc_attr__( 'New Template', 'wp-builder-locale' ),
			'view_item' => esc_attr__( 'View Template', 'wp-builder-locale' ),
			'search_items' => esc_attr__( 'Search Templates', 'wp-builder-locale' ),
			'not_found' => esc_attr__( 'No Templates found', 'wp-builder-locale' ),
			'not_found_in_trash' => esc_attr__( 'No Templates found in Trash', 'wp-builder-locale' ),
			'parent_item_colon' => ''
		],
		'args' => [
			'exclude_from_search' => true,
			'public' => false,
			'publicly_queryable' => false,
			'show_ui' => ($this->inArray( ['builder'], $core_features )) ? true : false,
			'show_in_menu' => ($this->inArray( ['builder'], $core_features )) ? true : false,
			'has_archive' => false,
			'can_export' => true,
			'query_var' => true,
			'rewrite' => array('slug' => 'cjwpbldr-templates', 'with_front' => false, 'hierarchical' => true),
			'capability_type' => 'post',
			'taxonomies' => array(),
			'hierarchical' => false,
			'menu_position' => 90,
			'menu_icon' => 'dashicons-media-document',
			'supports' => array('title')
		]
	],
	'wpb-portfolio' => [
		'labels' => [
			'name' => esc_attr__( 'Portfolio', 'wp-builder-locale' ),
			'singular_name' => esc_attr__( 'Portfolio Item', 'wp-builder-locale' ),
			'add_new' => _x( 'Add New', 'Portfolio' ),
			'add_new_item' => esc_attr__( 'Add New Portfolio Item', 'wp-builder-locale' ),
			'edit_item' => esc_attr__( 'Edit Portfolio Item', 'wp-builder-locale' ),
			'new_item' => esc_attr__( 'New Portfolio Item', 'wp-builder-locale' ),
			'view_item' => esc_attr__( 'View Portfolio Item', 'wp-builder-locale' ),
			'search_items' => esc_attr__( 'Search Portfolio', 'wp-builder-locale' ),
			'not_found' => esc_attr__( 'No Portfolio found', 'wp-builder-locale' ),
			'not_found_in_trash' => esc_attr__( 'No Portfolio found in Trash', 'wp-builder-locale' ),
			'parent_item_colon' => ''
		],
		'args' => [
			'exclude_from_search' => true,
			'public' => false,
			'publicly_queryable' => false,
			'show_ui' => ($this->inArray( ['portfolio'], $core_features )),
			'show_in_menu' => ($this->inArray( ['portfolio'], $core_features )),
			'has_archive' => false,
			'can_export' => true,
			'query_var' => true,
			'rewrite' => array('slug' => 'portfolio', 'with_front' => false, 'hierarchical' => true),
			'capability_type' => 'post',
			'taxonomies' => array(),
			'hierarchical' => false,
			'menu_position' => 21,
			'menu_icon' => 'dashicons-portfolio',
			'supports' => array('title', 'editor', 'thumbnail', 'revisions'),
		]
	],
	'wpb-team' => [
		'labels' => [
			'name' => esc_attr__( 'Team Members', 'wp-builder-locale' ),
			'singular_name' => esc_attr__( 'Team Member', 'wp-builder-locale' ),
			'add_new' => _x( 'Add New', 'Team Members' ),
			'add_new_item' => esc_attr__( 'Add New Team Member', 'wp-builder-locale' ),
			'edit_item' => esc_attr__( 'Edit Team Member', 'wp-builder-locale' ),
			'new_item' => esc_attr__( 'New Team Member', 'wp-builder-locale' ),
			'view_item' => esc_attr__( 'View Team Member', 'wp-builder-locale' ),
			'search_items' => esc_attr__( 'Search Team Members', 'wp-builder-locale' ),
			'not_found' => esc_attr__( 'No Team Members found', 'wp-builder-locale' ),
			'not_found_in_trash' => esc_attr__( 'No Team Members found in Trash', 'wp-builder-locale' ),
			'parent_item_colon' => ''
		],
		'args' => [
			'exclude_from_search' => true,
			'public' => false,
			'publicly_queryable' => false,
			'show_ui' => ($this->inArray( ['team'], $core_features )),
			'show_in_menu' => ($this->inArray( ['team'], $core_features )),
			'has_archive' => false,
			'can_export' => true,
			'query_var' => true,
			'rewrite' => array('slug' => 'team', 'with_front' => false, 'hierarchical' => true),
			'capability_type' => 'post',
			'taxonomies' => array(),
			'hierarchical' => false,
			'menu_position' => 21,
			'menu_icon' => 'dashicons-groups',
			'supports' => array('title', 'editor', 'thumbnail', 'revisions'),
		]
	],
	'wpb-faqs' => [
		'labels' => [
			'name' => esc_attr__( 'FAQs', 'wp-builder-locale' ),
			'singular_name' => esc_attr__( 'FAQ', 'wp-builder-locale' ),
			'add_new' => _x( 'Add New', 'FAQs' ),
			'add_new_item' => esc_attr__( 'Add New FAQ', 'wp-builder-locale' ),
			'edit_item' => esc_attr__( 'Edit FAQ', 'wp-builder-locale' ),
			'new_item' => esc_attr__( 'New FAQ', 'wp-builder-locale' ),
			'view_item' => esc_attr__( 'View FAQ', 'wp-builder-locale' ),
			'search_items' => esc_attr__( 'Search FAQs', 'wp-builder-locale' ),
			'not_found' => esc_attr__( 'No FAQs found', 'wp-builder-locale' ),
			'not_found_in_trash' => esc_attr__( 'No FAQs found in Trash', 'wp-builder-locale' ),
			'parent_item_colon' => ''
		],
		'args' => [
			'exclude_from_search' => true,
			'public' => false,
			'publicly_queryable' => false,
			'show_ui' => ($this->inArray( ['faqs'], $core_features )),
			'show_in_menu' => ($this->inArray( ['faqs'], $core_features )),
			'has_archive' => false,
			'can_export' => true,
			'query_var' => true,
			'rewrite' => array('slug' => 'faqs', 'with_front' => false, 'hierarchical' => true),
			'capability_type' => 'post',
			'taxonomies' => array(),
			'hierarchical' => false,
			'menu_position' => 21,
			'menu_icon' => 'dashicons-editor-help',
			'supports' => array('title', 'editor', 'revisions'),
		]
	],
	'wpb-testimonials' => [
		'labels' => [
			'name' => esc_attr__( 'Testimonials', 'wp-builder-locale' ),
			'singular_name' => esc_attr__( 'Testimonial', 'wp-builder-locale' ),
			'add_new' => _x( 'Add New', 'Testimonials' ),
			'add_new_item' => esc_attr__( 'Add New Testimonial', 'wp-builder-locale' ),
			'edit_item' => esc_attr__( 'Edit Testimonial', 'wp-builder-locale' ),
			'new_item' => esc_attr__( 'New Testimonial', 'wp-builder-locale' ),
			'view_item' => esc_attr__( 'View Testimonial', 'wp-builder-locale' ),
			'search_items' => esc_attr__( 'Search Testimonials', 'wp-builder-locale' ),
			'not_found' => esc_attr__( 'No Testimonials found', 'wp-builder-locale' ),
			'not_found_in_trash' => esc_attr__( 'No Testimonials found in Trash', 'wp-builder-locale' ),
			'parent_item_colon' => ''
		],
		'args' => [
			'exclude_from_search' => true,
			'public' => false,
			'publicly_queryable' => false,
			'show_ui' => ($this->inArray( ['testimonials'], $core_features )),
			'show_in_menu' => ($this->inArray( ['testimonials'], $core_features )),
			'has_archive' => false,
			'can_export' => true,
			'query_var' => true,
			'rewrite' => array('slug' => 'testimonials', 'with_front' => false, 'hierarchical' => true),
			'capability_type' => 'post',
			'taxonomies' => array(),
			'hierarchical' => false,
			'menu_position' => 21,
			'menu_icon' => 'dashicons-feedback',
			'supports' => array('title', 'editor', 'thumbnail', 'revisions'),
		]
	],
];