<?php
$core_features = $this->getOption( 'core_features', [] );
return [
	'cjwpbldr-blocks-group' => [
		'labels' => [
			'name' => __( 'Groups', 'wp-builder-locale' ),
			'singular_name' => __( 'Group', 'wp-builder-locale' ),
			'search_items' => __( 'Search Group', 'wp-builder-locale' ),
			'all_items' => __( 'All Groups', 'wp-builder-locale' ),
			'parent_item' => __( 'Parent Group', 'wp-builder-locale' ),
			'parent_item_colon' => __( 'Parent Group:', 'wp-builder-locale' ),
			'edit_item' => __( 'Edit Group', 'wp-builder-locale' ),
			'update_item' => __( 'Update Group', 'wp-builder-locale' ),
			'add_new_item' => __( 'Add New Group', 'wp-builder-locale' ),
			'new_item_name' => __( 'New Group', 'wp-builder-locale' ),
		],
		'args' => [
			'public' => false,
			'publicly_queryable' => false,
			'show_ui' => false,
			'show_in_menu' => false,
			'show_in_nav_menus' => false,
			'show_in_rest' => true,
			'show_tagcloud' => false,
			'show_in_quick_edit' => false,
			'show_admin_column' => true,
			'meta_box_cb' => false,
			'hierarchical' => false,
			'query_var' => true,
			'capabilities' => ['manage_terms'],
			'rewrite' => ['slug' => 'cjwpbldr-blocks-group', 'with_front' => false],
		],
		'post_types' => ['cjwpbldr-ui-blocks']
	],
	'wpb-portfolio-category' => [
		'labels' => [
			'name' => __( 'Portfolio Categories', 'wp-builder-locale' ),
			'singular_name' => __( 'Portfolio Category', 'wp-builder-locale' ),
			'search_items' => __( 'Search Portfolio Category', 'wp-builder-locale' ),
			'all_items' => __( 'All Portfolio Categories', 'wp-builder-locale' ),
			'parent_item' => __( 'Parent Portfolio Category', 'wp-builder-locale' ),
			'parent_item_colon' => __( 'Parent Portfolio Category:', 'wp-builder-locale' ),
			'edit_item' => __( 'Edit Portfolio Category', 'wp-builder-locale' ),
			'update_item' => __( 'Update Portfolio Category', 'wp-builder-locale' ),
			'add_new_item' => __( 'Add New Portfolio Category', 'wp-builder-locale' ),
			'new_item_name' => __( 'New Portfolio Category', 'wp-builder-locale' ),
		],
		'args' => [
			'public' => false,
			'publicly_queryable' => false,
			'show_ui' => ($this->inArray( ['portfolio'], $core_features )) ? true : false,
			'show_in_menu' => ($this->inArray( ['portfolio'], $core_features )) ? true : false,
			'show_in_nav_menus' => ($this->inArray( ['portfolio'], $core_features )) ? true : false,
			'show_in_rest' => ($this->inArray( ['portfolio'], $core_features )) ? true : false,
			'show_tagcloud' => ($this->inArray( ['portfolio'], $core_features )) ? true : false,
			'show_in_quick_edit' => ($this->inArray( ['portfolio'], $core_features )) ? true : false,
			'show_admin_column' => ($this->inArray( ['portfolio'], $core_features )) ? true : false,
			'hierarchical' => true,
			'query_var' => true,
			'capabilities' => ['manage_terms'],
			'rewrite' => ['slug' => 'wpb-portfolio-category', 'with_front' => false],
		],
		'post_types' => ['wpb-portfolio']
	],
	'wpb-faqs-category' => [
		'labels' => [
			'name' => __( 'FAQs Categories', 'wp-builder-locale' ),
			'singular_name' => __( 'FAQs Category', 'wp-builder-locale' ),
			'search_items' => __( 'Search FAQs Category', 'wp-builder-locale' ),
			'all_items' => __( 'All FAQs Categories', 'wp-builder-locale' ),
			'parent_item' => __( 'Parent FAQs Category', 'wp-builder-locale' ),
			'parent_item_colon' => __( 'Parent FAQs Category:', 'wp-builder-locale' ),
			'edit_item' => __( 'Edit FAQs Category', 'wp-builder-locale' ),
			'update_item' => __( 'Update FAQs Category', 'wp-builder-locale' ),
			'add_new_item' => __( 'Add New FAQs Category', 'wp-builder-locale' ),
			'new_item_name' => __( 'New FAQs Category', 'wp-builder-locale' ),
		],
		'args' => [
			'public' => false,
			'publicly_queryable' => false,
			'show_ui' => ($this->inArray( ['faqs'], $core_features )) ? true : false,
			'show_in_menu' => ($this->inArray( ['faqs'], $core_features )) ? true : false,
			'show_in_nav_menus' => ($this->inArray( ['faqs'], $core_features )) ? true : false,
			'show_in_rest' => ($this->inArray( ['faqs'], $core_features )) ? true : false,
			'show_tagcloud' => ($this->inArray( ['faqs'], $core_features )) ? true : false,
			'show_in_quick_edit' => ($this->inArray( ['faqs'], $core_features )) ? true : false,
			'show_admin_column' => ($this->inArray( ['faqs'], $core_features )) ? true : false,
			'hierarchical' => true,
			'query_var' => true,
			'capabilities' => ['manage_terms'],
			'rewrite' => ['slug' => 'wpb-faqs-category', 'with_front' => false],
		],
		'post_types' => ['wpb-faqs']
	]
];