<?php
if( $this->helpers->isTheme() ) {
	$framework_name = $this->helpers->config( 'plugin-info', 'theme_name' );
} else {
	$framework_name = $this->helpers->config( 'plugin-info', 'name' );
}
$install_path = '<code>' . str_replace( ABSPATH, '/', $this->helpers->root_dir ) . '</code>';
?>
<div class="cj-columns cj-is-multiline cj-is-mobile">
    <div class="cj-column cj-is-12-fullhd cj-is-12-widescreen cj-is-12-desktop cj-is-12-tablet cj-is-12-mobile">
		<?php
		$framework_links[] = '<a target="_blank" href="' . $this->helpers->config( 'plugin-info', 'docs_url' ) . '">' . __( 'Documentation', 'wp-builder-locale' ) . '</a>';
		$framework_links[] = '<a target="_blank" href="' . $this->helpers->config( 'plugin-info', 'faqs_url' ) . '">' . __( 'FAQs', 'wp-builder-locale' ) . '</a>';
		$framework_links[] = '<a target="_blank" href="' . $this->helpers->config( 'plugin-info', 'support_url' ) . '">' . __( 'Help & Support', 'wp-builder-locale' ) . '</a>';
		$framework_links[] = '<a target="_blank" href="' . $this->helpers->config( 'plugin-info', 'hire_us_url' ) . '">' . __( 'Hire Us', 'wp-builder-locale' ) . '</a>';
		$framework_links[] = '<a target="_blank" href="' . $this->helpers->config( 'plugin-info', 'twitter_url' ) . '">' . __( 'Twitter', 'wp-builder-locale' ) . '</a>';
		$framework_links[] = '<a target="_blank" href="' . $this->helpers->config( 'plugin-info', 'facebook_url' ) . '">' . __( 'Facebook', 'wp-builder-locale' ) . '</a>';
		$framework_form_fields = [
			[
				'id' => 'framework-title',
				'type' => 'sub-heading',
				'info' => '',
				'params' => [],
				'default' => $framework_name,
				'options' => '', // array in case of dropdown, checkbox and radio buttons
				'quick-searchable' => false
			],
			[
				'id' => 'framework-version',
				'label' => __( 'Framework Version', 'wp-builder-locale' ),
				'type' => 'info',
				'info' => '',
				'default' => CJWPBLDR_VERSION,
				'options' => '', // array in case of dropdown, checkbox and radio buttons
				'quick-searchable' => false
			],
			[
				'id' => 'framework-install-path',
				'label' => __( 'Framework Path', 'wp-builder-locale' ),
				'type' => 'info',
				'info' => '',
				'default' => $install_path,
				'options' => '', // array in case of dropdown, checkbox and radio buttons
				'quick-searchable' => false
			],
			[
				'id' => 'framework-links',
				'label' => __( 'Useful Links', 'wp-builder-locale' ),
				'type' => 'info',
				'info' => '',
				'default' => implode( '<span class="cj-p-10 cj-opacity-50">|</span>', $framework_links ),
				'options' => '', // array in case of dropdown, checkbox and radio buttons
				'quick-searchable' => false
			],
		];
		echo $this->helpers->renderAdminForm( $framework_form_fields );
		?>
    </div>
</div>
<?php
$tab = (isset( $_GET['show'] ) && $_GET['show'] != '') ? $_GET['show'] : 'installed';
?>
<div id="cjwpbldr-cloud-app" v-cloak>
    <cjwpbldr-cloud show_tab="<?php echo $tab; ?>"></cjwpbldr-cloud>
</div>