<?php
/*
Plugin Name: Alinan Theme Core
Plugin URL: http://www.anthemes.net
Description: Theme Functionality: Custom Style, Theme core, etc.
Version: 1.1
Author: An-Themes
Author URI: http://themeforest.net/user/An-Themes/portfolio
*/
 

// ------------------------------------------------ 
// ---- Twitter ampersand entity decode -----------
// ------------------------------------------------ 
function alinan_social_title( $title ) {
    $title = html_entity_decode( $title );
    $title = urlencode( $title );
    return $title;
}


// ------------------------------------------------ 
// ---- Home Social share  ------------------------
// ------------------------------------------------ 
function alinan_wp_home_social_share() { ?>
    <?php $video_wp_facebooklink = 'https://www.facebook.com/sharer/sharer.php?u='; ?>
    <a class="fbbutton" target="_blank" href="<?php echo esc_url($video_wp_facebooklink); ?><?php the_permalink(); ?>" onClick="javascript:window.open(this.href, '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=400,width=700');return false;"><i class="fab fa-facebook-f" aria-hidden="true"></i></a>
    <?php $video_wp_twitterlink = 'https://twitter.com/intent/tweet?text=Check%20out%20this%20article:%20'; ?>
    <a class="twbutton" target="_blank" href="<?php echo esc_url($video_wp_twitterlink); ?><?php print alinan_social_title( get_the_title() ); ?>%20-%20<?php echo urlencode(the_permalink()); ?>" onClick="javascript:window.open(this.href, '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=400,width=700');return false;"><i class="fab fa-twitter" aria-hidden="true"></i></a>
<?php }

// ------------------------------------------------ 
// ---- Small Social share Single  ----------------
// ------------------------------------------------ 
function alinan_wp_small_social_share_single() { ?>
    <?php $alinan_wp_facebooklink = 'https://www.facebook.com/sharer/sharer.php?u='; ?><a class="fbbutton" target="_blank" href="<?php echo esc_url($alinan_wp_facebooklink); ?><?php the_permalink(); ?>" onClick="javascript:window.open(this.href, '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=400,width=700');return false;"><i class="fab fa-facebook-f" aria-hidden="true"></i></a>
    <?php $alinan_wp_twitterlink = 'https://twitter.com/intent/tweet?text=Check%20out%20this%20article:%20'; ?><a class="twbutton" target="_blank" href="<?php echo esc_url($alinan_wp_twitterlink); ?><?php print alinan_social_title( get_the_title() ); ?>%20-%20<?php echo urlencode(the_permalink()); ?>" onClick="javascript:window.open(this.href, '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=400,width=700');return false;"><i class="fab fa-twitter" aria-hidden="true"></i></a>    
    <?php $alinan_wp_articleimage = wp_get_attachment_url( get_post_thumbnail_id()); ?><?php $alinan_wp_pinlink = 'https://pinterest.com/pin/create/button/?url='; ?><a class="pinbutton" target="_blank" href="<?php echo esc_url($alinan_wp_pinlink); ?><?php the_permalink(); ?>&amp;media=<?php echo esc_html($alinan_wp_articleimage); ?>&amp;description=<?php the_title(); ?>" onClick="javascript:window.open(this.href, '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=400,width=700');return false;"><i class="fab fa-pinterest-p" aria-hidden="true"></i></a>
    <?php $alinan_wp_googlelink = 'https://plus.google.com/share?url='; ?><a class="googlebutton" target="_blank" href="<?php echo esc_url($alinan_wp_googlelink); ?><?php the_permalink(); ?>" onClick="javascript:window.open(this.href, '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=400,width=700');return false;"><i class="fab fa-google-plus-g" aria-hidden="true"></i></a>
<?php }


// ------------------------------------------------ 
// ---- Big Social share  -----------------------
// ------------------------------------------------ 
function alinan_wp_big_social_share() { ?>
    <?php $video_wp_facebooklink = 'https://www.facebook.com/sharer/sharer.php?u='; ?>
    <a class="fbbutton" target="_blank" href="<?php echo esc_url($video_wp_facebooklink); ?><?php the_permalink(); ?>" onClick="javascript:window.open(this.href, '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=400,width=700');return false;"><i class="fab fa-facebook-f" aria-hidden="true"></i></a>
    <?php $video_wp_twitterlink = 'https://twitter.com/intent/tweet?text=Check%20out%20this%20article:%20'; ?>
    <a class="twbutton" target="_blank" href="<?php echo esc_url($video_wp_twitterlink); ?><?php print alinan_social_title( get_the_title() ); ?>%20-%20<?php echo urlencode(the_permalink()); ?>" onClick="javascript:window.open(this.href, '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=400,width=700');return false;"><i class="fab fa-twitter" aria-hidden="true"></i></a>
    <?php $articleimage = wp_get_attachment_url( get_post_thumbnail_id()); ?>
    <?php $video_wp_pinlink = 'https://pinterest.com/pin/create/button/?url='; ?>
    <a class="pinbutton" target="_blank" href="<?php echo esc_url($video_wp_pinlink); ?><?php the_permalink(); ?>&amp;media=<?php echo esc_html($articleimage); ?>&amp;description=<?php the_title(); ?>" onClick="javascript:window.open(this.href, '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=400,width=700');return false;"><i class="fab fa-pinterest-p" aria-hidden="true"></i></a>
    <?php $video_wp_googlelink = 'https://plus.google.com/share?url='; ?>
    <a class="googlebutton" target="_blank" href="<?php echo esc_url($video_wp_googlelink); ?><?php the_permalink(); ?>" onClick="javascript:window.open(this.href, '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=400,width=700');return false;"><i class="fab fa-google-plus-g" aria-hidden="true"></i></a>
<?php }


// ------------------------------------------------
// ---- Add  rel attributes to embedded images ----
// ------------------------------------------------ 
function insert_rel_alinan_wp($content) {
    $pattern = '/<a(.*?)href="(.*?).(bmp|gif|jpeg|jpg|png)"(.*?)>/i';
    $replacement = '<a$1href="$2.$3" class=\'wp-img-bg-off\' rel=\'mygallery\'$4>';
    $content = preg_replace( $pattern, $replacement, $content );
    return $content;
}
add_filter( 'the_content', 'insert_rel_alinan_wp' );


// ------------------------------------------------ 
// --- Pagination class/style for entry articles --
// ------------------------------------------------ 
function custom_nextpage_links_alinan_wp($defaults) {
$args = array(
'before' => '<div class="my-paginated-posts"><p>' . '<span>',
'after' => '</span></p></div>',
);
$r = wp_parse_args($args, $defaults);
return $r;
}
add_filter('wp_link_pages_args','custom_nextpage_links_alinan_wp');
 

// ------------------------------------------------ 
// ------------ Number of post views --------------
// ------------------------------------------------

 // function to display number of posts.
function getPostViews_alinan_wp($postID){
    $count_key = 'post_views_count_alinan_wp';
    $count = get_post_meta($postID, $count_key, true);
    if($count==''){
        delete_post_meta($postID, $count_key);
        add_post_meta($postID, $count_key, '0');
        return '0';
    }
    return $count;
}

// function to count views.
function setPostViews_alinan_wp($postID) {
    $count_key = 'post_views_count_alinan_wp';
    $count = get_post_meta($postID, $count_key, true);
    if($count==''){
        $count = 0;
        delete_post_meta($postID, $count_key);
        add_post_meta($postID, $count_key, '0');
    }else{
        $count++;
        update_post_meta($postID, $count_key, $count);
    }
}

// ------------------------------------------------ 
// --- Characters limit for title -----------------
// ------------------------------------------------ 
function alinan_wp_the_title($length, $replacer = ' ..') {
    $string = get_the_title();
    if( mb_strlen( $string ) > $length ) {
        $string = mb_substr( $string, 0, $length-3 );
        echo esc_attr($string) . $replacer;
    } else echo esc_attr($string);
}


// ------------------------------------------------ 
// ------------ Meta Box --------------------------
// ------------------------------------------------
$prefix = 'alinan_wp_';
global $meta_boxes;
$meta_boxes = array();

// 1st meta box
$meta_boxes[] = array(
    'id' => 'standard',
    'title' => esc_html__( 'Article Page Options', 'alinan-wp' ),
    'context' => 'normal',
    'priority' => 'high',
    'autosave' => true,


    // Fields
    'fields' => array(
 

        // Youtube
        array(
            // Field name - Will be used as label
            'name'  => esc_html__( 'Video: Youtube:', 'alinan-wp' ),
            // Field ID, i.e. the meta key
            'id'    => "{$prefix}youtube",
            // Field description (optional)
            'desc'  => esc_html__( 'Add Youtube code ex: LpRLb9Rf1do', 'alinan-wp' ),
            'type'  => 'text',
            // Default value (optional)
            'std'   => esc_html__( '', 'alinan-wp' ),
            // CLONES: Add to make the field cloneable (i.e. have multiple value)
            'clone' => false,
        ),
 

    // Vimeo
        // TEXT
        array(
            // Field name - Will be used as label
            'name'  => esc_html__( 'Video: Vimeo:', 'alinan-wp' ),
            // Field ID, i.e. the meta key
            'id'    => "{$prefix}vimeo",
            // Field description (optional)
            'desc'  => esc_html__( 'Add Vimeo code ex: 7449107', 'alinan-wp' ),
            'type'  => 'text',
            // Default value (optional)
            'std'   => esc_html__( '', 'alinan-wp' ),
            // CLONES: Add to make the field cloneable (i.e. have multiple value)
            'clone' => false,
        ),

    // Gallery
        // IMAGE UPLOAD
        array(
            'name' => esc_html__( 'Gallery:', 'alinan-wp' ),
            'id'   => "{$prefix}slider",
            // Field description (optional)
            'desc'  => esc_html__( 'Image with any size!', 'alinan-wp' ),            
            'type' => 'image_advanced',
        ),

    // Hide Featured Image
        // CheckBox
        array(
            'name' => esc_html__( 'Featured Image:', 'alinan-wp' ),
            'id'   => "{$prefix}hideimg",
            'desc'  => esc_html__( 'Hide Featured Image on single page for this article', 'alinan-wp' ),
            'type' => 'checkbox',
        ),


    ),

);



/**
 * Register meta boxes
 *
 * @return void
 */
function alinan_wp_register_meta_boxes()
{
    // Make sure there's no errors when the plugin is deactivated or during upgrade
    if ( !class_exists( 'RW_Meta_Box' ) )
        return;

    global $meta_boxes;
    foreach ( $meta_boxes as $meta_box )
    {
        new RW_Meta_Box( $meta_box );
    }
}
// Hook to 'admin_init' to make sure the meta box class is loaded before
// (in case using the meta box class in another plugin)
// This is also helpful for some conditionals like checking page template, categories, etc.
add_action( 'admin_init', 'alinan_wp_register_meta_boxes' );


?>