<?php
// ------------------------------------------------ 
// ---------- Options Framework Theme -------------
// ------------------------------------------------
 include( get_template_directory() . '/inc/Acid/acid.php' ); 


// ---------------------------------------------- 
// - Updates for Themes (Envato Market plugin.) -
// ---------------------------------------------- 
 include( get_template_directory() . '/inc/custom/github.php');


// ---------------------------------------------- 
// --------------- Load Custom Widgets ----------
// ----------------------------------------------
 include( get_template_directory() . '/inc/widgets.php');
 include( get_template_directory() . '/inc/widgets/widget-tags.php');
 include( get_template_directory() . '/inc/widgets/widget-posts.php');
 include( get_template_directory() . '/inc/widgets/widget-top-posts.php');
 include( get_template_directory() . '/inc/widgets/widget-cat.php');
 include( get_template_directory() . '/inc/widgets/widget-banner.php');
 include( get_template_directory() . '/inc/widgets/widget-social.php');
 include( get_template_directory() . '/inc/widgets/widget-posts-tags.php');
 include( get_template_directory() . '/inc/widgets/widget-feedburner.php');


// ----------------------------------------------
// --------------- Load Custom ------------------
// ---------------------------------------------- 
 include( get_template_directory() . '/inc/custom/comments.php');
  

// ----------------------------------------------
// ------ Content width -------------------------
// ----------------------------------------------
if ( ! isset( $content_width ) ) $content_width = 920;


// ----------------------------------------------
// ------ Theme set up --------------------------
// ----------------------------------------------
add_action( 'after_setup_theme', 'alinan_wp_theme_setup' );
if ( !function_exists('alinan_wp_theme_setup') ) {

    function alinan_wp_theme_setup() {
    
        // Register navigation menu
        register_nav_menus(
            array(
                'alinan-wp-primary-menu' => esc_html__( 'Header Navigation', 'alinan-wp' )
            )
        );
        
        // Localization support
        load_theme_textdomain( 'alinan-wp', get_template_directory() . '/languages' );
        
        // Feed Links
        add_theme_support( 'automatic-feed-links' );
        
        // Title Tag
        add_theme_support( 'title-tag' );

        // Post thumbnails
        add_theme_support( 'post-thumbnails' );
        add_image_size( 'alinan-wp-thumbnail-blog-articles', 385, 250, true ); // Blog Latest Articles
        add_image_size( 'alinan-wp-thumbnail-featured-slider', 385, 650, true ); // Blog Latest Articles
        add_image_size( 'alinan-wp-thumbnail-widget-small', 75, 75, true ); // Sidebar Widget thumbnails small
        add_image_size( 'alinan-wp-thumbnail-single-image', 920, '', true ); // Single thumbnails
        add_image_size( 'alinan-wp-thumbnail-single-gallery-image', 184, 184, true ); // Single thumbnails
    
    }
}


// ------------------------------------------------ 
// --- One Click Demo Import (Plugin) -------------
// ------------------------------------------------ 
function anthemes_wp_plugin_intro_text( $anthemes_wp_default_text ) {
    $anthemes_wp_default_text =  /* https://wordpress.org/plugins/one-click-demo-import/faq/ the inline style is added for the demo import plugin, that is displayed via Dashboard > Appearance. */ '<div class="ocdi__intro-text" style="width:355px;">'. esc_html__( 'Please click "Import Demo Data" button only once and wait, it can take a couple of minutes.', 'alinan-wp' ) .'</div>';?><br /><img style="width:400px; margin-bottom: 20px; border-radius: 4px;" src="<?php echo get_template_directory_uri(); ?>/screenshot.png" width="400" hieght="300" alt="img" /><br /> In the meantime, you check the <a href="https://anthemes.com/docs/alinan/" target="_blank">help file</a> or <a href="https://anthemes.com/support/" target="_blank">get support</a>.<?php
    return $anthemes_wp_default_text;
}
add_filter( 'pt-ocdi/plugin_intro_text', 'anthemes_wp_plugin_intro_text' );

function anthemes_wp_import_files() {
    return array(
        array(
            'import_file_name'             => esc_html__( 'Main Demo', 'alinan-wp' ),
            'local_import_file'            => trailingslashit( get_template_directory() ) . '/inc/demo/alinan-content.xml',
            'local_import_widget_file'     => trailingslashit( get_template_directory() ) . '/inc/demo/alinan-widgets.wie',
        ) 
    );
}
add_filter( 'pt-ocdi/import_files', 'anthemes_wp_import_files' );


// ----------------------------------------------
// ------------ JavaScrips Files ----------------
// ----------------------------------------------
if( !function_exists( 'alinan_wp_enqueue_scripts' ) ) {
    function alinan_wp_enqueue_scripts() {

        // Register css files
        wp_enqueue_style( 'alinan-wp-style', get_stylesheet_uri(), '', '1.9');
        wp_enqueue_style( 'alinan-wp-default', get_template_directory_uri() . '/css/colors/default.css', array( 'alinan-wp-style' ), '1.7' );
        wp_enqueue_style( 'alinan-wp-responsive', get_template_directory_uri() . '/css/responsive.css', array( 'alinan-wp-style' ), '1.7' );
        wp_enqueue_style( 'owl-carousel', get_template_directory_uri() . '/inc/owl-carousel/owl.carousel.css', array(), '2.0.0' );
        wp_enqueue_style( 'fontawesome', get_template_directory_uri() . '/css/fontawesome-free-5.6.3-web/css/all.min.css', array(), '5.6.3' );

        // Register scripts
        wp_enqueue_script( 'alinan-wp-customjs', get_template_directory_uri() . '/js/custom.js', array( 'jquery' ), '1.0', true );
        wp_enqueue_script( 'masonry' );
        wp_enqueue_script( 'jquery-sticky-kit',  get_template_directory_uri() . '/js/jquery.sticky-kit.js', array( 'jquery' ), '1.1.2', true );
        wp_enqueue_script( 'jquery-owl-carousel', get_template_directory_uri() . '/inc/owl-carousel/owl.carousel.min.js', array( 'jquery' ), '2.0', true );

        // Load Comments & .js files.
        if( is_single() ) {
            wp_enqueue_style( 'fancybox', get_template_directory_uri() . '/inc/fancybox/jquery.fancybox-1.3.4.css', array(), '1.34' );    
            wp_enqueue_script( 'jquery-fancybox', get_template_directory_uri() . '/inc/fancybox/jquery.fancybox-1.3.4.pack.js', array( 'jquery' ), '1.34', true );
            wp_enqueue_script( 'comment-reply' );
         }


// ----------------------------------------------
// ------- Register Fonts Google Fonts ----------
// ----------------------------------------------
        function alinan_wp_fonts_url() {
            $alinan_wp_font_url_google = '';
            
            /*
            Translators: If there are characters in your language that are not supported
            by chosen font(s), translate this to 'off'. Do not translate into your own language.
             */
            if ( 'off' !== _x( 'on', 'Google font: on or off', 'alinan-wp' ) ) {
                $alinan_wp_font_url_google = add_query_arg( 'family', urlencode( 'Droid+Sans:400,700|Oswald:400,700' ), "//fonts.googleapis.com/css" );
            }
            return $alinan_wp_font_url_google;
        }
        /* -- Enqueue styles -- */
        wp_enqueue_style( 'alinan_wp_fonts', alinan_wp_fonts_url(), array(), '1.0.0' );
  

    }
    add_action('wp_enqueue_scripts', 'alinan_wp_enqueue_scripts');
}


// ----------------------------------------------
// ---------- excerpt length adjust -------------
// ----------------------------------------------
function alinan_wp_excerpt($str, $length, $minword = 3) {
    $sub = '';
    $len = 0;
    foreach (explode(' ', $str) as $word) {
        $part = (($sub != '') ? ' ' : '') . $word;
        $sub .= $part;
        $len += strlen($part);
        if (strlen($word) > $minword && strlen($sub) >= $length) { break; }
    }
    return $sub . (($len < strlen($str)) ? ' ..' : '');
}


// ------------------------------------------------ 
// ------------ Notice ----------------------------
// ------------------------------------------------
function themes_admin_notice(){
    global $pagenow;
    if ( $pagenow == 'themes.php' ) {
         echo '<div class="notice notice-info is-dismissible" style="box-shadow: 0 1px 5px rgba(0,0,0,0.2); ">
             <p><a class="button" href="https://anthemes.com/" target="_blank">Anthemes.com</a> <a class="button activate" href="https://anthemes.com/wordpress-themes/" target="_blank">35+ WordPress Themes</a> <a class="button activate" href="https://anthemes.com/support/" target="_blank">Get Support</a> <a class="button activate" href="https://anthemes.com/docs/" target="_blank">Help file</a></p>
         </div>';
    }
}
add_action('admin_notices', 'themes_admin_notice');


// ------------------------------------------------ 
// ---------- TGM_Plugin_Activation -------------
// ------------------------------------------------ 
 include( get_template_directory() . '/inc/custom/class-tgm-plugin-activation.php');
 add_action( 'tgmpa_register', 'alinan_wp_register_required_plugins' );

function alinan_wp_register_required_plugins() {

    $plugins = array(
        array(
            'name'                  => esc_html__( 'Alinan Theme Core', 'alinan-wp' ), // The plugin name
            'slug'                  => 'alinan-options', // The plugin slug (typically the folder name)
            'source'                => get_template_directory() . '/plugins/alinan-options.zip', // The plugin source
            'required'              => false, // If false, the plugin is only 'recommended' instead of required
            'version'               => '1.1', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
            'force_activation'      => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
            'force_deactivation'    => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
            'external_url'          => '', // If set, overrides default API URL and points to an external URL
        ),

        array(
            'name'                  =>  esc_html__( 'Shortcodes', 'alinan-wp' ), // The plugin name
            'slug'                  => 'anthemes-shortcodes', // The plugin slug (typically the folder name)
            'source'                => get_template_directory() . '/plugins/anthemes-shortcodes.zip', // The plugin source
            'required'              => false, // If false, the plugin is only 'recommended' instead of required
            'version'               => '1.2', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
            'force_activation'      => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
            'force_deactivation'    => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
            'external_url'          => '', // If set, overrides default API URL and points to an external URL
            'is_callable'           => '', // If set, this callable will be be checked for availability to determine if a plugin is active.
       ),

        array(
            'name'                  => esc_html__( 'Daves WordPress Live Search', 'alinan-wp' ),
            'slug'                  => 'daves-wordpress-live-search',
            'required'              => false,
            'version'               => '',
        ),
 
        array(
            'name'                  => esc_html__( 'Meta Box', 'alinan-wp' ),
            'slug'                  => 'meta-box',
            'required'              => false,
            'version'               => '',
        ),

        array(
            'name'                  => esc_html__( 'Contact Form 7', 'alinan-wp' ),
            'slug'                  => 'contact-form-7',
            'required'              => false,
            'version'               => '',
        ),

        array(
            'name'                  => esc_html__( 'One Click Demo Import', 'alinan-wp' ),
            'slug'                  => 'one-click-demo-import',
            'required'              => false,
            'version'               => '',
        ),            

    );

    $config = array(
        'id'           => 'tgmpa',                 // Unique ID for hashing notices for multiple instances of TGMPA.
        'default_path' => '',                      // Default absolute path to bundled plugins.
        'menu'         => 'tgmpa-install-plugins', // Menu slug.
        'parent_slug'  => 'themes.php',            // Parent menu slug.
        'capability'   => 'edit_theme_options',    // Capability needed to view plugin install page, should be a capability associated with the parent menu used.
        'has_notices'  => true,                    // Show admin notices or not.
        'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
        'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
        'is_automatic' => false,                   // Automatically activate plugins after installation or not.
        'message'      => '',                      // Message to output right before the plugins table.

    );

    tgmpa( $plugins, $config );

}

?>