<?php
/**
 * 
 * 
 * @version 0.0.2
 * @author Bilal Hassan
 * @copyright (c) 2018, Bilal Hassan
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * tran: AcidOptions / Sortable
 * 
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class AcidConfig {
    
    const THEME_NAME = 'Acid';
    const THEME_SLUG = 'acid';
    static $url = null;
    
    
    public static function set_url( $url ) {
        self::$url = $url;
    }
    
    public static function get_url() {
        return self::$url . 'Acid/';
    }
    
    public static function assets_url() {
        return self::get_url() . 'assets/';
    }
    
}


include( get_template_directory() . '/inc/Acid/controls/RadioImage.php');
include( get_template_directory() . '/inc/Acid/controls/RadioToggle.php');
include( get_template_directory() . '/inc/Acid/controls/Range.php');
include( get_template_directory() . '/inc/Acid/controls/Toggle.php');
include( get_template_directory() . '/inc/Acid/controls/Sortable.php');
include( get_template_directory() . '/inc/Acid/controls/ColorSelect.php');
include( get_template_directory() . '/inc/Acid/controls/HtmlEditor.php');

include( get_template_directory() . '/inc/Acid/includes/AcidComponent.php');
include( get_template_directory() . '/inc/Acid/includes/AcidPanel.php');
include( get_template_directory() . '/inc/Acid/includes/AcidSection.php');
include( get_template_directory() . '/inc/Acid/includes/AcidOption.php');
include( get_template_directory() . '/inc/Acid/includes/AcidCustomizer.php');
include( get_template_directory() . '/inc/Acid/includes/functions-sanitization.php');
include( get_template_directory() . '/inc/Acid/includes/functions-option.php');
include( get_template_directory() . '/inc/Acid/includes/theme-options.php');

function acid_instance( $url ) {
    
    AcidConfig::set_url( $url ); 
    return new AcidCustomizer( AcidConfig::THEME_NAME, AcidConfig::THEME_SLUG );
    
}
