<?php

/**
* 
* $acid_location is where the Acid folder is located in your theme
* In this scenaario, the Acid folder is located in wp-contents/themes/alinan-wp/inc
* Tran: includes/AcidOptions.php controls/Sortable.php
* It is important to specify the location properly so that Acid knows the location of the assets it needs to look and function correctly
* 
*/

$acid_location = get_stylesheet_directory_uri() . '/inc/'; 
$acid = acid_instance( $acid_location );

/**
*
* Create your theme options as PHP arrays
* WordPress Customizer's structure allows you to create Options that are nested in Sections, which are in turn nested in Panels
* 
* Acid uses the same structure, allowing you to nest options easily, without needing to reference the section or panel ID
*
*/
$data = array (
    'panels' => array (
        'another-panel' => array (
            'title' => esc_html__( 'Theme Options', 'alinan-wp' ),
            'description' => esc_html__( 'WordPress Theme Customizer', 'alinan-wp' ),
            'sections' => array (



                //////////// Section
                //////////// General Settings
                'alinan_general_settings' => array (
                    'title' => esc_html__( 'General Settings', 'alinan-wp' ),
                    'description' => esc_html__( 'General Settings section', 'alinan-wp' ),
                    'options' => array (
                        
                        // Logo
                        'alinan_wp_logo'  => array(
                            'label'         => esc_html__( 'Custom Logo.', 'alinan-wp' ),
                            'description'   => esc_html__('Upload a custom logo image for your site here. Size for height should be 70px or 140px for a better display, for retina screens.', 'alinan-wp'),
                            'type'          => 'image',
                        ),

                        // Social icons
                        'alinan_wp_topicons_display' => array (
                            'label' => esc_html__('Display Social Icons?', 'alinan-wp'),
                            'type' => 'select',
                            'default' => 'option1',
                            'choices' => array (
                                'option1' => esc_html__( 'No', 'alinan-wp'),
                                'option2' => esc_html__( 'Yes', 'alinan-wp'), 
                            ),
                        ),

                        // Social icons
                        'alinan_wp_top_icons' => array(
                            'label'         => esc_html__( 'Social Icons.', 'alinan-wp' ),
                            'description'   => "". esc_html__('You can use HTML code. For more social icons go to', 'alinan-wp') ." <a href=\"http://fontawesome.io/icons/\" target=\"_blank\">Font Awesome</a> ". esc_html__('and at the bottom you have Brand Icons! Change # with your link.', 'alinan-wp') ."",
                            'type'          => 'textarea',
                            'default'       => "<li><a href=\"#\"><i class=\"fab fa-facebook-f\"></i></a></li>
<li><a href=\"#\"><i class=\"fab fa-twitter\"></i></a></li>
<li><a href=\"#\"><i class=\"fab fa-pinterest\"></i></a></li>
<li><a href=\"#\"><i class=\"fab fa-instagram\"></i></a></li>
<li><a href=\"#\"><i class=\"fab fa-vimeo-v\"></i></a></li>
<li><a href=\"#\"><i class=\"fab fa-youtube\"></i></a></li>
",
                        ),                       

                    ), // Options
                ), // General Settings
 


                //////////// Section
                //////////// Header Settings
                'alinan_header_settings' => array (
                    'title' => esc_html__( 'Header Settings', 'alinan-wp' ),
                    'description' => esc_html__( 'Header Settings section', 'alinan-wp' ),
                    'options' => array (

                        // Top Articles
                        'alinan_wp_display_featured_slider' => array (
                            'label' => esc_html__('Carousel: Display Top viewed Posts?', 'alinan-wp'),
                            'type' => 'select',
                            'default' => 'option1',
                            'choices' => array (
                                'option1' => esc_html__( 'No', 'alinan-wp'),
                                'option2' => esc_html__( 'Yes', 'alinan-wp'), 
                            ),
                        ), 

                        // Featured Img section
                        'alinan_wp_display_fbig_section' => array (
                            'label' => esc_html__('Display Featured Big Image?', 'alinan-wp'),
                            'type' => 'select',
                            'default' => 'option1',
                            'choices' => array (
                                'option1' => esc_html__( 'No', 'alinan-wp'),
                                'option2' => esc_html__( 'Yes', 'alinan-wp'), 
                            ),
                        ),
                        
                        // Featured Img
                        'alinan_wp_fbig_img'  => array(
                            'label'         => esc_html__( 'Featured Big Image.', 'alinan-wp' ),
                            'description'   => esc_html__('Upload a custom image for your site here. The image can have any size.', 'alinan-wp'),
                            'type'          => 'image',
                        ),

                        // Youtube Code
                        'alinan_wp_fbig_youtube' => array(
                            'label'         => esc_html__( 'Featured Youtube Video', 'alinan-wp' ),
                            'description'   => esc_html__( 'Add Youtube code, ex: 2zYHnlfgew8', 'alinan-wp' ),
                            'type'          => 'text',
                            'default'       => '',
                        ), 

                        // Button Title
                        'alinan_wp_fbig_title' => array(
                            'label'         => esc_html__( 'Button text', 'alinan-wp' ),
                            'description'   => esc_html__( 'Add a text for your button, ex: Featured Video.', 'alinan-wp' ),
                            'type'          => 'text',
                            'default'       => '',
                        ), 

                        // Button Link
                        'alinan_wp_fbig_link' => array(
                            'label'         => esc_html__( 'Button Link', 'alinan-wp' ),
                            'description'   => esc_html__( 'Add a link to your button.', 'alinan-wp' ),
                            'type'          => 'text',
                            'default'       => '',
                        ),                                               

                    ), // Options
                ), // Header Settings


                //////////// Section
                //////////// Blog Settings
                'alinan_blog_settings' => array (
                    'title' => esc_html__( 'Blog Settings', 'alinan-wp' ),
                    'description' => esc_html__( 'Blog Settings section', 'alinan-wp' ),
                    'options' => array (

                        // Posts
                        'alinan_wp_posts_cols' => array (
                            'label' => esc_html__('Display Posts in 3 or 4 columns', 'alinan-wp'),
                            'type' => 'select',
                            'default' => 'option1',
                            'choices' => array (
                                'option1' => esc_html__( '4 columns', 'alinan-wp'),
                                'option2' => esc_html__( '3 columns', 'alinan-wp'), 
                            ),
                        ), 
                        
                        // About Me
                        'alinan_wp_display_about_me' => array (
                            'label' => esc_html__('Display Subheader About Me?', 'alinan-wp'),
                            'type' => 'select',
                            'default' => 'option1',
                            'choices' => array (
                                'option1' => esc_html__( 'No', 'alinan-wp'),
                                'option2' => esc_html__( 'Yes', 'alinan-wp'), 
                            ),
                        ), 

                        // Avatar
                        'alinan_wp_about_img'  => array(
                            'label'         => esc_html__( 'Custom Image.', 'alinan-wp' ),
                            'description'   => esc_html__('Upload a custom image for your site here. Recommended size should be 90x90 or 180x180 for a better display, for retina screens.', 'alinan-wp'),
                            'type'          => 'image',
                        ),

                        // About
                        'alinan_wp_about_me' => array(
                            'label'         => esc_html__( 'Small description about you', 'alinan-wp' ),
                            'type'          => 'textarea',
                            'default'       => "I'm Alina N. Jones, living in Monaco. <span>Love to travel</span> & also have a huge <span>interest in fashion</span>, photography and food!",
                        ),

                        // Blog Homepage Title
                        'alinan_wp_about_link' => array(
                            'label'         => esc_html__( 'About me link page', 'alinan-wp' ),
                            'description'   => esc_html__( 'Add a link to your custom image, for example: About Me.', 'alinan-wp' ),
                            'type'          => 'text',
                            'default'       => esc_url( 'http://yoursite.com/about-me/' ),
                        ),                        

                    ), // Options
                ), // General Settings


                //////////// Section
                //////////// Style Settings
                'alinan_style_settings' => array (
                    'title' => esc_html__( 'Style Settings', 'alinan-wp' ),
                    'description' => esc_html__( 'Style Settings section', 'alinan-wp' ),
                    'options' => array (
                        
                        'alinan_wp_main_color1' => array(
                            'label'         => esc_html__( 'Main Color (yellow)', 'alinan-wp' ),
                            'description'   => esc_html__( 'Use the color picker to change the main color of the site to match your brand color.', 'alinan-wp' ),
                            'type'          => 'color',
                            'default'       => '#ffda23'
                        ), 

                        'alinan_wp_main_color2' => array(
                            'label'         => esc_html__( 'Main Color (black)', 'alinan-wp' ),
                            'description'   => esc_html__( 'Use the color picker to change the main color of the site to match your brand color.', 'alinan-wp' ),
                            'type'          => 'color',
                            'default'       => '#000000'
                        ), 

                        'alinan_wp_entry_linkcolor' => array(
                            'label'         => esc_html__( 'Entry Link Color', 'alinan-wp' ),
                            'description'   => esc_html__( 'Use the color picker to change the entry link color on article or default / full width pages.', 'alinan-wp' ),
                            'type'          => 'color',
                            'default'       => '#000000'
                        ), 
                     
                    ), // Options
                ), // Style Settings



                //////////// Section
                //////////// Footer Settings
                'alinan_footer_settings' => array (
                    'title' => esc_html__( 'Footer Settings', 'alinan-wp' ),
                    'description' => esc_html__( 'Footer Settings section', 'alinan-wp' ),
                    'options' => array (

                        // Random Articles
                        'alinan_wp_display_random_slider' => array (
                            'label' => esc_html__('Carousel: Display Random Posts?', 'alinan-wp'),
                            'type' => 'select',
                            'default' => 'option1',
                            'choices' => array (
                                'option1' => esc_html__( 'No', 'alinan-wp'),
                                'option2' => esc_html__( 'Yes', 'alinan-wp'), 
                            ),
                        ), 

                        // Widgets
                        'alinan_wp_footer_display_widgets' => array (
                            'label' => esc_html__('Display Widgets?', 'alinan-wp'),
                            'type' => 'select',
                            'default' => 'option1',
                            'choices' => array (
                                'option1' => esc_html__( 'No', 'alinan-wp'),
                                'option2' => esc_html__( 'Yes', 'alinan-wp'), 
                            ),
                        ), 

                        // Footer Content
                        'alinan_wp_footer_display_content' => array (
                            'label'       => esc_html__('Display: Footer Content?', 'alinan-wp'),
                            'type'        => 'select',
                            'default' => 'option1',
                            'choices' => array (
                                'option1' => esc_html__( 'No', 'alinan-wp'),
                                'option2' => esc_html__( 'Yes', 'alinan-wp'), 
                            ),
                        ),

                        // Footer Content
                        'alinan_wp_footer_content' => array(
                            'label'         => esc_html__( 'Footer Content', 'alinan-wp' ),
                            'description'   => esc_html__( 'Change # with your contact page link', 'alinan-wp' ),
                            'type'          => 'textarea',
                            'default'       => "<h3>Business enquiries?</h3>
<h2><span>I'm ready! <span><a href=\"#\">Let's Chat.</a></span></span></h2>",
                        ),


                        // Copyright Left
                        'alinan_wp_copyright' => array(
                            'label'         => esc_html__( 'Copyright Left', 'alinan-wp' ),
                            'type'          => 'textarea',
                            'default'       => "2019 &copy; Alinan, Inc. Theme by <a href=\"https://anthemes.com/\" target=\"_blank\">Anthemes.com</a>",
                        ),

                         
                    ), // Options
                ), // Footer Settings



            ),
        ),
    ),
);

$acid->config( $data );







/**
 * Output styles in the header
 */
function alinan_wp_inline_styles() {


$output = '';

    // Main Color (yellow)
    $alinan_wp_main_color1 = get_theme_mod('alinan_wp_main_color1');
    if (!empty($alinan_wp_main_color1)) {    
        // BG Color
         $output .= "#newsletter-form input.newsletter-btn, footer .widget h3.title span, ul.random-slider li .article-category a, .featured-video .artbtn-category, .owl-prev, .owl-next, ul.featured-slider li .article-category a, ul.ant-responsive-menu li.current_page_item a, ul.ant-responsive-menu li.current-menu-ancestor a, ul.ant-responsive-menu li.current-menu-item a, ul.ant-responsive-menu li.current-menu-parent a, ul.modern-articles li .artbtn-category, .wp-pagenavi a:hover, .wp-pagenavi span.current, .defaultpag a, h3.index-title span, .single-category a, .page-title-line, .entry p a:hover, .my-paginated-posts span, div.p-first-letter p:first-child:first-letter, .ct-size a:hover, ul.comment li span.comment-reply-button, #commentform, #anthemes-404 h2, #back-top span { background-color: $alinan_wp_main_color1 !important; }";
        // Color
         $output .= "ul.random-slider li div.alinan-date i, ul.featured-slider li div.alinan-date i, ul.top-social li.search, .top-social li a:hover, .ant-responsive-menu li i, ul.modern-articles li i.fa-bookmark, ul.article_list .an-widget-title span.comm i, div.tagcloud span, div.footer-content a { color: $alinan_wp_main_color1 !important; }";
        // Border color
         $output .= ".about-home img, .about-home h1 span, .entry p a, div.footer-content a { border-color: $alinan_wp_main_color1 !important;}";  
    }
    
    // Main Color (black)
    $alinan_wp_main_color2 = get_theme_mod('alinan_wp_main_color2');
    if (!empty($alinan_wp_main_color2)) {
        // BG Color
        $output .= "ul.random-slider, #random-slider-wrap, .wrap-border-bottom, ul.featured-slider, #featured-slider-wrap, .logo, .ant-responsive-menu, #searchform2 .buttonicon, #searchform2 #s, .md-content, button, .top-social, footer  { background-color: $alinan_wp_main_color2 !important; }";
        // Border color
        $output .= "ul.featured-slider, ul.random-slider, header, .border-fullwidth { border-color: $alinan_wp_main_color2 !important; }";
        // BG Color
        $output .= "@media only screen and (max-width: 1329px) { .main-menu, #respMenu li ul.sub-menu li.current_page_item a, #respMenu li ul.sub-menu li.current-menu-ancestor a, #respMenu li ul.sub-menu li.current-menu-item a, #respMenu li ul.sub-menu li.current-menu-parent a, #respMenu li ul.sub-menu, #respMenu li ul.sub-menu a, #respMenu li ul.sub-menu li  { background-color: $alinan_wp_main_color2 !important; } }";
    }

    // Entry Link Color
    $alinan_wp_entry_linkcolor = get_theme_mod('alinan_wp_entry_linkcolor');
    if (!empty($alinan_wp_entry_linkcolor)) {
        $output .= ".entry p a { color: $alinan_wp_entry_linkcolor !important; }";
    }

    // Featured Big Image
    $alinan_wp_fbig_img = get_theme_mod('alinan_wp_fbig_img');
    if (!empty($alinan_wp_fbig_img)) {
        $output .= ".wrap-featured { background-image: url($alinan_wp_fbig_img); }";
    }

    // Columns
    $alinan_wp_posts_cols = get_theme_mod('alinan_wp_posts_cols');
    if ( 'option2' == get_theme_mod( 'alinan_wp_posts_cols' ) ) { 
        $output .= ".home-content { width: 1260px; }";
    }    

    // Output styles
    if ($output <> '') {
        $output = "<!-- Custom Styling --><style type=\"text/css\">" . $output . "</style>";
        echo stripslashes_deep($output);
    }
}
add_action( 'wp_head', 'alinan_wp_inline_styles', 100 );

?>