<?php
// ------------------------------------------------------
// ------ Subscribe widget  -----------------------------
// ------ Feedburner subscribe --------------------------
// ------ by AnThemes.net -------------------------------
//        http://themeforest.net/user/An-Themes/portfolio
//        http://themeforest.net/user/An-Themes/follow 
// ------------------------------------------------------

class alinan_wp_subscribe extends WP_Widget {
     function __construct() {
       wp_enqueue_media();
       wp_enqueue_script('alinan_wp_our_adminjs', get_template_directory_uri() . '/js/our_admin.js', array('jquery'));

	    $widget_ops = array('description' => esc_html__('Feedburner subscribe widget.', 'alinan-wp'));
        parent::__construct(false, $name = ''. esc_html__('Custom: Feedburner Subscribe', 'alinan-wp') .'',$widget_ops); 
    }

   function widget($args, $instance) {  
		extract( $args );
    $title = $instance['title'];
    $feedid = $instance['feedid'];
    $text = $instance['text'];
    $userimage1 = ! empty( $instance['userimage1'] ) ? $instance['userimage1'] : '';
?>		
 
<?php echo wp_kses_post($before_widget); ?>
<?php if ( $title ) echo wp_kses_post($before_title) . esc_attr($title) . wp_kses_post($after_title); ?>
    
    <div class="feed-info">
      <?php if($userimage1) { ?>
      <div class="img-zoom-in"><img class="userimage" src="<?php echo esc_url($userimage1); ?>" width="75" height="75" alt="<?php esc_attr( 'User image', 'alinan-wp' ); ?>"></div>
      <?php } ?>
      <?php echo stripslashes_deep($text); ?>
      <img class="iconfeed" src="<?php echo get_template_directory_uri(); ?>/images/paper-plane.png" alt="<?php esc_attr( 'Subscribe', 'alinan-wp' ); ?>" />
    </div>

    <form action="//feedburner.google.com/fb/a/mailverify" method="get" target="popupwindow" onsubmit="window.open('<?php echo esc_attr($feedid); ?>', 'popupwindow', 'scrollbars=yes,width=600,height=560');return true" id="newsletter-form">
      <input name="email" class="newsletter" placeholder="<?php esc_attr_e('Enter your e-mail address', 'alinan-wp'); ?>" type="text">
      <input type="hidden" value="<?php echo esc_attr($feedid); ?>" name="uri"/>
      <input class="newsletter-btn" value="<?php esc_attr_e('Subscribe', 'alinan-wp'); ?>" type="submit">
    </form>


<?php echo wp_kses_post($after_widget); ?>
  
<?php
    }

     function update($new_instance, $old_instance) {				
			$instance = $old_instance;
      $instance['title'] = strip_tags($new_instance['title']);
			$instance['feedid'] = strip_tags($new_instance['feedid']);
      $instance['text'] = stripslashes($new_instance['text']);
      $instance['userimage1'] = ( ! empty( $new_instance['userimage1'] ) ) ? $new_instance['userimage1'] : '';
     return $instance;
    }

 	function form( $instance ) {
  $userimage1 = ! empty( $instance['userimage1'] ) ? $instance['userimage1'] : '';
  // Set up some default widget settings
  $defaults = array(
    'title' => 'Feedburner',
    'text' => stripslashes('I bring you all you need to know about <strong>everything that matters</strong>! I cover everything.'),
  );

  $instance = wp_parse_args( (array) $instance, $defaults ); ?>

        <p>
          <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e( 'Widget Title:', 'alinan-wp' ); ?></label> 
          <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php if( isset($instance['title']) ) echo esc_attr($instance['title']); ?>" />
        </p>

        <p>
          <label for="<?php echo esc_attr($this->get_field_id( 'userimage1' )); ?>"><?php esc_html_e( 'user Image:', 'alinan-wp' ); ?></label>
          <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'userimage1' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'userimage1' )); ?>" type="text" value="<?php echo esc_url( $userimage1 ); ?>" />
          <button class="upload_image_button button button-primary"><?php esc_html_e( 'Upload Image', 'alinan-wp' ); ?></button>
          <p><?php esc_html_e( 'Recommended size 90x90', 'alinan-wp' ); ?></p>
        </p>

        <p>
          <label for="<?php echo esc_attr($this->get_field_id('feedid')); ?>"><?php esc_html_e( 'Feedburner ID:', 'alinan-wp' ); ?></label> 
          <input class="widefat" id="<?php echo esc_attr($this->get_field_id('feedid')); ?>" name="<?php echo esc_attr($this->get_field_name('feedid')); ?>" type="text" value="<?php if( isset($instance['feedid']) ) echo esc_attr($instance['feedid']); ?>" />
        </p>

        <p>
          <label for="<?php echo esc_attr($this->get_field_id('text')); ?>"><?php esc_html_e( 'Description:', 'alinan-wp' ); ?></label>      
          <textarea style="height:100px;" class="widefat" id="<?php echo esc_attr($this->get_field_id('text')); ?>" name="<?php echo esc_attr($this->get_field_name('text')); ?>" ><?php if( isset($instance['text']) ) echo stripslashes($instance['text']); ?></textarea>
        </p> 

<?php  } }

// register widget
function alinan_wp_subscribe_init_widget () {
    return register_widget('alinan_wp_subscribe');
  }
add_action ('widgets_init', 'alinan_wp_subscribe_init_widget');
?>