<?php get_header(); // add header ?>  
<?php
    // Display Big Letter (Yes/No)
    $alinan_wp_display_bigletter = get_theme_mod('alinan_wp_display_bigletter');
    if (empty($alinan_wp_display_bigletter)) { $alinan_wp_display_bigletter = 'No'; }   

    // Date Format
    $alinan_wp_date_format = get_theme_mod('alinan_wp_date_format');
    if (empty($alinan_wp_date_format)) { $alinan_wp_date_format = '23 June 17'; }
?>

 
<!-- Begin Content -->
<div class="border-fullwidth">
<div class="wrap-fullwidth">

    <div class="single-content">
        <?php if (have_posts()) : while (have_posts()) : the_post();  ?>
        <div class="entry-top">
            <div class="single-category"> 
                <?php the_category(' '); ?>
            </div><!-- end .single-category -->
            <div class="clear"></div>  
            <h1 class="article-title entry-title"><?php the_title(); ?></h1>
            <div class="clear"></div>
                <!-- Post Data  -->
                <div class="post-data">
                    <?php if ( function_exists( 'alinan_wp_small_social_share_single' ) ) { ?>
                        <div class="time-article">
                            <?php echo get_the_date(); ?>
                        </div><i class="fa fa-times timearticle"></i>
                        <div class="post-share">
                            <?php alinan_wp_small_social_share_single(); ?>
                        </div><!-- end .post-share -->
                    <?php } else { ?>
                        <div class="time-article">
                            <?php echo get_the_date(); ?>
                        </div>
                    <?php } ?>
                <div class="clear"></div>
                </div><!-- end .post-data -->            
        </div><div class="clear"></div>
        <?php endwhile; endif; ?>


        <article>
            <?php if (have_posts()) : while (have_posts()) : the_post();  ?>
            <?php if ( function_exists( 'getPostViews_alinan_wp' ) ) { setPostViews_alinan_wp(get_the_ID()); } ?>
            <div <?php post_class('post') ?> id="post-<?php the_ID(); ?>">

            <div class="media-single-content">
            <?php if ( function_exists( 'rwmb_meta' ) ) {  
            // If Meta Box plugin is activate ?>
                <?php
                $alinan_wp_youtubecode = rwmb_meta('alinan_wp_youtube', true );
                $alinan_wp_vimeocode = rwmb_meta('alinan_wp_vimeo', true );
                $alinan_wp_image = rwmb_meta('alinan_wp_slider', true );
                $alinan_wp_hideimg = rwmb_meta('alinan_wp_hideimg', true );
                ?> 

                <?php if(!empty($alinan_wp_image)) { ?>
                    <!-- #### Single Gallery #### -->
                    <div class="single-gallery">
                        <?php
                        $images = rwmb_meta( 'alinan_wp_slider', 'type=image&size=alinan-wp-thumbnail-single-gallery-image' );
                        foreach($images as $key =>$alinan_wp_image)
                         { echo wp_kses_post("<a href='{$alinan_wp_image['full_url']}' rel='mygallery'><img src='{$alinan_wp_image['url']}'  alt='{$alinan_wp_image['alt']}'  /></a>");
                        } ?>
                    </div><!-- end .single-gallery -->
                    <div class="clear"></div> 
                <?php } ?>

                <?php if(!empty($alinan_wp_youtubecode)) { ?>
                    <!-- Youtube video -->
                    <?php $alinan_wp_youtubeembed = '//www.youtube.com/embed/'; ?>
                    <iframe class="single_iframe" width="100%" height="450" src="<?php echo esc_url($alinan_wp_youtubeembed); ?><?php echo esc_html($alinan_wp_youtubecode); ?>?wmode=transparent" frameborder="0" allowfullscreen></iframe>
                <?php } ?>

                <?php if(!empty($alinan_wp_vimeocode)) { ?>
                    <!-- Vimeo video -->
                    <?php $alinan_wp_vimeoembed = '//player.vimeo.com/video/'; ?>
                    <iframe class="single_iframe" width="100%" height="450" src="<?php echo esc_url($alinan_wp_vimeoembed); ?><?php echo esc_html($alinan_wp_vimeocode); ?>?portrait=0" frameborder="0" allowFullScreen></iframe>
                <?php } ?>

                <?php if(!empty($alinan_wp_image) || !empty($alinan_wp_youtubecode) || !empty($alinan_wp_vimeocode)) { ?>
                <?php } elseif ( has_post_thumbnail()) { ?>
                    <?php if(!empty($alinan_wp_hideimg)) { } else { ?>
                     <?php the_post_thumbnail('alinan-wp-thumbnail-single-image'); ?>
                    <?php } // disable featured image ?>
                <?php } ?>
 
            <?php } else { 
            // Meta Box Plugin ?>
                <?php the_post_thumbnail('alinan-wp-thumbnail-single-image'); ?>
            <?php } ?> 
            </div><!-- end .media-single-content -->

 
            <div id="single-share">
            <?php if ( function_exists( 'alinan_wp_big_social_share' ) ) { 
                echo esc_attr(alinan_wp_big_social_share()); ?> 
                <div class="views-nr"><span><?php echo esc_attr(getPostViews_alinan_wp(get_the_ID())); ?></span><br /> <?php esc_html_e('Views', 'alinan-wp'); ?></div>
                <div class="comm-line"></div>
                <a href="#comments" class="commbutton"><i class="fas fa-comment-alt"></i></a>
            <?php } ?>
            </div><!-- end #single-share -->
            <div class="clear"></div>

                <div class="entry">
                    <div class="p-first-letter">
                        <!-- excerpt -->
                        <?php if ( !empty( $post->post_excerpt ) ) { ?> 
                            <?php echo the_excerpt(); ?>
                        <?php } ?>                             
                        <?php the_content(''); // content ?>
                        <div class="clear"></div>
                    </div><!-- end .p-first-letter -->
                    <?php wp_link_pages(); // content pagination ?>
                    <div class="clear"></div>

                    <!-- Related Articles -->
                    <ul class="article_list">
                        <?php $alinan_wp_related = get_posts( array( 'category__in' => wp_get_post_categories($post->ID), 'ignore_sticky_posts' => 1, 'numberposts' => esc_attr(3), 'post__not_in' => array($post->ID) ) );
                        if( $alinan_wp_related ) foreach( $alinan_wp_related as $post ) { setup_postdata($post); ?>    

                          <li class="img-zoom-in">
                              <a href="<?php the_permalink(); ?>"> <?php echo the_post_thumbnail('alinan-wp-thumbnail-widget-small'); ?></a>
                              <div class="an-widget-title" <?php if ( has_post_thumbnail()) { ?> style="margin-left:60px;" <?php } ?>>
                                <a href="<?php the_permalink(); ?>"><h4 class="article-title"><?php the_title(); ?></h4></a>              
                                <span class="time"><?php echo get_the_date(); ?></span>
                                <?php if (get_comments_number()==0) { } else { ?><span class="comm"><i class="fas fa-comment-dots"></i> <?php comments_popup_link('0', '1', '%'); ?></span><?php } ?>
                              </div>
                          </li>

                        <?php } wp_reset_postdata();  ?>          
                    </ul><!-- end .modern-grid -->


                    <div class="tags-cats"> 
                        <!-- tags -->
                        <?php $paintable_wp_single_tags = get_the_tags(); 
                        if ($paintable_wp_single_tags): ?>
                            <div class="ct-size"><?php the_tags('', ''); // tags ?></div><div class="clear"></div>
                        <?php endif; ?>                                              
                    </div><!-- end .tags-cats -->


                </div><!-- end .entry -->
                <div class="clear"></div> 

            </div><!-- end #post -->
            <?php endwhile; endif; ?>
        </article><!-- end article -->
   

        <!-- Comments -->
        <section class="article-bottom">
            <div id="comments" class="comments">
                <?php if ( ! post_password_required() ) { ?>    
                    <?php if (get_comments_number()==0) { } else { ?>
                        <div class="article-btn"><h3><?php esc_html_e( 'All Comments', 'alinan-wp' ); ?></h3></div>
                    <?php } ?>
                <?php } ?> 
                <div class="clear"></div>
                <?php comments_template('', true); // comments ?>
            </div>
            <div class="clear"></div>
        </section>
    </div><!-- end .single-content -->


    <!-- Begin Sidebar (right) -->
    <?php  get_sidebar(); // add sidebar ?>
    <!-- end #sidebar  (right) -->    


    <div class="clear"></div>
</div><!-- end .wrap-fullwidth  -->
</div><!-- end .border-fullwidth  -->
<?php get_footer(); // add footer  ?>