<?php 
/* 
Template Name: Template - Home
*/ 
?>
<?php get_header(); // add header  ?>

<?php if ( 'option2' == get_theme_mod( 'alinan_wp_display_featured_slider' ) ) {  ?>
<!-- Begin Featured Articles -->
<div id="featured-slider-wrap">
<ul class="featured-slider">
    <?php $alinan_wp_top_views_slider = new WP_Query( array( 'post_type' => 'post', 'meta_key' => 'post_views_count_alinan_wp', 'ignore_sticky_posts' => esc_attr(1), 'orderby' => 'meta_value_num', 'order' => 'DESC', 'posts_per_page' => esc_attr(8) ) );  ?> 
    <?php while ($alinan_wp_top_views_slider->have_posts()) : $alinan_wp_top_views_slider->the_post(); ?> 

        <li class="img-zoom-in">
                    <?php if ( has_post_thumbnail()) { ?>
                        <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail('alinan-wp-thumbnail-featured-slider', array('title' => "")); ?></a>
                    <?php } else { ?>             
                        <a href="<?php the_permalink(); ?>"> <img src="<?php echo get_template_directory_uri(); ?>/images/no-photo-321.png" alt="<?php esc_attr( 'Article image', 'alinan-wp' ); ?>" /></a>
                    <?php } ?>

                        <div class="inner-small">
                            <div class="inner-cell">
                                <!-- Category --><div class="article-category"><?php $alian_wp_category = get_the_category(); if ($alian_wp_category) { echo wp_kses_post('<a href="' . get_category_link( $alian_wp_category[0]->term_id ) . '">' . $alian_wp_category[0]->name.'</a> ');}  ?></div><!-- end .article-category -->                           
                                <!-- Title --><a href="<?php the_permalink(); ?>"><h2><?php the_title(); ?></h2></a> <div class="clear"></div>
                                <!-- Date --><div class="alinan-date"><i class="fas fa-clock"></i> <?php echo get_the_date(); ?></div><div class="clear"></div>
                            </div><!-- end .inner-cell --> 
                        </div><!-- end .inner-small -->
        </li><!-- end .item -->

    <?php endwhile; 
    /* Restore original Post Data */
    wp_reset_postdata(); ?>
</ul><!-- end #featured-slider -->
</div><!-- end #featured-slider-wrap -->
<div class="wrap-border-bottom"></div>
<div class="clear"></div>
<?php } ?>


<?php if ( 'option2' == get_theme_mod( 'alinan_wp_display_fbig_section' ) ) {  ?>
<div class="wrap-featured"> 
    <div class="featured-video">
        <?php $alinan_wp_fbig_embed = '//www.youtube.com/embed/'; ?>
        <iframe src="<?php echo esc_url($alinan_wp_fbig_embed); ?><?php echo esc_html(get_theme_mod('alinan_wp_fbig_youtube')); ?>?wmode=transparent&amp;showinfo=0" allowfullscreen></iframe>
        <div class="artbtn-category"><a href="<?php echo esc_url(get_theme_mod( 'alinan_wp_fbig_link' )); ?>"><?php echo esc_attr(get_theme_mod('alinan_wp_fbig_title')); ?></a></div> 
    </div><!-- end .featured-video -->
</div><!-- end .wrap-featured -->
<div class="warp-border"></div> 
<div class="wrap-border-bottom"></div>
<div class="clear"></div>
<?php } ?>


<!-- Begin home fullwidth -->
<div class="border-fullwidth">
    <div class="home-content">

    <?php if ( 'option2' == get_theme_mod( 'alinan_wp_display_about_me' ) ) {  ?>
    <div class="about-home">
        <a href="<?php echo esc_url(get_theme_mod( 'alinan_wp_about_link' )); ?>"><img src="<?php echo esc_url(get_theme_mod( 'alinan_wp_about_img' )); ?>" alt="<?php esc_attr('About me', 'alinan-wp'); ?>" width="90" height="90"></a>
        <h1><?php echo wp_kses_post(stripslashes(get_theme_mod( 'alinan_wp_about_me' ))); ?> </h1>
        <div class="clear"></div>
    </div>
    <?php } ?>


    <ul class="modern-articles js-masonry">
        <?php
            if ( get_query_var('paged') )  {  $paged = get_query_var('paged'); } elseif ( get_query_var('page') ) { $paged = get_query_var('page'); } else { $paged = 1;  }
            // The Query
            query_posts( array( 'post_type' => 'post', 'paged' => $paged ) );
            if (have_posts()) : while (have_posts()) : the_post();
        ?>

        <li <?php post_class('ms-item') ?> id="post-<?php the_ID(); ?>">

            <?php if ( function_exists( 'rwmb_meta' ) ) {  
            // If Meta Box plugin is activate 
                $alinan_wp_youtubecode = rwmb_meta('alinan_wp_youtube', true );
                $alinan_wp_vimeocode = rwmb_meta('alinan_wp_vimeo', true ); 
                ?> 

                <?php if(!empty($alinan_wp_youtubecode)) { ?>
                    <!-- Youtube video -->
                    <?php $alinan_wp_youtubeembed = '//www.youtube.com/embed/'; ?>
                    <iframe src="<?php echo esc_url($alinan_wp_youtubeembed); ?><?php echo esc_html($alinan_wp_youtubecode); ?>?wmode=transparent&amp;showinfo=0" allowfullscreen></iframe>
                <?php } ?>

                <?php if(!empty($alinan_wp_vimeocode)) { ?>
                    <!-- Vimeo video -->
                    <?php $alinan_wp_vimeoembed = '//player.vimeo.com/video/'; ?>
                    <iframe src="<?php echo esc_url($alinan_wp_vimeoembed); ?><?php echo esc_html($alinan_wp_vimeocode); ?>?title=0&amp;byline=0&amp;portrait=0" allowFullScreen></iframe>
                <?php } ?>                

                <?php if(!empty($alinan_wp_youtubecode) || !empty($alinan_wp_vimeocode)) { ?>
                <?php } elseif ( has_post_thumbnail()) { ?>
                        <?php if (is_sticky()) { ?> <i class="fas fa-bookmark"></i> <?php } ?>             
                        <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail('alinan-wp-thumbnail-blog-articles', array('title' => "")); ?></a>
                    <?php } else { ?> 
                        <div class="noimg"><a href="<?php the_permalink(); ?>"><?php esc_html_e( 'Read More', 'alinan-wp' ); ?></a></div>
                <?php } ?>

            <?php } else { ?> 
                    <?php if ( has_post_thumbnail()) { ?>
                        <?php if (is_sticky()) { ?> <i class="fas fa-bookmark"></i> <?php } ?>
                        <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail('alinan-wp-thumbnail-blog-articles', array('title' => "")); ?></a>
                    <?php } else { ?> 
                        <div class="noimg"><a href="<?php the_permalink(); ?>"><?php esc_html_e( 'Read More', 'alinan-wp' ); ?></a></div>                          
                    <?php } ?><div class="clear"></div> 
            <?php } // Custom Fields ?> 

            <div class="artbtn-category"><?php $alinan_wp_category = get_the_category(); if ($alinan_wp_category) 
                { echo wp_kses_post('<a href="' . get_category_link( $alinan_wp_category[0]->term_id ) . '">' . $alinan_wp_category[0]->name.'</a> ');}  ?>
            </div><!-- end .artbtn-category -->

            <div class="ma-wrap">
                <div class="ma-left">
                    <div class="home-share">
                        <?php if ( function_exists( 'alinan_wp_home_social_share' ) ) { 
                            echo esc_attr(alinan_wp_home_social_share()); ?>
                            <div class="views-nr"><span><?php echo esc_attr(getPostViews_alinan_wp(get_the_ID())); ?></span><br /> <?php esc_html_e('Views', 'alinan-wp'); ?></div>
                        <?php } ?>
                    </div><!-- end #home-share -->
                </div><!-- end .ma-left -->

                <div class="ma-right">
                    <a href="<?php the_permalink(); ?>"><h2><?php the_title(); ?> </h2></a>
                    <p><?php echo wp_kses_post(alinan_wp_excerpt(strip_tags(strip_shortcodes(get_the_excerpt())), 120)); ?></p>
                </div><!-- .ma-right -->    
            </div><!-- end .ma-wrap -->

        </li><!-- end .post-class -->

        <?php endwhile; ?>    
    </ul><!-- end .modern-articles -->


        <!-- Pagination -->
        <div class="clear"></div>
        <?php if(function_exists('wp_pagenavi')) { ?>
            <?php wp_pagenavi(); ?>
        <?php } else { ?>
            <div class="defaultpag">
                <?php previous_posts_link('&lsaquo; ' . esc_html__('Newer Posts', 'alinan-wp') . ''); ?>
                <?php next_posts_link('' . esc_html__('Older Posts', 'alinan-wp') . ' &rsaquo;'); ?>
            </div><!-- end .defaultpag -->
        <?php } ?>
        <?php endif; ?>  


     <div class="clear"></div>
    </div><!-- end .home-content -->
</div><!-- end .border-fullwidth  -->
<?php get_footer(); // add footer  ?>