<!DOCTYPE HTML>
<html <?php language_attributes(); ?>>
<head>
<?php
    // Logo
    $alinan_wp_logo = get_theme_mod('alinan_wp_logo');
    if (empty($alinan_wp_logo)) { $alinan_wp_logo = get_template_directory_uri().'/images/logo.png'; }
?>
    <!-- Meta Tags -->
    <meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />

    <!-- Mobile Device Meta -->
    <meta name="viewport" content="width=device-width, initial-scale=1"> 

    <!-- Theme output -->
    <?php wp_head(); ?> 

</head>
<body <?php body_class(); ?>>


<!-- Begin Header -->
<header>
    <div class="main-menu">
            <!-- Logo -->    
            <a href="<?php echo esc_url(home_url( '/' )); ?>"><img class="logo" src="<?php echo esc_url($alinan_wp_logo); ?>" alt="<?php esc_attr(bloginfo('sitename')); ?>" /></a>

            <!-- Navigation Menu -->
            <?php if ( has_nav_menu( 'alinan-wp-primary-menu' ) ) : // Check if there's a menu assigned to the 'Header Navigation' location. ?>
                <nav>
                    <!-- Menu Toggle btn-->
                    <div class="menu-toggle">
                        <button type="button" id="menu-btn">
                            <span class="icon-bar"></span><span class="icon-bar"></span><span class="icon-bar"></span>
                        </button>
                    </div>                       
                    <?php wp_nav_menu( array( 'container' => false, 'items_wrap' => '<ul id="respMenu" class="ant-responsive-menu" data-menu-style="horizontal">%3$s</ul>', 'theme_location' => 'alinan-wp-primary-menu' ) ); ?>
                </nav>
            <?php endif; // End check for menu. ?>

            <ul class="top-social">
                <?php if ( 'option2' == get_theme_mod( 'alinan_wp_topicons_display' ) ) { ?>
                    <?php echo wp_kses_post(stripslashes(get_theme_mod('alinan_wp_top_icons'))); ?>
                <?php } ?> 
                <li class="md-trigger search" data-modal="modal-7"><i class="fas fa-search"></i></li>
            </ul>
     </div><!-- end .main-menu -->  
</header><!-- end #header -->
<div class="clear"></div>

<div class="md-modal md-effect-7" id="modal-7">
    <div class="md-content">
      <div>
        <!-- search form get_search_form(); -->
        <button class="md-close"><i class="fas fa-times"></i></button><?php get_search_form(); ?>
      </div>
    </div><!-- end .md-content -->
</div><!-- end .md-modal -->
