<?php
// ------------------------------------------------------
// ------ Widget Banner  -------------------------------
// ------ by Anthemes.net -------------------------------
//        http://themeforest.net/user/An-Themes/portfolio
//        http://themeforest.net/user/An-Themes/follow 
// ------------------------------------------------------

class alinan_wp_300px extends WP_Widget {
     function __construct() {
	    $widget_ops = array('description' => esc_html__('Advertisement - Paste your HTML or JavaScript code.', 'alinan-wp'));
        parent::__construct(false, $name = ''. esc_html__('Custom: Advertisement 300px', 'alinan-wp') .'',$widget_ops); 
    }

   function widget($args, $instance) {  
		extract( $args );
		$title_tw = $instance['title_tw'];
		$bcode = $instance['bcode'];
?>		
 
<?php echo wp_kses_post($before_widget); ?> 
<?php if ( $title_tw ) echo wp_kses_post($before_title) . esc_attr( $title_tw ) . wp_kses_post($after_title); ?>

<div class="img-300">
  <?php echo stripslashes_deep($bcode); // esc_textarea() if is added will be shown as a text ?>
</div>

<?php echo wp_kses_post($after_widget); ?>
  
<?php
    }

     function update($new_instance, $old_instance) {				
			$instance = $old_instance;
			$instance['title_tw'] = strip_tags($new_instance['title_tw']);
			$instance['bcode'] = stripslashes($new_instance['bcode']);
     return $instance;
    }

 	function form( $instance ) {
		$instance = wp_parse_args( (array) $instance );
?>

         <p>
          <label for="<?php echo esc_attr($this->get_field_id('title_tw')); ?>"><?php esc_html_e( 'Title:', 'alinan-wp' ); ?></label> 
          <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title_tw')); ?>" name="<?php echo esc_attr($this->get_field_name('title_tw')); ?>" type="text" value="<?php if( isset($instance['title_tw']) ) echo esc_attr($instance['title_tw']); ?>" />
        </p>
        
        <p>
          <label for="<?php echo esc_attr($this->get_field_id('bcode')); ?>"><?php esc_html_e( 'Paste your HTML or JavaScript code here:', 'alinan-wp' ); ?></label>      
          <textarea style="height:100px;" class="widefat" id="<?php echo esc_attr($this->get_field_id('bcode')); ?>" name="<?php echo esc_attr($this->get_field_name('bcode')); ?>" ><?php if( isset($instance['bcode']) ) echo stripslashes($instance['bcode']); ?></textarea>
        </p> 

<?php  } }

// register widget
function alinan_wp_300px_init_widget () {
    return register_widget('alinan_wp_300px');
  }
add_action ('widgets_init', 'alinan_wp_300px_init_widget');
?>