<?php get_header(); // add header  ?>

<!-- Begin home fullwidth -->
<div class="border-fullwidth">
    <div class="home-content">

        <?php if (is_category()) { ?> 
            <h3 class="index-title"><?php esc_html_e( 'All posts in:', 'alinan-wp' ); ?> <span><?php single_cat_title(''); ?></span></h3>
        <?php } elseif (is_tag()) { ?>
            <h3 class="index-title"><?php esc_html_e( 'All posts tagged in:', 'alinan-wp' ); ?> <span><?php single_tag_title(''); ?></span></h3>
        <?php } elseif (is_search()) { ?>
            <h3 class="index-title"><?php printf( esc_html__( 'Search Results for: %s', 'alinan-wp' ), '<span>' . get_search_query() . '</span>' ); ?></h3>
        <?php } elseif (is_author()) { ?> 
            <h3 class="index-title"><?php esc_html_e( 'All posts by:', 'alinan-wp' ); ?> <span><?php the_author(); ?></span></h3>
        <?php } elseif (is_404()) { ?> 
            <h3 class="index-title"><?php esc_html_e('Error 404 - Not Found', 'alinan-wp'); ?></h3>
            <?php esc_html_e('Sorry, but you are looking for something that isn\'t here.', 'alinan-wp'); ?>
        <?php } else { ?>

            <?php if ( 'option2' == get_theme_mod( 'alinan_wp_display_about_me' ) ) {  ?>
            <div class="about-home">
                <a href="<?php echo esc_url(get_theme_mod( 'alinan_wp_about_link' )); ?>"><img src="<?php echo esc_url(get_theme_mod( 'alinan_wp_about_img' )); ?>" alt="<?php esc_attr('About me', 'alinan-wp'); ?>" width="90" height="90"></a>
                <h1><?php echo wp_kses_post(stripslashes(get_theme_mod( 'alinan_wp_about_me' ))); ?> </h1>
                <div class="clear"></div>
            </div>
            <?php } ?>
        <?php } ?>
        <div class="clear"></div>

    <ul class="modern-articles js-masonry">
    <?php if (have_posts()) : while (have_posts()) : the_post(); ?>

        <li <?php post_class('ms-item') ?> id="post-<?php the_ID(); ?>">

            <?php if ( function_exists( 'rwmb_meta' ) ) {  
            // If Meta Box plugin is activate 
                $alinan_wp_youtubecode = rwmb_meta('alinan_wp_youtube', true );
                $alinan_wp_vimeocode = rwmb_meta('alinan_wp_vimeo', true ); 
                ?> 

                <?php if(!empty($alinan_wp_youtubecode)) { ?>
                    <!-- Youtube video -->
                    <?php $alinan_wp_youtubeembed = '//www.youtube.com/embed/'; ?>
                    <iframe src="<?php echo esc_url($alinan_wp_youtubeembed); ?><?php echo esc_html($alinan_wp_youtubecode); ?>?wmode=transparent&amp;showinfo=0" allowfullscreen></iframe>
                <?php } ?>

                <?php if(!empty($alinan_wp_vimeocode)) { ?>
                    <!-- Vimeo video -->
                    <?php $alinan_wp_vimeoembed = '//player.vimeo.com/video/'; ?>
                    <iframe src="<?php echo esc_url($alinan_wp_vimeoembed); ?><?php echo esc_html($alinan_wp_vimeocode); ?>?title=0&amp;byline=0&amp;portrait=0" allowFullScreen></iframe>
                <?php } ?>                 

                <?php if(!empty($alinan_wp_youtubecode) || !empty($alinan_wp_vimeocode)) { ?>
                <?php } elseif ( has_post_thumbnail()) { ?>
                        <?php if (is_sticky()) { ?> <i class="fas fa-bookmark"></i> <?php } ?>             
                        <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail('alinan-wp-thumbnail-blog-articles', array('title' => "")); ?></a>
                    <?php } else { ?> 
                        <div class="noimg"><a href="<?php the_permalink(); ?>"><?php esc_html_e( 'Read More', 'alinan-wp' ); ?></a></div>
                <?php } ?>

            <?php } else { ?> 
                    <?php if ( has_post_thumbnail()) { ?>
                        <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail('alinan-wp-thumbnail-blog-articles', array('title' => "")); ?></a>
                    <?php } else { ?> 
                        <div class="noimg"><a href="<?php the_permalink(); ?>"><?php esc_html_e( 'Read More', 'alinan-wp' ); ?></a></div>                          
                    <?php } ?><div class="clear"></div> 
            <?php } // Custom Fields ?> 

            <div class="artbtn-category"><?php $alinan_wp_category = get_the_category(); if ($alinan_wp_category) 
                { echo wp_kses_post('<a href="' . get_category_link( $alinan_wp_category[0]->term_id ) . '">' . $alinan_wp_category[0]->name.'</a> ');}  ?>
            </div><!-- end .artbtn-category -->
 
            <div class="ma-wrap">
                <div class="ma-left">
                    <div class="home-share">
                        <?php if ( function_exists( 'alinan_wp_home_social_share' ) ) { 
                            echo esc_attr(alinan_wp_home_social_share()); ?>
                            <div class="views-nr"><span><?php echo esc_attr(getPostViews_alinan_wp(get_the_ID())); ?></span><br /> <?php esc_html_e('Views', 'alinan-wp'); ?></div>
                        <?php } ?>
                    </div><!-- end #home-share -->
                </div><!-- end .ma-left -->

                <div class="ma-right">
                    <a href="<?php the_permalink(); ?>"><h2><?php the_title(); ?> </h2></a>
                    <p><?php echo wp_kses_post(alinan_wp_excerpt(strip_tags(strip_shortcodes(get_the_excerpt())), 120)); ?></p>
                </div><!-- .ma-right -->    
            </div><!-- end .ma-wrap -->

        </li><!-- end .post-class -->

    <?php endwhile; ?>    
    </ul>
    <!-- end .modern-articles -->


        <!-- Pagination -->
        <div class="clear"></div>
        <?php if(function_exists('wp_pagenavi')) { ?>
            <?php wp_pagenavi(); ?>
        <?php } else { ?>
            <div class="defaultpag">
                <?php previous_posts_link('&lsaquo; ' . esc_html__('Newer Posts', 'alinan-wp') . ''); ?>
                <?php next_posts_link('' . esc_html__('Older Posts', 'alinan-wp') . ' &rsaquo;'); ?>
            </div><!-- end .defaultpag -->
        <?php } ?>

        <?php else : ?> 
            <div class="not-found">
                <div id="anthemes-404">
                    <h1><?php esc_html_e('Error 404!', 'alinan-wp'); ?></h1>
                    <p><?php esc_html_e('Sorry, but you are looking for something that isn\'t here.', 'alinan-wp'); ?></p>
                </div><!-- end .anthemes-404 -->           
            </div><div class="clear"></div> 
        <?php endif; ?> 


     <div class="clear"></div>
    </div><!-- end .home-content -->
</div><!-- end .border-fullwidth  -->
<?php get_footer(); // add footer  ?>