<?php
/**
 * Color Palettes
 *
 * @package Authentic
 */

/**
 * Return array of color palettes
 */
function csco_color_palettes() {
	$palettes = array(
		'monochrome' => array(
			'label'    => esc_html__( 'Monochrome', 'authentic' ),
			'color'    => '#EEEEEE',
			'settings' => array(
				'color_body_bg'                                   => '#FFFFFF',
				'color_text'                                      => '#777777',
				'color_text_secondary'                            => '#c9c9c9',
				'color_links'                                     => '#000000',
				'color_links_hover'                               => '#A0A0A0',
				'colors_borders'                                  => '#EEEEEE',
				'colors_accent'                                   => '#F8F8F8',
				'color_headings'                                  => '#000000',
				'color_headings_links'                            => '#000000',
				'color_headings_links_hover'                      => '#A0A0A0',
				'color_headings_title_blocks'                     => '#000000',
				'color_btn_primary_text'                          => '#EEEEEE',
				'color_btn_primary_text_hover'                    => '#FFFFFF',
				'color_btn_primary_bg'                            => '#282828',
				'color_btn_primary_bg_hover'                      => '#000000',
				'color_btn_secondary_text'                        => '#A0A0A0',
				'color_btn_secondary_text_hover'                  => '#000000',
				'color_btn_secondary_bg'                          => '#EEEEEE',
				'color_btn_secondary_bg_hover'                    => '#F8F8F8',
				'colors_logo_text'                                => '#000000',
				'colors_logo_text_hover'                          => '#A0A0A0',
				'colors_logo_description'                         => '#A0A0A0',
				'colors_navbar_bg'                                => '#FFFFFF',
				'colors_navbar_main_links'                        => '#000000',
				'colors_navbar_main_links_hover'                  => '#A0A0A0',
				'colors_navbar_submenu_bg'                        => '#FFFFFF',
				'colors_navbar_submenu_borders'                   => '#EEEEEE',
				'colors_navbar_submenu_items_links'               => '#000000',
				'colors_navbar_submenu_items_links_hover'         => '#FFFFFF',
				'colors_navbar_submenu_items_links_active'        => '#000000',
				'colors_navbar_submenu_items_borders'             => '#EEEEEE',
				'colors_navbar_submenu_links_bg_hover'            => '#000000',
				'colors_navbar_submenu_links_bg_active'           => '#EEEEEE',
				'colors_topbar_bg'                                => '#FFFFFF',
				'colors_topbar_main_links'                        => '#A0A0A0',
				'colors_topbar_main_links_hover'                  => '#000000',
				'colors_topbar_social_icons'                      => '#000000',
				'colors_topbar_social_icons_hover'                => '#000000',
				'colors_topbar_social_text'                       => '#A0A0A0',
				'colors_topbar_social_text_hover'                 => '#000000',
				'colors_offcanvas_navbar_links'                   => '#000000',
				'colors_offcanvas_navbar_links_hover'             => '#A0A0A0',
				'colors_offcanvas_navbar_bg'                      => '#FFFFFF',
				'color_footer_bg'                                 => '#000000',
				'color_footer_text'                               => '#A0A0A0',
				'color_footer_title'                              => '#777777',
				'color_footer_link'                               => '#FFFFFF',
				'color_footer_link_hover'                         => '#A0A0A0',
				'color_footer_border'                             => '#242424',
				'color_footer_btn_text'                           => '#A0A0A0',
				'color_footer_btn_text_hover'                     => '#FFFFFF',
				'color_footer_btn_bg'                             => '#242424',
				'color_footer_btn_bg_hover'                       => '#141414',
				'color_misc_overlay'                              => 'rgba(44,47,48,0.25)',
				'color_misc_overlay_hover'                        => 'rgba(44,47,48,0.5)',
				'color_post_links'                                => '#000000',
				'color_post_links_hover'                          => '#A0A0A0',
				'color_category'                                  => '#000000',
				'color_category_hover'                            => '#A0A0A0',
				'color_selection_text'                            => '#FFFFFF',
				'color_selection_background'                      => '#000000',
				'color_blockquote'                                => '#292929',
				'color_leadin_dropcap'                            => '#292929',
				'colors_navbar_submenu_borders_toggle_next'       => true,
				'colors_navbar_submenu_items_borders_toggle_next' => true,
				'colors_topbar_bg_toggle_next'                    => false,
				'colors_navbar_borders'                           => true,
				'colors_topbar_borders'                           => true,
				'colors_offcanvas_borders'                        => true,
			),
		),
		'lapis-blue' => array(
			'label'    => esc_html__( 'Lapis Blue', 'authentic' ),
			'color'    => '#0c4c8a',
			'settings' => array(
				'color_body_bg'                                   => '#FFFFFF',
				'color_text'                                      => '#777777',
				'color_text_secondary'                            => '#c9c9c9',
				'color_links'                                     => '#000000',
				'color_links_hover'                               => '#0c4c8a',
				'colors_borders'                                  => '#EEEEEE',
				'colors_accent'                                   => '#F8F8F8',
				'color_headings'                                  => '#000000',
				'color_headings_links'                            => '#000000',
				'color_headings_links_hover'                      => '#A0A0A0',
				'color_headings_title_blocks'                     => '#000000',
				'color_btn_primary_text'                          => '#FFFFFF',
				'color_btn_primary_text_hover'                    => '#FFFFFF',
				'color_btn_primary_bg'                            => '#0c4c8a',
				'color_btn_primary_bg_hover'                      => '#0c4c8a',
				'color_btn_secondary_text'                        => '#A0A0A0',
				'color_btn_secondary_text_hover'                  => '#000000',
				'color_btn_secondary_bg'                          => '#EEEEEE',
				'color_btn_secondary_bg_hover'                    => '#F8F8F8',
				'colors_logo_text'                                => '#000000',
				'colors_logo_text_hover'                          => '#A0A0A0',
				'colors_logo_description'                         => '#A0A0A0',
				'colors_navbar_bg'                                => '#FFFFFF',
				'colors_navbar_main_links'                        => '#000000',
				'colors_navbar_main_links_hover'                  => '#0c4c8a',
				'colors_navbar_submenu_bg'                        => '#1E1E1E',
				'colors_navbar_submenu_borders'                   => '#1E1E1E',
				'colors_navbar_submenu_items_links'               => '#EEEEEE',
				'colors_navbar_submenu_items_links_hover'         => '#FFFFFF',
				'colors_navbar_submenu_items_links_active'        => '#FFFFFF',
				'colors_navbar_submenu_items_borders'             => '#2B2B2B',
				'colors_navbar_submenu_links_bg_hover'            => '#2B2B2B',
				'colors_navbar_submenu_links_bg_active'           => '#2B2B2B',
				'colors_topbar_bg'                                => '#FFFFFF',
				'colors_topbar_main_links'                        => '#A0A0A0',
				'colors_topbar_main_links_hover'                  => '#0c4c8a',
				'colors_topbar_social_icons'                      => '#0c4c8a',
				'colors_topbar_social_icons_hover'                => '#0c4c8a',
				'colors_topbar_social_text'                       => '#A0A0A0',
				'colors_topbar_social_text_hover'                 => '#000000',
				'colors_offcanvas_navbar_links'                   => '#000000',
				'colors_offcanvas_navbar_links_hover'             => '#0c4c8a',
				'colors_offcanvas_navbar_bg'                      => '#FFFFFF',
				'color_footer_bg'                                 => '#000000',
				'color_footer_text'                               => '#A0A0A0',
				'color_footer_title'                              => '#777777',
				'color_footer_link'                               => '#FFFFFF',
				'color_footer_link_hover'                         => '#A0A0A0',
				'color_footer_border'                             => '#242424',
				'color_footer_btn_text'                           => '#A0A0A0',
				'color_footer_btn_text_hover'                     => '#FFFFFF',
				'color_footer_btn_bg'                             => '#242424',
				'color_footer_btn_bg_hover'                       => '#141414',
				'color_misc_overlay'                              => 'rgba(44,47,48,0.25)',
				'color_misc_overlay_hover'                        => 'rgba(44,47,48,0.5)',
				'color_post_links'                                => '#0c4c8a',
				'color_post_links_hover'                          => '#000000',
				'color_category'                                  => '#0c4c8a',
				'color_category_hover'                            => '#000000',
				'color_selection_text'                            => '#000000',
				'color_selection_background'                      => '#EEEEEE',
				'color_blockquote'                                => '#292929',
				'color_leadin_dropcap'                            => '#292929',
				'colors_navbar_submenu_borders_toggle_next'       => true,
				'colors_navbar_submenu_items_borders_toggle_next' => true,
				'colors_topbar_bg_toggle_next'                    => false,
				'colors_navbar_borders'                           => true,
				'colors_topbar_borders'                           => true,
				'colors_offcanvas_borders'                        => true,
			),
		),
		'electric-blue' => array(
			'label'    => esc_html__( 'Electric Blue', 'authentic' ),
			'color'    => '#033fd6',
			'settings' => array(
				'color_body_bg'                                   => '#FFFFFF',
				'color_text'                                      => '#777777',
				'color_text_secondary'                            => '#c9c9c9',
				'color_links'                                     => '#000000',
				'color_links_hover'                               => '#033fd6',
				'colors_borders'                                  => '#EEEEEE',
				'colors_accent'                                   => '#F8F8F8',
				'color_headings'                                  => '#000000',
				'color_headings_links'                            => '#000000',
				'color_headings_links_hover'                      => '#A0A0A0',
				'color_headings_title_blocks'                     => '#000000',
				'color_btn_primary_text'                          => '#FFFFFF',
				'color_btn_primary_text_hover'                    => '#FFFFFF',
				'color_btn_primary_bg'                            => '#033fd6',
				'color_btn_primary_bg_hover'                      => '#033fd6',
				'color_btn_secondary_text'                        => '#A0A0A0',
				'color_btn_secondary_text_hover'                  => '#000000',
				'color_btn_secondary_bg'                          => '#EEEEEE',
				'color_btn_secondary_bg_hover'                    => '#F8F8F8',
				'colors_logo_text'                                => '#000000',
				'colors_logo_text_hover'                          => '#A0A0A0',
				'colors_logo_description'                         => '#A0A0A0',
				'colors_navbar_bg'                                => '#FFFFFF',
				'colors_navbar_main_links'                        => '#000000',
				'colors_navbar_main_links_hover'                  => '#033fd6',
				'colors_navbar_submenu_bg'                        => '#1E1E1E',
				'colors_navbar_submenu_borders'                   => '#1E1E1E',
				'colors_navbar_submenu_items_links'               => '#EEEEEE',
				'colors_navbar_submenu_items_links_hover'         => '#FFFFFF',
				'colors_navbar_submenu_items_links_active'        => '#FFFFFF',
				'colors_navbar_submenu_items_borders'             => '#2B2B2B',
				'colors_navbar_submenu_links_bg_hover'            => '#2B2B2B',
				'colors_navbar_submenu_links_bg_active'           => '#2B2B2B',
				'colors_topbar_bg'                                => '#FFFFFF',
				'colors_topbar_main_links'                        => '#A0A0A0',
				'colors_topbar_main_links_hover'                  => '#033fd6',
				'colors_topbar_social_icons'                      => '#033fd6',
				'colors_topbar_social_icons_hover'                => '#033fd6',
				'colors_topbar_social_text'                       => '#A0A0A0',
				'colors_topbar_social_text_hover'                 => '#000000',
				'colors_offcanvas_navbar_links'                   => '#000000',
				'colors_offcanvas_navbar_links_hover'             => '#033fd6',
				'colors_offcanvas_navbar_bg'                      => '#FFFFFF',
				'color_footer_bg'                                 => '#000000',
				'color_footer_text'                               => '#A0A0A0',
				'color_footer_title'                              => '#777777',
				'color_footer_link'                               => '#FFFFFF',
				'color_footer_link_hover'                         => '#A0A0A0',
				'color_footer_border'                             => '#242424',
				'color_footer_btn_text'                           => '#A0A0A0',
				'color_footer_btn_text_hover'                     => '#FFFFFF',
				'color_footer_btn_bg'                             => '#242424',
				'color_footer_btn_bg_hover'                       => '#141414',
				'color_misc_overlay'                              => 'rgba(44,47,48,0.25)',
				'color_misc_overlay_hover'                        => 'rgba(44,47,48,0.5)',
				'color_post_links'                                => '#033fd6',
				'color_post_links_hover'                          => '#000000',
				'color_category'                                  => '#033fd6',
				'color_category_hover'                            => '#000000',
				'color_selection_text'                            => '#000000',
				'color_selection_background'                      => '#EEEEEE',
				'color_blockquote'                                => '#292929',
				'color_leadin_dropcap'                            => '#292929',
				'colors_navbar_submenu_borders_toggle_next'       => true,
				'colors_navbar_submenu_items_borders_toggle_next' => true,
				'colors_topbar_bg_toggle_next'                    => false,
				'colors_navbar_borders'                           => true,
				'colors_topbar_borders'                           => true,
				'colors_offcanvas_borders'                        => true,
			),
		),
		'blue-iris' => array(
			'label'    => esc_html__( 'Blue Iris', 'authentic' ),
			'color'    => '#595ca1',
			'settings' => array(
				'color_body_bg'                                   => '#FFFFFF',
				'color_text'                                      => '#777777',
				'color_text_secondary'                            => '#c9c9c9',
				'color_links'                                     => '#000000',
				'color_links_hover'                               => '#595ca1',
				'colors_borders'                                  => '#EEEEEE',
				'colors_accent'                                   => '#F8F8F8',
				'color_headings'                                  => '#000000',
				'color_headings_links'                            => '#000000',
				'color_headings_links_hover'                      => '#A0A0A0',
				'color_headings_title_blocks'                     => '#000000',
				'color_btn_primary_text'                          => '#FFFFFF',
				'color_btn_primary_text_hover'                    => '#FFFFFF',
				'color_btn_primary_bg'                            => '#595ca1',
				'color_btn_primary_bg_hover'                      => '#595ca1',
				'color_btn_secondary_text'                        => '#A0A0A0',
				'color_btn_secondary_text_hover'                  => '#000000',
				'color_btn_secondary_bg'                          => '#EEEEEE',
				'color_btn_secondary_bg_hover'                    => '#F8F8F8',
				'colors_logo_text'                                => '#000000',
				'colors_logo_text_hover'                          => '#A0A0A0',
				'colors_logo_description'                         => '#A0A0A0',
				'colors_navbar_bg'                                => '#FFFFFF',
				'colors_navbar_main_links'                        => '#000000',
				'colors_navbar_main_links_hover'                  => '#595ca1',
				'colors_navbar_submenu_bg'                        => '#FFFFFF',
				'colors_navbar_submenu_borders'                   => '#EEEEEE',
				'colors_navbar_submenu_items_links'               => '#000000',
				'colors_navbar_submenu_items_links_hover'         => '#595ca1',
				'colors_navbar_submenu_items_links_active'        => '#595ca1',
				'colors_navbar_submenu_items_borders'             => '#EEEEEE',
				'colors_navbar_submenu_links_bg_hover'            => '#FFFFFF',
				'colors_navbar_submenu_links_bg_active'           => '#FFFFFF',
				'colors_topbar_bg'                                => '#FFFFFF',
				'colors_topbar_main_links'                        => '#A0A0A0',
				'colors_topbar_main_links_hover'                  => '#595ca1',
				'colors_topbar_social_icons'                      => '#595ca1',
				'colors_topbar_social_icons_hover'                => '#595ca1',
				'colors_topbar_social_text'                       => '#A0A0A0',
				'colors_topbar_social_text_hover'                 => '#000000',
				'colors_offcanvas_navbar_links'                   => '#000000',
				'colors_offcanvas_navbar_links_hover'             => '#595ca1',
				'colors_offcanvas_navbar_bg'                      => '#FFFFFF',
				'color_footer_bg'                                 => '#000000',
				'color_footer_text'                               => '#A0A0A0',
				'color_footer_title'                              => '#777777',
				'color_footer_link'                               => '#FFFFFF',
				'color_footer_link_hover'                         => '#A0A0A0',
				'color_footer_border'                             => '#242424',
				'color_footer_btn_text'                           => '#A0A0A0',
				'color_footer_btn_text_hover'                     => '#FFFFFF',
				'color_footer_btn_bg'                             => '#242424',
				'color_footer_btn_bg_hover'                       => '#141414',
				'color_misc_overlay'                              => 'rgba(44,47,48,0.25)',
				'color_misc_overlay_hover'                        => 'rgba(44,47,48,0.5)',
				'color_post_links'                                => '#595ca1',
				'color_post_links_hover'                          => '#000000',
				'color_category'                                  => '#595ca1',
				'color_category_hover'                            => '#000000',
				'color_selection_text'                            => '#FFFFFF',
				'color_selection_background'                      => '#595ca1',
				'color_blockquote'                                => '#292929',
				'color_leadin_dropcap'                            => '#292929',
				'colors_navbar_submenu_borders_toggle_next'       => true,
				'colors_navbar_submenu_items_borders_toggle_next' => true,
				'colors_topbar_bg_toggle_next'                    => false,
				'colors_navbar_borders'                           => true,
				'colors_topbar_borders'                           => true,
				'colors_offcanvas_borders'                        => true,
			),
		),
		'pale-dogwood' => array(
			'label'    => esc_html__( 'Pale Dogwood', 'authentic' ),
			'color'    => '#efcec5',
			'settings' => array(
				'color_body_bg'                                   => '#FFFFFF',
				'color_text'                                      => '#777777',
				'color_text_secondary'                            => '#c9c9c9',
				'color_links'                                     => '#000000',
				'color_links_hover'                               => '#efcec5',
				'colors_borders'                                  => '#EEEEEE',
				'colors_accent'                                   => '#F8F8F8',
				'color_headings'                                  => '#000000',
				'color_headings_links'                            => '#000000',
				'color_headings_links_hover'                      => '#A0A0A0',
				'color_headings_title_blocks'                     => '#000000',
				'color_btn_primary_text'                          => '#FFFFFF',
				'color_btn_primary_text_hover'                    => '#FFFFFF',
				'color_btn_primary_bg'                            => '#efcec5',
				'color_btn_primary_bg_hover'                      => '#efcec5',
				'color_btn_secondary_text'                        => '#A0A0A0',
				'color_btn_secondary_text_hover'                  => '#000000',
				'color_btn_secondary_bg'                          => '#EEEEEE',
				'color_btn_secondary_bg_hover'                    => '#F8F8F8',
				'colors_logo_text'                                => '#000000',
				'colors_logo_text_hover'                          => '#A0A0A0',
				'colors_logo_description'                         => '#A0A0A0',
				'colors_navbar_bg'                                => '#FFFFFF',
				'colors_navbar_main_links'                        => '#000000',
				'colors_navbar_main_links_hover'                  => '#efcec5',
				'colors_navbar_submenu_bg'                        => '#FFFFFF',
				'colors_navbar_submenu_borders'                   => '#EEEEEE',
				'colors_navbar_submenu_items_links'               => '#000000',
				'colors_navbar_submenu_items_links_hover'         => '#efcec5',
				'colors_navbar_submenu_items_links_active'        => '#efcec5',
				'colors_navbar_submenu_items_borders'             => '#EEEEEE',
				'colors_navbar_submenu_links_bg_hover'            => '#FFFFFF',
				'colors_navbar_submenu_links_bg_active'           => '#FFFFFF',
				'colors_topbar_bg'                                => '#FFFFFF',
				'colors_topbar_main_links'                        => '#A0A0A0',
				'colors_topbar_main_links_hover'                  => '#efcec5',
				'colors_topbar_social_icons'                      => '#efcec5',
				'colors_topbar_social_icons_hover'                => '#efcec5',
				'colors_topbar_social_text'                       => '#A0A0A0',
				'colors_topbar_social_text_hover'                 => '#000000',
				'colors_offcanvas_navbar_links'                   => '#000000',
				'colors_offcanvas_navbar_links_hover'             => '#efcec5',
				'colors_offcanvas_navbar_bg'                      => '#FFFFFF',
				'color_footer_bg'                                 => '#000000',
				'color_footer_text'                               => '#A0A0A0',
				'color_footer_title'                              => '#777777',
				'color_footer_link'                               => '#FFFFFF',
				'color_footer_link_hover'                         => '#A0A0A0',
				'color_footer_border'                             => '#242424',
				'color_footer_btn_text'                           => '#A0A0A0',
				'color_footer_btn_text_hover'                     => '#FFFFFF',
				'color_footer_btn_bg'                             => '#242424',
				'color_footer_btn_bg_hover'                       => '#141414',
				'color_misc_overlay'                              => 'rgba(44,47,48,0.25)',
				'color_misc_overlay_hover'                        => 'rgba(44,47,48,0.5)',
				'color_post_links'                                => '#efcec5',
				'color_post_links_hover'                          => '#000000',
				'color_category'                                  => '#efcec5',
				'color_category_hover'                            => '#000000',
				'color_selection_text'                            => '#FFFFFF',
				'color_selection_background'                      => '#efcec5',
				'color_blockquote'                                => '#292929',
				'color_leadin_dropcap'                            => '#292929',
				'colors_navbar_submenu_borders_toggle_next'       => true,
				'colors_navbar_submenu_items_borders_toggle_next' => true,
				'colors_topbar_bg_toggle_next'                    => false,
				'colors_navbar_borders'                           => true,
				'colors_topbar_borders'                           => true,
				'colors_offcanvas_borders'                        => true,
			),
		),
		'hazelnut' => array(
			'label'    => esc_html__( 'Hazelnut', 'authentic' ),
			'color'    => '#d1af94',
			'settings' => array(
				'color_body_bg'                                   => '#FFFFFF',
				'color_text'                                      => '#777777',
				'color_text_secondary'                            => '#c9c9c9',
				'color_links'                                     => '#000000',
				'color_links_hover'                               => '#d1af94',
				'colors_borders'                                  => '#EEEEEE',
				'colors_accent'                                   => '#F8F8F8',
				'color_headings'                                  => '#000000',
				'color_headings_links'                            => '#000000',
				'color_headings_links_hover'                      => '#A0A0A0',
				'color_headings_title_blocks'                     => '#000000',
				'color_btn_primary_text'                          => '#FFFFFF',
				'color_btn_primary_text_hover'                    => '#FFFFFF',
				'color_btn_primary_bg'                            => '#d1af94',
				'color_btn_primary_bg_hover'                      => '#d1af94',
				'color_btn_secondary_text'                        => '#A0A0A0',
				'color_btn_secondary_text_hover'                  => '#000000',
				'color_btn_secondary_bg'                          => '#EEEEEE',
				'color_btn_secondary_bg_hover'                    => '#F8F8F8',
				'colors_logo_text'                                => '#000000',
				'colors_logo_text_hover'                          => '#A0A0A0',
				'colors_logo_description'                         => '#A0A0A0',
				'colors_navbar_bg'                                => '#FFFFFF',
				'colors_navbar_main_links'                        => '#000000',
				'colors_navbar_main_links_hover'                  => '#d1af94',
				'colors_navbar_submenu_bg'                        => '#FFFFFF',
				'colors_navbar_submenu_borders'                   => '#EEEEEE',
				'colors_navbar_submenu_items_links'               => '#000000',
				'colors_navbar_submenu_items_links_hover'         => '#d1af94',
				'colors_navbar_submenu_items_links_active'        => '#d1af94',
				'colors_navbar_submenu_items_borders'             => '#EEEEEE',
				'colors_navbar_submenu_links_bg_hover'            => '#FFFFFF',
				'colors_navbar_submenu_links_bg_active'           => '#FFFFFF',
				'colors_topbar_bg'                                => '#FFFFFF',
				'colors_topbar_main_links'                        => '#A0A0A0',
				'colors_topbar_main_links_hover'                  => '#d1af94',
				'colors_topbar_social_icons'                      => '#d1af94',
				'colors_topbar_social_icons_hover'                => '#d1af94',
				'colors_topbar_social_text'                       => '#A0A0A0',
				'colors_topbar_social_text_hover'                 => '#000000',
				'colors_offcanvas_navbar_links'                   => '#000000',
				'colors_offcanvas_navbar_links_hover'             => '#d1af94',
				'colors_offcanvas_navbar_bg'                      => '#FFFFFF',
				'color_footer_bg'                                 => '#000000',
				'color_footer_text'                               => '#A0A0A0',
				'color_footer_title'                              => '#777777',
				'color_footer_link'                               => '#FFFFFF',
				'color_footer_link_hover'                         => '#A0A0A0',
				'color_footer_border'                             => '#242424',
				'color_footer_btn_text'                           => '#A0A0A0',
				'color_footer_btn_text_hover'                     => '#FFFFFF',
				'color_footer_btn_bg'                             => '#242424',
				'color_footer_btn_bg_hover'                       => '#141414',
				'color_misc_overlay'                              => 'rgba(44,47,48,0.25)',
				'color_misc_overlay_hover'                        => 'rgba(44,47,48,0.5)',
				'color_post_links'                                => '#d1af94',
				'color_post_links_hover'                          => '#000000',
				'color_category'                                  => '#d1af94',
				'color_category_hover'                            => '#000000',
				'color_selection_text'                            => '#FFFFFF',
				'color_selection_background'                      => '#d1af94',
				'color_blockquote'                                => '#292929',
				'color_leadin_dropcap'                            => '#292929',
				'colors_navbar_submenu_borders_toggle_next'       => true,
				'colors_navbar_submenu_items_borders_toggle_next' => true,
				'colors_topbar_bg_toggle_next'                    => false,
				'colors_navbar_borders'                           => true,
				'colors_topbar_borders'                           => true,
				'colors_offcanvas_borders'                        => true,
			),
		),
		'island-paradise' => array(
			'label'    => esc_html__( 'Island Paradise', 'authentic' ),
			'color'    => '#97d5e0',
			'settings' => array(
				'color_body_bg'                                   => '#FFFFFF',
				'color_text'                                      => '#777777',
				'color_text_secondary'                            => '#c9c9c9',
				'color_links'                                     => '#000000',
				'color_links_hover'                               => '#97d5e0',
				'colors_borders'                                  => '#EEEEEE',
				'colors_accent'                                   => '#F8F8F8',
				'color_headings'                                  => '#000000',
				'color_headings_links'                            => '#000000',
				'color_headings_links_hover'                      => '#A0A0A0',
				'color_headings_title_blocks'                     => '#000000',
				'color_btn_primary_text'                          => '#FFFFFF',
				'color_btn_primary_text_hover'                    => '#FFFFFF',
				'color_btn_primary_bg'                            => '#97d5e0',
				'color_btn_primary_bg_hover'                      => '#97d5e0',
				'color_btn_secondary_text'                        => '#A0A0A0',
				'color_btn_secondary_text_hover'                  => '#000000',
				'color_btn_secondary_bg'                          => '#EEEEEE',
				'color_btn_secondary_bg_hover'                    => '#F8F8F8',
				'colors_logo_text'                                => '#000000',
				'colors_logo_text_hover'                          => '#A0A0A0',
				'colors_logo_description'                         => '#A0A0A0',
				'colors_navbar_bg'                                => '#FFFFFF',
				'colors_navbar_main_links'                        => '#000000',
				'colors_navbar_main_links_hover'                  => '#97d5e0',
				'colors_navbar_submenu_bg'                        => '#1E1E1E',
				'colors_navbar_submenu_borders'                   => '#1E1E1E',
				'colors_navbar_submenu_items_links'               => '#EEEEEE',
				'colors_navbar_submenu_items_links_hover'         => '#FFFFFF',
				'colors_navbar_submenu_items_links_active'        => '#FFFFFF',
				'colors_navbar_submenu_items_borders'             => '#2B2B2B',
				'colors_navbar_submenu_links_bg_hover'            => '#2B2B2B',
				'colors_navbar_submenu_links_bg_active'           => '#2B2B2B',
				'colors_topbar_bg'                                => '#FFFFFF',
				'colors_topbar_main_links'                        => '#A0A0A0',
				'colors_topbar_main_links_hover'                  => '#97d5e0',
				'colors_topbar_social_icons'                      => '#97d5e0',
				'colors_topbar_social_icons_hover'                => '#97d5e0',
				'colors_topbar_social_text'                       => '#A0A0A0',
				'colors_topbar_social_text_hover'                 => '#000000',
				'colors_offcanvas_navbar_links'                   => '#000000',
				'colors_offcanvas_navbar_links_hover'             => '#97d5e0',
				'colors_offcanvas_navbar_bg'                      => '#FFFFFF',
				'color_footer_bg'                                 => '#000000',
				'color_footer_text'                               => '#A0A0A0',
				'color_footer_title'                              => '#777777',
				'color_footer_link'                               => '#FFFFFF',
				'color_footer_link_hover'                         => '#A0A0A0',
				'color_footer_border'                             => '#242424',
				'color_footer_btn_text'                           => '#A0A0A0',
				'color_footer_btn_text_hover'                     => '#FFFFFF',
				'color_footer_btn_bg'                             => '#242424',
				'color_footer_btn_bg_hover'                       => '#141414',
				'color_misc_overlay'                              => 'rgba(44,47,48,0.25)',
				'color_misc_overlay_hover'                        => 'rgba(44,47,48,0.5)',
				'color_post_links'                                => '#97d5e0',
				'color_post_links_hover'                          => '#000000',
				'color_category'                                  => '#97d5e0',
				'color_category_hover'                            => '#000000',
				'color_selection_text'                            => '#000000',
				'color_selection_background'                      => '#EEEEEE',
				'color_blockquote'                                => '#292929',
				'color_leadin_dropcap'                            => '#292929',
				'colors_navbar_submenu_borders_toggle_next'       => true,
				'colors_navbar_submenu_items_borders_toggle_next' => true,
				'colors_topbar_bg_toggle_next'                    => false,
				'colors_navbar_borders'                           => true,
				'colors_topbar_borders'                           => true,
				'colors_offcanvas_borders'                        => true,
			),
		),
		'niagara' => array(
			'label'    => esc_html__( 'Niagara', 'authentic' ),
			'color'    => '#5587a2',
			'settings' => array(
				'color_body_bg'                                   => '#FFFFFF',
				'color_text'                                      => '#777777',
				'color_text_secondary'                            => '#c9c9c9',
				'color_links'                                     => '#000000',
				'color_links_hover'                               => '#5587a2',
				'colors_borders'                                  => '#EEEEEE',
				'colors_accent'                                   => '#F8F8F8',
				'color_headings'                                  => '#000000',
				'color_headings_links'                            => '#000000',
				'color_headings_links_hover'                      => '#A0A0A0',
				'color_headings_title_blocks'                     => '#000000',
				'color_btn_primary_text'                          => '#FFFFFF',
				'color_btn_primary_text_hover'                    => '#FFFFFF',
				'color_btn_primary_bg'                            => '#5587a2',
				'color_btn_primary_bg_hover'                      => '#5587a2',
				'color_btn_secondary_text'                        => '#A0A0A0',
				'color_btn_secondary_text_hover'                  => '#000000',
				'color_btn_secondary_bg'                          => '#EEEEEE',
				'color_btn_secondary_bg_hover'                    => '#F8F8F8',
				'colors_logo_text'                                => '#000000',
				'colors_logo_text_hover'                          => '#A0A0A0',
				'colors_logo_description'                         => '#A0A0A0',
				'colors_navbar_bg'                                => '#FFFFFF',
				'colors_navbar_main_links'                        => '#000000',
				'colors_navbar_main_links_hover'                  => '#5587a2',
				'colors_navbar_submenu_bg'                        => '#1E1E1E',
				'colors_navbar_submenu_borders'                   => '#1E1E1E',
				'colors_navbar_submenu_items_links'               => '#EEEEEE',
				'colors_navbar_submenu_items_links_hover'         => '#FFFFFF',
				'colors_navbar_submenu_items_links_active'        => '#FFFFFF',
				'colors_navbar_submenu_items_borders'             => '#2B2B2B',
				'colors_navbar_submenu_links_bg_hover'            => '#2B2B2B',
				'colors_navbar_submenu_links_bg_active'           => '#2B2B2B',
				'colors_topbar_bg'                                => '#FFFFFF',
				'colors_topbar_main_links'                        => '#A0A0A0',
				'colors_topbar_main_links_hover'                  => '#5587a2',
				'colors_topbar_social_icons'                      => '#5587a2',
				'colors_topbar_social_icons_hover'                => '#5587a2',
				'colors_topbar_social_text'                       => '#A0A0A0',
				'colors_topbar_social_text_hover'                 => '#000000',
				'colors_offcanvas_navbar_links'                   => '#000000',
				'colors_offcanvas_navbar_links_hover'             => '#5587a2',
				'colors_offcanvas_navbar_bg'                      => '#FFFFFF',
				'color_footer_bg'                                 => '#000000',
				'color_footer_text'                               => '#A0A0A0',
				'color_footer_title'                              => '#777777',
				'color_footer_link'                               => '#FFFFFF',
				'color_footer_link_hover'                         => '#A0A0A0',
				'color_footer_border'                             => '#242424',
				'color_footer_btn_text'                           => '#A0A0A0',
				'color_footer_btn_text_hover'                     => '#FFFFFF',
				'color_footer_btn_bg'                             => '#242424',
				'color_footer_btn_bg_hover'                       => '#141414',
				'color_misc_overlay'                              => 'rgba(44,47,48,0.25)',
				'color_misc_overlay_hover'                        => 'rgba(44,47,48,0.5)',
				'color_post_links'                                => '#5587a2',
				'color_post_links_hover'                          => '#000000',
				'color_category'                                  => '#5587a2',
				'color_category_hover'                            => '#000000',
				'color_selection_text'                            => '#000000',
				'color_selection_background'                      => '#EEEEEE',
				'color_blockquote'                                => '#292929',
				'color_leadin_dropcap'                            => '#292929',
				'colors_navbar_submenu_borders_toggle_next'       => true,
				'colors_navbar_submenu_items_borders_toggle_next' => true,
				'colors_topbar_bg_toggle_next'                    => false,
				'colors_navbar_borders'                           => true,
				'colors_topbar_borders'                           => true,
				'colors_offcanvas_borders'                        => true,
			),
		),
		'pink-yarrow' => array(
			'label'    => esc_html__( 'Pink Yarrow', 'authentic' ),
			'color'    => '#d13076',
			'settings' => array(
				'color_body_bg'                                   => '#FFFFFF',
				'color_text'                                      => '#777777',
				'color_text_secondary'                            => '#c9c9c9',
				'color_links'                                     => '#000000',
				'color_links_hover'                               => '#d13076',
				'colors_borders'                                  => '#EEEEEE',
				'colors_accent'                                   => '#F8F8F8',
				'color_headings'                                  => '#000000',
				'color_headings_links'                            => '#000000',
				'color_headings_links_hover'                      => '#A0A0A0',
				'color_headings_title_blocks'                     => '#000000',
				'color_btn_primary_text'                          => '#FFFFFF',
				'color_btn_primary_text_hover'                    => '#FFFFFF',
				'color_btn_primary_bg'                            => '#d13076',
				'color_btn_primary_bg_hover'                      => '#d13076',
				'color_btn_secondary_text'                        => '#A0A0A0',
				'color_btn_secondary_text_hover'                  => '#000000',
				'color_btn_secondary_bg'                          => '#EEEEEE',
				'color_btn_secondary_bg_hover'                    => '#F8F8F8',
				'colors_logo_text'                                => '#000000',
				'colors_logo_text_hover'                          => '#A0A0A0',
				'colors_logo_description'                         => '#A0A0A0',
				'colors_navbar_bg'                                => '#FFFFFF',
				'colors_navbar_main_links'                        => '#000000',
				'colors_navbar_main_links_hover'                  => '#d13076',
				'colors_navbar_submenu_bg'                        => '#1E1E1E',
				'colors_navbar_submenu_borders'                   => '#1E1E1E',
				'colors_navbar_submenu_items_links'               => '#EEEEEE',
				'colors_navbar_submenu_items_links_hover'         => '#FFFFFF',
				'colors_navbar_submenu_items_links_active'        => '#FFFFFF',
				'colors_navbar_submenu_items_borders'             => '#2B2B2B',
				'colors_navbar_submenu_links_bg_hover'            => '#2B2B2B',
				'colors_navbar_submenu_links_bg_active'           => '#2B2B2B',
				'colors_topbar_bg'                                => '#FFFFFF',
				'colors_topbar_main_links'                        => '#A0A0A0',
				'colors_topbar_main_links_hover'                  => '#d13076',
				'colors_topbar_social_icons'                      => '#d13076',
				'colors_topbar_social_icons_hover'                => '#d13076',
				'colors_topbar_social_text'                       => '#A0A0A0',
				'colors_topbar_social_text_hover'                 => '#000000',
				'colors_offcanvas_navbar_links'                   => '#000000',
				'colors_offcanvas_navbar_links_hover'             => '#d13076',
				'colors_offcanvas_navbar_bg'                      => '#FFFFFF',
				'color_footer_bg'                                 => '#000000',
				'color_footer_text'                               => '#A0A0A0',
				'color_footer_title'                              => '#777777',
				'color_footer_link'                               => '#FFFFFF',
				'color_footer_link_hover'                         => '#A0A0A0',
				'color_footer_border'                             => '#242424',
				'color_footer_btn_text'                           => '#A0A0A0',
				'color_footer_btn_text_hover'                     => '#FFFFFF',
				'color_footer_btn_bg'                             => '#242424',
				'color_footer_btn_bg_hover'                       => '#141414',
				'color_misc_overlay'                              => 'rgba(44,47,48,0.25)',
				'color_misc_overlay_hover'                        => 'rgba(44,47,48,0.5)',
				'color_post_links'                                => '#d13076',
				'color_post_links_hover'                          => '#000000',
				'color_category'                                  => '#d13076',
				'color_category_hover'                            => '#000000',
				'color_selection_text'                            => '#000000',
				'color_selection_background'                      => '#EEEEEE',
				'color_blockquote'                                => '#292929',
				'color_leadin_dropcap'                            => '#292929',
				'colors_navbar_submenu_borders_toggle_next'       => true,
				'colors_navbar_submenu_items_borders_toggle_next' => true,
				'colors_topbar_bg_toggle_next'                    => false,
				'colors_navbar_borders'                           => true,
				'colors_topbar_borders'                           => true,
				'colors_offcanvas_borders'                        => true,
			),
		),
		'mimosa' => array(
			'label'    => esc_html__( 'Mimosa', 'authentic' ),
			'color'    => '#f0bf59',
			'settings' => array(
				'color_body_bg'                                   => '#FFFFFF',
				'color_text'                                      => '#777777',
				'color_text_secondary'                            => '#c9c9c9',
				'color_links'                                     => '#000000',
				'color_links_hover'                               => '#f0bf59',
				'colors_borders'                                  => '#EEEEEE',
				'colors_accent'                                   => '#F8F8F8',
				'color_headings'                                  => '#000000',
				'color_headings_links'                            => '#000000',
				'color_headings_links_hover'                      => '#A0A0A0',
				'color_headings_title_blocks'                     => '#000000',
				'color_btn_primary_text'                          => '#FFFFFF',
				'color_btn_primary_text_hover'                    => '#FFFFFF',
				'color_btn_primary_bg'                            => '#f0bf59',
				'color_btn_primary_bg_hover'                      => '#f0bf59',
				'color_btn_secondary_text'                        => '#A0A0A0',
				'color_btn_secondary_text_hover'                  => '#000000',
				'color_btn_secondary_bg'                          => '#EEEEEE',
				'color_btn_secondary_bg_hover'                    => '#F8F8F8',
				'colors_logo_text'                                => '#000000',
				'colors_logo_text_hover'                          => '#A0A0A0',
				'colors_logo_description'                         => '#A0A0A0',
				'colors_navbar_bg'                                => '#FFFFFF',
				'colors_navbar_main_links'                        => '#000000',
				'colors_navbar_main_links_hover'                  => '#f0bf59',
				'colors_navbar_submenu_bg'                        => '#1E1E1E',
				'colors_navbar_submenu_borders'                   => '#1E1E1E',
				'colors_navbar_submenu_items_links'               => '#EEEEEE',
				'colors_navbar_submenu_items_links_hover'         => '#FFFFFF',
				'colors_navbar_submenu_items_links_active'        => '#FFFFFF',
				'colors_navbar_submenu_items_borders'             => '#2B2B2B',
				'colors_navbar_submenu_links_bg_hover'            => '#2B2B2B',
				'colors_navbar_submenu_links_bg_active'           => '#2B2B2B',
				'colors_topbar_bg'                                => '#FFFFFF',
				'colors_topbar_main_links'                        => '#A0A0A0',
				'colors_topbar_main_links_hover'                  => '#f0bf59',
				'colors_topbar_social_icons'                      => '#f0bf59',
				'colors_topbar_social_icons_hover'                => '#f0bf59',
				'colors_topbar_social_text'                       => '#A0A0A0',
				'colors_topbar_social_text_hover'                 => '#000000',
				'colors_offcanvas_navbar_links'                   => '#000000',
				'colors_offcanvas_navbar_links_hover'             => '#f0bf59',
				'colors_offcanvas_navbar_bg'                      => '#FFFFFF',
				'color_footer_bg'                                 => '#000000',
				'color_footer_text'                               => '#A0A0A0',
				'color_footer_title'                              => '#777777',
				'color_footer_link'                               => '#FFFFFF',
				'color_footer_link_hover'                         => '#A0A0A0',
				'color_footer_border'                             => '#242424',
				'color_footer_btn_text'                           => '#A0A0A0',
				'color_footer_btn_text_hover'                     => '#FFFFFF',
				'color_footer_btn_bg'                             => '#242424',
				'color_footer_btn_bg_hover'                       => '#141414',
				'color_misc_overlay'                              => 'rgba(44,47,48,0.25)',
				'color_misc_overlay_hover'                        => 'rgba(44,47,48,0.5)',
				'color_post_links'                                => '#f0bf59',
				'color_post_links_hover'                          => '#000000',
				'color_category'                                  => '#f0bf59',
				'color_category_hover'                            => '#000000',
				'color_selection_text'                            => '#000000',
				'color_selection_background'                      => '#EEEEEE',
				'color_blockquote'                                => '#292929',
				'color_leadin_dropcap'                            => '#292929',
				'colors_navbar_submenu_borders_toggle_next'       => true,
				'colors_navbar_submenu_items_borders_toggle_next' => true,
				'colors_topbar_bg_toggle_next'                    => false,
				'colors_navbar_borders'                           => true,
				'colors_topbar_borders'                           => true,
				'colors_offcanvas_borders'                        => true,
			),
		),
		'kale' => array(
			'label'    => esc_html__( 'Kale', 'authentic' ),
			'color'    => '#5c7148',
			'settings' => array(
				'color_body_bg'                                   => '#FFFFFF',
				'color_text'                                      => '#777777',
				'color_text_secondary'                            => '#c9c9c9',
				'color_links'                                     => '#000000',
				'color_links_hover'                               => '#5c7148',
				'colors_borders'                                  => '#EEEEEE',
				'colors_accent'                                   => '#F8F8F8',
				'color_headings'                                  => '#000000',
				'color_headings_links'                            => '#000000',
				'color_headings_links_hover'                      => '#A0A0A0',
				'color_headings_title_blocks'                     => '#000000',
				'color_btn_primary_text'                          => '#FFFFFF',
				'color_btn_primary_text_hover'                    => '#FFFFFF',
				'color_btn_primary_bg'                            => '#5c7148',
				'color_btn_primary_bg_hover'                      => '#5c7148',
				'color_btn_secondary_text'                        => '#A0A0A0',
				'color_btn_secondary_text_hover'                  => '#000000',
				'color_btn_secondary_bg'                          => '#EEEEEE',
				'color_btn_secondary_bg_hover'                    => '#F8F8F8',
				'colors_logo_text'                                => '#000000',
				'colors_logo_text_hover'                          => '#A0A0A0',
				'colors_logo_description'                         => '#A0A0A0',
				'colors_navbar_bg'                                => '#FFFFFF',
				'colors_navbar_main_links'                        => '#000000',
				'colors_navbar_main_links_hover'                  => '#5c7148',
				'colors_navbar_submenu_bg'                        => '#1E1E1E',
				'colors_navbar_submenu_borders'                   => '#1E1E1E',
				'colors_navbar_submenu_items_links'               => '#EEEEEE',
				'colors_navbar_submenu_items_links_hover'         => '#FFFFFF',
				'colors_navbar_submenu_items_links_active'        => '#FFFFFF',
				'colors_navbar_submenu_items_borders'             => '#2B2B2B',
				'colors_navbar_submenu_links_bg_hover'            => '#2B2B2B',
				'colors_navbar_submenu_links_bg_active'           => '#2B2B2B',
				'colors_topbar_bg'                                => '#FFFFFF',
				'colors_topbar_main_links'                        => '#A0A0A0',
				'colors_topbar_main_links_hover'                  => '#5c7148',
				'colors_topbar_social_icons'                      => '#5c7148',
				'colors_topbar_social_icons_hover'                => '#5c7148',
				'colors_topbar_social_text'                       => '#A0A0A0',
				'colors_topbar_social_text_hover'                 => '#000000',
				'colors_offcanvas_navbar_links'                   => '#000000',
				'colors_offcanvas_navbar_links_hover'             => '#5c7148',
				'colors_offcanvas_navbar_bg'                      => '#FFFFFF',
				'color_footer_bg'                                 => '#000000',
				'color_footer_text'                               => '#A0A0A0',
				'color_footer_title'                              => '#777777',
				'color_footer_link'                               => '#FFFFFF',
				'color_footer_link_hover'                         => '#A0A0A0',
				'color_footer_border'                             => '#242424',
				'color_footer_btn_text'                           => '#A0A0A0',
				'color_footer_btn_text_hover'                     => '#FFFFFF',
				'color_footer_btn_bg'                             => '#242424',
				'color_footer_btn_bg_hover'                       => '#141414',
				'color_misc_overlay'                              => 'rgba(44,47,48,0.25)',
				'color_misc_overlay_hover'                        => 'rgba(44,47,48,0.5)',
				'color_post_links'                                => '#5c7148',
				'color_post_links_hover'                          => '#000000',
				'color_category'                                  => '#5c7148',
				'color_category_hover'                            => '#000000',
				'color_selection_text'                            => '#000000',
				'color_selection_background'                      => '#EEEEEE',
				'color_blockquote'                                => '#292929',
				'color_leadin_dropcap'                            => '#292929',
				'colors_navbar_submenu_borders_toggle_next'       => true,
				'colors_navbar_submenu_items_borders_toggle_next' => true,
				'colors_topbar_bg_toggle_next'                    => false,
				'colors_navbar_borders'                           => true,
				'colors_topbar_borders'                           => true,
				'colors_offcanvas_borders'                        => true,
			),
		),
		'greenery' => array(
			'label'    => esc_html__( 'Greenery', 'authentic' ),
			'color'    => '#88b14b',
			'settings' => array(
				'color_body_bg'                                   => '#FFFFFF',
				'color_text'                                      => '#777777',
				'color_text_secondary'                            => '#c9c9c9',
				'color_links'                                     => '#000000',
				'color_links_hover'                               => '#88b14b',
				'colors_borders'                                  => '#EEEEEE',
				'colors_accent'                                   => '#F8F8F8',
				'color_headings'                                  => '#000000',
				'color_headings_links'                            => '#000000',
				'color_headings_links_hover'                      => '#A0A0A0',
				'color_headings_title_blocks'                     => '#000000',
				'color_btn_primary_text'                          => '#FFFFFF',
				'color_btn_primary_text_hover'                    => '#FFFFFF',
				'color_btn_primary_bg'                            => '#88b14b',
				'color_btn_primary_bg_hover'                      => '#88b14b',
				'color_btn_secondary_text'                        => '#A0A0A0',
				'color_btn_secondary_text_hover'                  => '#000000',
				'color_btn_secondary_bg'                          => '#EEEEEE',
				'color_btn_secondary_bg_hover'                    => '#F8F8F8',
				'colors_logo_text'                                => '#000000',
				'colors_logo_text_hover'                          => '#A0A0A0',
				'colors_logo_description'                         => '#A0A0A0',
				'colors_navbar_bg'                                => '#FFFFFF',
				'colors_navbar_main_links'                        => '#000000',
				'colors_navbar_main_links_hover'                  => '#88b14b',
				'colors_navbar_submenu_bg'                        => '#FFFFFF',
				'colors_navbar_submenu_borders'                   => '#EEEEEE',
				'colors_navbar_submenu_items_links'               => '#000000',
				'colors_navbar_submenu_items_links_hover'         => '#88b14b',
				'colors_navbar_submenu_items_links_active'        => '#88b14b',
				'colors_navbar_submenu_items_borders'             => '#EEEEEE',
				'colors_navbar_submenu_links_bg_hover'            => '#FFFFFF',
				'colors_navbar_submenu_links_bg_active'           => '#FFFFFF',
				'colors_topbar_bg'                                => '#FFFFFF',
				'colors_topbar_main_links'                        => '#A0A0A0',
				'colors_topbar_main_links_hover'                  => '#88b14b',
				'colors_topbar_social_icons'                      => '#88b14b',
				'colors_topbar_social_icons_hover'                => '#88b14b',
				'colors_topbar_social_text'                       => '#A0A0A0',
				'colors_topbar_social_text_hover'                 => '#000000',
				'colors_offcanvas_navbar_links'                   => '#000000',
				'colors_offcanvas_navbar_links_hover'             => '#88b14b',
				'colors_offcanvas_navbar_bg'                      => '#FFFFFF',
				'color_footer_bg'                                 => '#000000',
				'color_footer_text'                               => '#A0A0A0',
				'color_footer_title'                              => '#777777',
				'color_footer_link'                               => '#FFFFFF',
				'color_footer_link_hover'                         => '#A0A0A0',
				'color_footer_border'                             => '#242424',
				'color_footer_btn_text'                           => '#A0A0A0',
				'color_footer_btn_text_hover'                     => '#FFFFFF',
				'color_footer_btn_bg'                             => '#242424',
				'color_footer_btn_bg_hover'                       => '#141414',
				'color_misc_overlay'                              => 'rgba(44,47,48,0.25)',
				'color_misc_overlay_hover'                        => 'rgba(44,47,48,0.5)',
				'color_post_links'                                => '#88b14b',
				'color_post_links_hover'                          => '#000000',
				'color_category'                                  => '#88b14b',
				'color_category_hover'                            => '#000000',
				'color_selection_text'                            => '#FFFFFF',
				'color_selection_background'                      => '#88b14b',
				'color_blockquote'                                => '#292929',
				'color_leadin_dropcap'                            => '#292929',
				'colors_navbar_submenu_borders_toggle_next'       => true,
				'colors_navbar_submenu_items_borders_toggle_next' => true,
				'colors_topbar_bg_toggle_next'                    => false,
				'colors_navbar_borders'                           => true,
				'colors_topbar_borders'                           => true,
				'colors_offcanvas_borders'                        => true,
			),
		),
		'emerald' => array(
			'label'    => esc_html__( 'Emerald', 'authentic' ),
			'color'    => '#169c78',
			'settings' => array(
				'color_body_bg'                                   => '#FFFFFF',
				'color_text'                                      => '#777777',
				'color_text_secondary'                            => '#c9c9c9',
				'color_links'                                     => '#000000',
				'color_links_hover'                               => '#169c78',
				'colors_borders'                                  => '#EEEEEE',
				'colors_accent'                                   => '#F8F8F8',
				'color_headings'                                  => '#000000',
				'color_headings_links'                            => '#000000',
				'color_headings_links_hover'                      => '#A0A0A0',
				'color_headings_title_blocks'                     => '#000000',
				'color_btn_primary_text'                          => '#FFFFFF',
				'color_btn_primary_text_hover'                    => '#FFFFFF',
				'color_btn_primary_bg'                            => '#169c78',
				'color_btn_primary_bg_hover'                      => '#169c78',
				'color_btn_secondary_text'                        => '#A0A0A0',
				'color_btn_secondary_text_hover'                  => '#000000',
				'color_btn_secondary_bg'                          => '#EEEEEE',
				'color_btn_secondary_bg_hover'                    => '#F8F8F8',
				'colors_logo_text'                                => '#000000',
				'colors_logo_text_hover'                          => '#A0A0A0',
				'colors_logo_description'                         => '#A0A0A0',
				'colors_navbar_bg'                                => '#FFFFFF',
				'colors_navbar_main_links'                        => '#000000',
				'colors_navbar_main_links_hover'                  => '#169c78',
				'colors_navbar_submenu_bg'                        => '#FFFFFF',
				'colors_navbar_submenu_borders'                   => '#EEEEEE',
				'colors_navbar_submenu_items_links'               => '#000000',
				'colors_navbar_submenu_items_links_hover'         => '#169c78',
				'colors_navbar_submenu_items_links_active'        => '#169c78',
				'colors_navbar_submenu_items_borders'             => '#EEEEEE',
				'colors_navbar_submenu_links_bg_hover'            => '#FFFFFF',
				'colors_navbar_submenu_links_bg_active'           => '#FFFFFF',
				'colors_topbar_bg'                                => '#FFFFFF',
				'colors_topbar_main_links'                        => '#A0A0A0',
				'colors_topbar_main_links_hover'                  => '#169c78',
				'colors_topbar_social_icons'                      => '#169c78',
				'colors_topbar_social_icons_hover'                => '#169c78',
				'colors_topbar_social_text'                       => '#A0A0A0',
				'colors_topbar_social_text_hover'                 => '#000000',
				'colors_offcanvas_navbar_links'                   => '#000000',
				'colors_offcanvas_navbar_links_hover'             => '#169c78',
				'colors_offcanvas_navbar_bg'                      => '#FFFFFF',
				'color_footer_bg'                                 => '#000000',
				'color_footer_text'                               => '#A0A0A0',
				'color_footer_title'                              => '#777777',
				'color_footer_link'                               => '#FFFFFF',
				'color_footer_link_hover'                         => '#A0A0A0',
				'color_footer_border'                             => '#242424',
				'color_footer_btn_text'                           => '#A0A0A0',
				'color_footer_btn_text_hover'                     => '#FFFFFF',
				'color_footer_btn_bg'                             => '#242424',
				'color_footer_btn_bg_hover'                       => '#141414',
				'color_misc_overlay'                              => 'rgba(44,47,48,0.25)',
				'color_misc_overlay_hover'                        => 'rgba(44,47,48,0.5)',
				'color_post_links'                                => '#169c78',
				'color_post_links_hover'                          => '#000000',
				'color_category'                                  => '#169c78',
				'color_category_hover'                            => '#000000',
				'color_selection_text'                            => '#FFFFFF',
				'color_selection_background'                      => '#169c78',
				'color_blockquote'                                => '#292929',
				'color_leadin_dropcap'                            => '#292929',
				'colors_navbar_submenu_borders_toggle_next'       => true,
				'colors_navbar_submenu_items_borders_toggle_next' => true,
				'colors_topbar_bg_toggle_next'                    => false,
				'colors_navbar_borders'                           => true,
				'colors_topbar_borders'                           => true,
				'colors_offcanvas_borders'                        => true,
			),
		),
		'flame' => array(
			'label'    => esc_html__( 'Flame', 'authentic' ),
			'color'    => '#ef562d',
			'settings' => array(
				'color_body_bg'                                   => '#FFFFFF',
				'color_text'                                      => '#777777',
				'color_text_secondary'                            => '#c9c9c9',
				'color_links'                                     => '#000000',
				'color_links_hover'                               => '#ef562d',
				'colors_borders'                                  => '#EEEEEE',
				'colors_accent'                                   => '#F8F8F8',
				'color_headings'                                  => '#000000',
				'color_headings_links'                            => '#000000',
				'color_headings_links_hover'                      => '#A0A0A0',
				'color_headings_title_blocks'                     => '#000000',
				'color_btn_primary_text'                          => '#FFFFFF',
				'color_btn_primary_text_hover'                    => '#FFFFFF',
				'color_btn_primary_bg'                            => '#ef562d',
				'color_btn_primary_bg_hover'                      => '#ef562d',
				'color_btn_secondary_text'                        => '#A0A0A0',
				'color_btn_secondary_text_hover'                  => '#000000',
				'color_btn_secondary_bg'                          => '#EEEEEE',
				'color_btn_secondary_bg_hover'                    => '#F8F8F8',
				'colors_logo_text'                                => '#000000',
				'colors_logo_text_hover'                          => '#A0A0A0',
				'colors_logo_description'                         => '#A0A0A0',
				'colors_navbar_bg'                                => '#FFFFFF',
				'colors_navbar_main_links'                        => '#000000',
				'colors_navbar_main_links_hover'                  => '#ef562d',
				'colors_navbar_submenu_bg'                        => '#FFFFFF',
				'colors_navbar_submenu_borders'                   => '#EEEEEE',
				'colors_navbar_submenu_items_links'               => '#000000',
				'colors_navbar_submenu_items_links_hover'         => '#ef562d',
				'colors_navbar_submenu_items_links_active'        => '#ef562d',
				'colors_navbar_submenu_items_borders'             => '#EEEEEE',
				'colors_navbar_submenu_links_bg_hover'            => '#FFFFFF',
				'colors_navbar_submenu_links_bg_active'           => '#FFFFFF',
				'colors_topbar_bg'                                => '#FFFFFF',
				'colors_topbar_main_links'                        => '#A0A0A0',
				'colors_topbar_main_links_hover'                  => '#ef562d',
				'colors_topbar_social_icons'                      => '#ef562d',
				'colors_topbar_social_icons_hover'                => '#ef562d',
				'colors_topbar_social_text'                       => '#A0A0A0',
				'colors_topbar_social_text_hover'                 => '#000000',
				'colors_offcanvas_navbar_links'                   => '#000000',
				'colors_offcanvas_navbar_links_hover'             => '#ef562d',
				'colors_offcanvas_navbar_bg'                      => '#FFFFFF',
				'color_footer_bg'                                 => '#000000',
				'color_footer_text'                               => '#A0A0A0',
				'color_footer_title'                              => '#777777',
				'color_footer_link'                               => '#FFFFFF',
				'color_footer_link_hover'                         => '#A0A0A0',
				'color_footer_border'                             => '#242424',
				'color_footer_btn_text'                           => '#A0A0A0',
				'color_footer_btn_text_hover'                     => '#FFFFFF',
				'color_footer_btn_bg'                             => '#242424',
				'color_footer_btn_bg_hover'                       => '#141414',
				'color_misc_overlay'                              => 'rgba(44,47,48,0.25)',
				'color_misc_overlay_hover'                        => 'rgba(44,47,48,0.5)',
				'color_post_links'                                => '#ef562d',
				'color_post_links_hover'                          => '#000000',
				'color_category'                                  => '#ef562d',
				'color_category_hover'                            => '#000000',
				'color_selection_text'                            => '#FFFFFF',
				'color_selection_background'                      => '#ef562d',
				'color_blockquote'                                => '#292929',
				'color_leadin_dropcap'                            => '#292929',
				'colors_navbar_submenu_borders_toggle_next'       => true,
				'colors_navbar_submenu_items_borders_toggle_next' => true,
				'colors_topbar_bg_toggle_next'                    => false,
				'colors_navbar_borders'                           => true,
				'colors_topbar_borders'                           => true,
				'colors_offcanvas_borders'                        => true,
			),
		),
		'dark' => array(
			'label'    => esc_html__( 'Dark', 'authentic' ),
			'color'    => '#292929',
			'settings' => array(
				'color_body_bg'                                   => '#232323',
				'color_text'                                      => '#dbdbdb',
				'color_text_secondary'                            => '#595959',
				'color_links'                                     => '#CCCCCC',
				'color_links_hover'                               => '#FFFFFF',
				'colors_borders'                                  => '#2B2B2B',
				'colors_accent'                                   => '#1E1E1E',
				'color_headings'                                  => '#FFFFFF',
				'color_headings_links'                            => '#FFFFFF',
				'color_headings_links_hover'                      => '#CCCCCC',
				'color_headings_title_blocks'                     => '#FFFFFF',
				'color_btn_primary_text'                          => '#EEEEEE',
				'color_btn_primary_text_hover'                    => '#FFFFFF',
				'color_btn_primary_bg'                            => '#474747',
				'color_btn_primary_bg_hover'                      => '#282828',
				'color_btn_secondary_text'                        => '#A0A0A0',
				'color_btn_secondary_text_hover'                  => '#000000',
				'color_btn_secondary_bg'                          => '#EEEEEE',
				'color_btn_secondary_bg_hover'                    => '#F8F8F8',
				'colors_logo_text'                                => '#FFFFFF',
				'colors_logo_text_hover'                          => '#EEEEEE',
				'colors_logo_description'                         => '#888888',
				'colors_navbar_bg'                                => '#232323',
				'colors_navbar_main_links'                        => '#EEEEEE',
				'colors_navbar_main_links_hover'                  => '#FFFFFF',
				'colors_navbar_submenu_bg'                        => '#1E1E1E',
				'colors_navbar_submenu_borders'                   => '#1E1E1E',
				'colors_navbar_submenu_items_links'               => '#EEEEEE',
				'colors_navbar_submenu_items_links_hover'         => '#FFFFFF',
				'colors_navbar_submenu_items_links_active'        => '#FFFFFF',
				'colors_navbar_submenu_items_borders'             => '#2B2B2B',
				'colors_navbar_submenu_links_bg_hover'            => '#2B2B2B',
				'colors_navbar_submenu_links_bg_active'           => '#2B2B2B',
				'colors_topbar_bg'                                => '#232323',
				'colors_topbar_main_links'                        => '#dbdbdb',
				'colors_topbar_main_links_hover'                  => '#FFFFFF',
				'colors_topbar_social_icons'                      => '#FFFFFF',
				'colors_topbar_social_icons_hover'                => '#FFFFFF',
				'colors_topbar_social_text'                       => '#dbdbdb',
				'colors_topbar_social_text_hover'                 => '#FFFFFF',
				'colors_offcanvas_navbar_links'                   => '#EEEEEE',
				'colors_offcanvas_navbar_links_hover'             => '#FFFFFF',
				'colors_offcanvas_navbar_bg'                      => '#232323',
				'color_footer_bg'                                 => '#111111',
				'color_footer_text'                               => '#A0A0A0',
				'color_footer_title'                              => '#777777',
				'color_footer_link'                               => '#FFFFFF',
				'color_footer_link_hover'                         => '#A0A0A0',
				'color_footer_border'                             => '#242424',
				'color_footer_btn_text'                           => '#A0A0A0',
				'color_footer_btn_text_hover'                     => '#FFFFFF',
				'color_footer_btn_bg'                             => '#242424',
				'color_footer_btn_bg_hover'                       => '#141414',
				'color_misc_overlay'                              => 'rgba(44,47,48,0.25)',
				'color_misc_overlay_hover'                        => 'rgba(44,47,48,0.5)',
				'color_post_links'                                => '#CCCCCC',
				'color_post_links_hover'                          => '#FFFFFF',
				'color_category'                                  => '#FFFFFF',
				'color_category_hover'                            => '#CCCCCC',
				'color_selection_text'                            => '#000000',
				'color_selection_background'                      => '#EEEEEE',
				'color_blockquote'                                => '#FFFFFF',
				'color_leadin_dropcap'                            => '#FFFFFF',
				'colors_navbar_submenu_borders_toggle_next'       => true,
				'colors_navbar_submenu_items_borders_toggle_next' => true,
				'colors_topbar_bg_toggle_next'                    => false,
				'colors_navbar_borders'                           => true,
				'colors_topbar_borders'                           => true,
				'colors_offcanvas_borders'                        => true,
			),
		),
	);
	return $palettes;
}

add_filter( 'csco_color_palettes', 'csco_color_palettes' );
