<?php
/**
 * The template part for displaying related posts.
 *
 * @package Authentic
 */

$attrs = array();
$query = array();

$title           = get_theme_mod( 'post_carousel_title', esc_html__( 'You May Also Like', 'authentic' ) );
$slides          = get_theme_mod( 'post_carousel_slides', 8 );
$source          = get_theme_mod( 'post_carousel_source', 'all' );
$category_slug   = get_theme_mod( 'post_carousel_source_category_slug' );
$tag_slug        = get_theme_mod( 'post_carousel_source_tag_slug' );
$posts_slug      = get_theme_mod( 'post_carousel_source_posts_slug' );
$categories_only = get_theme_mod( 'post_carousel_current', true );
$orderby         = get_theme_mod( 'post_carousel_orderby', 'date' );
$time_frame      = get_theme_mod( 'post_carousel_time_frame', '' );
$orientation     = get_theme_mod( 'post_carousel_orientation', 'landscape' );
$heading         = get_theme_mod( 'post_carousel_heading', array( 'font-size' => '1rem' ) );

// Slides.
if ( $slides ) {
	$attrs['slides'] = sprintf( '"layout_carousel_slides":"%s"', $slides );
}

// Orientation.
if ( $orientation ) {
	$attrs['orientation'] = sprintf( '"layout_carousel_thumbnailOrientation":"%s"', $orientation );
}

// Categories only.
if ( $categories_only ) {
	if ( is_single() ) {

		// Get current post categories.
		$categories = get_the_terms( get_the_ID(), 'category' );

		$category__in = array();

		// Add category IDs to the array.
		foreach ( $categories as $category ) {
			$category__in[] = $category->slug;
		}

		// Add current post category IDs.
		$query['categories'] = sprintf( '"categories":"%s"', implode( ',', $category__in ) );
	}
} else {
	// Source.
	if ( 'category' === $source ) {

		$query['categories'] = sprintf( '"categories":"%s"', $category_slug );
	} elseif ( 'tag' === $source ) {

		$query['tags'] = sprintf( '"tags":"%s"', $tag_slug );
	} elseif ( 'posts' === $source ) {

		$query['posts'] = sprintf( '"posts":"%s"', $posts_slug );
	}
}

// Order By.
if ( $orderby ) {
	$query['orderby'] = sprintf( '"orderby":"%s"', $orderby );
}

// Time Frame.
if ( $time_frame ) {
	$query['time_frame'] = sprintf( '"time_frame":"%s"', $time_frame );
}

ob_start();
?>
	<section class="section-related-posts">
		<?php csco_section_heading( $title ); ?>

		<!-- wp:canvas/posts {
			<?php echo (string) implode( ',', $attrs ); // XSS. ?>,
			"canvasClassName":"pk-block-posts-single",
			"canvasLocation":"section-wide",
			"layout":"carousel",
			"layout_carousel_columns":3,
			"relatedPosts":true,
			"layout_carousel_typographyHeading":"1.125rem",
			"query":{"posts_type":"post","formats":"","offset":"","order":"DESC",<?php echo (string) implode( ',', $query ); // XSS. ?>}} /-->

		<style>
			.section-related-posts article .entry-title {
				font-size: <?php echo esc_attr( $heading['font-size'] ); ?>
			}
		</style>
	</section>
<?php
echo (string) do_blocks( ob_get_clean() ); // XSS.
