
	// =============================================================================
	// Mobile Categories
	// =============================================================================

	barberry.mobileCategories = function() {

		if( $(window).width() > 1024 ) return;

		var categories = $('.barberry-categories'),
		    subCategories = categories.find('li > ul'),
		    button = $('.barberry-show-categories'),
		    time = 200;

		$('body').on('click', '.barberry-show-categories', function(e) {
		    e.preventDefault();

		    if( isOpened() ) {
		        closeCats();
		    } else {
		            openCats();
		    }
		});

		$('body').on('click', '.list_shop_categories a, .list_blog_categories a', function(e) {
		    closeCats();
		    categories.stop().attr('style', '');
		});

		var isOpened = function() {
		    return $('.barberry-categories').hasClass('categories-opened');
		};

		var openCats = function() {


		    var tl = new TimelineMax(),
		        categories = $(".barberry-categories"),
		        categories_items = $(".barberry-categories li");

		        tl.fromTo(categories, 1, {"max-height":0,autoAlpha: 0}, {"max-height":1000,autoAlpha: 1,ease: Power4.easeIn}, 0);
		        tl.staggerFromTo(categories_items, 1, {opacity:0, scale:2, skewX:30}, {opacity:1, scale:1, skewX:0, ease: Back.easeOut}, .1, .3);
		        
		        setTimeout(function() {
		            $('.barberry-categories').addClass('categories-opened');
		            $('.barberry-show-categories').addClass('button-open');
		        }, 500);
 
		};

		var closeCats = function() {


		    var tl = new TimelineMax(),
		        categories = $(".barberry-categories"),
		        categories_items = $(".barberry-categories li");

		        tl.fromTo(categories, 1, {"max-height":1000,autoAlpha: 1}, {autoAlpha: 0, "max-height":0,ease: Power3.easeInOut}, 0);

		        setTimeout(function() {
			        $('.barberry-show-categories').removeClass('button-open');
			        $('.barberry-categories').removeClass('categories-opened');
		        }, 700);
		       
		};

	}