
  // =============================================================================
  // Page Header Animation
  // =============================================================================

  barberry.pageHeaderAnimation = function() {

	$('.page-header-bg').imagesLoaded( { background: true }, function() {
	  $('.page-header-bg-wrapper').addClass('bg-loaded');

		var	tl = new TimelineMax(),
			header = $(".header-sections"),
			topbar = $(".topbar"),
		  	page_title = $(".page-title"),
		  	subtitle = $(".term-description"),
		  	breadcrumbs = $(".breadcrumbs"),
		  	categories_bg = $(".shop-categories, .blog-categories, body.single .page-header .barberry-entry-meta ul.entry-meta-list"),
		  	delimiter = $(".page-title-delimiter"),
		  	arrow_back = $(".back-btn svg"),
		  	content = $(".content-area, .blog-content-area, .post-content-area"),
		  	pagination = $(".woocommerce-pagination, .products_ajax_button"),
		  	footer = $("#site-footer"),

	      	easing = BezierEasing(.1,.68,.32,1);

			tl.fromTo([header, topbar], 1, {autoAlpha:0,opacity:0}, {ease: Power4.easeInOut, autoAlpha:1, opacity:1}, .2);
			tl.fromTo(page_title, 1.2, {y:100, opacity:0}, {ease: Power4.easeInOut, y:0, opacity:1}, .3);
			tl.fromTo(subtitle, 1.4, {scale: 1.4, opacity:0}, {ease: Power4.easeInOut, scale: 1, opacity:1}, .2);
			tl.fromTo(arrow_back, 1, {x:20, opacity:0}, {ease: Power4.easeInOut,x:0, opacity:1}, .5);

			if ( barberry.$body.hasClass('woocommerce-shop') ) {
				tl.fromTo(breadcrumbs, 1.2, {y:40, opacity:0}, {ease: Power4.easeInOut,y:0, opacity:1}, .25);
			} else if ( barberry.$body.hasClass('single-product') ) {
				tl.fromTo(breadcrumbs, 1.2, {y:40, opacity:0}, {ease: Power4.easeInOut,y:0, opacity:1}, .6);
			} else {
				tl.fromTo(breadcrumbs, 1.2, {y:40, opacity:0}, {ease: Power4.easeInOut,y:0, opacity:1}, .25);
			}

			tl.fromTo(categories_bg, 1.4, {y:-40, opacity:0}, {ease: Power4.easeInOut,y:0, opacity:1}, .25);
			tl.fromTo(delimiter, 1, {opacity:0, width:0}, {opacity:1, width:70}, .8);
			tl.fromTo([content, pagination], 1, {opacity:0}, {opacity:1}, .8);
			tl.fromTo(footer, 1, {opacity:0}, {opacity:1}, 1.5);
	});	

	barberry.productInfoAnimation = function() {

		var	tl = new TimelineMax(),
			product_title = $(".product_title"),
			gallery = $(".product_layout #product-images .flickity-slider"),
			single_gallery = $(".product_layout #product-images"),			
			single_gallery_th = $(".single-product .product-thumbnails, .single-product .product-vr-thumbnails"),
		  	product_gallery_labels = $(".single-product .product-images-wrapper .product-labels"),
		  	product_sidebar = $("body.single-product .product_layout_default .sidebar-container"),		  	
		  	product_share = $(".single-product .box-share-master-container"),
		  	product_tool_buttons = $(".single-product .product_layout .product-images-inner .product_tool_buttons_placeholder, .product_layout.product_layout_style_3 .product-title-section-wrapper .product-title-section-right"),
		  	product_nav = $(".single-product .products-nav, .single-product .woocommerce-message"),

		  	product_summary_middle = $(".single-product .product_layout.product_layout_default .product-info-cell .product_summary_middle, .single-product .product_layout.product_layout_style_2 .product-info-cell .product_summary_middle, .product_layout.product_layout_style_3 .product-title-section-wrapper .product-title-section-wrapper-inner .product_summary_middle, .product_layout.product_layout_style_3 .product-info-cell, #barberry_woocommerce_quickview .product_summary_middle"),
		  	product_summary_bottom = $(".single-product .product_layout.product_layout_default .product-info-cell .product_summary_bottom, .single-product .product_layout.product_layout_style_2 .product-info-cell .product_summary_bottom, #barberry_woocommerce_quickview .product_summary_bottom");

		  	tl.fromTo(product_title, 1.6, {y:100, opacity:0}, {ease: Power4.easeInOut, y:0, opacity:1}, .7);
			tl.fromTo(gallery, 1, {opacity:0}, {ease: Power4.easeInOut, opacity:1}, 0);
			tl.fromTo(single_gallery, 2, {scale: 1.1, opacity:0}, {ease: Power4.easeInOut,scale: 1, opacity:1}, .3);
    		tl.fromTo(single_gallery_th, 1.4, {y:20, opacity:0}, {ease: Power4.easeInOut,y:0, opacity:1, onStart:thShadow }, 1);
			function thShadow () {
				setTimeout(function() {
					$('.single-product .product-thumbnails-container, .single-product .product-vr-thumbnails-container').addClass('shadow');
				}, 600);
	    	};

            tl.fromTo(product_summary_middle, 2, {y:40, opacity:0}, {ease: Power4.easeInOut,y:0, opacity:1 }, .8);
            tl.fromTo(product_summary_bottom, 2, {y:40, opacity:0}, {ease: Power4.easeInOut,y:0, opacity:1 }, 1);
            tl.fromTo([product_gallery_labels, product_share, product_tool_buttons, product_nav, product_sidebar], 2, {opacity:0}, {ease: Power4.easeInOut,opacity:1 }, .7);

	}
  }