<?php get_header(); ?>

<?php // Page title
get_template_part( 'template-parts/page-title' ); ?>

<!-- CORE COLUMNS : begin -->
<div class="core__columns core__columns--narrow">
	<div class="core__columns-inner">
		<div class="lsvr-container">
			<div class="core__columns-bg">

				<?php // Breadcrumbs
				get_template_part( 'template-parts/breadcrumbs' ); ?>

				<!-- MAIN : begin -->
				<main id="main">
					<div class="main__inner">

						<div <?php post_class( 'error-404-page' ); ?>>

							<!-- PAGE CONTENT : begin -->
							<div class="page__content">

								<!-- ERROR 404 PAGE : begin -->
								<div class="error-404-page__inner">

									<h2 class="error-404-page__title"><?php esc_html_e( '404', 'bluecollar' ); ?></h2>

									<div class="error-404-page__content">

										<?php lsvr_bluecollar_the_alert_message( esc_html__( 'The server can\'t find the page you requested. The page has either been moved to a different location or deleted, or you may have mistyped the URL.', 'bluecollar' ) ); ?>

										<?php // Add custom code after alert message
										do_action( 'lsvr_bluecollar_404_message_after' ); ?>

										<p class="error-404-page__button">
											<a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="error-404-page__button-link">
												<?php esc_html_e( 'Back to Homepage', 'bluecollar' ); ?>
											</a>
										</p>

									</div>

								</div>
								<!-- ERROR 404 PAGE : end -->

								<?php // Add custom code after page content
								do_action( 'lsvr_bluecollar_404_page_after' ); ?>

							</div>
							<!-- PAGE CONTENT : end -->

						</div>

					</div>
				</main>
				<!-- MAIN : end -->

			</div>
		</div>
	</div>
</div>
<!-- CORE COLUMNS : end -->

<?php get_footer(); ?>