/**
 * Table of contents
 *
 * 1. General
 * 2. Header
 * 3. Core
 * 4. Footer
 * 5. Core
 * 6. Other
 * 7. Plugins
 */

(function($){ "use strict";
$(document).on( 'ready', function() {

/* -----------------------------------------------------------------------------

	1. GENERAL

----------------------------------------------------------------------------- */

	/* -------------------------------------------------------------------------
		ANCHOR SCROLL ANIMATION
	-------------------------------------------------------------------------- */

	$( '.lsvr-has-anchor-scrolling-animations a[href^="#"]' ).each(function() {

		var $this = $(this),
			element = $this.attr( 'href' ),
			headerHeight = $( '.header--sticky' ).length > 0 ? $( '.header--sticky' ).height() + 10 : 0;

		if ( $( element ).length > 0 ) {
			$this.click(function(e){
				$( 'html, body' ).animate({
					'scrollTop' : $( element ).offset().top - headerHeight
				}, 500);
				return false;
			});
		}

	});

/* -----------------------------------------------------------------------------

	2. HEADER

----------------------------------------------------------------------------- */

	/* -------------------------------------------------------------------------
		STICKY HEADER
	-------------------------------------------------------------------------- */

	$( '.header--sticky' ).each(function() {

		if ( $.fn.lsvrBluecollarGetMediaQueryBreakpoint() > 991 ) {

			var $this = $(this),
				$placeholder = $( '.header__placeholder' ),
				headerHeight = $this.outerHeight();

			$placeholder.css( 'height', headerHeight );

		}

	});

	/* -------------------------------------------------------------------------
		HEADER SEARCH
	------------------------------------------------------------------------- */

	$( '.header-search' ).each(function() {

		var $this = $(this),
			$toggle = $this.find( '.header-search__toggle' ),
			$form = $this.find( '.header-search__form' ),
			$input = $this.find( '.c-search-form__input' );

		// Toggle form
		$toggle.on( 'click', function() {
			$form.fadeToggle( 100, function() {
				if ( $form.is( ':visible' ) ) {
					$input.focus();
				}
			});
			$(this).toggleClass( 'header-search__toggle--active' );
		});

		// Hide on click outside
		$(document).on( 'click', function(e) {
			if ( ! $( e.target ).closest( '.header-search' ).length && $.fn.lsvrBluecollarGetMediaQueryBreakpoint() > 1199 ) {
				$form.fadeOut( 100 );
				$toggle.removeClass( 'header-search__toggle--active' );
			}
		});

		// Reset state on screen transition
		$(document).on( 'lsvrBluecollarScreenTransition', function() {
			$toggle.removeClass( 'header-search__toggle--active' );
			$form.removeAttr( 'style' );
		});

	});

	/* -------------------------------------------------------------------------
		LANGUAGES MOBILE
	------------------------------------------------------------------------- */

	$( '.header-languages' ).each(function() {

		var $this = $(this);
		$this.clone().removeClass( 'header-topbar__item' ).addClass( 'header-languages--mobile' ).appendTo( '.header-topbar > .lsvr-container' );

	});

	/* -------------------------------------------------------------------------
		HEADER MENU
	------------------------------------------------------------------------- */

	$( '.header-menu-primary' ).each(function() {

		var $this = $(this),
			expandPopupLabel = $this.data( 'label-expand-popup' ),
			collapsePopupLabel = $this.data( 'label-collapse-popup' );

		// Hide desktop all submenus function
		function resetMenu() {
			$this.find( '.header-menu-primary__item' ).removeClass( 'header-menu-primary__item--hover header-menu-primary__item--active' );
			$this.find( '.header-menu-primary__item-link' ).attr( 'aria-expanded', false );
			$this.find( '.header-menu-primary__submenu' ).removeAttr( 'style' ).attr( 'aria-expanded', false );
			$this.find( '.header-menu-primary__submenu-toggle' ).removeClass( 'header-menu-primary__submenu-toggle--active' ).attr( 'title', expandPopupLabel ).attr( 'aria-expanded', false );
		}

		// Init mobile
		function initMobile() {
			$this.find( '.header-menu-primary__item-link' ).each(function() {
				if ( $(this).attr( 'aria-controls' ) ) {
					$(this).attr( 'data-aria-controls', $(this).attr( 'aria-controls' ) ).removeAttr( 'aria-controls' ).removeAttr( 'aria-owns' ).removeAttr( 'aria-haspopup' ).removeAttr( 'aria-expanded' );
				}
			});
		}

		// Init desktop
		function initDesktop() {
			$this.find( '.header-menu-primary__item-link' ).each(function() {
				if ( $(this).attr( 'data-aria-controls' ) ) {
					$(this).attr( 'aria-controls', $(this).attr( 'data-aria-controls' ) ).attr( 'aria-owns', $(this).attr( 'data-aria-controls' ) ).attr( 'aria-haspopup', true ).attr( 'aria-expanded', false );
				}
			});
		}

		// Init mobile version on refresh
		if ( $.fn.lsvrBluecollarGetMediaQueryBreakpoint() < 1200 ) {
			initMobile();
		}

		// Reset menu when click on link without submenu
		$this.find( '.header-menu-primary__item-link' ).each(function() {
			$(this).on( 'click', function() {
				if ( $(this).parent().find( '> .header-menu-primary__submenu' ).length < 1 ) {
					resetMenu();
				}
			});
		});

		// Parse submenus
		$this.find( '.header-menu-primary__submenu' ).each(function() {

			var $submenu = $(this),
				$parent = $submenu.parent(),
				$toggle = $parent.find( '> .header-menu-primary__submenu-toggle' ),
				$link = $parent.find( '> .header-menu-primary__item-link' ),
				type = $link.closest( '.header-menu-primary__item--megamenu' ).length > 0 ? 'megamenu' : 'dropdown';

			// Show desktop submenu function
			function desktopShowSubmenu() {
				$submenu.show();
				$submenu.attr( 'aria-expanded', true );
				$parent.addClass( 'header-menu-primary__item--hover' );
				$link.attr( 'aria-expanded', true );
			}

			// Hide desktop submenu function
			function desktopHideSubmenu() {
				$submenu.hide();
				$submenu.attr( 'aria-expanded', false );
				$parent.removeClass( 'header-menu-primary__item--hover' );
				$link.attr( 'aria-expanded', false );
			}

			// Show mobile submenu function
			function mobileShowSubmenu() {
				$submenu.slideDown( 150 );
				$submenu.attr( 'aria-expanded', true );
				$parent.addClass( 'header-menu-primary__item--active' );
				$toggle.attr( 'title', collapsePopupLabel ).attr( 'aria-expanded', true );
			}

			// Hide mobile submenu function
			function mobileHideSubmenu() {
				$submenu.slideUp( 150 );
				$submenu.attr( 'aria-expanded', false );
				$parent.removeClass( 'header-menu-primary__item--active' );
				$toggle.attr( 'title', expandPopupLabel ).attr( 'aria-expanded', false );
			}

			// Desktop interaction
			if ( ( 'dropdown' === type ) || ( 'megamenu' === type && $submenu.hasClass( 'header-menu-primary__submenu--level-0' ) ) ) {

				// Desktop mouseover and focus action
				$parent.on( 'mouseover focus', function() {
					if ( $.fn.lsvrBluecollarGetMediaQueryBreakpoint() > 1199 ) {
						desktopShowSubmenu();
					}
				});

				// Desktop mouseleave and blur action
				$parent.on( 'mouseleave blur', function() {
					if ( $.fn.lsvrBluecollarGetMediaQueryBreakpoint() > 1199 ) {
						desktopHideSubmenu();
					}
				});

				// Desktop click or key enter
				$link.on( 'click', function() {

					if ( $.fn.lsvrBluecollarGetMediaQueryBreakpoint() > 1199 && ! $parent.hasClass( 'header-menu-primary__item--hover' ) ) {

						// Hide opened submenus
						$parent.siblings( '.header-menu-primary__item.header-menu-primary__item--hover' ).each(function() {

							$(this).removeClass( 'header-menu-primary__item--hover' );
							$(this).find( '> .header-menu-primary__submenu' ).hide();
							$(this).find( '> .header-menu-primary__item-link' ).attr( 'aria-expanded', false );
							$(this).find( '> .header-menu-primary__submenu' ).attr( 'aria-expanded', false );

							if ( $(this).hasClass( 'header-menu-primary__item--dropdown' ) ) {

								$(this).find( '.header-menu-primary__item--hover' ).removeClass( 'header-menu-primary__item--hover' );
								$(this).find( '.header-menu-primary__submenu' ).hide();
								$(this).find( '.header-menu-primary__item-link' ).attr( 'aria-expanded', false );
								$(this).find( '.header-menu-primary__submenu' ).attr( 'aria-expanded', false );

							}

						});

						// Show submenu
						desktopShowSubmenu();

						// Hide on click outside
						$( 'html' ).on( 'click.lsvrBluecollarHeaderMenuPrimaryCloseSubmenuOnClickOutside touchstart.lsvrBluecollarHeaderMenuPrimaryCloseSubmenuOnClickOutside', function(e) {

							desktopHideSubmenu();
							$( 'html' ).unbind( 'click.lsvrBluecollarHeaderMenuPrimaryCloseSubmenuOnClickOutside touchstart.lsvrBluecollarHeaderMenuPrimaryCloseSubmenuOnClickOutside' );

						});

						// Disable link
						$parent.on( 'click touchstart', function(e) {
							e.stopPropagation();
						});
						return false;

					} else {
						resetMenu();
					}

				});

			}

			// Mobile interactions
			$toggle.on( 'click', function() {

				$toggle.toggleClass( 'header-menu-primary__submenu-toggle--active' );
				if ( $toggle.hasClass( 'header-menu-primary__submenu-toggle--active' ) ) {
					mobileShowSubmenu();
				} else {
					mobileHideSubmenu();
				}

			});

		});

		// Reset menu on ESC key
		$(document).on( 'keyup.lsvrBlueCollarHeaderMenuPrimaryCloseSubmenuOnEscKey', function(e) {

			if ( e.key === "Escape" ) {

				// Close active submenu
				if ( $( '*:focus' ).closest( '.header-menu-primary__item--hover, .header-menu-primary__item--active' ).length > 0 ) {

					$( '*:focus' ).closest( '.header-menu-primary__item--hover, .header-menu-primary__item--active' ).each(function() {

						$(this).removeClass( 'header-menu-primary__item--hover header-menu-primary__item--active' );
						$(this).find( '> .header-menu-primary__submenu' ).hide();
						$(this).find( '> .header-menu-primary__submenu' ).attr( 'aria-expanded', false );
						$(this).find( '> .header-menu-primary__submenu-toggle' ).removeClass( 'header-menu-primary__submenu-toggle--active' ).attr( 'title', expandPopupLabel ).attr( 'aria-expanded', false );
						if ( $.fn.lsvrBluecollarGetMediaQueryBreakpoint() > 1199 ) {
							$(this).find( '> .header-menu-primary__item-link' ).attr( 'aria-expanded', false );
							$(this).find( '> .header-menu-primary__item-link' ).focus();
						} else {
							$(this).find( '> .header-menu-primary__submenu-toggle' ).focus();
						}

					});

				}

				// Otherwise close all submenus
				else {

					$( '.header-menu-primary__item--hover, .header-menu-primary__item--active' ).each(function() {

						$(this).removeClass( 'header-menu-primary__item--hover header-menu-primary__item--active' );
						$(this).find( '> .header-menu-primary__submenu' ).hide();
						$(this).find( '> .header-menu-primary__submenu' ).attr( 'aria-expanded', false );
						$(this).find( '> .header-menu-primary__submenu-toggle' ).removeClass( 'header-menu-primary__submenu-toggle--active' ).attr( 'title', expandPopupLabel ).attr( 'aria-expanded', false );
						if ( $.fn.lsvrBluecollarGetMediaQueryBreakpoint() > 1199 ) {
							$(this).find( '> .header-menu-primary__item-link' ).attr( 'aria-expanded', false );
						}

					});

				}

			}

		});

		// Reset on screen transition
		$(document).on( 'lsvrBluecollarScreenTransition', function() {

			resetMenu();

			if ( $.fn.lsvrBluecollarGetMediaQueryBreakpoint() > 1199 ) {
				initDesktop();
			} else {
				initMobile();
			}

		});

	});

	/* -------------------------------------------------------------------------
		TOPBAR MOBILE TOGGLE
	------------------------------------------------------------------------- */

	$( '.header-topbar__toggle' ).each(function() {

		var $this = $(this),
			$topbar = $( '.header-topbar__inner' );

		$this.on( 'click', function() {
			$this.toggleClass( 'header-topbar__toggle--active' );
			$topbar.slideToggle( 100 );
		});

		// Remove inline styles on screen transition
		$(document).on( 'lsvrBluecollarScreenTransition', function() {
			$this.removeClass( 'header-topbar__toggle--active' );
			$topbar.removeAttr( 'style' );
		});

	});

	/* -------------------------------------------------------------------------
		HEADER MENU MOBILE TOGGLE
	------------------------------------------------------------------------- */

	$( '.header-menu-primary__toggle' ).each(function() {

		var $this = $(this),
			$menu = $( '.header-menu-primary' ),
			$branding = $( '.header-branding__inner > *:nth-child( 2 )' );

		$this.on( 'click', function() {

			$this.toggleClass( 'header-menu-primary__toggle--active' );
			$menu.slideToggle( 100 );

			if ( $.fn.lsvrBluecollarGetMediaQueryBreakpoint() < 768 ) {
				$branding.slideToggle( 100 );
			}

		});

		// Remove inline styles on screen transition
		$(document).on( 'lsvrBluecollarScreenTransition', function() {
			$this.removeClass( 'header-menu-primary__toggle--active' );
			$menu.removeAttr( 'style' );
			$branding.removeAttr( 'style' );
		});

	});


/* -----------------------------------------------------------------------------

	3. CORE

----------------------------------------------------------------------------- */

	/* -------------------------------------------------------------------------
		PAGE TITLE
	------------------------------------------------------------------------- */

	// parallax effect
	if ( $.fn.lsvrBluecollarParallax ) {
		$( '.lsvr-has-parallax .page-title' ).each(function() {
			$(this).lsvrBluecollarParallax( '50%', 0.3 );
		});
	}

	/* -------------------------------------------------------------------------
		BLOG
	------------------------------------------------------------------------- */

	// Archive masonry
	if ( $.fn.masonry ) {
		$( '.blog-post-archive--is-masonry .post-archive__list' ).each(function() {

			var $this = $(this),
				isRTL = $( 'html' ).attr( 'dir' ) && 'rtl' === $( 'html' ).attr( 'dir' ) ? true : false;

			// Wait for images to load
			$this.imagesLoaded(function() {
				$this.masonry({
					isRTL: isRTL
				});
			});

		});
	}

	/* -------------------------------------------------------------------------
		SERVICE
	------------------------------------------------------------------------- */

	// Archive masonry
	if ( $.fn.masonry ) {
		$( '.lsvr_service-post-archive--is-masonry .post-archive__list' ).each(function() {

			var $this = $(this),
				isRTL = $( 'html' ).attr( 'dir' ) && 'rtl' === $( 'html' ).attr( 'dir' ) ? true : false;

			// Wait for images to load
			$this.imagesLoaded(function() {
				$this.masonry({
					isRTL: isRTL
				});
			});

		});
	}

	/* -------------------------------------------------------------------------
		PORTFOLIO
	------------------------------------------------------------------------- */

	// Archive masonry
	if ( $.fn.masonry ) {
		$( '.lsvr_project-post-archive--is-masonry .post-archive__list' ).each(function() {

			var $this = $(this),
				isRTL = $( 'html' ).attr( 'dir' ) && 'rtl' === $( 'html' ).attr( 'dir' ) ? true : false;

			// Wait for images to load
			$this.imagesLoaded(function() {
				$this.masonry({
					isRTL: isRTL
				});
			});

		});
	}

	// Single masonry
	if ( $.fn.masonry && $.fn.imagesLoaded ) {
		$( '.lsvr_project-post-single .post__image-list' ).each(function() {

			var $this = $(this),
				isRTL = $( 'html' ).attr( 'dir' ) && 'rtl' === $( 'html' ).attr( 'dir' ) ? true : false;

			// Wait for images to load
			$this.imagesLoaded(function() {
				$this.masonry({
					isRTL: isRTL
				});
			});

		});
	}

	/* -------------------------------------------------------------------------
		GALLERIES
	------------------------------------------------------------------------- */

	// Detail masonry
	if ( $.fn.masonry && $.fn.imagesLoaded ) {
		$( '.lsvr_gallery-post-single .post__image-list' ).each(function() {

			var $this = $(this),
				isRTL = $( 'html' ).attr( 'dir' ) && 'rtl' === $( 'html' ).attr( 'dir' ) ? true : false;

			// Wait for images to load
			$this.imagesLoaded(function() {
				$this.masonry({
					isRTL: isRTL
				});
			});

		});
	}

	/* -------------------------------------------------------------------------
		PEOPLE
	------------------------------------------------------------------------- */

	// Archive masonry
	if ( $.fn.masonry ) {
		$( '.lsvr_person-post-archive--is-masonry .post-archive__list' ).each(function() {

			var $this = $(this),
				isRTL = $( 'html' ).attr( 'dir' ) && 'rtl' === $( 'html' ).attr( 'dir' ) ? true : false;

			// Init masonry
			$this.masonry({
				isRTL: isRTL
			});

		});
	}

	/* -------------------------------------------------------------------------
		TESTIMONIALS
	------------------------------------------------------------------------- */

	// Archive masonry
	if ( $.fn.masonry ) {
		$( '.lsvr_testimonial-post-archive--is-masonry .post-archive__list' ).each(function() {

			var $this = $(this),
				isRTL = $( 'html' ).attr( 'dir' ) && 'rtl' === $( 'html' ).attr( 'dir' ) ? true : false;

			// Init masonry
			$this.masonry({
				isRTL: isRTL
			});

		});
	}

	/* -------------------------------------------------------------------------
		FAQ
	------------------------------------------------------------------------- */

	// Expandable posts
	$( '.lsvr_faq-post-archive--is-expandable .post-archive__list > .post' ).each(function() {

		var $this = $(this),
			$parent = $this.parent(),
			$header = $this.find( '.post__header' ),
			$content = $this.find( '.post__content-wrapper' );

		// Toggle
		$header.on( 'click', function() {
			$content.slideToggle( 200 );
			$this.toggleClass( 'post--expanded' );
		});

	});


/* -----------------------------------------------------------------------------

	4. FOOTER

----------------------------------------------------------------------------- */

	// Parallax
	if ( $.fn.lsvrBluecollarParallax ) {
		$( '.lsvr-has-parallax #footer' ).each(function() {
			$(this).lsvrBluecollarParallax( '50%', 0.3 );
		});
	}


/* -----------------------------------------------------------------------------

	5. ELEMENTS

----------------------------------------------------------------------------- */

	/* -------------------------------------------------------------------------
		FAQ
	------------------------------------------------------------------------- */

	// Parallax
	if ( $.fn.lsvrBluecollarParallax ) {
		$( '.lsvr-has-parallax .lsvr-bluecollar-faq__bg' ).each(function() {
			$(this).lsvrBluecollarParallax( '50%', 0.3 );
		});
	}

	// Expandable posts
	$( '.lsvr-bluecollar-faq__post' ).each(function() {

		var $this = $(this),
			$parent = $this.parent(),
			$header = $this.find( '.lsvr-bluecollar-faq__post-header' ),
			$content = $this.find( '.lsvr-bluecollar-faq__post-content-wrapper' );

		// Toggle
		$header.on( 'click', function() {
			$content.slideToggle( 200 );
			$this.toggleClass( 'lsvr-bluecollar-faq__post--expanded' );
		});

	});

	/* -------------------------------------------------------------------------
		POSTS
	------------------------------------------------------------------------- */

	// Parallax
	if ( $.fn.lsvrBluecollarParallax ) {
		$( '.lsvr-has-parallax .lsvr-bluecollar-posts__bg' ).each(function() {
			$(this).lsvrBluecollarParallax( '50%', 0.3 );
		});
	}

	// Masonry
	if ( $.fn.masonry && $.fn.imagesLoaded ) {
		$( '.lsvr-bluecollar-posts--is-masonry .lsvr-bluecollar-posts__list' ).each(function() {

			var $this = $(this),
				isRTL = $( 'html' ).attr( 'dir' ) && 'rtl' === $( 'html' ).attr( 'dir' ) ? true : false;

			// Wait for images to load
			$this.imagesLoaded(function() {
				$this.masonry({
					isRTL: isRTL
				});
			});

		});
	}

	/* -------------------------------------------------------------------------
		PROJECTS
	------------------------------------------------------------------------- */

	// Parallax
	if ( $.fn.lsvrBluecollarParallax ) {
		$( '.lsvr-has-parallax .lsvr-bluecollar-projects__bg' ).each(function() {
			$(this).lsvrBluecollarParallax( '50%', 0.3 );
		});
	}

	// Masonry
	if ( $.fn.masonry && $.fn.imagesLoaded ) {
		$( '.lsvr-bluecollar-projects--is-masonry .lsvr-bluecollar-projects__list' ).each(function() {

			var $this = $(this),
				isRTL = $( 'html' ).attr( 'dir' ) && 'rtl' === $( 'html' ).attr( 'dir' ) ? true : false;

			// Wait for images to load
			$this.imagesLoaded(function() {
				$this.masonry({
					isRTL: isRTL
				});
			});

		});
	}

	/* -------------------------------------------------------------------------
		SERVICES
	------------------------------------------------------------------------- */

	// Parallax
	if ( $.fn.lsvrBluecollarParallax ) {
		$( '.lsvr-has-parallax .lsvr-bluecollar-services__bg' ).each(function() {
			$(this).lsvrBluecollarParallax( '50%', 0.3 );
		});
	}

	/* -------------------------------------------------------------------------
		TESTIMONIALS
	------------------------------------------------------------------------- */

	// Parallax
	if ( $.fn.lsvrBluecollarParallax ) {
		$( '.lsvr-has-parallax .lsvr-bluecollar-testimonials__bg' ).each(function() {
			$(this).lsvrBluecollarParallax( '50%', 0.3 );
		});
	}

	// Masonry
	if ( $.fn.masonry && $.fn.imagesLoaded ) {
		$( '.lsvr-bluecollar-testimonials--is-masonry .lsvr-bluecollar-testimonials__list' ).each(function() {

			var $this = $(this),
				isRTL = $( 'html' ).attr( 'dir' ) && 'rtl' === $( 'html' ).attr( 'dir' ) ? true : false;

			// Wait for images to load
			$this.imagesLoaded(function() {
				$this.masonry({
					isRTL: isRTL
				});
			});

		});
	}


/* -----------------------------------------------------------------------------

	6. OTHER

----------------------------------------------------------------------------- */

	/* -------------------------------------------------------------------------
		MAGNIFIC POPUP
	------------------------------------------------------------------------- */

	if ( $.fn.magnificPopup ) {

		// Lightbox config
		if ( 'undefined' !== typeof lsvr_bluecollar_js_labels && lsvr_bluecollar_js_labels.hasOwnProperty( 'magnific_popup' ) ) {

			var js_strings = lsvr_bluecollar_js_labels.magnific_popup;
			$.extend( true, $.magnificPopup.defaults, {
				tClose: js_strings.mp_tClose,
				tLoading: js_strings.mp_tLoading,
				gallery: {
					tPrev: js_strings.mp_tPrev,
					tNext: js_strings.mp_tNext,
					tCounter: '%curr% / %total%'
				},
				image: {
					tError: js_strings.mp_image_tError,
				},
				ajax: {
					tError: js_strings.mp_ajax_tError,
				}
			});

		}

		// Init lightbox
		$( '.lsvr-open-in-lightbox, body:not( .elementor-page ) .gallery .gallery-item a, .wp-block-gallery .blocks-gallery-item a' ).magnificPopup({
			type: 'image',
			removalDelay: 300,
			mainClass: 'mfp-fade',
			gallery: {
				enabled: true
			}
		});

	}


});
})(jQuery);

(function($){ "use strict";

/* -----------------------------------------------------------------------------

	7. PLUGINS

----------------------------------------------------------------------------- */

	/* -------------------------------------------------------------------------
		MEDIA QUERY BREAKPOINT
	------------------------------------------------------------------------- */

	if ( ! $.fn.lsvrBluecollarGetMediaQueryBreakpoint ) {
		$.fn.lsvrBluecollarGetMediaQueryBreakpoint = function() {

			if ( $( '#lsvr-media-query-breakpoint' ).length < 1 ) {
				$( 'body' ).append( '<span id="lsvr-media-query-breakpoint" style="display: none;"></span>' );
			}
			var value = $( '#lsvr-media-query-breakpoint' ).css( 'font-family' );
			if ( typeof value !== 'undefined' ) {
				value = value.replace( "\"", "" ).replace( "\"", "" ).replace( "\'", "" ).replace( "\'", "" );
			}
			if ( isNaN( value ) ) {
				return $( window ).width();
			}
			else {
				return parseInt( value );
			}

		};
	}

	var lsvrBluecollarMediaQueryBreakpoint;
	if ( $.fn.lsvrBluecollarGetMediaQueryBreakpoint ) {
		lsvrBluecollarMediaQueryBreakpoint = $.fn.lsvrBluecollarGetMediaQueryBreakpoint();
		$(window).resize(function(){
			if ( $.fn.lsvrBluecollarGetMediaQueryBreakpoint() !== lsvrBluecollarMediaQueryBreakpoint ) {
				lsvrBluecollarMediaQueryBreakpoint = $.fn.lsvrBluecollarGetMediaQueryBreakpoint();
				$.event.trigger({
					type: 'lsvrBluecollarScreenTransition',
					message: 'Screen transition completed.',
					time: new Date()
				});
			}
		});
	}
	else {
		lsvrBluecollarMediaQueryBreakpoint = $(document).width();
	}


	/* -------------------------------------------------------------------------
		PARALLAX
	------------------------------------------------------------------------- */

	if ( ! $.fn.lsvrBluecollarParallax ) {
		$.fn.lsvrBluecollarParallax = function( xPosition, inertia ) {
			if ( $.fn.parallax ) {

				// WebKit "background-attachment:fixed" bug fix
				if ( 'WebkitAppearance' in document.documentElement.style ) {
					$(this).fadeOut(1).fadeIn(1);
				}

				// Apply parallax
				if ( lsvrBluecollarMediaQueryBreakpoint > 1199 ) {

					$(this).parallax( xPosition, inertia );
				}

			}
		};
	}

})(jQuery);