<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta http-equiv="Content-Type" content="<?php bloginfo( 'html_type' ); ?>; charset=<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

	<!-- WRAPPER : begin -->
	<div id="wrapper">

		<?php // Add custom code before Header
		do_action( 'lsvr_bluecollar_header_before' ); ?>

		<!-- HEADER : begin -->
		<header id="header" <?php lsvr_bluecollar_the_header_class(); ?>>
			<div class="header__inner">

				<?php // Add custom code at the top of Header
				do_action( 'lsvr_bluecollar_header_top' ); ?>

				<?php // Header topbar
				get_template_part( 'template-parts/header/topbar' ); ?>

				<!-- HEADER NAVBAR : begin -->
				<div class="header-navbar">
					<div class="lsvr-container">
						<div class="header-navbar__inner">

							<?php // Add custom code at the top of the Header navbar
							do_action( 'lsvr_bluecollar_header_navbar_top' ); ?>

							<?php // Header branding
							get_template_part( 'template-parts/header/branding' ); ?>

							<?php // Add custom code after the Header branding
							do_action( 'lsvr_bluecollar_header_branding_after' ); ?>

							<?php // Primary header menu
							get_template_part( 'template-parts/header/menu-primary' ); ?>

							<?php // Add custom code at the bottom of the Header navbar
							do_action( 'lsvr_bluecollar_header_navbar_bottom' ); ?>

						</div>
					</div>
				</div>
				<!-- HEADER NAVBAR : end -->

				<?php // Add custom code at the bottom of Header
				do_action( 'lsvr_bluecollar_header_bottom' ); ?>

			</div>
		</header>

		<?php // Add custom code after Header
		do_action( 'lsvr_bluecollar_header_after' ); ?>

		<!-- CORE : begin -->
		<div id="core" <?php lsvr_bluecollar_core_class(); ?>>
			<div class="core__inner">