<?php

/**
 * GENERAL
 */

	// Load Google Fonts
	add_action( 'lsvr_bluecollar_load_assets', 'lsvr_bluecollar_load_google_fonts_css' );
	if ( ! function_exists( 'lsvr_bluecollar_load_google_fonts_css' ) ) {
		function lsvr_bluecollar_load_google_fonts_css() {

			if ( true === get_theme_mod( 'typography_google_fonts_enable', true ) ) {

				// Prepare query params
				$primary_font = get_theme_mod( 'typography_primary_font', 'Source+Sans+Pro' );
				$primary_font_variants = '400,400italic,600,600italic,700,700italic';
				$secondary_font = get_theme_mod( 'typography_secondary_font', 'Exo+2' );
				$secondary_font_variants = '400,400italic,700,700italic';
				$family_param = $primary_font !== $secondary_font ? $primary_font . ':' . $primary_font_variants . '|' . $secondary_font . ':' . $secondary_font_variants : $primary_font . ':' . $primary_font_variants;
				$subset = get_theme_mod( 'typography_font_subsets' );
				$subset_param = ! empty( $subset ) && is_string( $subset ) ? $subset : '';

				// Create query
				$query_args = array(
					'family' => $family_param,
					'subset' => $subset_param,
				);
				$query_args = array_filter( $query_args );

				// Enqueue fonts
				if ( ! empty( $query_args ) ) {
					wp_enqueue_style( 'lsvr-bluecollar-google-fonts', add_query_arg( $query_args, '//fonts.googleapis.com/css' ) );
				}

				// Primary font style
				$primary_font_elements = array( 'body', 'input', 'textarea', 'select', 'button', '#cancel-comment-reply-link' );
				$primary_font_family = str_replace( '+', ' ', $primary_font );
				$primary_font_css = implode( ', ', $primary_font_elements ) . ' { font-family: \'' . esc_attr( $primary_font_family ) . '\', Arial, sans-serif; }';
				wp_add_inline_style( 'lsvr-bluecollar-general-style', $primary_font_css );
				wp_add_inline_style( 'lsvr-bluecollar-general-style', 'html, body { font-size: ' . esc_attr( get_theme_mod( 'typography_base_font_size', '16' ) ) . 'px; }' );

				// Secondary font style
				if ( $primary_font !== $secondary_font ) {
					$secondary_font_elements = array( 'h1', 'h2', 'h3', 'h4', '.is-secondary-font' );
					$secondary_font_family = str_replace( '+', ' ', $secondary_font );
					$secondary_font_css = implode( ', ', $secondary_font_elements ) . ' { font-family: \'' . esc_attr( $secondary_font_family ) . '\', Arial, sans-serif; }';
					wp_add_inline_style( 'lsvr-bluecollar-general-style', $secondary_font_css );
				}

			}

		}
	}

	// Load editor Google Fonts
	add_action( 'lsvr_bluecollar_load_editor_assets', 'lsvr_bluecollar_load_editor_google_fonts_css' );
	if ( ! function_exists( 'lsvr_bluecollar_load_editor_google_fonts_css' ) ) {
		function lsvr_bluecollar_load_editor_google_fonts_css() {

			if ( true === get_theme_mod( 'typography_google_fonts_enable', true ) ) {

				// Prepare query params
				$primary_font = get_theme_mod( 'typography_primary_font', 'Source+Sans+Pro' );
				$primary_font_variants = '400,400italic,600,600italic,700,700italic';
				$secondary_font = get_theme_mod( 'typography_secondary_font', 'Exo+2' );
				$secondary_font_variants = '400,400italic,700,700italic';
				$family_param = $primary_font !== $secondary_font ? $primary_font . ':' . $primary_font_variants . '|' . $secondary_font . ':' . $secondary_font_variants : $primary_font . ':' . $primary_font_variants;
				$subset = get_theme_mod( 'typography_font_subsets' );
				$subset_param = ! empty( $subset ) && is_string( $subset ) ? $subset : '';

				// Create query
				$query_args = array(
					'family' => $family_param,
					'subset' => $subset_param,
				);
				$query_args = array_filter( $query_args );

				// Enqueue fonts
				if ( ! empty( $query_args ) ) {
					wp_enqueue_style( 'lsvr-bluecollar-google-fonts', add_query_arg( $query_args, '//fonts.googleapis.com/css' ) );
				}

				// Primary font style
				$primary_font_elements = array( 'body .editor-styles-wrapper', '.editor-styles-wrapper', '.editor-styles-wrapper button' );
				$primary_font_family = str_replace( '+', ' ', $primary_font );
				$primary_font_css = implode( ', ', $primary_font_elements ) . ' { font-family: \'' . esc_attr( $primary_font_family ) . '\', Arial, sans-serif; }';
				wp_add_inline_style( 'lsvr-bluecollar-editor-style', $primary_font_css );
				wp_add_inline_style( 'lsvr-bluecollar-editor-style', 'body .editor-styles-wrapper, .editor-styles-wrapper { font-size: ' . esc_attr( get_theme_mod( 'typography_base_font_size', '16' ) ) . 'px; }' );

				// Secondary font style
				if ( $primary_font !== $secondary_font ) {
					$secondary_font_elements = array( '.editor-styles-wrapper h1', '.editor-styles-wrapper h2', '.editor-styles-wrapper h3', '.editor-styles-wrapper h4', '.editor-styles-wrapper .is-secondary-font' );
					$secondary_font_family = str_replace( '+', ' ', $secondary_font );
					$secondary_font_css = implode( ', ', $secondary_font_elements ) . ' { font-family: \'' . esc_attr( $secondary_font_family ) . '\', Arial, sans-serif; }';
					wp_add_inline_style( 'lsvr-bluecollar-editor-style', $secondary_font_css );
				}

			}

		}
	}

	// Set logo dimensions
	add_action( 'lsvr_bluecollar_load_assets', 'lsvr_bluecollar_set_logo_dimensions' );
	if ( ! function_exists( 'lsvr_bluecollar_set_logo_dimensions' ) ) {
		function lsvr_bluecollar_set_logo_dimensions() {

			$max_width = get_theme_mod( 'header_logo_max_width', 50 );
			if ( ! empty( $max_width ) ) {
				wp_add_inline_style( 'lsvr-bluecollar-general-style', '.header-logo__link { max-width: ' . esc_attr( $max_width ) . 'px; }' );
			}

		}
	}

	// Load skin CSS
	add_action( 'lsvr_bluecollar_load_assets', 'lsvr_bluecollar_load_skin_css' );
	if ( ! function_exists( 'lsvr_bluecollar_load_skin_css' ) ) {
		function lsvr_bluecollar_load_skin_css() {

			$version = wp_get_theme( 'bluecollar' );
			$version = $version->Version;

			// Load predefined color skin
			if ( 'predefined' === get_theme_mod( 'colors_method', 'predefined' ) || 'custom-colors' === get_theme_mod( 'colors_method', 'predefined' ) ) {
				$skin_file = get_theme_mod( 'colors_predefined_skin', 'default' );
				wp_enqueue_style( 'lsvr-bluecollar-color-scheme', get_template_directory_uri() . '/assets/css/skins/' . esc_attr( $skin_file ) . '.css', array( 'lsvr-bluecollar-general-style' ), $version );
			}

			// Generate CSS from custom colors
			if ( 'custom-colors' === get_theme_mod( 'colors_method', 'predefined' ) ) {
				wp_add_inline_style( 'lsvr-bluecollar-color-scheme', lsvr_bluecollar_get_custom_colors_css() );
			}

		}
	}

	// Load editor skin CSS
	add_action( 'lsvr_bluecollar_load_editor_assets', 'lsvr_bluecollar_load_editor_skin_css' );
	if ( ! function_exists( 'lsvr_bluecollar_load_editor_skin_css' ) ) {
		function lsvr_bluecollar_load_editor_skin_css() {

			$version = wp_get_theme( 'bluecollar' );
			$version = $version->Version;

			// Load predefined editor color skin
			if ( 'predefined' === get_theme_mod( 'colors_method', 'predefined' ) || 'custom-colors' === get_theme_mod( 'colors_method', 'predefined' ) ) {
				$skin_file = get_theme_mod( 'colors_predefined_skin', 'default' );
				wp_enqueue_style( 'lsvr-bluecollar-editor-color-scheme', get_template_directory_uri() . '/assets/css/skins/' . esc_attr( $skin_file ) . '.editor.css', array( 'lsvr-bluecollar-editor-style' ), $version );
			}

			// Generate CSS from custom colors
			if ( 'custom-colors' === get_theme_mod( 'colors_method', 'predefined' ) ) {
				wp_add_inline_style( 'lsvr-bluecollar-editor-color-scheme', lsvr_bluecollar_get_custom_colors_css( true ) );
			}

		}
	}

	// Load JS labels
	add_action( 'lsvr_bluecollar_load_assets', 'lsvr_bluecollar_load_js_labels' );
	if ( ! function_exists( 'lsvr_bluecollar_load_js_labels' ) ) {
		function lsvr_bluecollar_load_js_labels() {

			$js_labels = array();

			// Magnific popup JS labels
			if ( true === apply_filters( 'lsvr_bluecollar_default_lightbox_enable', true ) ) {
				$js_labels[ 'magnific_popup' ] = array(
					'mp_tClose' => esc_html__( 'Close (Esc)', 'bluecollar' ),
					'mp_tLoading' => esc_html__( 'Loading...', 'bluecollar' ),
					'mp_tPrev' => esc_html__( 'Previous (Left arrow key)', 'bluecollar' ),
					'mp_tNext' => esc_html__( 'Next (Right arrow key)', 'bluecollar' ),
					'mp_image_tError' => esc_html__( 'The image could not be loaded.', 'bluecollar' ),
					'mp_ajax_tError' => esc_html__( 'The content could not be loaded.', 'bluecollar' ),
				);
			}

			// Apply filters
			$js_labels = array_merge( $js_labels, apply_filters( 'lsvr_bluecollar_add_js_labels', array() ) );

			// Convert to JS
			if ( ! empty( $js_labels ) ) {
				wp_add_inline_script( 'lsvr-bluecollar-main-scripts', 'var lsvr_bluecollar_js_labels = ' . json_encode( $js_labels ) );
			}

		}
	}

	// Load Masonry JS files
	add_action( 'lsvr_bluecollar_load_assets', 'lsvr_bluecollar_load_masonry_js' );
	if ( ! function_exists( 'lsvr_bluecollar_load_masonry_js' ) ) {
		function lsvr_bluecollar_load_masonry_js() {

			if ( is_page() ||
				( true === get_theme_mod( 'blog_archive_masonry_enable', false ) && lsvr_bluecollar_is_blog() && ! is_singular( 'post' ) ) ) {
				wp_enqueue_script( 'masonry' );
			}

		}
	}

	// Enable parallax effects
	add_filter( 'body_class', 'lsvr_bluecollar_parallax_enable' );
	if ( ! function_exists( 'lsvr_bluecollar_parallax_enable' ) ) {
		function lsvr_bluecollar_parallax_enable( $body_class ) {

			if ( true === get_theme_mod( 'parallax_effects_enable', true ) ) {
				array_push( $body_class, 'lsvr-has-parallax' );
			}

			return $body_class;

		}
	}

	// Enable anchor scroll animation
	add_filter( 'body_class', 'lsvr_bluecollar_anchor_scroll_animation_enable' );
	if ( ! function_exists( 'lsvr_bluecollar_anchor_scroll_animation_enable' ) ) {
		function lsvr_bluecollar_anchor_scroll_animation_enable( $body_class ) {

			array_push( $body_class, 'lsvr-has-anchor-scrolling-animations' );
			return $body_class;

		}
	}

	// Enable strong tag in widget titles
	add_filter( 'widget_title', 'lsvr_bluecollar_widget_title_tags' );
	if ( ! function_exists( 'lsvr_bluecollar_widget_title_tags' ) ) {
		function lsvr_bluecollar_widget_title_tags( $title ) {
			$title = str_replace( '[', '<', $title );
			$title = str_replace( '[/', '</', $title );
			$title = str_replace( 'strong]', 'strong>', $title );
			return $title;
		}
	}

	// Set current post type
	add_filter( 'lsvr_bluecollar_current_post_type', 'lsvr_bluecollar_blog_set_current_post_type' );
	if ( ! function_exists( 'lsvr_bluecollar_blog_set_current_post_type' ) ) {
		function lsvr_bluecollar_blog_set_current_post_type( $post_type ) {

			if ( lsvr_bluecollar_is_blog() ) {
				return 'post';
			}
			return $post_type;

		}
	}


/**
 * HEADER
 */

	// Add sticky header placeholder
	add_action( 'lsvr_bluecollar_header_after', 'lsvr_bluecollar_sticky_header_placeholder' );
	if ( ! function_exists( 'lsvr_bluecollar_sticky_header_placeholder' ) ) {
		function lsvr_bluecollar_sticky_header_placeholder() {
		    if ( true === get_theme_mod( 'header_sticky_enable', false ) ) {
		        echo '<div class="header__placeholder"></div>';
		    }
		}
	}


/**
 * CORE
 */

	// Page title
	add_filter( 'lsvr_bluecollar_page_title_title', 'lsvr_bluecollar_page_title' );
	if ( ! function_exists( 'lsvr_bluecollar_page_title' ) ) {
		function lsvr_bluecollar_page_title( $title ) {

			if ( is_category() || is_tax() ) {
				return single_term_title( '', false );
			} elseif ( lsvr_bluecollar_is_blog() && ! is_singular( 'post' ) ) {
				return lsvr_bluecollar_get_blog_archive_title();
			} elseif ( is_search() ) {
				return esc_html__( 'Search Results', 'bluecollar' );
			} elseif ( is_404() ) {
				return esc_html__( 'Page Not Found', 'bluecollar' );
			} else {
				return get_the_title();
			}

			return $title;

		}
	}

	// pre_get_posts actions
	add_action( 'pre_get_posts', 'lsvr_bluecollar_pre_get_posts' );
	if ( ! function_exists( 'lsvr_bluecollar_pre_get_posts' ) ) {
		function lsvr_bluecollar_pre_get_posts( $query ) {

			// Search results
			if ( ! is_admin() && $query->is_search() && $query->is_main_query() ) {

				// Posts per page
				if ( 0 === (int) get_theme_mod( 'search_results_posts_per_page', 10 ) ) {
					$query->set( 'posts_per_page', 1000 );
				} else {
					$query->set( 'posts_per_page', esc_attr( get_theme_mod( 'search_results_posts_per_page', 10 ) ) );
				}

			}

		}
	}

	// Get breadcrumbs
	add_filter( 'lsvr_bluecollar_breadcrumbs', 'lsvr_bluecollar_breadcrumbs' );
	if ( ! function_exists( 'lsvr_bluecollar_breadcrumbs' ) ) {
		function lsvr_bluecollar_breadcrumbs() {

			global $wp_query, $post;
			$breadcrumbs = [];

			// Home link
			$breadcrumbs[] = array(
				'url' => esc_url( home_url( '/' ) ),
				'label' => esc_html__( 'Home', 'bluecollar' ),
			);

			// Blog root for blog pages
			if ( get_option( 'page_for_posts' ) ) {
				$blog_root = array(
					'url' => get_permalink( get_option( 'page_for_posts' ) ),
					'label' => get_the_title( get_option( 'page_for_posts' ) ),
				);
			}
			else {
				$blog_root = array(
					'url' => esc_url( home_url( '/' ) ),
					'label' => esc_html__( 'Blog', 'bluecollar' ),
				);
			}

			// Blog
			if ( is_tag() || is_day() || is_month() || is_year() || is_author() || is_singular( 'post' ) ) {
				array_push( $breadcrumbs, $blog_root );
			}

			// Blog category
			else if ( is_category() ) {
				$breadcrumbs[] = $blog_root;
				$current_term = $wp_query->queried_object;
				$current_term_id = $current_term->term_id;
				$parent_ids = lsvr_bluecollar_get_term_parents( $current_term_id, 'category' );
				if ( ! empty( $parent_ids ) ) {
					foreach( $parent_ids as $parent_id ){
						$parent = get_term( $parent_id, 'category' );
						$breadcrumbs[] = array(
							'url' => get_term_link( $parent, 'category' ),
							'label' => $parent->name,
						);
					}
				}
			}

			// Regular page
			else if ( is_page() ) {
				$parent_id = $post->post_parent;
				$parents_arr = [];
				while ( $parent_id ) {
					$page = get_page( $parent_id );
					$parents_arr[] = array(
						'url' => get_permalink( $page->ID ),
						'label' => get_the_title( $page->ID ),
					);
					$parent_id = $page->post_parent;
				}
				$parents_arr = array_reverse( $parents_arr );
				foreach ( $parents_arr as $parent ) {
					$breadcrumbs[] = $parent;
				}
			}

			// Apply filters
			if ( ! empty( apply_filters( 'lsvr_bluecollar_add_to_breadcrumbs', array() ) ) ) {
				$breadcrumbs = array_merge( $breadcrumbs, apply_filters( 'lsvr_bluecollar_add_to_breadcrumbs', array() ) );
			}

			// Taxonomy
			if ( is_tax() ) {

				$taxonomy = get_query_var( 'taxonomy' );
				$term_parents = lsvr_bluecollar_get_term_parents( get_queried_object_id(), $taxonomy );
				if ( ! empty( $term_parents ) ) {
					foreach( $term_parents as $term_id ) {

						$term = get_term_by( 'id', $term_id, $taxonomy );
						$breadcrumbs[] = array(
							'url' => get_term_link( $term_id, $taxonomy ),
							'label' => $term->name,
						);

					}
				}
			}

			// Return breadcrumbs
			return $breadcrumbs;

		}
	}

	// Set blog archive layout
	add_filter( 'lsvr_bluecollar_blog_archive_layout', 'lsvr_bluecollar_blog_archive_layout' );
	if ( ! function_exists( 'lsvr_bluecollar_blog_archive_layout' ) ) {
		function lsvr_bluecollar_blog_archive_layout() {

			$path_prefix = 'template-parts/blog/archive-layout-';

			// Get layout from Customizer
			if ( ! empty( locate_template( $path_prefix . get_theme_mod( 'blog_archive_layout', 'default' ) . '.php' ) ) ) {
				return get_theme_mod( 'blog_archive_layout', 'default' );
			}

			// Default layout
			else {
				return 'default';
			}

		}
	}

	// Archive intro title
	add_filter( 'lsvr_bluecollar_post_archive_intro_title', 'lsvr_bluecollar_blog_archive_intro_title' );
	if ( ! function_exists( 'lsvr_bluecollar_blog_archive_intro_title' ) ) {
		function lsvr_bluecollar_blog_archive_intro_title( $title ) {

			if ( lsvr_bluecollar_is_blog() && ! empty( get_theme_mod( 'blog_archive_intro_title', '' ) ) ) {
				$title = get_theme_mod( 'blog_archive_intro_title', '' );
			}

			return $title;

		}
	}

	// Archive intro text
	add_filter( 'lsvr_bluecollar_post_archive_intro_text', 'lsvr_bluecollar_blog_archive_intro_text' );
	if ( ! function_exists( 'lsvr_bluecollar_blog_archive_intro_text' ) ) {
		function lsvr_bluecollar_blog_archive_intro_text( $text ) {

			if ( lsvr_bluecollar_is_blog() && ! empty( get_theme_mod( 'blog_archive_intro_text', '' ) ) ) {
				$text = get_theme_mod( 'blog_archive_intro_text', '' );
			}

			if ( is_category() && ! empty( term_description( get_queried_object()->term_id, 'category' ) ) ) {
				$text = term_description( get_queried_object()->term_id, 'category' );
			}

			return $text;

		}
	}

	// Enable archive categories
	add_filter( 'lsvr_bluecollar_post_archive_categories_enable', 'lsvr_bluecollar_blog_archive_categories_enable' );
	if ( ! function_exists( 'lsvr_bluecollar_blog_archive_categories_enable' ) ) {
		function lsvr_bluecollar_blog_archive_categories_enable( $enabled ) {

			if ( lsvr_bluecollar_is_blog() && true === get_theme_mod( 'blog_archive_categories_enable', false ) ) {
				return true;
			}

			return $enabled;

		}
	}

	// Get categories taxonomy
	add_filter( 'lsvr_bluecollar_post_archive_categories_taxonomy', 'lsvr_bluecollar_blog_archive_categories_taxonomy' );
	if ( ! function_exists( 'lsvr_bluecollar_blog_archive_categories_taxonomy' ) ) {
		function lsvr_bluecollar_blog_archive_categories_taxonomy( $taxonomy ) {

			if ( lsvr_bluecollar_is_blog() ) {
				return 'category';
			}

			return $taxonomy;

		}
	}

	// Set page sidebar position
	add_filter( 'lsvr_bluecollar_sidebar_position', 'lsvr_bluecollar_sidebar_position', 10, 2 );
	if ( ! function_exists( 'lsvr_bluecollar_sidebar_position' ) ) {
		function lsvr_bluecollar_sidebar_position( $sidebar_position ) {

			// Is blog single
			if ( is_singular( 'post' ) ) {
				return get_theme_mod( 'blog_single_sidebar_position', 'right' );
			}

			// Is blog archive
			elseif ( lsvr_bluecollar_is_blog() ) {
				return get_theme_mod( 'blog_archive_sidebar_position', 'right' );
			}

			return $sidebar_position;

		}
	}

	// Set page sidebar ID
	add_filter( 'lsvr_bluecollar_sidebar_id', 'lsvr_bluecollar_sidebar_id' );
	if ( ! function_exists( 'lsvr_bluecollar_sidebar_id' ) ) {
		function lsvr_bluecollar_sidebar_id( $sidebar_id ) {

			// Page
			if ( is_page() ) {
				$page_id = ! empty( $page_id ) ? $page_id : get_the_ID();
				$sidebar_id = ! empty( $page_id ) ? get_post_meta( $page_id, 'lsvr_bluecollar_page_sidebar', true ) : false;

				if ( ! empty( $sidebar_id ) ) {
					$sidebar_id = $sidebar_id;
				} else {
					$sidebar_id = 'lsvr-bluecollar-default-sidebar';
				}
			}

			// Is blog single
			elseif ( is_singular( 'post' ) ) {
				$sidebar_id = get_theme_mod( 'blog_single_sidebar_id', 'lsvr-bluecollar-default-sidebar' );
			}

			// Is blog archive
			elseif ( lsvr_bluecollar_is_blog() ) {
				$sidebar_id = get_theme_mod( 'blog_archive_sidebar_id', 'lsvr-bluecollar-default-sidebar' );
			}

			// Default
			else {
				$sidebar_id = 'lsvr-bluecollar-default-sidebar';
			}

			return ! empty( $sidebar_id ) ? $sidebar_id : 'lsvr-bluecollar-default-sidebar';

		}
	}

	// Disable sidebars for narrow layouts
	add_filter( 'lsvr_bluecollar_sidebar_position', 'lsvr_bluecollar_narrow_layout_sidebar_position_disable', 20 );
	if ( ! function_exists( 'lsvr_bluecollar_narrow_layout_sidebar_position_disable' ) ) {
		function lsvr_bluecollar_narrow_layout_sidebar_position_disable( $sidebar_position ) {

			if ( true === apply_filters( 'lsvr_bluecollar_narrow_layout_enable', false ) ) {
				return 'disable';
			}

			return $sidebar_position;

		}
	}

	// Enable single post single navigation
	add_filter( 'lsvr_bluecollar_post_single_navigation_enable', 'lsvr_bluecollar_blog_single_post_navigation_enable' );
	if ( ! function_exists( 'lsvr_bluecollar_blog_single_post_navigation_enable' ) ) {
		function lsvr_bluecollar_blog_single_post_navigation_enable( $enabled ) {

			if ( lsvr_bluecollar_is_blog() && true === get_theme_mod( 'blog_single_post_navigation_enable', true ) ) {
				return true;
			}

			return $enabled;

		}
	}


/**
 * META DATA
 */

	// Add breadcrumbs meta
	add_action( 'lsvr_bluecollar_breadcrumbs_bottom', 'lsvr_bluecollar_add_breadcrumbs_meta', 10, 2 );
	if ( ! function_exists( 'lsvr_bluecollar_add_breadcrumbs_meta' ) ) {
		function lsvr_bluecollar_add_breadcrumbs_meta() { ?>

			<!-- BREADCRUMBS META DATA : begin -->
			<script type="application/ld+json">
			{
				"@context": "http://schema.org",
				"@type": "BreadcrumbList",
				"itemListElement" : [
					<?php $i = 1;
					$breadcrumbs = apply_filters( 'lsvr_bluecollar_breadcrumbs', '' );
					foreach ( $breadcrumbs as $breadcrumb ) : ?>
					{
						"@type": "ListItem",
						"position": <?php echo esc_js( $i ); ?>,
						"item": {
							"@id": "<?php echo esc_url( $breadcrumb['url'] ); ?>",
							"name": "<?php echo esc_js( $breadcrumb['label'] ); ?>"
						}
					}<?php if ( $breadcrumb !== end( $breadcrumbs ) ) { echo ','; } ?>
					<?php $i++; endforeach; ?>
				]
			}
			</script>
			<!-- BREADCRUMBS META DATA : end -->

		<?php }
	}

	// Add blog post meta data
	add_action( 'lsvr_bluecollar_blog_single_bottom', 'lsvr_bluecollar_add_blog_single_meta', 10, 2 );
	if ( ! function_exists( 'lsvr_bluecollar_add_blog_single_meta' ) ) {
		function lsvr_bluecollar_add_blog_single_meta() { ?>

			<script type="application/ld+json">
			{
				"@context" : "http://schema.org",
				"@type" : "NewsArticle",
				"headline": "<?php echo esc_js( get_the_title() ); ?>",
				"url" : "<?php echo esc_url( get_permalink() ); ?>",
				"mainEntityOfPage" : "<?php echo esc_url( get_permalink() ); ?>",
			 	"datePublished": "<?php echo esc_js( get_the_time( 'c' ) ); ?>",
			 	"dateModified": "<?php echo esc_js( get_the_modified_date( 'c' ) ); ?>",
			 	"description": "<?php echo esc_js( get_the_excerpt() ); ?>",
			 	"author": {
			 		"@type" : "person",
			 		"name" : "<?php echo esc_js( get_the_author() ); ?>",
			 		"url" : "<?php esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>"
			 	},
			 	"publisher" : {
			 		"@id" : "<?php echo esc_url( home_url() ); ?>#WebSitePublisher"
			 	}

			 	<?php if ( lsvr_bluecollar_has_post_terms( get_the_ID(), 'post_tag' ) ) : ?>
				,"keywords": "<?php echo esc_js( implode( ',', lsvr_bluecollar_get_post_term_names( get_the_ID(), 'post_tag' ) ) ); ?>"
			 	<?php endif; ?>

				<?php if ( has_post_thumbnail() ) : ?>
			 	,"image": {
			 		"@type" : "ImageObject",
			 		"url" : "<?php the_post_thumbnail_url( 'full' ); ?>",
			 		"width" : "<?php echo esc_js( lsvr_bluecollar_get_image_width( get_post_thumbnail_id( get_the_ID() ), 'full' ) ); ?>",
			 		"height" : "<?php echo esc_js( lsvr_bluecollar_get_image_height( get_post_thumbnail_id( get_the_ID() ), 'full' ) ); ?>",
			 		"thumbnailUrl" : "<?php the_post_thumbnail_url( 'thumbnail' ); ?>"
			 	}
			 	<?php endif; ?>

			}
			</script>

		<?php }
	}

	// Add site meta data
	add_action( 'wp_footer', 'lsvr_bluecollar_add_site_meta', 10, 2 );
	if ( ! function_exists( 'lsvr_bluecollar_add_site_meta' ) ) {
		function lsvr_bluecollar_add_site_meta() { ?>

			<?php // Get URLs of social links and email address
			$social_links = lsvr_bluecollar_get_social_links();
			if ( ! empty( $social_links->email ) ) {
				$email = ! empty( $social_links->email->url ) ? $social_links->email->url : '';
				unset( $social_links->email );
			} ?>

			<script type="application/ld+json">
			{
				"@context" : "http://schema.org",
				"@type" : "WebSite",
				"name" : "<?php bloginfo( 'name' ); ?>",
				"url" : "<?php echo esc_url( home_url() ); ?>",
				"description" : "<?php bloginfo( 'description' ); ?>",
			 	"publisher" : {

			 		"@id" : "<?php echo esc_url( home_url() ); ?>#WebSitePublisher",
			 		"@type" : "Organization",
			 		"name" : "<?php echo esc_js( get_bloginfo('name') ); ?>",
			 		"url" : "<?php echo esc_url( home_url() ); ?>"

					<?php if ( ! empty( $email ) ) : ?>
					,"contactPoint": {
				 		"@type": "ContactPoint",
				 		"contactType": "customer service",
				 		"url": "<?php echo esc_url( home_url() ); ?>",
				 		"email": "<?php echo esc_js( $email ); ?>"
				 	}
					<?php endif; ?>

			 		<?php if ( has_custom_logo() ) : ?>
			 		,"logo" : {
			 			"@type" : "ImageObject",
			 			"url" : "<?php echo esc_url( lsvr_bluecollar_get_image_url( get_theme_mod( 'custom_logo' ) ) ); ?>",
						"width" : "<?php echo esc_attr( lsvr_bluecollar_get_image_width( get_theme_mod( 'custom_logo' ) ) ); ?>",
						"height" : "<?php echo esc_attr( lsvr_bluecollar_get_image_height( get_theme_mod( 'custom_logo' ) ) ); ?>"
			 		}
			 		<?php endif; ?>

					<?php if ( ! empty( $social_links ) ) : ?>
					,"sameAs" : [
						<?php foreach( $social_links as $social ) : if ( ! empty( $social->url ) ) : ?>
				    		"<?php echo esc_url( $social->url ); ?>"<?php if ( $social !== end( $social_links ) ) { echo ','; } ?>
						<?php endif; endforeach; ?>
				  	]
				  	<?php endif; ?>

			 	},
			 	"potentialAction": {
			    	"@type" : "SearchAction",
			    	"target" : "<?php echo esc_url( home_url() ); ?>/?s={search_term}",
			    	"query-input": "required name=search_term"
			    }
			}
			</script>

		<?php }
	}

?>