<?php
/**
 * WordPress customizer settings
 */
add_action( 'customize_register', 'lsvr_bluecollar_customize_register' );
if ( ! function_exists( 'lsvr_bluecollar_customize_register' ) ) {
    function lsvr_bluecollar_customize_register( $wp_customize ) {

        // Init the LSVR Customizer object
        if ( class_exists( 'Lsvr_Customizer' ) ) {

            $lsvr_customizer = new Lsvr_Customizer( $wp_customize, 'lsvr_bluecollar_' );

            // Change order of default sections
            $wp_customize->get_section( 'static_front_page' )->priority = 117;
            $wp_customize->get_section( 'custom_css' )->priority = 300;

            // Header
            $lsvr_customizer->add_section( 'header_settings', array(
                'title' => esc_html__( 'Header', 'bluecollar' ),
                'priority' => 101,
            ));

                // Page Title background image
                $lsvr_customizer->add_field( 'page_title_background_image', array(
                    'section' => 'header_settings',
                    'label' => esc_html__( 'Page Title Background Image', 'bluecollar' ),
                    'description' => esc_html__( 'Optimal resolution is about 2000x1000px or more.', 'bluecollar' ),
                    'type' => 'image',
                    'priority' => 1010,
                ));

                // Background overlay opacity
                $lsvr_customizer->add_field( 'page_title_background_overlay_opacity', array(
                    'section' => 'header_settings',
                    'label' => esc_html__( 'Page Title Overlay Opacity', 'bluecollar' ),
                    'description' => esc_html__( 'Set to 0 for invisible overlay and to 100 for solid color.', 'bluecollar' ),
                    'type' => 'lsvr-slider',
                    'choices' => array(
                        'min' => 0,
                        'max' => 100,
                        'step' => 5,
                    ),
                    'default' => 80,
                    'priority' => 1110,
                ));

                // Separator
                $lsvr_customizer->add_separator( 'header_separator_2', array(
                    'section' => 'header_settings',
                    'priority' => 2000,
                ));

                // Max logo width
                $lsvr_customizer->add_field( 'header_logo_max_width', array(
                    'section' => 'header_settings',
                    'label' => esc_html__( 'Logo Max Width', 'bluecollar' ),
                    'description' => esc_html__( 'Set maximum width of your header logo. You can upload your site logo under Customizer / Site Identity.', 'bluecollar' ),
                    'type' => 'lsvr-slider',
                    'choices' => array(
                        'min' => 30,
                        'max' => 300,
                        'step' => 1,
                    ),
                    'default' => 50,
                    'priority' => 2010,
                ));

                // Site title enable
                $lsvr_customizer->add_field( 'header_site_title_enable', array(
                    'section' => 'header_settings',
                    'label' => esc_html__( 'Display Site Title', 'bluecollar' ),
                    'description' => esc_html__( 'Show your site title in the header near logo. It can be changed under Customizer / Site Identity.', 'bluecollar' ),
                    'type' => 'checkbox',
                    'default' => true,
                    'priority' => 2020,
                ));

                // Site description enable
                $lsvr_customizer->add_field( 'header_site_tagline_enable', array(
                    'section' => 'header_settings',
                    'label' => esc_html__( 'Display Site Tagline', 'bluecollar' ),
                    'description' => esc_html__( 'Show your site description in the header near logo. It can be changed under Customizer / Site Identity.', 'bluecollar' ),
                    'type' => 'checkbox',
                    'default' => true,
                    'priority' => 2030,
                ));

                // Separator
                $lsvr_customizer->add_separator( 'header_separator_3', array(
                    'section' => 'header_settings',
                    'priority' => 3000,
                ));

                // Enable topbar
                $lsvr_customizer->add_field( 'header_topbar_enable', array(
                    'section' => 'header_settings',
                    'label' => esc_html__( 'Display Topbar', 'bluecollar' ),
                    'description' => esc_html__( 'Enable section with quick contact info and social icons.', 'bluecollar' ),
                    'type' => 'checkbox',
                    'default' => true,
                    'priority' => 3010,
                ));

                // Contact item 1 label
                $lsvr_customizer->add_field( 'header_contact_item1_label', array(
                    'section' => 'header_settings',
                    'label' => esc_html__( 'Contact Item 1 Label', 'bluecollar' ),
                    'description' => esc_html__( 'Ideal for quick contact info.', 'bluecollar' ),
                    'type' => 'text',
                    'priority' => 3110,
                    'required' => array(
                        'setting' => 'header_topbar_enable',
                        'operator' => '==',
                        'value' => true,
                    ),
                ));

                // Contact item 1 icon
                $lsvr_customizer->add_field( 'header_contact_item1_icon', array(
                    'section' => 'header_settings',
                    'label' => esc_html__( 'Contact Item 1 Icon', 'bluecollar' ),
                    'description' => esc_html__( 'For example "icon-phone". Please refer to the documentation to learn more about icons.', 'bluecollar' ),
                    'type' => 'text',
                    'priority' => 3120,
                    'required' => array(
                        'setting' => 'header_topbar_enable',
                        'operator' => '==',
                        'value' => true,
                    ),
                ));

                // Contact item 1 link
                $lsvr_customizer->add_field( 'header_contact_item1_link', array(
                    'section' => 'header_settings',
                    'label' => esc_html__( 'Contact Item 1 Link', 'bluecollar' ),
                    'description' => esc_html__( 'Please use an abolute URL. If this is a phone number, you can use "tel:123456" format, if it is an email use "mailto:example@example.org" format.', 'bluecollar' ),
                    'type' => 'text',
                    'priority' => 3130,
                    'required' => array(
                        'setting' => 'header_topbar_enable',
                        'operator' => '==',
                        'value' => true,
                    ),
                ));

                // Contact item 2 label
                $lsvr_customizer->add_field( 'header_contact_item2_label', array(
                    'section' => 'header_settings',
                    'label' => esc_html__( 'Contact Item 2 Label', 'bluecollar' ),
                    'type' => 'text',
                    'priority' => 3210,
                    'required' => array(
                        'setting' => 'header_topbar_enable',
                        'operator' => '==',
                        'value' => true,
                    ),
                ));

                // Contact item 2 icon
                $lsvr_customizer->add_field( 'header_contact_item2_icon', array(
                    'section' => 'header_settings',
                    'label' => esc_html__( 'Contact Item 2 Icon', 'bluecollar' ),
                    'type' => 'text',
                    'priority' => 3220,
                    'required' => array(
                        'setting' => 'header_topbar_enable',
                        'operator' => '==',
                        'value' => true,
                    ),
                ));

                // Contact item 2 link
                $lsvr_customizer->add_field( 'header_contact_item2_link', array(
                    'section' => 'header_settings',
                    'label' => esc_html__( 'Contact Item 2 Link', 'bluecollar' ),
                    'type' => 'text',
                    'priority' => 3230,
                    'required' => array(
                        'setting' => 'header_topbar_enable',
                        'operator' => '==',
                        'value' => true,
                    ),
                ));

                // Contact item 3 label
                $lsvr_customizer->add_field( 'header_contact_item3_label', array(
                    'section' => 'header_settings',
                    'label' => esc_html__( 'Contact Item 3 Label', 'bluecollar' ),
                    'type' => 'text',
                    'priority' => 3310,
                    'required' => array(
                        'setting' => 'header_topbar_enable',
                        'operator' => '==',
                        'value' => true,
                    ),
                ));

                // Contact item 3 icon
                $lsvr_customizer->add_field( 'header_contact_item3_icon', array(
                    'section' => 'header_settings',
                    'label' => esc_html__( 'Contact Item 3 Icon', 'bluecollar' ),
                    'type' => 'text',
                    'priority' => 3320,
                    'required' => array(
                        'setting' => 'header_topbar_enable',
                        'operator' => '==',
                        'value' => true,
                    ),
                ));

                // Contact item 3 link
                $lsvr_customizer->add_field( 'header_contact_item3_link', array(
                    'section' => 'header_settings',
                    'label' => esc_html__( 'Contact Item 3 Link', 'bluecollar' ),
                    'type' => 'text',
                    'priority' => 3330,
                    'required' => array(
                        'setting' => 'header_topbar_enable',
                        'operator' => '==',
                        'value' => true,
                    ),
                ));

                // Enable social links
                $lsvr_customizer->add_field( 'header_social_links_enable', array(
                    'section' => 'header_settings',
                    'label' => esc_html__( 'Display Social Links', 'bluecollar' ),
                    'description' => esc_html__( 'You can manage your social links under Social Links.', 'bluecollar' ),
                    'type' => 'checkbox',
                    'default' => true,
                    'priority' => 3510,
                    'required' => array(
                        'setting' => 'header_topbar_enable',
                        'operator' => '==',
                        'value' => true,
                    ),
                ));

                // Enable search
                $lsvr_customizer->add_field( 'header_search_enable', array(
                    'section' => 'header_settings',
                    'label' => esc_html__( 'Display Search', 'bluecollar' ),
                    'type' => 'checkbox',
                    'default' => true,
                    'priority' => 3520,
                    'required' => array(
                        'setting' => 'header_topbar_enable',
                        'operator' => '==',
                        'value' => true,
                    ),
                ));

                // Separator
                $lsvr_customizer->add_separator( 'header_separator_4', array(
                    'section' => 'header_settings',
                    'priority' => 4000,
                ));

                // Sticky header
                $lsvr_customizer->add_field( 'header_sticky_enable', array(
                    'section' => 'header_settings',
                    'label' => esc_html__( 'Enable Sticky Header', 'bluecollar' ),
                    'description' => esc_html__( 'Make header stick to the top of the page on desktop devices.', 'bluecollar' ),
                    'type' => 'checkbox',
                    'default' => false,
                    'priority' => 4010,
                ));


            // Footer settings
            $lsvr_customizer->add_section( 'footer_settings', array(
                'title' => esc_html__( 'Footer', 'bluecollar' ),
                'priority' => 102,
            ));

                // Background Image
                $lsvr_customizer->add_field( 'footer_background_image', array(
                    'section' => 'footer_settings',
                    'label' => esc_html__( 'Background Image', 'bluecollar' ),
                    'description' => esc_html__( 'Optimal resolution is about 2000x1600px or more.', 'bluecollar' ),
                    'type' => 'image',
                    'priority' => 1010,
                ));

                // Background Overlay Opacity
                $lsvr_customizer->add_field( 'footer_background_overlay_opacity', array(
                    'section' => 'footer_settings',
                    'label' => esc_html__( 'Background Overlay Opacity', 'bluecollar' ),
                    'description' => esc_html__( 'Set to 0 for invisible overlay and to 100 for solid color.', 'bluecollar' ),
                    'type' => 'lsvr-slider',
                    'choices' => array(
                        'min' => 0,
                        'max' => 100,
                        'step' => 5,
                    ),
                    'default' => 80,
                    'priority' => 1020,
                ));

                // Separator
                $lsvr_customizer->add_separator( 'footer_separator_2', array(
                    'section' => 'footer_settings',
                    'priority' => 2000,
                ));

                // Enable footer CTA
                $lsvr_customizer->add_field( 'footer_cta_enable', array(
                    'section' => 'footer_settings',
                    'label' => esc_html__( 'Enable Footer CTA', 'bluecollar' ),
                    'description' => esc_html__( 'Enable CTA section at the top of the footer.', 'bluecollar' ),
                    'type' => 'checkbox',
                    'default' => false,
                    'priority' => 2010,
                ));

                // CTA Title
                $lsvr_customizer->add_field( 'footer_cta_title', array(
                    'section' => 'footer_settings',
                    'label' => esc_html__( 'CTA Title', 'bluecollar' ),
                    'type' => 'text',
                    'priority' => 2020,
                    'required' => array(
                        'setting' => 'footer_cta_enable',
                        'operator' => '==',
                        'value' => true,
                    ),
                ));

                // CTA Text
                $lsvr_customizer->add_field( 'footer_cta_text', array(
                    'section' => 'footer_settings',
                    'label' => esc_html__( 'CTA Text', 'bluecollar' ),
                    'description' => esc_html__( 'You can use A, EM, BR, P and STRONG tags here. For example:  &lt;strong&gt;&lt;a href="http://example.com"&gt;Hello World!&lt;/a&gt;&lt;/strong&gt;', 'bluecollar' ),
                    'type' => 'textarea',
                    'priority' => 2030,
                    'required' => array(
                        'setting' => 'footer_cta_enable',
                        'operator' => '==',
                        'value' => true,
                    ),
                ));

                // CTA Button Label
                $lsvr_customizer->add_field( 'footer_cta_button_label', array(
                    'section' => 'footer_settings',
                    'label' => esc_html__( 'CTA Button Label', 'bluecollar' ),
                    'type' => 'text',
                    'priority' => 2040,
                    'required' => array(
                        'setting' => 'footer_cta_enable',
                        'operator' => '==',
                        'value' => true,
                    ),
                ));

                // CTA Button Link
                $lsvr_customizer->add_field( 'footer_cta_button_url', array(
                    'section' => 'footer_settings',
                    'label' => esc_html__( 'CTA Button URL', 'bluecollar' ),
                    'description' => esc_html__( 'Please use complete URL with "http://" or "https://" respectively.', 'bluecollar' ),
                    'type' => 'text',
                    'priority' => 2050,
                    'required' => array(
                        'setting' => 'footer_cta_enable',
                        'operator' => '==',
                        'value' => true,
                    ),
                ));

                // Open CTA URL in a new tab
                $lsvr_customizer->add_field( 'footer_cta_button_url_new_tab_enable', array(
                    'section' => 'footer_settings',
                    'label' => esc_html__( 'Open CTA URL in a new tab', 'bluecollar' ),
                    'type' => 'checkbox',
                    'default' => false,
                    'priority' => 2060,
                    'required' => array(
                        'setting' => 'footer_cta_enable',
                        'operator' => '==',
                        'value' => true,
                    ),
                ));

                // Separator
                $lsvr_customizer->add_separator( 'footer_separator_3', array(
                    'section' => 'footer_settings',
                    'priority' => 3000,
                ));

                // Footer widgets columns
                $lsvr_customizer->add_field( 'footer_widgets_columns', array(
                    'section' => 'footer_settings',
                    'label' => esc_html__( 'Widget Columns', 'bluecollar' ),
                    'description' => esc_html__( 'How many columns should be used to display widgets in the footer. You can populate the footer with widgets under Appearance / Widgets.', 'bluecollar' ),
                    'type' => 'lsvr-slider',
                    'choices' => array(
                        'min' => 1,
                        'max' => 4,
                        'step' => 1,
                    ),
                    'default' => 3,
                    'priority' => 3010,
                ));

                // Separator
                $lsvr_customizer->add_separator( 'footer_separator_4', array(
                    'section' => 'footer_settings',
                    'priority' => 4000,
                ));

                // Footer text
                $lsvr_customizer->add_field( 'footer_text', array(
                    'section' => 'footer_settings',
                    'label' => esc_html__( 'Footer Text', 'bluecollar' ),
                    'description' => esc_html__( 'Ideal for copyright info. You can use A, EM, BR, P and STRONG tags here. For example: &amp;copy; 2018 &lt;a href="http://mysite.com"&gt;MySite&lt;/a&gt;', 'bluecollar' ),
                    'type' => 'textarea',
                    'default'  => '&copy; ' . date( 'Y' ) . ' ' . get_bloginfo( 'name' ),
                    'priority' => 4010,
                ));


            // Sidebar settings
            $lsvr_customizer->add_section( 'sidebar_settings', array(
                'title' => esc_html__( 'Custom Sidebars', 'bluecollar' ),
                'priority' => 115,
            ));

                // Custom sidebars
                $lsvr_customizer->add_field( 'custom_sidebars', array(
                    'section' => 'sidebar_settings',
                    'label' => esc_html__( 'Manage Custom Sidebars', 'bluecollar' ),
                    'description' => esc_html__( 'Here you can manage your custom sidebars. You can populate them with widgets under Appearance / Widgets. To assign a sidebar to a page, set its page template to "Sidebar on the Left" or "Sidebar on the Right" and then choose the sidebar under Sidebar Settings of that page. You can assign sidebars to post type pages (directory, events, galleries, etc.) in the Customizer.', 'bluecollar' ),
                    'type' => 'lsvr-sidebars',
                    'priority' => 1010,
                ));


            // Blog settings
            $lsvr_customizer->add_section( 'blog_settings', array(
                'title' => esc_html__( 'Standard Posts', 'bluecollar' ),
                'priority' => 120,
            ));

                // Archive settings
                $lsvr_customizer->add_info( 'blog_archive_info', array(
                    'section' => 'blog_settings',
                    'label' => esc_html__( 'Archive Settings', 'bluecollar' ),
                    'description' => esc_html__( 'The following settings apply to post archive page. You can change your default post archive page under Settings / Reading. Scroll down for post detail page settings.', 'bluecollar' ),
                    'priority' => 1005,
                ));

                // Intro title
                $lsvr_customizer->add_field( 'blog_archive_intro_title', array(
                    'section' => 'blog_settings',
                    'label' => esc_html__( 'Archive Intro Title', 'bluecollar' ),
                    'description' => esc_html__( 'Title of the intro section displayed right above the post list. Leave blank to hide.', 'bluecollar' ),
                    'type' => 'text',
                    'default' => '',
                    'priority' => 1020,
                ));

                // Intro text
                $lsvr_customizer->add_field( 'blog_archive_intro_text', array(
                    'section' => 'blog_settings',
                    'label' => esc_html__( 'Archive Intro Text', 'bluecollar' ),
                    'description' => esc_html__( 'Content of the intro section displayed right above the post list. Leave blank to hide.', 'bluecollar' ),
                    'type' => 'textarea',
                    'default' => '',
                    'priority' => 1030,
                ));

                // Archive layout
                $lsvr_customizer->add_field( 'blog_archive_layout', array(
                    'section' => 'blog_settings',
                    'label' => esc_html__( 'Archive Layout', 'bluecollar' ),
                    'description' => esc_html__( 'Change layout for the post archive page.', 'bluecollar' ),
                    'type' => 'select',
                    'choices' => array(
                        'default' => esc_html__( 'Default', 'bluecollar' ),
                        'grid' => esc_html__( 'Grid', 'bluecollar' ),
                    ),
                    'default' => 'default',
                    'priority' => 1110,
                ));

                // Archive grid columns
                $lsvr_customizer->add_field( 'blog_archive_grid_columns', array(
                    'section' => 'blog_settings',
                    'label' => esc_html__( 'Number of Columns', 'bluecollar' ),
                    'description' => esc_html__( 'Divide layout into several columns.', 'bluecollar' ),
                    'type' => 'lsvr-slider',
                    'choices' => array(
                        'min' => 1,
                        'max' => 4,
                        'step' => 1,
                    ),
                    'default' => 3,
                    'priority' => 1120,
                    'required' => array(
                        'setting' => 'blog_archive_layout',
                        'operator' => '==',
                        'value' => 'grid',
                    ),
                ));

                // Enable categories
                $lsvr_customizer->add_field( 'blog_archive_categories_enable', array(
                    'section' => 'blog_settings',
                    'label' => esc_html__( 'Display Archive Categories', 'bluecollar' ),
                    'description' => esc_html__( 'Display links to categories at the top of the archive page.', 'bluecollar' ),
                    'type' => 'checkbox',
                    'default' => false,
                    'priority' => 1130,
                ));

                // Enable masonry on archive
                $lsvr_customizer->add_field( 'blog_archive_masonry_enable', array(
                    'section' => 'blog_settings',
                    'label' => esc_html__( 'Enable Masonry On Archive', 'bluecollar' ),
                    'description' => esc_html__( 'Display posts grid using the masonry layout.', 'bluecollar' ),
                    'type' => 'checkbox',
                    'default' => false,
                    'priority' => 1140,
                    'required' => array(
                        'setting' => 'blog_archive_layout',
                        'operator' => '==',
                        'value' => 'grid',
                    ),
                ));

                // Archive sidebar position
                $lsvr_customizer->add_field( 'blog_archive_sidebar_position', array(
                    'section' => 'blog_settings',
                    'label' => esc_html__( 'Archive Sidebar Position', 'bluecollar' ),
                    'description' => esc_html__( 'Change the post archive sidebar position.', 'bluecollar' ),
                    'type' => 'select',
                    'choices' => array(
                        'disable' => esc_html__( 'Disable', 'bluecollar' ),
                        'left' => esc_html__( 'Left', 'bluecollar' ),
                        'right' => esc_html__( 'Right', 'bluecollar' ),
                    ),
                    'default' => 'right',
                    'priority' => 1510,
                ));

                // Archive sidebar ID
                $lsvr_customizer->add_field( 'blog_archive_sidebar_id', array(
                    'section' => 'blog_settings',
                    'label' => esc_html__( 'Archive Sidebar', 'bluecollar' ),
                    'description' => esc_html__( 'Choose sidebar to display.', 'bluecollar' ),
                    'type' => 'select',
                    'choices' => lsvr_bluecollar_get_sidebars(),
                    'priority' => 1520,
                    'default' => 'lsvr-bluecollar-default-sidebar',
                    'required' => array(
                        'setting' => 'blog_archive_sidebar_position',
                        'operator' => '==',
                        'value' => 'left,right',
                    ),
                ));

                // Separator
                $lsvr_customizer->add_separator( 'blog_separator_1', array(
                    'section' => 'blog_settings',
                    'priority' => 2000,
                ));

                // Detail settings
                $lsvr_customizer->add_info( 'blog_single_info', array(
                    'section' => 'blog_settings',
                    'label' => esc_html__( 'Detail Settings', 'bluecollar' ),
                    'description' => esc_html__( 'The following settings apply to post detail pages.', 'bluecollar' ),
                    'priority' => 2005,
                ));

                // Enable author
                $lsvr_customizer->add_field( 'blog_single_author_enable', array(
                    'section' => 'blog_settings',
                    'label' => esc_html__( 'Display Author on Detail', 'bluecollar' ),
                    'description' => esc_html__( 'Display post author on post detail.', 'bluecollar' ),
                    'type' => 'checkbox',
                    'default' => true,
                    'priority' => 2010,
                ));

                // Enable post detail navigation
                $lsvr_customizer->add_field( 'blog_single_post_navigation_enable', array(
                    'section' => 'blog_settings',
                    'label' => esc_html__( 'Enable Post Detail Navigation', 'bluecollar' ),
                    'description' => esc_html__( 'Display links to previous and next posts at the bottom of the current post.', 'bluecollar' ),
                    'type' => 'checkbox',
                    'default' => true,
                    'priority' => 2020,
                ));

                // Single sidebar position
                $lsvr_customizer->add_field( 'blog_single_sidebar_position', array(
                    'section' => 'blog_settings',
                    'label' => esc_html__( 'Detail Sidebar Position', 'bluecollar' ),
                    'description' => esc_html__( 'Change the post detail sidebar position.', 'bluecollar' ),
                    'type' => 'select',
                    'choices' => array(
                        'disable' => esc_html__( 'Disable', 'bluecollar' ),
                        'left' => esc_html__( 'Left', 'bluecollar' ),
                        'right' => esc_html__( 'Right', 'bluecollar' ),
                    ),
                    'default' => 'right',
                    'priority' => 2030,
                ));

                // Single sidebar ID
                $lsvr_customizer->add_field( 'blog_single_sidebar_id', array(
                    'section' => 'blog_settings',
                    'label' => esc_html__( 'Detail Sidebar', 'bluecollar' ),
                    'description' => esc_html__( 'Choose sidebar to display.', 'bluecollar' ),
                    'type' => 'select',
                    'choices' => lsvr_bluecollar_get_sidebars(),
                    'priority' => 2040,
                    'default' => 'lsvr-bluecollar-default-sidebar',
                    'required' => array(
                        'setting' => 'blog_single_sidebar_position',
                        'operator' => '==',
                        'value' => 'left,right',
                    ),
                ));


            // Typography
            $lsvr_customizer->add_section( 'typography_settings', array(
                'title' => esc_html__( 'Typography', 'bluecollar' ),
                'priority' => 200,
            ));

                // Enable Google Fonts
                $lsvr_customizer->add_field( 'typography_google_fonts_enable', array(
                    'section' => 'typography_settings',
                    'label' => esc_html__( 'Enable Google Fonts', 'bluecollar' ),
                    'description' => esc_html__( 'If you disable Google Fonts, default sans-serif font will be used for all text.', 'bluecollar' ),
                    'type' => 'checkbox',
                    'default' => true,
                    'priority' => 1010,
                ));

                // Primary font
                $lsvr_customizer->add_field( 'typography_primary_font', array(
                    'section' => 'typography_settings',
                    'label' => esc_html__( 'Primary Font', 'bluecollar' ),
                    'description' => esc_html__( 'This font will be used for almost all text except some headlines and titles.', 'bluecollar' ),
                    'type' => 'select',
                    'choices' => array(
                        'Alegreya' => 'Alegreya',
                        'Alegreya+Sans' => 'Alegreya Sans',
                        'Archivo+Narrow' => 'Archivo Narrow',
                        'Assistant' => 'Assistant',
                        'Exo+2' => 'Exo 2',
                        'Fira+Sans' => 'Fira Sans',
                        'Hind' => 'Hind',
                        'Inconsolata' => 'Inconsolata',
                        'Karla' => 'Karla',
                        'Lato' => 'Lato',
                        'Libre+Baskerville' => 'Libre Baskerville',
                        'Lora' => 'Lora',
                        'Merriweather' => 'Merriweather',
                        'Montserrat' => 'Montserrat',
                        'Nunito+Sans' => 'Nunito Sans',
                        'Open+Sans' => 'Open Sans',
                        'PT+Serif' => 'PT Serif',
                        'Playfair+Display' => 'Playfair Display',
                        'Roboto' => 'Roboto',
                        'Roboto+Slab' => 'Roboto Slab',
                        'Source+Sans+Pro' => 'Source Sans Pro',
                        'Source+Serif+Pro' => 'Source Serif Pro',
                        'Work+Sans' => 'Work Sans',
                    ),
                    'default' => 'Source+Sans+Pro',
                    'priority' => 1020,
                    'required' => array(
                        'setting' => 'typography_google_fonts_enable',
                        'operator' => '==',
                        'value' => true,
                    ),
                ));

                // Secondary font
                $lsvr_customizer->add_field( 'typography_secondary_font', array(
                    'section' => 'typography_settings',
                    'label' => esc_html__( 'Secondary Font', 'bluecollar' ),
                    'description' => esc_html__( 'This font will be used for most headlines.', 'bluecollar' ),
                    'type' => 'select',
                    'choices' => array(
                        'Alegreya' => 'Alegreya',
                        'Alegreya+Sans' => 'Alegreya Sans',
                        'Archivo+Narrow' => 'Archivo Narrow',
                        'Assistant' => 'Assistant',
                        'Exo+2' => 'Exo 2',
                        'Fira+Sans' => 'Fira Sans',
                        'Hind' => 'Hind',
                        'Inconsolata' => 'Inconsolata',
                        'Karla' => 'Karla',
                        'Lato' => 'Lato',
                        'Libre+Baskerville' => 'Libre Baskerville',
                        'Lora' => 'Lora',
                        'Merriweather' => 'Merriweather',
                        'Montserrat' => 'Montserrat',
                        'Nunito+Sans' => 'Nunito Sans',
                        'Open+Sans' => 'Open Sans',
                        'PT+Serif' => 'PT Serif',
                        'Playfair+Display' => 'Playfair Display',
                        'Roboto' => 'Roboto',
                        'Roboto+Slab' => 'Roboto Slab',
                        'Source+Sans+Pro' => 'Source Sans Pro',
                        'Source+Serif+Pro' => 'Source Serif Pro',
                        'Work+Sans' => 'Work Sans',
                    ),
                    'default' => 'Exo+2',
                    'priority' => 1030,
                    'required' => array(
                        'setting' => 'typography_google_fonts_enable',
                        'operator' => '==',
                        'value' => true,
                    ),
                ));

                // Base font size
                $lsvr_customizer->add_field( 'typography_base_font_size', array(
                    'section' => 'typography_settings',
                    'label' => esc_html__( 'Base Font Size', 'bluecollar' ),
                    'description' => esc_html__( 'Font size of basic content text. All other font sizes will also be calculated from this value. Default font size is 16px.', 'bluecollar' ),
                    'type' => 'select',
                    'choices' => array(
                        '12' => esc_html__( '12px', 'bluecollar' ),
                        '13' => esc_html__( '13px', 'bluecollar' ),
                        '14' => esc_html__( '14px', 'bluecollar' ),
                        '15' => esc_html__( '15px', 'bluecollar' ),
                        '16' => esc_html__( '16px', 'bluecollar' ),
                        '17' => esc_html__( '17px', 'bluecollar' ),
                        '18' => esc_html__( '18px', 'bluecollar' ),
                    ),
                    'default' => '16',
                    'priority' => 1040,
                ));

                // Font subsets
                $lsvr_customizer->add_field( 'typography_font_subsets', array(
                    'section' => 'typography_settings',
                    'label' => esc_html__( 'Font Subsets', 'bluecollar' ),
                    'description' => esc_html__( 'Only the Latin subset is loaded by default. If your site is in any other language than English, you may need to load an additional font subset. Please note that not all font families support all font subsets.', 'bluecollar' ),
                    'type' => 'lsvr-multicheck',
                    'choices' => array(
                        'latin-ext' => esc_html__( 'Latin Extended', 'bluecollar' ),
                        'greek' => esc_html__( 'Greek', 'bluecollar' ),
                        'greek-ext' => esc_html__( 'Greek Extended', 'bluecollar' ),
                        'vietnamese' => esc_html__( 'Vietnamese', 'bluecollar' ),
                        'cyrillic' => esc_html__( 'Cyrillic', 'bluecollar' ),
                        'cyrillic-ext' => esc_html__( 'Cyrillic Extended', 'bluecollar' ),
                    ),
                    'priority' => 1050,
                    'required' => array(
                        'setting' => 'typography_google_fonts_enable',
                        'operator' => '==',
                        'value' => true,
                    ),
                ));


            // Colors
            $lsvr_customizer->add_section( 'colors_settings', array(
                'title' => esc_html__( 'Colors', 'bluecollar' ),
                'priority' => 210,
            ));

                // Colors method
                $lsvr_customizer->add_field( 'colors_method', array(
                    'section' => 'colors_settings',
                    'label' => esc_html__( 'Set Colors By', 'bluecollar' ),
                    'type' => 'radio',
                    'choices' => array(
                        'predefined' => esc_html__( 'Predefined Scheme', 'bluecollar' ),
                        'custom-colors' => esc_html__( 'Custom Colors', 'bluecollar' ),
                        'custom-skin' => esc_html__( 'Custom Scheme', 'bluecollar' ),
                    ),
                    'default' => 'predefined',
                    'priority' => 1010,
                ));

                // Predefined skin
                $lsvr_customizer->add_field( 'colors_predefined_skin', array(
                    'section' => 'colors_settings',
                    'label' => esc_html__( 'Choose Predefined Skin', 'bluecollar' ),
                    'type' => 'select',
                    'choices' => array(
                        'default' => esc_html__( 'Default', 'bluecollar' ),
                        'turquoise-orange' => esc_html__( 'Turquoise & Orange', 'bluecollar' ),
                        'gray-blue' => esc_html__( 'Gray & Blue', 'bluecollar' ),
                        'green-orange' => esc_html__( 'Green & Orange', 'bluecollar' ),
                    ),
                    'default' => 'default',
                    'priority' => 2010,
                    'required' => array(
                        'setting' => 'colors_method',
                        'operator' => '==',
                        'value' => 'predefined',
                    ),
                ));

                // Accent 1
                $lsvr_customizer->add_field( 'colors_custom_accent1', array(
                    'section' => 'colors_settings',
                    'label' => esc_html__( 'Accent 1', 'bluecollar' ),
                    'type' => 'color',
                    'default' => '#f9b109',
                    'priority' => 3010,
                    'required' => array(
                        'setting' => 'colors_method',
                        'operator' => '==',
                        'value' => 'custom-colors',
                    ),
                ));

                // Accent 2
                $lsvr_customizer->add_field( 'colors_custom_accent2', array(
                    'section' => 'colors_settings',
                    'label' => esc_html__( 'Accent 2', 'bluecollar' ),
                    'type' => 'color',
                    'default' => '#193c9d',
                    'priority' => 3020,
                    'required' => array(
                        'setting' => 'colors_method',
                        'operator' => '==',
                        'value' => 'custom-colors',
                    ),
                ));

                // Accent 3
                $lsvr_customizer->add_field( 'colors_custom_accent3', array(
                    'section' => 'colors_settings',
                    'label' => esc_html__( 'Accent 3', 'bluecollar' ),
                    'type' => 'color',
                    'default' => '#0cb6ef',
                    'priority' => 3020,
                    'required' => array(
                        'setting' => 'colors_method',
                        'operator' => '==',
                        'value' => 'custom-colors',
                    ),
                ));

                // Link
                $lsvr_customizer->add_field( 'colors_custom_link', array(
                    'section' => 'colors_settings',
                    'label' => esc_html__( 'Link', 'bluecollar' ),
                    'type' => 'color',
                    'default' => '#444',
                    'priority' => 3030,
                    'required' => array(
                        'setting' => 'colors_method',
                        'operator' => '==',
                        'value' => 'custom-colors',
                    ),
                ));

                // Text
                $lsvr_customizer->add_field( 'colors_custom_text', array(
                    'section' => 'colors_settings',
                    'label' => esc_html__( 'Text', 'bluecollar' ),
                    'type' => 'color',
                    'default' => '#444',
                    'priority' => 3040,
                    'required' => array(
                        'setting' => 'colors_method',
                        'operator' => '==',
                        'value' => 'custom-colors',
                    ),
                ));

                // Child theme's style.csss
                $lsvr_customizer->add_info( 'colors_info_skin', array(
                    'section' => 'colors_settings',
                    'label' => esc_html( 'About Custom Scheme', 'bluecollar' ),
                    'description' => esc_html__( 'Please refer to the documentation on how to generate your custom color scheme. Put your generated code into child theme\'s style.css file (you can access it via Appearance / Editor).', 'bluecollar' ),
                    'priority' => 4010,
                    'required' => array(
                        'setting' => 'colors_method',
                        'operator' => '==',
                        'value' => 'custom-skin',
                    ),
                ));


            // Social settings
            $lsvr_customizer->add_section( 'social_settings', array(
                'title' => esc_html__( 'Social Links', 'bluecollar' ),
                'priority' => 220,
            ));

                // About
                $lsvr_customizer->add_info( 'social_links_info', array(
                    'section' => 'social_settings',
                    'label' => esc_html( 'Info', 'bluecollar' ),
                    'description' => esc_html__( 'You can add your social links either by using custom fields, predefined fields or combination of both.', 'bluecollar' ),
                    'priority' => 1000,
                ));

                // Custom Social Link 1 Icon
                $lsvr_customizer->add_field( 'custom_social_link1_icon', array(
                    'section' => 'social_settings',
                    'label' => esc_html__( 'Custom Social Link 1 Icon', 'bluecollar' ),
                    'description' => esc_html__( 'Add icon class here. Please refer to the documentation to learn more about icons.', 'bluecollar' ),
                    'type' => 'text',
                    'priority' => 1110,
                ));

                // Custom Social Link 1 URL
                $lsvr_customizer->add_field( 'custom_social_link1_url', array(
                    'section' => 'social_settings',
                    'label' => esc_html__( 'Custom Social Link 1 URL', 'bluecollar' ),
                    'description' => esc_html__( 'Absolute URL to your social profile.', 'bluecollar' ),
                    'type' => 'text',
                    'priority' => 1120,
                ));

                // Custom Social Link 1 Label
                $lsvr_customizer->add_field( 'custom_social_link1_label', array(
                    'section' => 'social_settings',
                    'label' => esc_html__( 'Custom Social Link 1 Label', 'bluecollar' ),
                    'description' => esc_html__( 'This label will appear when you hover over the icon.', 'bluecollar' ),
                    'type' => 'text',
                    'priority' => 1130,
                ));

                // Custom Social Link 2 Icon
                $lsvr_customizer->add_field( 'custom_social_link2_icon', array(
                    'section' => 'social_settings',
                    'label' => esc_html__( 'Custom Social Link 2 Icon', 'bluecollar' ),
                    'type' => 'text',
                    'priority' => 1210,
                ));

                // Custom Social Link 2 URL
                $lsvr_customizer->add_field( 'custom_social_link2_url', array(
                    'section' => 'social_settings',
                    'label' => esc_html__( 'Custom Social Link 2 URL', 'bluecollar' ),
                    'type' => 'text',
                    'priority' => 1220,
                ));

                // Custom Social Link 2 Label
                $lsvr_customizer->add_field( 'custom_social_link2_label', array(
                    'section' => 'social_settings',
                    'label' => esc_html__( 'Custom Social Link 2 Label', 'bluecollar' ),
                    'type' => 'text',
                    'priority' => 1230,
                ));

                // Custom Social Link 3 Icon
                $lsvr_customizer->add_field( 'custom_social_link3_icon', array(
                    'section' => 'social_settings',
                    'label' => esc_html__( 'Custom Social Link 3 Icon', 'bluecollar' ),
                    'type' => 'text',
                    'priority' => 1310,
                ));

                // Custom Social Link 3 URL
                $lsvr_customizer->add_field( 'custom_social_link3_url', array(
                    'section' => 'social_settings',
                    'label' => esc_html__( 'Custom Social Link 3 URL', 'bluecollar' ),
                    'type' => 'text',
                    'priority' => 1320,
                ));

                // Custom Social Link 3 Label
                $lsvr_customizer->add_field( 'custom_social_link3_label', array(
                    'section' => 'social_settings',
                    'label' => esc_html__( 'Custom Social Link 3 Label', 'bluecollar' ),
                    'type' => 'text',
                    'priority' => 1330,
                ));

                // Separator
                $lsvr_customizer->add_separator( 'social_links_separator_1', array(
                    'section' => 'social_settings',
                    'priority' => 2000,
                ));

                // Predefined Social Links
                $lsvr_customizer->add_field( 'social_links', array(
                    'section' => 'social_settings',
                    'label' => esc_html__( 'Predefined Social Links', 'bluecollar' ),
                    'description' => esc_html__( 'Insert URLs into inputs of social networks which you want to display. You can drag and drop items to change the order.', 'bluecollar' ),
                    'type' => 'lsvr-social-links',
                    'choices' => array(
                        'email' => array(
                            'label' => esc_html__( 'Email', 'bluecollar' ),
                            'icon' => 'icon-envelope-o',
                        ),
                        '500px' => array(
                            'label' => esc_html__( '500px', 'bluecollar' ),
                            'icon' => 'icon-500px',
                        ),
                        'bandcamp' => array(
                            'label' => esc_html__( 'Bandcamp', 'bluecollar' ),
                            'icon' => 'icon-bandcamp',
                        ),
                        'behance' => array(
                            'label' => esc_html__( 'Behance', 'bluecollar' ),
                            'icon' => 'icon-behance',
                        ),
                        'codepen' => array(
                            'label' => esc_html__( 'CodePen', 'bluecollar' ),
                            'icon' => 'icon-codepen',
                        ),
                        'deviantart' => array(
                            'label' => esc_html__( 'DeviantArt', 'bluecollar' ),
                            'icon' => 'icon-deviantart',
                        ),
                        'dribbble' => array(
                            'label' => esc_html__( 'Dribbble', 'bluecollar' ),
                            'icon' => 'icon-dribbble',
                        ),
                        'dropbox' => array(
                            'label' => esc_html__( 'Dropbox', 'bluecollar' ),
                            'icon' => 'icon-dropbox',
                        ),
                        'etsy' => array(
                            'label' => esc_html__( 'Etsy', 'bluecollar' ),
                            'icon' => 'icon-etsy',
                        ),
                        'facebook' => array(
                            'label' => esc_html__( 'Facebook', 'bluecollar' ),
                            'icon' => 'icon-facebook',
                        ),
                        'flickr' => array(
                            'label' => esc_html__( 'Flickr', 'bluecollar' ),
                            'icon' => 'icon-flickr',
                        ),
                        'foursquare' => array(
                            'label' => esc_html__( 'Foursquare', 'bluecollar' ),
                            'icon' => 'icon-foursquare',
                        ),
                        'github' => array(
                            'label' => esc_html__( 'Github', 'bluecollar' ),
                            'icon' => 'icon-github',
                        ),
                        'google-plus' => array(
                            'label' => esc_html__( 'Google+', 'bluecollar' ),
                            'icon' => 'icon-google-plus',
                        ),
                        'instagram' => array(
                            'label' => esc_html__( 'Instagram', 'bluecollar' ),
                            'icon' => 'icon-instagram',
                        ),
                        'lastfm' => array(
                            'label' => esc_html__( 'last.fm', 'bluecollar' ),
                            'icon' => 'icon-lastfm',
                        ),
                        'linkedin' => array(
                            'label' => esc_html__( 'LinkedIn', 'bluecollar' ),
                            'icon' => 'icon-linkedin',
                        ),
                        'odnoklassniki' => array(
                            'label' => esc_html__( 'Odnoklassniki', 'bluecollar' ),
                            'icon' => 'icon-odnoklassniki',
                        ),
                        'pinterest' => array(
                            'label' => esc_html__( 'Pinterest', 'bluecollar' ),
                            'icon' => 'icon-pinterest',
                        ),
                        'qq' => array(
                            'label' => esc_html__( 'QQ', 'bluecollar' ),
                            'icon' => 'icon-qq',
                        ),
                        'reddit' => array(
                            'label' => esc_html__( 'Reddit', 'bluecollar' ),
                            'icon' => 'icon-reddit',
                        ),
                        'skype' => array(
                            'label' => esc_html__( 'Skype', 'bluecollar' ),
                            'icon' => 'icon-skype',
                        ),
                        'slack' => array(
                            'label' => esc_html__( 'Slack', 'bluecollar' ),
                            'icon' => 'icon-slack',
                        ),
                        'snapchat' => array(
                            'label' => esc_html__( 'Snapchat', 'bluecollar' ),
                            'icon' => 'icon-snapchat',
                        ),
                        'tripadvisor' => array(
                            'label' => esc_html__( 'TripAdvisor', 'bluecollar' ),
                            'icon' => 'icon-tripadvisor',
                        ),
                        'tumblr' => array(
                            'label' => esc_html__( 'Tumblr', 'bluecollar' ),
                            'icon' => 'icon-tumblr',
                        ),
                        'twitch' => array(
                            'label' => esc_html__( 'Twitch', 'bluecollar' ),
                            'icon' => 'icon-twitch',
                        ),
                        'twitter' => array(
                            'label' => esc_html__( 'Twitter', 'bluecollar' ),
                            'icon' => 'icon-twitter',
                        ),
                        'vimeo' => array(
                            'label' => esc_html__( 'Vimeo', 'bluecollar' ),
                            'icon' => 'icon-vimeo',
                        ),
                        'vk' => array(
                            'label' => esc_html__( 'VK', 'bluecollar' ),
                            'icon' => 'icon-vk',
                        ),
                        'yahoo' => array(
                            'label' => esc_html__( 'Yahoo', 'bluecollar' ),
                            'icon' => 'icon-yahoo',
                        ),
                        'yelp' => array(
                            'label' => esc_html__( 'Yelp', 'bluecollar' ),
                            'icon' => 'icon-yelp',
                        ),
                        'youtube' => array(
                            'label' => esc_html__( 'YouTube', 'bluecollar' ),
                            'icon' => 'icon-youtube',
                        ),
                    ),
                    'priority' => 2100,
                ));


            // Language settings
            $lsvr_customizer->add_section( 'language_settings', array(
                'title' => esc_html__( 'Languages', 'bluecollar' ),
                'priority' => 230,
            ));

                // About
                $lsvr_customizer->add_info( 'language_info', array(
                    'section' => 'language_settings',
                    'label' => esc_html( 'Info', 'bluecollar' ),
                    'description' => esc_html__( 'The following settings are useful if you want to run your site in more than one language. If you just want to translate the theme to a single language, please check out the documentation on how to do that.', 'bluecollar' ),
                    'priority' => 1000,
                ));

                // Language switcher
                $lsvr_customizer->add_field( 'language_switcher', array(
                    'section' => 'language_settings',
                    'label' => esc_html__( 'Language Switcher', 'bluecollar' ),
                    'description' => esc_html__( 'Display links to other language versions. WPML plugin is required for "WPML Generated" option to work.', 'bluecollar' ),
                    'type' => 'radio',
                    'choices' => array(
                        'disable' => esc_html__( 'Disable', 'bluecollar' ),
                        'wpml' => esc_html__( 'WPML Generated', 'bluecollar' ),
                        'custom' => esc_html__( 'Custom Links', 'bluecollar' ),
                    ),
                    'default' => 'disable',
                    'priority' => 1010,
                ));

                // Custom lang 1 label
                $lsvr_customizer->add_field( 'language_custom1_label', array(
                    'section' => 'language_settings',
                    'label' => esc_html__( 'Language 1 Label', 'bluecollar' ),
                    'description' => esc_html__( 'For example "EN", "DE" or "ES".', 'bluecollar' ),
                    'type' => 'text',
                    'priority' => 1020,
                    'required' => array(
                        'setting' => 'language_switcher',
                        'operator' => '==',
                        'value' => 'custom',
                    ),
                ));

                // Custom lang 1 code
                $lsvr_customizer->add_field( 'language_custom1_code', array(
                    'section' => 'language_settings',
                    'label' => esc_html__( 'Language 1 Code', 'bluecollar' ),
                    'description' => esc_html__( 'It will be used to determine the active language. For example "en_US", "de_DE" or "es_ES".', 'bluecollar' ),
                    'type' => 'text',
                    'priority' => 1030,
                    'required' => array(
                        'setting' => 'language_switcher',
                        'operator' => '==',
                        'value' => 'custom',
                    ),
                ));

                // Custom lang 1 URL
                $lsvr_customizer->add_field( 'language_custom1_url', array(
                    'section' => 'language_settings',
                    'label' => esc_html__( 'Language 1 URL', 'bluecollar' ),
                    'description' => esc_html__( 'For example "http://mysite.com/en".', 'bluecollar' ),
                    'type' => 'text',
                    'priority' => 1040,
                    'required' => array(
                        'setting' => 'language_switcher',
                        'operator' => '==',
                        'value' => 'custom',
                    ),
                ));

                // Custom lang 2 label
                $lsvr_customizer->add_field( 'language_custom2_label', array(
                    'section' => 'language_settings',
                    'label' => esc_html__( 'Language 2 Label', 'bluecollar' ),
                    'type' => 'text',
                    'priority' => 1050,
                    'required' => array(
                        'setting' => 'language_switcher',
                        'operator' => '==',
                        'value' => 'custom',
                    ),
                ));

                // Custom lang 2 code
                $lsvr_customizer->add_field( 'language_custom2_code', array(
                    'section' => 'language_settings',
                    'label' => esc_html__( 'Language 2 Code', 'bluecollar' ),
                    'type' => 'text',
                    'priority' => 1060,
                    'required' => array(
                        'setting' => 'language_switcher',
                        'operator' => '==',
                        'value' => 'custom',
                    ),
                ));

                // Custom lang 2 URL
                $lsvr_customizer->add_field( 'language_custom2_url', array(
                    'section' => 'language_settings',
                    'label' => esc_html__( 'Language 2 URL', 'bluecollar' ),
                    'type' => 'text',
                    'priority' => 1070,
                    'required' => array(
                        'setting' => 'language_switcher',
                        'operator' => '==',
                        'value' => 'custom',
                    ),
                ));

                // Custom lang 3 label
                $lsvr_customizer->add_field( 'language_custom3_label', array(
                    'section' => 'language_settings',
                    'label' => esc_html__( 'Language 3 Label', 'bluecollar' ),
                    'type' => 'text',
                    'priority' => 1080,
                    'required' => array(
                        'setting' => 'language_switcher',
                        'operator' => '==',
                        'value' => 'custom',
                    ),
                ));

                // Custom lang 3 code
                $lsvr_customizer->add_field( 'language_custom3_code', array(
                    'section' => 'language_settings',
                    'label' => esc_html__( 'Language 3 Code', 'bluecollar' ),
                    'type' => 'text',
                    'priority' => 1090,
                    'required' => array(
                        'setting' => 'language_switcher',
                        'operator' => '==',
                        'value' => 'custom',
                    ),
                ));

                // Custom lang 3 URL
                $lsvr_customizer->add_field( 'language_custom3_url', array(
                    'section' => 'language_settings',
                    'label' => esc_html__( 'Language 3 URL', 'bluecollar' ),
                    'type' => 'text',
                    'priority' => 1100,
                    'required' => array(
                        'setting' => 'language_switcher',
                        'operator' => '==',
                        'value' => 'custom',
                    ),
                ));

                // Custom lang 4 label
                $lsvr_customizer->add_field( 'language_custom4_label', array(
                    'section' => 'language_settings',
                    'label' => esc_html__( 'Language 4 Label', 'bluecollar' ),
                    'type' => 'text',
                    'priority' => 1100,
                    'required' => array(
                        'setting' => 'language_switcher',
                        'operator' => '==',
                        'value' => 'custom',
                    ),
                ));

                // Custom lang 4 code
                $lsvr_customizer->add_field( 'language_custom4_code', array(
                    'section' => 'language_settings',
                    'label' => esc_html__( 'Language 4 Code', 'bluecollar' ),
                    'type' => 'text',
                    'priority' => 1120,
                    'required' => array(
                        'setting' => 'language_switcher',
                        'operator' => '==',
                        'value' => 'custom',
                    ),
                ));

                // Custom lang 4 URL
                $lsvr_customizer->add_field( 'language_custom4_url', array(
                    'section' => 'language_settings',
                    'label' => esc_html__( 'Language 4 URL', 'bluecollar' ),
                    'type' => 'text',
                    'priority' => 1130,
                    'required' => array(
                        'setting' => 'language_switcher',
                        'operator' => '==',
                        'value' => 'custom',
                    ),
                ));

            // Misc settings
            $lsvr_customizer->add_section( 'misc_settings', array(
                'title' => esc_html__( 'Misc', 'bluecollar' ),
                'priority' => 240,
            ));

                // Search input placeholder
                $lsvr_customizer->add_field( 'search_input_placeholder', array(
                    'section' => 'misc_settings',
                    'label' => __( 'Search Input Placeholder', 'bluecollar' ),
                    'description' => esc_html__( 'Placeholder text for search input.', 'bluecollar' ),
                    'type' => 'text',
                    'default' => esc_html__( 'Search this site...', 'bluecollar' ),
                    'priority' => 1020,
                ));

                // Search results posts per page
                $lsvr_customizer->add_field( 'search_results_posts_per_page', array(
                    'section' => 'misc_settings',
                    'label' => esc_html__( 'Search Results Per Page', 'bluecollar' ),
                    'description' => esc_html__( 'Number of search results per page. Set to 0 to display all.', 'bluecollar' ),
                    'type' => 'lsvr-slider',
                    'choices' => array(
                        'min' => 0,
                        'max' => 50,
                        'step' => 1,
                    ),
                    'default' => 10,
                    'priority' => 1030,
                ));

                 // Search results excerpt
                $lsvr_customizer->add_field( 'search_results_excerpt_enable', array(
                    'section' => 'misc_settings',
                    'label' => __( 'Search Results Excerpt', 'bluecollar' ),
                    'description' => esc_html__( 'Display post excerpt on search results page.', 'bluecollar' ),
                    'type' => 'checkbox',
                    'default' => false,
                    'priority' => 1040,
                ));

                // Separator
                $lsvr_customizer->add_separator( 'footer_separator_2', array(
                    'section' => 'misc_settings',
                    'priority' => 2000,
                ));

                // Parallax enable
                $lsvr_customizer->add_field( 'parallax_effects_enable', array(
                    'section' => 'misc_settings',
                    'label' => esc_html__( 'Enable Parallax Animations', 'bluecollar' ),
                    'type' => 'checkbox',
                    'default' => true,
                    'priority' => 2010,
                ));

        }

	}
}

?>